/**********************************************************************\
*                                                                      *
* rgbtree.h -- include file for rgb palette sort and search functions  *
*                                                                      *
*    *** LISTING 1 ***                                                 *
\**********************************************************************/

// Mark Betz
// 120 N. Shore Rd.
// Derry, NH 03038
// 603-898-8214

// Copyright (c) 1993, Mark Betz

#ifndef __RGBTREE__
#  define __RGBTREE__


const PAL_SIZE = 768;                // number of bytes in palette
const DAC_SIZE = PAL_SIZE/3;         // size of DAC assuming 3 bytes/reg
const HEAD = 0;                      // index of the head done in tree
const TAIL = (PAL_SIZE/3) + 1;       // index of the tail node in tree
const ZIDX = -1;                     // invalid index

// change the order here to change the order of comparisons in the tree
// build and sort routines. The default is to compare green, red, then
// blue values.

const R = 1;
const G = 0;
const B = 2;

// generic array type for palette values

typedef unsigned char DACTBL[PAL_SIZE];

// the BSP tree class for sorting RGB values

class RGBBinTree
{
   friend class ViewTree;

   public:
   RGBBinTree();
   RGBBinTree( const DACTBL dacs ) { build( dacs ); };
   int rgbMatch( unsigned char r, unsigned char g,
                 unsigned char b, int thold );
   void build( const DACTBL dacs );
   int nodesVisited() { return visitCnt; };

   protected:
   struct pnode
   {
      unsigned char c[3];
      int index;
      int left;
      int right;
   };
   RGBBinTree( const RGBBinTree& rbt ) {};
   RGBBinTree& operator =(const RGBBinTree& rbt) {};
   int getMid( const DACTBL dacs ) const;
   void insertNode( const struct pnode& newn, int elem );

   private:
   pnode pn[ DAC_SIZE+2 ];
   static int n_stack[ DAC_SIZE*2 ];
   static int n_sp;
   int treeBuilt;
   int visitCnt;
};

#endif
