/**********************************************************************\
*                                                                      *
* showtree.c -- viewer for RGB BSP tree                                *
*                                                                      *
* By: Mark Betz, released to the public domain                         *
\**********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <conio.h>
#include "viewtree.h"
#include "rgbtree.h"

static DACTBL pal1;
static char *tpal1;
static RGBBinTree RGBTree;

// get the file name from the command line. Returns 0 on failure,
// loads the filename into tpal1 and returns 1 on success

int parse_clp(int argc, char* argv[])
{
   int result = 0;
   if(argc == 2)
   {
      tpal1 = argv[1];
      result = 1;
   }
   return result;
}

// open the test palette file and read it into the palette array
// pal1. Handle any i/o errors. Returns 1 on success, 0 on
// failure.

int init_pals()
{
   int result = 1;
   int htp1;

   printf("->loading %s ...", tpal1);
   if ((htp1 = open(tpal1, O_BINARY | O_RDONLY)) == -1)
   {
      printf("error opening file %s!\r\n",tpal1);
      result = 0;
   }
   else if (read(htp1, pal1, PAL_SIZE) != PAL_SIZE)
   {
      printf("error reading %s data!\r\n",tpal1);
      result = 0;
   }
   else if (close(htp1) == -1)
   {
      printf("bad file number closing %s!\r\n",tpal1);
      result = 0;
   }
   else printf("done.\r\n");
   return result;
}

int main(int argc, char* argv[])
{
   int i;
   ViewTree VT( &RGBTree );

   clrscr();
   if (parse_clp(argc, argv))
   {
      printf(" RGB tree viewer: left - '1', right - '3', up - '8'\r\n");
      printf("----------------------------------------------------\r\n");
      if( init_pals())
      {
         RGBTree.build( pal1 );
         VT.show();
         clrscr();
      }
   }
   else
   {
      printf("Useage:  SHOWTREE [palette-file]\r\n");
      printf("example: showtree test1.pal\r\n");
   }
   exit(0);
}

