/* viewtree.c */

#include <conio.h>
#include <mem.h>
#include "viewtree.h"
#include "rgbtree.h"

int win_pos[15][4] = { {37,6,1,8},    {18,10,2,5},   {8,14,3,4},
                       {8,16,-1,-1},  {18,16,-1,-1}, {28,14,6,7},
                       {28,16,-1,-1}, {38,16,-1,-1}, {56,10,9,12},
                       {46,14,10,11}, {46,16,-1,-1}, {56,16,-1,-1},
                       {66,14,13,14}, {66,16,-1,-1}, {76,16,-1,-1}
                     };

static char* label[3] = { "GREEN", "RED", "BLUE" };

const wpX = 0;
const wpY = 1;
const wpL = 2;
const wpR = 3;

ViewTree::ViewTree( const RGBBinTree* rgbt )
{
   tptr = rgbt;
}

void ViewTree::show()
{
   int p=0, c, k=1;
   int exit = 0;
   int level = 0;

   makeScreen();
   while (!exit)
   {
      showTree(k);
      gotoxy(30,6);
      textcolor(WHITE);
      cprintf("%i ", level);
      gotoxy(7,6);
      cprintf("%s KEY  ", label[level % 3]);
      while(!kbhit);
      c = getch();
      if (c == 0x1B)
         exit = 1;
      else if ((c == 72) || (c == 56))
      {
         if(p)
         {
            k = s_stack[--p];
            level--;
         }
      }
      else if ((c == 79) || (c == 49))
      {
         if (tptr->pn[k].left != TAIL)
         {
            s_stack[p++] = k;
            k = tptr->pn[k].left;
            level++;
         }
      }
      else if ((c == 81) || (c == 51))
      {
         if (tptr->pn[k].right != TAIL)
         {
            s_stack[p++] = k;
            k = tptr->pn[k].right;
            level++;
         }
      }
   }
   return;
}

void ViewTree::makeScreen() const
{
cprintf("\r\n");
textcolor(LIGHTCYAN);
cprintf("                                  ͻ\r\n");
cprintf("                      level:                   \r\n");
cprintf("                                  ͼ\r\n");
textcolor(LIGHTBLUE);
cprintf("                      ͼ         ͻ\r\n");
cprintf("               ͻ                       ͻ\r\n");
cprintf("                                                                \r\n");
cprintf("               ͼ                       ͼ\r\n");
cprintf("            ͼ         ͻ                 ͼ         ͻ\r\n");
cprintf("     ͻ     ͻ   ͻ     ͻ\r\n");
cprintf("                                                                      \r\n");
cprintf("     ͼ     ͼ   ͼ     ͼ\r\n");
textcolor(LIGHTGRAY);
}

void ViewTree::showTree( int node )
{
   int p=0, i=0, k;

   clearTree();
   gotoxy(42,4);
   if (node != 1)
      putch(0x1E);
   else
      cprintf("H");
   st_stack[p++] = 0;
   st_stack[p++] = node;
   while(p)
   {
      k = st_stack[--p];
      i = st_stack[--p];
      textcolor(WHITE);
      gotoxy(win_pos[i][wpX], win_pos[i][wpY]);
      if (win_pos[i][wpY] == 16)
         putch(0x1F);
      else
      {
         textcolor(LIGHTRED);
         cprintf("%i ",tptr->pn[k].c[R]);
         textcolor(LIGHTGREEN);
         cprintf("%i ",tptr->pn[k].c[G]);
         textcolor(LIGHTBLUE);
         cprintf("%i ",tptr->pn[k].c[B]);
         textcolor(WHITE);
         cprintf("%i",tptr->pn[k].index);
         textcolor(LIGHTGRAY);
         if (tptr->pn[k].right != TAIL)
         {
            st_stack[p++] = win_pos[i][wpR];
            st_stack[p++] = tptr->pn[k].right;
         }
         if (tptr->pn[k].left != TAIL)
         {
            st_stack[p++] = win_pos[i][wpL];
            st_stack[p++] = tptr->pn[k].left;
         }
      }
   }
   return;
}

void ViewTree::clearTree() const
{
   int i;
   for (i = 0; i < 15; i++)
   {
      gotoxy(win_pos[i][wpX], win_pos[i][wpY]);
      cprintf("            ");
   }
}

