/*-----------------------------------------------------------------------

07/28/92  DR  Add support for BFTYP_TRSIGN type.

08/04/92  DR  Add support for removing NULLS from LSTRING.
-----------------------------------------------------------------------*/


#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "bfile.h"
#include "btrieve.h"
extern "C" {
#include "realcnvt.h"
};

#define EOS '\0'

double bcdtof(char *,int );
double numerictof(char *);
int asc_bcd(char *dest,char *source,int no_bytes);
char *numerictostr(double numf,int len=9,int decimals=2);
int del_trsp(char *t);

int del_trzero(char *t)
{
   int loop;
   for ( loop=(strlen(t))-1 ; t[loop]==' ' || t[loop]=='0' ; loop-- )
   {
      t[loop]=EOS;
   }
   return(loop);
}

char *btrvConvert(int type,char *src,char *dst,int slen,int sdec,int dlen,int ddec)
{
   char temp[100];
   char tdst[255];
   int *i,ii;
   long *l,ll;
   double *d,dd;
   float *f,ff;
   double tempf;

   memset(dst,EOS,dlen);
   switch(type)
   {
      case BFTYP_LOGICAL:
      case BFTYP_STRING:
         {
            sprintf(tdst,"%-*.*s",dlen,dlen,src);
/*******    for ( int loop=0 ; loop<slen ; loop++ )
            {
               if ( src[loop]==EOS )
               {
                  src[loop]=' ';
               }
            }************/
            memcpy(dst,tdst,dlen);
         }
         break;
      case BFTYP_AUTOINC:
      case BFTYP_INT:
         if ( slen==2 )
         {
            i=(int *)src;
            sprintf(dst,"%*d",dlen,*i);
         }
         else if ( slen==4 )
         {
            l=(long *)src;
            sprintf(dst,"%*ld",dlen,*l);
         }
         else if ( slen==1 )
         {
            char *c;
            c=(char *)src;
            sprintf(dst,"%*d",dlen,*c);
         }
         break;
      case BFTYP_UNSIGNED:
         if ( slen==2 )
         {
            unsigned *u;
            u=(unsigned *)src;
            sprintf(dst,"%*u",dlen,(unsigned)*u);
         }
         else if ( slen==4 )
         {
            unsigned long *ul;
            ul=(unsigned long *)src;
            sprintf(dst,"%*lu",dlen,(unsigned long)*ul);
         }
         else if ( slen==1 )
         {
            unsigned char *c;
            c=(unsigned char *)src;
            sprintf(dst,"%*u",dlen,(unsigned)*c);
         }
         break;
      case BFTYP_FLOAT:
         if ( slen==4 )
         {
            f=(float *)src;
            if ( ddec==0 )
            {
               ddec=6;
            }
            sprintf(dst,"%*.*f",dlen,ddec,*f);
         }
         else if ( slen==8 )
         {
            d=(double *)src;
            if ( ddec==0 )
            {
               ddec=6;
            }
            sprintf(dst,"%*.*f",dlen,ddec,*d);
         }
         break;
      case BFTYP_DATE:
         i=(int *)(src+2);
         if ( dlen>=10 )
         {
            sprintf(temp,"%2d/%02d/%04d",src[1],src[0],*i);
         }
         else
         {
            sprintf(temp,"%2d/%02d/%02d",src[1],src[0],(*i)%100);
         }
         temp[dlen]=EOS;
         strcpy(dst,temp);
         break;
      case BFTYP_TIME:
         sprintf(temp,"%2d:%02d:%02d.%02d",src[3],src[2],src[1],src[0]);
         temp[dlen]=EOS;
         strcpy(dst,temp);
         break;
      case BFTYP_DECIMAL:
      case BFTYP_MONEY:
         {
            tempf=(bcdtof(src,slen));
            for ( int loop=0 ; loop<ddec ; loop++ )
            {
               tempf/=10.0;
            }
            sprintf(dst,"%*.*f",dlen,ddec,tempf);
         }
         break;
      case BFTYP_NUMERIC:
         {
            char temp[255];
            strncpy(temp,src,slen);
            temp[slen]=EOS;
            tempf=(numerictof(temp));
            for ( int loop=0 ; loop<ddec ; loop++ )
            {
               tempf/=10.0;
            }
            sprintf(dst,"%*.*f",dlen,ddec,tempf);
         }
         break;
      case BFTYP_TRSIGN:
         {
            char temp[255];
            strncpy(temp,src,slen);
            temp[slen]=EOS;
            tempf=(atof(temp));
            for ( int loop=0 ; loop<ddec ; loop++ )
            {
               tempf/=10.0;
            }
            if ( src[slen-1]=='-' && tempf )
            {
               sprintf(dst,"%*.*f",dlen,ddec,(tempf*-1.0));
            }
            else
            {
               sprintf(dst,"%*.*f",dlen,ddec,tempf);
            }
         }
         break;
#ifdef BTFILER
      case BFTYP_PREAL:
         {
            char temp[20];
            memcpy(temp,src,slen);
            if ( slen==6 )
            {
               char temp[100];
               tempf=(pasrealtodouble(src));
               sprintf(temp,"%f",tempf);
               del_trzero(temp);
               sprintf(dst,"%*s",dlen,temp);
            }
            memcpy(src,temp,slen);
         }
         break;
#endif
      case BFTYP_BFLOAT:
         {
            char temp[20];
            memcpy(temp,src,slen);
            if ( slen==4 )
            {
               char temp[100];
               tempf=(bassngltodouble(src));
               sprintf(temp,"%f",tempf);
               del_trzero(temp);
               sprintf(dst,"%*s",dlen,temp);
            }
            else if ( slen==8 )
            {
               char temp[100];
               tempf=(basdbletodouble(src));
               sprintf(temp,"%f",tempf);
               del_trzero(temp);
               sprintf(dst,"%*s",dlen,temp);
            }
            memcpy(src,temp,slen);
         }
         break;
      case BFTYP_LSTRING:
         {
            int tlen=dlen;
            if ( (*src)<dlen )
            {
               tlen=*src;
            }
            memset(dst,EOS,dlen);
            memcpy(dst,(src+1),tlen);
            for ( int loop=0 ; loop<(*src) && loop<tlen ; loop++ )
            {
               if ( dst[loop]==EOS )
               {
                  dst[loop]=' ';
               }
            }
            dst[dlen]=EOS;
         }
         break;
      case BFTYP_ZSTRING:
         {
            memcpy(dst,EOS,dlen);
            strncpy(dst,src,dlen);
            dst[dlen]=EOS;
            del_trsp(dst);
         }
         break;
      case BFTYP_LOGICAL+100:
      case BFTYP_STRING+100:
         sprintf(tdst,"%-*.*s",dlen,dlen,src);
         memcpy(dst,tdst,dlen);
//       memcpy(dst,src,dlen);
//       for ( int loop=0 ; loop<dlen ; loop++ )
//       {
//          if ( dst[loop]==EOS )
//          {
//             dst[loop]=' ';
//          }
//       }
         break;
      case BFTYP_AUTOINC+100:
      case BFTYP_INT+100:
         if ( dlen==2 )
         {
            ii=atoi(src);
            memcpy((int *)dst,&ii,2);
         }
         else if ( dlen==4 )
         {
            ll=atol(src);
            memcpy((long *)dst,&ll,4);
         }
         else if ( dlen==1 )
         {
            char cc;
            cc=atoi(src);
            memcpy((long *)dst,&cc,1);
         }
         break;
      case BFTYP_UNSIGNED+100:
         if ( dlen==2 )
         {
            unsigned uu;
            uu=(unsigned)atoi(src);
            memcpy((int *)dst,&uu,2);
         }
         else if ( dlen==4 )
         {
            unsigned long ulul;
            ulul=(unsigned long)atol(src);
            memcpy((long *)dst,&ulul,4);
         }
         else if ( dlen==1 )
         {
            unsigned char cc;
            cc=(unsigned char)atoi(src);
            memcpy((long *)dst,&cc,1);
         }
         break;
      case BFTYP_FLOAT+100:
         if ( dlen==4 )
         {
            ff=(float)(atof(src));
            memcpy((double *)dst,&ff,4);
         }
         else if ( dlen==8 )
         {
            dd=(float)(atof(src));
            memcpy((double *)dst,&dd,8);
         }
         break;
      case BFTYP_DATE+100:
         dst[1]=(char)(atoi(src));
         dst[0]=(char)(atoi(&src[3]));
         ii=(atoi(&src[6]));
         memcpy((char *)&dst[2],&ii,2);
         break;
      case BFTYP_TIME+100:
         sprintf(temp,"%2d:%02d:%02d.%02d",src[3],src[2],src[1],src[0]);
         temp[dlen]=EOS;
         strcpy(dst,temp);
         dst[3]=(char)(atoi(src));
         while ( (*src) && (*src)!=':' )
         {
            src++;
         }
         if ( src )
         {
            src++;
            dst[2]=(char)(atoi(src));
            while ( (*src) && (*src)!=':' )
            {
               src++;
            }
            if ( src )
            {
               src++;
               dst[1]=(char)(atoi(src));
               while ( (*src) && (*src)!=':' && (*src)!='.' )
               {
                  src++;
               }
               if ( src )
               {
                  src++;
                  dst[0]=(char)(atoi(src));
               }
            }
         }
         break;
      case BFTYP_DECIMAL+100:
      case BFTYP_MONEY+100:
         {
            tempf=(atof(src));
            for ( int loop=0 ; loop<sdec ; loop++ )
            {
               tempf*=10.0;
            }
            sprintf(temp,"%0*.0f",dlen*2,tempf);
            asc_bcd(dst,temp,dlen);
         }
         break;
      case BFTYP_NUMERIC+100:
         {
            char temp[255];
            tempf=(atof(src));
            for ( int loop=0 ; loop<sdec ; loop++ )
            {
               tempf*=10.0;
            }
            sprintf(temp,"%s",numerictostr(tempf,dlen,ddec));
            memcpy(dst,temp,dlen);
         }
         break;
      case BFTYP_TRSIGN+100:
         {
            char temp[255];
            int sign='+';

            tempf=(atof(src));
            if ( tempf<0.0 )
            {
               sign='-';
               tempf*=-1.0;
            }
            for ( int loop=0 ; loop<sdec ; loop++ )
            {
               tempf*=10.0;
            }
            if ( tempf<0.0 )
            {
               sprintf(temp,"%0*.0f%c",dlen-1,tempf,sign);
            }
            else
            {
               sprintf(temp,"%0*.0f%c",dlen-1,tempf,sign);
            }
            memcpy(dst,temp,dlen);
         }
         break;
#ifdef BTFILER
      case BFTYP_PREAL+100:
         if ( dlen==6 )
         {
            tempf=(atof(src));
            doubletopasreal((pasreal *)dst,tempf);
         }
         break;
#endif
      case BFTYP_BFLOAT+100:
         if ( dlen==4 )
         {
            tempf=(atof(src));
            doubletobassngl((bassngl *)dst,tempf);
         }
         else if ( dlen==8 )
         {
            tempf=(atof(src));
            doubletobasdble((basdble *)dst,tempf);
         }
         break;
      case BFTYP_LSTRING+100:
         memcpy(dst+1,(src),strlen(src));
         *dst=(char)(strlen(src));
         break;
      case BFTYP_ZSTRING+100:
         memcpy(dst,EOS,dlen);
         strncpy(dst,src,dlen);
         dst[dlen]=EOS;
         del_trsp(dst);
         break;
   }
   return(0);
}
