/*

      btrieve.h
      Used with bfile class, a Btrieve class for Borland C++
      09/06/91

      Douglas J. Reilly
      Access Microsystems Inc.
      404 Midstreams Road
      Brick, New Jersey  08724
      (908) 892-2683
      CompuServe 74040,607

      Comments?  Questions?  Suggestions?
      Have a paying C/C++ programming job you need done?
      Give me a call.
      Released into the public domain.  Do with it as you see fit, but
      if you do anything really neat with it, let me know...


*/
#ifndef BTRIEVE_READ
#define BTRIEVE_READ

// field types
#define BFTYP_STRING     0
#define BFTYP_INT        1
#define BFTYP_FLOAT      2
#define BFTYP_DATE       3
#define BFTYP_TIME       4
#define BFTYP_DECIMAL    5
#define BFTYP_MONEY      6
#define BFTYP_LOGICAL    7
#define BFTYP_NUMERIC    8
#define BFTYP_BFLOAT     9
#define BFTYP_LSTRING   10
#define BFTYP_ZSTRING   11
#define BFTYP_UNSIGNED  14
#define BFTYP_AUTOINC   15
#define BFTYP_TRSIGN    0x11
#define BFTYP_PREAL     0x20
// operation codes...
#define B_ABORT        21
#define B_BEGIN        19
#define B_CLEAR_OWNR   30
#define B_CLOSE         1
#define B_CREATE       14
#define B_CREATE_SUP   31
#define B_DELETE        4
#define B_DROP_SUP     32
#define B_END          20
#define B_EXTEND       16
#define B_GET_DIRECT   23
#define B_GET_DIR      18
#define B_GET_EQ        5
#define B_GET_GT        8
#define B_GET_GTE       9
#define B_GET_HI       13
#define B_GET_LT       10
#define B_GET_LTE      11
#define B_GET_LO       12
#define B_GET_NEXT      6
#define B_GET_POS      22
#define B_GET_PREV      7
#define B_INSERT        2
#define B_OPEN          0
#define B_RESET        28
#define B_SET_DIR      17
#define B_SET_OWNR     29
#define B_STAT         15
#define B_STEP_DIRECT  24
#define B_STEP_FIRST   33
#define B_STEP_LAST    34
#define B_STEP_NEXT    24
#define B_STEP_PREV    35
#define B_STOP         25
#define B_UNLOCK       27
#define B_UPDATE        3
#define B_VERSION      26
#define B_LOCK_SRNW   200   /* single rec loc, no wait */
#define B_LOCK_MRNW   400   /* multi record lock, no wait */

// a NON-error code.
#define BERR_NONE           0

// error codes, not all, but all I have ever seen.
#define BERR_INVALID_OP     1
#define BERR_IO_ERROR       2
#define BERR_NO_OPEN        3
#define BERR_REC_NOT_FOUND  4
#define BERR_DUP_ERROR      5
#define BERR_INVALID_KEY    6
#define BERR_DIFF_KEY       7
#define BERR_INVALID_POS    8
#define BERR_EOF            9
#define BERR_MOD_ERR       10
#define BERR_INVALID_FILE  11
#define BERR_NO_FILE       12
#define BERR_EXTENSION_ERR 13
#define BERR_PRE_OPEN_ERR  14
#define BERR_PRE_IMAGE_ERR 15
#define BERR_EXPANSION_ERR 16
#define BERR_CLOSE_ERROR   17
#define BERR_DISK_FULL     18
#define BERR_UNRECOVERABLE 19
#define BERR_REC_MAN_ERR   20
#define BERR_KEY_BUF_ERR   21
#define BERR_REC_BUF_ERR   22
#define BERR_HANDLE_NG     23
#define BERR_PAGE_SIZE     24
#define BERR_CREATE_IO     25
#define BERR_NUM_KEYS      26
#define BERR_KEY_POS       27
#define BERR_REC_LEN       28
#define BERR_KEY_LEN       29
#define BERR_FNAME_NG      30
#define BERR_EXTEND_ERR    31
#define BERR_EXTEND_IO_ERR 32
#define BERR_EXTEND_NAME   34
#define BERR_DIR_ERROR     35
#define BERR_TRANS_ERR     36
#define BERR_BEG_TRANS     37
#define BERR_TRANS_END     39
#define BERR_TRANS_MAX     40
#define BERR_INVALID_ADDR  43
#define BERR_NULL_KEY      44
#define BERR_NO_ACCESS     46
#define BERR_MAX_FILES     47
#define BERR_KEY_TYPE      48
#define BERR_INVALID_OWNER 51
#define BERR_CACHE_ERR     52
#define BERR_VAR_PAGE      54
#define BERR_MEM_ERR       57
#define BERR_CONFLICT      80
#define BERR_LOCK_ERR      81
#define BERR_LOST_POS      82
#define BERR_REC_IN_USE    84
#define BERR_FILE_IN_USE   85
#define BERR_TOO_MANY_FILE 86
#define BERR_HANDLE_FULL   87
#define BERR_MODE_ERR      88
#define BERR_INCOMPAT_LOCK 93

// my own pseudo-error code.
#define BERR_MEM_ALLOC    200

// Btrieve ERROR action codes.  Used by my error handler.
#define BACT_ABORT    0
#define BACT_RETRY    1
#define BACT_FAIL     2

// open mode
#define B_ACCELL       -1

// for create operation
#define DUP 1
#define MOD 2
#define BIN 4
#define NULL_VAL 8
#define SEG 16
#define DESC 64
#define ALT 32
#define SUP 128
#define MAN 512

#define EXT_TYPE 256
#define B_INT_TYPE 1

#define B_NUM_TYPE 8
#define B_STR_TYPE 0
#define B_ZSTR_TYPE 11
#define BF_VARIABLE      0x01
#define BF_BLANKTRUNC    0x02
#define BF_DATACOMP      0x08
#define BF_KEYONLY       0x10
#define BF_10PCTFREE     0x40
#define BF_20PCTFREE     0x80
#define BF_30PCTFREE     0xC0

struct KEY_SPEC
{
   int   KEY_POS;
   int   KEY_LEN;
   int   KEY_FLAG;
   long  KEY_TOTAL;
   char  KEY_TYPE;
   char  NULL_VALUE;
   char  RESERVE1[4];
};

struct FIL_SPEC
{
   int     REC_LEN;
   int     PAGE_SIZ;
   int     NDX_CNT;
   long    NUM_RECS;
   int     FILE_FLAG;
   char    RESERVE2[2];
   int     UNUSED_PGS;
struct     KEY_SPEC KEY_BUF[24];
  char     ALT_COL_SEQ[512];
};


#endif

