#ifndef DDFFILE_H
#define DDFFILE_H

#include "bfile.h"

class Value {
   char *strValue;
   double dValue;
   long iValue;
   int len;
   int dec;
public:
   Value(int l=0,int dec=0);
   Value(char *s,int l=10,int dec=0);
   Value(double t,int l=10,int dec=0);
   Value(long i,int l=10);
   ~Value()
   {
      if ( strValue!=0 )
      {
         my_free(strValue,__FILE__,__LINE__);
      }
   }
   void setVal(char *s);
   void setVal(double t);
   void setVal(long i);
   void operator=(long l)
   {
      setVal(l);
   }
   void operator=(double d)
   {
      setVal(d);
   }
   void operator=(char *s)
   {
      setVal(s);
   }
   void setLenDec(int l,int d);
   void clear();
   operator char *() { return strValue; }
   operator long() { return iValue; }
   operator double() { return dValue; }
   int getLen() { return len; }
   int getDec() { return dec; }
};

struct FILEDDF {
   int fileID;
   char fileName[20];
   char fileLoc[64];
   int flags;
};
struct FIELDDDF {
      int fieldID;
      int fileID;
      char fieldName[20];
      char btDataType;
      int offset;
      int fieldSize;
      char decimals;
      int flags;
      class Value value;
} ;
struct INDEXDDF {
   int fileID;
   int fieldID;
   int keyNumber;
   int segNumber;
   int flags;
};

// this is what is needed to keep track of Btrieve currency.
struct BOOKMARK {
   char pos[4];
   int key;
};

class ddfFile {
   char physicalName[22];
   char logicalName[70];
   bfile *theFile;
   struct FIELDDDF *fields[256];
   struct FILEDDF fileDDF;
   int numFields;
   int fieldsToData();
   int dataToFields();
public:
   ddfFile(char *lname,char *owner=0);
   ~ddfFile();
   void setValue(char *t,int fnum)  { fields[fnum]->value.setVal(t); }
   void setValue(long l,int fnum)   { fields[fnum]->value.setVal(l); }
   void setValue(double d,int fnum) { fields[fnum]->value.setVal(d); }
   void nullOut();
   int getFieldID(char *);
   char *getFieldName(int);
   char *getValue(char *);
   char *getValue(int fnum);
   void toData(int fnum,void *t);
   int get_status()
   {
      if ( theFile==0 )
      {
         return 9999;
      }
      else
      {
         return theFile->get_status();
      }
   }
   int unlock()
   {
      return theFile->unlock();
   }
   void set_key_num(int key_num)
   {
      theFile->set_key_num(key_num);
   }
  // overload operator++
   int  operator++(int )
   {
      char temp[255];
      return(get_rec(temp,B_GET_NEXT));
   }
  // overload  operator--
   int  operator--(int )
   {
      char temp[255];
      return(get_rec(temp,B_GET_PREV));
   }
  // Gets a record.  Uses key 0 unless you have set key number.
   int  get_rec(char far *keystr,int op=B_GET_EQ);
  //   SEE BELOW...
   int  put_rec(char far *keystr=0,unsigned tlen=0,int just_update=0);
  // Insert.  made seperate functions to force insert.
   int  insert(char far *keystr=0,unsigned tlen=0);
  // self explanatory...except that if keystr==0, positioning is not done
   int  del_rec(char far *keystr=0) { return(theFile->del_rec(keystr)); };
   int getBookmark(struct BOOKMARK *theMark);
   int gotoBookmark(struct BOOKMARK *theMark);
};
#endif

