#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "io.h"
#include "bfile.h"
extern "C" {
   char *my_malloc(int num,char *pfile,int line);
   int  my_free(char *,char *pfile,int line);
};
int del_trsp(char *);

#include "ddffile.h"
#define EOS '\0'

char *searchBTFilePath(char *fname,char *fpath)
{
   fpath[0]=EOS;
   if ( (access(fname,00))==-1 )
   {
      _searchenv(fname,"BTFILEPATH",fpath);
   }
   else
   {
      strcpy(fpath,fname);
   }
   return(fpath);
}



char *pNameFromLName(char *lname,struct FILEDDF& fileDDF)
{
   char temp[_MAX_PATH];
   static char tfilename[200];
   bfile fileddf((searchBTFilePath("FILE.DDF",temp)));
   sprintf(temp,"%-*s",20,lname);

   tfilename[0]=EOS;
   if ( fileddf.get_status()!=BERR_NONE )
   {
      return tfilename;
   }

   fileddf.set_key_num(1);
   if ( (fileddf.get_rec(temp,B_GET_EQ))==BERR_NONE )
   {
      memcpy((char *)&fileDDF,fileddf.get_data(),(sizeof(struct FILEDDF)));
      memcpy(tfilename,fileDDF.fileLoc,64);
      tfilename[64]=EOS;
      del_trsp(tfilename);
   }
   return(tfilename);
}
int dataToFieldDDF(char *data,struct FIELDDDF *field)
{
   memcpy(&field->fieldID,(data),2);
   memcpy(&field->fileID,(data+2),2);
   memcpy(&field->fieldName[0],(data+4),20);
   memcpy(&field->btDataType,(data+24),1);
   memcpy(&field->offset,(data+25),2);
   memcpy(&field->fieldSize,(data+27),2);
   memcpy(&field->decimals,(data+29),1);
   memcpy(&field->flags,(data+30),2);
   return(1);
}

int dataToIndexDDF(char *data,struct INDEXDDF *field)
{
   memcpy(&field->fileID,(data),2);
   memcpy(&field->fieldID,(data+2),2);
   memcpy(&field->keyNumber,(data+4),2);
   memcpy(&field->segNumber,(data+6),2);
   memcpy(&field->flags,(data+8),2);
   return(1);
}

int calcAsciiLen(struct FIELDDDF *choosenFields)
{
      if ( choosenFields->btDataType==BFTYP_INT ||
           choosenFields->btDataType==BFTYP_UNSIGNED ||
           choosenFields->btDataType==BFTYP_AUTOINC )
      {
         if ( choosenFields->fieldSize==2 )
         {
            return(6);   // 6 since sign might be there
         }
         else
         {
            return(12);
         }
      }
      else if ( choosenFields->btDataType==BFTYP_DECIMAL ||
                choosenFields->btDataType==BFTYP_MONEY )
      {
         return(choosenFields->fieldSize*2);
      }
      else if ( choosenFields->btDataType==BFTYP_FLOAT ||
                choosenFields->btDataType==BFTYP_BFLOAT )
      {
         if ( choosenFields->decimals==0 )
         {
            return(14);
         }
         else
         {
            return(12);
         }
      }
      else if ( choosenFields->btDataType==BFTYP_DATE )
      {
         return(10);
      }
      else if ( choosenFields->btDataType==BFTYP_LSTRING ||
                choosenFields->btDataType==BFTYP_ZSTRING )
      {
         return(choosenFields->fieldSize-1);
      }
      else if ( choosenFields->btDataType==BFTYP_TIME )
      {
         return(8);
      }
      else if ( choosenFields->btDataType==BFTYP_NUMERIC ||
                choosenFields->btDataType==BFTYP_TRSIGN )
      {
         if ( choosenFields->decimals>0 )
         {
            return(choosenFields->fieldSize+3);
         }
         else
         {
            return(choosenFields->fieldSize);
         }
      }
      return(choosenFields->fieldSize);
}



int loadFields(int currentFileID,struct FIELDDDF *fields[])
{
   char temp[_MAX_PATH];
   bfile fieldddf((searchBTFilePath("FIELD.DDF",temp)));
   int  loop=0;
   int  numFields=0;
   struct FIELDDDF fieldDDF;

   fieldddf.set_key_num(1);
   memcpy(temp,(char *)&currentFileID,2);

   memcpy(temp,&currentFileID,2);
   if ( (fieldddf.get_rec(temp,B_GET_EQ))==BERR_NONE )
   {
      do {
         dataToFieldDDF(fieldddf.get_data(),&fieldDDF);
        /* current file? */
         if ( (fieldDDF.fileID)==currentFileID )
         {
            fields[loop]=new struct FIELDDDF;
            if ( fields[loop] )
            {
               memcpy((char *)fields[loop],(char *)&fieldDDF,(sizeof(struct FIELDDDF)));
               fields[loop]->value.setLenDec((calcAsciiLen(&fieldDDF)),fieldDDF.decimals);
            }
            loop++;
            fields[loop]=0;
            numFields++;
         }
         else
         {
            break;
         }
      } while ( (fieldddf.get_rec(temp,B_GET_NEXT))==BERR_NONE && loop<255 );
   }
   fields[255]=new struct FIELDDDF;
   if ( fields[255]!=0 )
   {
      strcpy(fields[255]->fieldName,"N/A");
      fields[255]->value.setVal(" ");
   }

   return(numFields);
}


