/*******************************************************************************
*                                                                              *
*                                 SAFEALOC.C                                   *
*                                                                              *
*  A safer way to do malloc and free                                           *
*                                                                              *
*                                                                              *
*******************************************************************************/

/*------------------------------  HEADER FILES  ------------------------------*/
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "conio.h"

/*----------------  EXPORTED GLOBAL VARIABLE/FUNCTION DEF'S  -----------------*/

int alloc_count = 0;
static unsigned bytes=0;

/*

These functions also include a global variable called alloc_count which is
incremented when a 'malloc' is done, and decremented when a 'free' is done
At the end of your program, you may wish  to check 'alloc_count' to make
sure that it is '0'.  If it is NOT, you are NOT freeing all the memory
you have allocated.

*/

/*------------------------------------------------------------------------------

MY_MALLOC        -allocate memory...SAFELY!


SYNOPSIS:

    ptr_temp_bytes_space = char *my_malloc(number,file,line);

    unsigned number;        number of bytes requested
    char *file;             name of the function who call my_malloc()
    int line;               source line # who called my_malloc()

    char *ptr_temp_bytes_space;     = pointer to the requested amt of space


DESCRIPTION:

    My_malloc allocates memory by calling malloc(3).  It also checks
    for an error, and exits if necessary.

    EX: slug = my_malloc(sizeof(INODE), __FILE__, __LINE__);


------------------------------------------------------------------------------*/
char *my_malloc(int number,char *file,int line)
{
    char *temp;

    if( (temp = (char *)malloc(number)) == (char *)NULL)
    {
        printf("\n%s, %d: malloc failure (%u)",file,line,number);
        printf("\nBytes allocated=%u alloc_count=%d ",bytes,alloc_count);
	getch();
        exit(0);
    }
    memset( (char *)temp, '\0', number);

    alloc_count++;
    bytes+=number;

    return(temp);
}

/*------------------------------------------------------------------------------
My_realloc - reallocate memory

SYNOPSIS:

    char *my_realloc(pointer,size,file,line)

DESCRIPTION:

    See "my_malloc" above.

------------------------------------------------------------------------------*/
char *my_realloc(char *pointer,unsigned size,char *file,int line)
{

    if( (pointer = (char *)realloc(pointer, size)) == (char *)NULL)
    {
        printf("\n%s, %d: realloc failure (%u)",file,line,size);
	getch();
	exit(0);
    }
    alloc_count++;
    bytes+=size;
    memset( (char *)pointer, 0, size);
    return(pointer);
}
/*------------------------------------------------------------------------------
My_free - free memory

SYNOPSIS:

    char my_free(pointer)

DESCRIPTION:

    See "my_malloc" above.


------------------------------------------------------------------------------*/

int my_free(char *pointer,char *file,int line)
{
    if(pointer == NULL)
    {
	printf("\n%s, %d: free failure ",file,line);
	getch();
	exit(0);
    }

    alloc_count--;

    if ( (unsigned char)(*pointer)!=255 )
    {
       *pointer=(unsigned char)255;
       free(pointer);
    }
    return(1);
}

int report_alloc_balance()
{
   printf("\nAlloc balance is %u ",alloc_count);
   getch();
   return(1);

}

