#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "bfile.h"

extern "C" {
   char *my_malloc(int num,char *pfile,int line);
   int  my_free(char *,char *pfile,int line);
};

#include "ddffile.h"
#include "realcnvt.h"

void showData(ddfFile& file)
{
   char temp[255];
   if ( (file.get_rec(temp,B_GET_LO))==BERR_NONE )
   {
      do {
         printf("\nName: %-12.12s, %-12.12s  ID: %10ld  Zip Code: %s",
                                      file.getValue("LAST NAME"),
                                      file.getValue("FIRST NAME"),
                                      (atol(file.getValue("ID"))),
                                      file.getValue("ZIP"));
      } while ( ((file)++)==BERR_NONE );
   }
}

void main()
{
   ddfFile file1("TEST 1");
   ddfFile file2("TEST 2");
   if ( file1.get_status()==BERR_NONE )
   {
      printf("\n\nFILE 1\n\n");
      showData(file1);
   }
   else
   {
      printf("\nStatus %d on FILE 1",file1.get_status());
   }
   if ( file2.get_status()==BERR_NONE )
   {
      printf("\n\nFILE 2\n\n");
      showData(file2);
   }
   else
   {
      printf("\nStatus %d on FILE 2",file2.get_status());
   }
}

