/* ----------------------------------------------------------- *\
**  compare.cpp -- Compare files created by tpack and tunpack  **
** ----------------------------------------------------------- **
**                                                             **
** ----------------------------------------------------------- **
**     Copyright (c) 1993 by Tom Swan. All rights reserved.    **
\* ----------------------------------------------------------- */

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <stdlib.h>

void Error(const char *msg);

int main(int argc, char *argv[])
{
  int np, ns;  // Number of pixels, number of scan lines
  int b1, b2;  // Bytes from files 1 (original) and 2 (converted)

  if (argc <= 2)
    Error("filenames missing (enter two names)");

  ifstream ifsOriginal(argv[1], ios::in);
  if (!ifsOriginal)
    Error("unable to open file #1");
  ifstream ifsConverted(argv[2], ios::in);
  if (!ifsConverted)
    Error("unable to open file #2");

  // Skip number of pixels np and number of scan line ns
  // at beginning of original test data
  ifsOriginal >> hex >> np >> ns;

  while (!ifsOriginal.eof()) {
    ifsOriginal >> hex >> b1;
    ifsConverted >> hex >> b2;
    if (b1 != b2) Error("Files are different");
  }
  cerr << endl << "Files match" << endl;
  return 0;
}

// Display error message and halt
void Error(const char *msg)
{
  cerr << endl << "Error: " << msg << endl;
  exit(1);
}


// --------------------------------------------------------------
// Copyright (c) 1993 by Tom Swan. All rights reserved.
// Revision 1.00    Date: 04/13/1993   Time: 03:27 pm
