/* ----------------------------------------------------------- *\
**  create.cpp -- Create random test bitmap file               **
** ----------------------------------------------------------- **
**                                                             **
** ----------------------------------------------------------- **
**     Copyright (c) 1993 by Tom Swan. All rights reserved.    **
\* ----------------------------------------------------------- */

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <stdlib.h>
#include <time.h>

typedef unsigned char Byte;

void Error(const char *msg);
void RandomizeScanLine(Byte *sl, int np);
int RandomRange(int low, int high);
void PutByte(Byte b);

int main()
{
  int np;  // Number of pixels per scan line
  int ns;  // Number of scan lines

  cout << setiosflags(ios::uppercase);
  cout << setfill('0') << hex;
  randomize();
  np = RandomRange(10, 640);
  ns = RandomRange(4, 480);
  cout << setw(2) << np << ' ' << setw(2) << ns << endl;
  Byte *sl = new Byte[np];  // Allocate scan line
  if (!sl) Error("out of memory");
  while (ns-- > 0) {
    RandomizeScanLine(sl, np);
    for (int i = 0; i < np; ++i)
      PutByte(sl[i]);
    cout << endl;
  }
  delete sl;
  return 0;
}

// Display error message and halt
void Error(const char *msg)
{
  cerr << endl << "Error: " << msg << endl;
  exit(1);
}

// Insert random pixel values into scan line sl
void RandomizeScanLine(Byte *sl, int np)
{
  int pixel = random(256);
  for (int i = 0; i < np; ++i) {
    if (random(100) >= 80)
      pixel = random(256);  // 20% chance of new pixel value
    sl[i] = pixel;
  }
}

// Return integer at random from low to high
int RandomRange(int low, int high)
{
  return low + random((high - low) + 1);
}

// Write byte b in hex in 2 columns with leading 0
// plus one blank to cout
void PutByte(Byte b)
{
  cout << setw(2) << (unsigned int)b << ' ';
}


// --------------------------------------------------------------
// Copyright (c) 1993 by Tom Swan. All rights reserved.
// Revision 1.00    Date: 04/20/1993   Time: 03:33 pm
