{ ubitmap.pas -- Load DIB bitmap .BMP files }

unit UBitmap;

interface

uses WinTypes, WinProcs;

function LoadBitmap(FileName: PChar; (*HWindow: HWnd;*)
  var Width, Height: LongInt): HBitmap;

implementation

var Result: Word;

{ Required for segment arithmetic in GetBitmapData }
procedure AHIncr; far; external 'KERNEL' index 114;

procedure GetBitmapData(var TheFile: File;
  BitsHandle: THandle; BitsByteSize: Longint);
type
  LongType = record
    case Word of
      0: (Ptr: Pointer);
      1: (Long: Longint);
      2: (Lo: Word;
	  Hi: Word);
  end;
var
  Count: Longint;
  Start, ToAddr, Bits: LongType;
begin
  Start.Long := 0;
  Count := BitsByteSize;
  Bits.Ptr := GlobalLock(BitsHandle);
  if Bits.Ptr <> nil then
  begin
    while Count > 0 do
    begin
      ToAddr.Hi := Bits.Hi + (Start.Hi * Ofs(AHIncr));
      ToAddr.Lo := Start.Lo;
      if Count > $4000 then Count := $4000;
      BlockRead(TheFile, ToAddr.Ptr^, Count, Result);
      Start.Long := Start.Long + Count;
      Count := BitsByteSize - Start.Long
    end;
    GlobalUnlock(BitsHandle)
  end
end;

{- True if file F is a bitmap file. If true, F is opened. }
function IsBitmapFile(FileName: PChar; var F: File): Boolean;
var
  TestValue: LongInt;
begin
  IsBitmapFile := false;
  Assign(F, FileName);
  {$I-} Reset(F, 1); {$I+}
  if IoResult = 0 then
  begin
    Seek(F, 14);
    BlockRead(F, TestValue, SizeOf(TestValue), Result);
    if TestValue = $28 then
      IsBitmapFile := true
    else
      Close(F)
  end
end;

{- Load DIB bitmap file. Return handle if successful, else return 0.}
function LoadBitmap(FileName: PChar;
  var Width, Height: LongInt): HBitmap;
var
  BitmapInfo: PBitmapInfo;
  BmpHandle: THandle;
  BitmapSize: Word;
  HeaderSize: Word;
  LWidth: Longint;
  PBits: Pointer;
  F: File;
  DC: HDC;
begin

  LoadBitmap := 0;  { Preset function result to "null" }

  if IsBitmapFile(FileName, F) then
  begin

{- Load bitmap header information at offset 28 }

    Seek(F, 28);
    BlockRead(F, BitmapSize, SizeOf(BitmapSize), Result);
    if BitmapSize <= 8 then
    begin
      HeaderSize := SizeOf(TBitmapInfoHeader) +
        ((1 shl BitmapSize) * SizeOf(TRGBQuad));
      GetMem(BitmapInfo, HeaderSize);
      if BitmapInfo <> nil then
      begin

{- Get width and height of bitmap in pixels }

        with BitmapInfo^, BMIHeader do
        begin
          Seek(F, SizeOf(TBitmapFileHeader));
          BlockRead(F, BitmapInfo^, HeaderSize, Result);
          Width := BIWidth;
          Height := BIHeight;

{- Load DIB image }

          LWidth := (((Width * BitmapSize) + 31) div 32) * 4;
          BISizeImage := LWidth * Height;
          GlobalCompact(-1);
          BmpHandle := GlobalAlloc(gmem_Moveable or gmem_Zeroinit,
            BISizeImage);
          if BmpHandle <> 0 then
          begin
            GetBitmapData(F, BmpHandle, BISizeImage);
            PBits := GlobalLock(BmpHandle);
            if PBits <> nil then
            begin
              DC := CreateDC('Display', nil, nil, nil);
              LoadBitmap := CreateDIBitmap(DC, BMIHeader, cbm_Init,
                PBits, BitmapInfo^, 0);
              DeleteDC(DC);
              GlobalUnlock(BmpHandle)
            end;
            GlobalFree(BmpHandle)
          end
        end;
        FreeMem(BitmapInfo, HeaderSize)
      end
    end;
    Close(F)
  end
end;

end.


{ --------------------------------------------------------------
  Copyright (c) 1991, 1993 by Tom Swan. All rights reserved.
  -------------------------------------------------------------- }
