/* Extended IEEE Compatible Floating Point Arithmetic Library
**
** Version 1.1
** Copyright (C) 1990,1992 by Fred Motteler
** All Rights Reserved
**
** This is a simple extended floating point arithmetic package.
** It must be used with the extended integer arithmetic package.
**
** Format:
**
** |S| n bit signed exponent | m bit fraction |
**
** The format is compatible with IEEE Standard for Binary Floating
** when:
**		n = 8,   m = 23		single precision
**		n = 11,  m = 52		double precision
**
** If n = 15 and m = 64, this format is almost compatible with IEEE
** extended precision format.  The main difference are
**	1) IEEE extended precision format is a 12 byte format with 10 bytes of
**	   information.  Bits 64 thru 80 are zero.
**	2) The most significant bit of the mantissa (implied in single and
**	   double precision IEEE formats) is explicitly included.
*/

/* Integer formats tested.  These values represent the "standard" integer
** formats: BYTE, WORD, and LONG.  To test the extensibility of these
** routines, four extra long formats are also tested: DOUBLE LONG and
** QUAD LONG, DOUBLE QUAD LONG, and QUAD QUAD LONG */
#define BYTEWIDE 1
#define WORDWIDE 2
#define LONGWIDE 4
#define DOUBLEWIDE 8
#define QUADWIDE 16
#define DQWIDE 32
#define QQWIDE 64

/* Floating point formats tested.  These values represent the "standard"
** IEEE floating point formats: FLOAT, DOUBLE, and EXTENDED.  To test the
** extensibility of these routines, extra long SIXTEEN, THIRTYTWO, and
** FORTYEIGHTEXP byte formats are also tested. */
#define SINGLEXP 8
#define SINGLEFRAC 23
#define SINGLEN 4
#define DOUBLEXP 11
#define DOUBLEFRAC 52
#define DOUBLEN 8
#define EXTENDEXP 15
#define EXTENDFRAC 63
#define EXTENDLEN 10
#define SIXTEENEXP 23
#define SIXTEENFRAC 104
#define SIXTEENLEN 16
#define THIRTYTWOEXP 23
#define THIRTYTWOFRAC 232
#define THIRTYTWOLEN 32
#define FORTYEIGHTEXP 23
#define FORTYEIGHTFRAC 360
#define FORTYEIGHTLEN 48


#ifdef PROTOTYPES
extern int fmtst1(int *testN);
extern int fmtst2(int *testN);
extern int fmtst3(int *testN);
extern void foutput(char *stringBP, unsigned char *floatBP, int lengthN);
#else 
extern int fmtst1();
/* Some compilers (EcoSoft for the CP/M) can't handle the entire tester... */
#ifndef PARTEST
extern int fmtst2();
extern int fmtst3();
#endif
extern void foutput();
#endif

