/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
DEBUGTABLES:	public	const	int = 16;	// Maximum # of debug tables
						// in a unit.

debugUnitHeader:	public	type	packed	{
	public:
	name:		[9] char;
	nTables:	char;
	flags:		unsigned[16];
	codeOffset:	unsigned[32];
	nextUnit:	unsigned[32];
	tableOffsets:	[DEBUGTABLES] unsigned[32];
	};

G_SVC:		public	const	unsigned[8] =  0x00;
G_GATE:		public	const	unsigned[8] =  0x01;

RUN_MAGIC:	public	const	unsigned[16] = 0x8c6a;
RUN_VERSION:	public	const	unsigned[8] =  0x11;
RUN_VERSION_2:	public	const	unsigned[8] =  0x12;
LOD_MAGIC:	public	const	unsigned[16] = 0x8c6b;
LOD_VERSION:	public	const	unsigned[8] =  0x1;

runHeader:	public	type	packed	{
	public:
	magic:		unsigned[16];
	version:	unsigned[8];
			unsigned[8];
	cs:		unsigned[16];
	ds:		unsigned[16];
	ss:		unsigned[16];
			unsigned[16];
	ip:		unsigned[32];
	sp:		unsigned[32];
	descriptors:	unsigned[32];
	image:		unsigned[32];
	fixups:		unsigned[32];
	gates:		unsigned[32];
	codeLen:	unsigned[32];
	dataInitLen:	unsigned[32];
	dataTotalLen:	unsigned[32];
	externGates:	unsigned[32];
	debugInfo:	unsigned[32];
	codeOffset:	unsigned[32];
	dataOffset:	unsigned[32];
	tables:		[48] unsigned[32];
	};

