/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	file;
include	alys;
include	symtab;

trace:	public	(db: ref debugBuffer) =
	{
	esp:	unsigned;
	nsp:	unsigned;
	ebp:	unsigned;
	nbp:	unsigned;
	eip:	unsigned;
	esp = db->tss.esp;
	ebp = db->tss.ebp;
	printf("                              ");
	printf("Stopped at %08x ", db->tss.eip);
	s:	* symbol;
	s = CodeSymbols findSymbol(db->tss.eip);
	if	(s)
		s display(db->tss.eip);
	printf("\n");
/*
	if	(CoreLen < RunHeader->dataTotalLen){
		printf("Data segment too small\n");
		exit(1);
		}
 */
	while	(s != Start){
		if	(s &&
			 s hasFullStackFrame()){
			if	(ebp == 0)
				break;
			}
		printf("esp: %08x%c ebp: %08x%c ", esp, esp & 3 ? '*' : ' ',
						   ebp, ebp & 3 ? '*' : ' ');
		if	(esp < RunHeader->dataInitLen){
			printf("Stack overflow\n");
			printf("                              ");
			}
		if	(esp > RunHeader->sp){
			printf("Stack underflow\n");
			break;
			}
		if	(s == 0){
			printf("In unknown function\n");
			break;
			}
		b:	boolean;

		b = s hasFullStackFrame();
		if	(b){
			if	(ebp < esp ||
				 ebp > RunHeader->sp - 4){
				printf("Frame pointer is not valid\n");
				break;
				}
			get(&db->dataFD, ebp, &nbp, sizeof nbp);
			if	(nbp &&
				 nbp < ebp){
				printf("Frames are not ascending\n");
				break;
				}
			}
		else
			nbp = ebp;
		nsp = s locateReturnAddress(ebp, esp);
		if	(nsp == 0 ||
			 nsp > RunHeader->sp - 4){
			printf("Could not find return address\n");
			break;
			}
		get(&db->dataFD, nsp, &eip, sizeof eip);
		printf("from %08x ", eip);
		s = CodeSymbols findSymbol(eip);
		if	(!b)
			printf("? ");
		if	(s)
			s display(eip);
		printf("\n");
		esp = nsp + 4;
		ebp = nbp;
		}
	}

get:	(fd: ref stream, loc: unsigned, buf: [:] byte) int =
	{
	fd seek(loc, SEEK_ABS);
	return fd read(buf);
	}
