/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	kprintf;
include	error;
include	hardware;
include	process;
include	memory;
include	object;
include	alys;
include	message;

NARENAS:		public	const int = _KERNEL_PROCS;
ARENA_LATCH_COUNT:	public	const int = 2;

ArenaTable:		[NARENAS] ref arena;
CurArena:	public	ref arena;

arena:	public	type	{
	useCount:		int;

locateEvent:	(event: vaddr_t) ref eventList =
	{
	e:	ref eventList;
	n:	threadLock;

	n lock();
	for	(e = elist; e; e = e->next)
		if	(e->event == event)
			return e;
	e = elist = new eventList[ elist, event, [ 0 ] ];
	n unlock();
	return e;
	}

	public:

	latch:			byte;
	elist:			ref eventList;

eventDown:	(event: vaddr_t) =
	{
	e:	ref eventList;

	e = locateEvent(event);
	latch = 0;
	e->sema down(FALSE);
	}

eventUp:	(event: vaddr_t) _latchValues_t =
	{
	e:	ref eventList;
	n:	threadLock;
	i:	_latchValues_t;

	e = locateEvent(event);
	n lock();
	e->sema up();
	if	(e->sema.count >= 0)
		i = _LATCH_CLOSED;
	else
		i = _LATCH_WAITERS;
	n unlock();
	return i;
	}

assignTableEntry:	factory	(ar: ref arena) int =
	{
	i:	int;
	n:	threadLock;

	n lock();
	for	(i = 0; i < NARENAS; i++){
		if	(ArenaTable[i] == 0){
			ArenaTable[i] = ar;
			n unlock();
			return i;
			}
		}
	n unlock();
	return -1;
	}

constructor:	() =
	{
	useCount = 1;
	latch = 0;
	elist = 0;
	}

dup:	() =
	{
	useCount++;
	}

bind:	(p: ref process) =
	{
	ar: 	ref arena;
	n:	threadLock;

	ar = p->where;
	n lock();
	CurArena = p->where = p->animates->where = self;
	n unlock();
	useCount++;
	ar close();
	}

generalProtectionFault:	dynamic	(ref interruptFrame_t) =
	{
	}

peekThread:	dynamic	() vaddr_t =
	{
	return 0;
	}

pokeThread:	dynamic	(x: vaddr_t) =
	{
	}

dumpHex:	dynamic	(p: vaddr_t, len: vaddr_t) =
	{
	}

initializeThread:	dynamic	(p: ref process, th: vaddr_t, 
					stack: vaddr_t, func: vaddr_t) =
	{
	}

grow:	dynamic	(newLen: vaddr_t) boolean =
	{
	return FALSE;
	}

close:	() =
	{
	n:	threadLock;

	n lock();
	useCount--;
	if	(useCount == 0){
		n unlock();
		_free();
		}
	else
		n unlock();
	}

_free:	dynamic	() =
	{
	enext, e:	ref eventList;

	for	(e = elist; e; e = enext){
		enext = e->next;
		free(e);
		}
	free(self);
	}

obtainWrite:	dynamic	(buf: vaddr_t, len: vaddr_t) pointer =
	{
	return 0;
	}

unlock:	dynamic	() =
	{
	}

write:	dynamic	(offs: vaddr_t, src: pointer, len: vaddr_t) int =
	{
	return ERRINVALIDFUNC;
	}

read:	dynamic	(offs: vaddr_t, dest: pointer, len: vaddr_t) int =
	{
	return ERRINVALIDFUNC;
	}
/*
	This function tests whether the kernel can legitimately call the 
	named code address.  The address is relative to the code segment.
 */
canCall:	dynamic	(addr: vaddr_t) boolean =
	{
	return FALSE;
	}
/*
	This function tests whether the kernel can legitimately read
	the named data buffer in the arena.  The address is relative to
	the data segment.
 */
canRead:	dynamic	(addr: vaddr_t, len: vaddr_t) boolean =
	{
	return FALSE;
	}
/*
	This function tests whether the kernel can legitimately write to
	the named data buffer in the arena.  The address is relative to
	the data segment.
 */
canWrite:	dynamic	(addr: vaddr_t, len: vaddr_t) boolean =
	{
	return FALSE;
	}

recoverSendParameters:	dynamic	(ref task_t) =
	{
	}

scheduleSignal:	dynamic	(o: ref object, p: ref process, seq: int) =
	{
	}
/*
	This function returns TRUE if the signal was caught, FALSEif it was
	not.
 */
/*
handleSignal:	dynamic	(ifr: ref interruptFrame_t, o: ref object,
				sig: signal_t) boolean =
	{
	return FALSE;
	}
 */
coreDump:	dynamic	(ref message) boolean =
	{
	return FALSE;
	}

	};

eventList:	type	{ public:
	next:		ref eventList;
	event:		vaddr_t;
	sema:		semaphore;
	};
