/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	alys, string;
include	error;
include	filesys;
include	object;
include	kprintf;

ALYS_NAME_LENGTH:	const	int = 32;

createBackbone:	entry	() =
	{
//	Root = [ AR_ANY ];
	Root constructor(AR_ANY);
//	kprintf("Root id = %x\n", Root.id);
	}

//RootDirectory:	public	ref far alysDictionary;
Root:		public	alysDictionary;

alysDictionary:	public	type	inherit	directory {
	public:
	first:		ref alysFile;
	last:		ref alysFile;
	dot:		alysDir;
	id:		ref far alysDictionary;

constructor:	(access: accessRights_t) =
	{
	dot = [ ".", self ];
	first = &dot;
	last = &dot;
	id = ref far alysDictionary(publishKernel("/", self, access, 
					AR_ANY, AR_ANY, AR_ANY));
//	kprintf("constructing alysDictionary id = %x\n", id);
	}

mount:	(name: [:] char, dev: ref volume, dir: ref far directory) int =
	{
	af:	ref alysFile;

	for	(af = first; af; af = af->next){
		if	(stringIcompare(name, af->name) == 0)
			return ERREXIST;
		}

	xdf:	ref alysVolume;
	xdf = new alysVolume[ name, dev, dir ];
	appendToDirectory(xdf);
	kprintf("Mounting /%S\n", name);
	return SUCCESS;
	}

createDevice:	(fname: [:] char, dev: ref file, attr: fAttributes_t) int =
	{
	xdv:	ref alysDevice;
	af:	ref alysFile;

	for	(af = first; af; af = af->next){
		if	(stringIcompare(fname, af->name) == 0)
			return ERREXIST;
		}
	xdv = new alysDevice[ fname, dev, attr ];
	appendToDirectory(xdv);
	kprintf("Defining /%S\n", fname);
	return SUCCESS;
	}

appendToDirectory:	(xd: ref alysFile) =
	{
	if	(first){
		last->next = xd;
		xd->prev = last;
		}
	else	{
		first = xd;
		xd->prev = 0;
		}
	xd->next = 0;
	last = xd;
	}

open:	gate	(fname: [:] char, opt: accessRights_t) ref far channel = 
	{
	v:		ref alysFile;
	ch:		ref far channel;

//	kprintf("opening %S opt %x\n", fname, opt);
	v = findDirectoryEntry(fname);
	if	(v == 0)
		return 0;
	if	(v attach(opt))
		return 0;
	ch = v open(opt);
	if	(ch == 0)
		v close();
	return ch;
	}
/*
create:			gate	(fname: [:] char, attr: [:] char) 
							ref far channel = 
	{
	reject();
	}

makeDirectory:		gate	(fname: [:] char) int =
	{
	reject();
	}

removeDirectory:	gate	(fname: [:] char) int =
	{
	reject();
	}

delete:			gate	(fname: [:] char) int =
	{
	reject();
	}

deleteGroup:		gate	(fname: [:] char) int =
	{
	reject();
	}

 */
find:	gate	(fname: [:] char) ref far directory = 
	{
	v:		ref alysFile;
	
//	kprintf("In backbone find fname = %S\n", fname);
	v = findDirectoryEntry(fname);
	if	(v == 0)
		return 0;
	if	(v->attributes & FA_DIR == 0)
		return 0;
//	kprintf("v = %x v getDirectory = %x\n", v, v getDirectory());
	d:	ref far directory;
	d = v getDirectory();
	dupObject(d);
	return d;
	}

setFileAttributes:	gate	(fname: [:] char, attr: fAttributes_t) int =
	{
	v:		ref alysFile;
	err:		int;

	v = findDirectoryEntry(fname);
	if	(v == 0)
		return ERRNOFILE;
	err = v attach(AR_WRITE);
	if	(err){
		v close();
		return err;
		}
	v->attributes = attr;
//	v->flags |= F_CHANGED;
	v close();
	return SUCCESS;
	}

access:			gate	(fname: [:] char, opt: accessRights_t) int =
	{
	err:		int;
	v:		* alysFile;

	v = findDirectoryEntry(fname);
	if	(v == 0)
		return ERRNOFILE;
	err = v attach(opt);
	v close();
	return err;
	}

stat:	gate	(fname: [:] char) file_t = 
	{
	v:		* alysFile;
	f:		file_t;

//	kprintf("stat(%S)\n", fname);
	v = findDirectoryEntry(fname);
//	kprintf("v = %x\n", v);
	if	(v == 0){
		memSet(&f, 0, sizeof f);
		f.id = -1;
		return f;
		}
	f.attributes = v->attributes;
	f.size = v->size;
	f.ftime = v->ftime;
	f.user = v->user;
	f.group = v->group;
	f.id = int(v);
	v close();
	return f;
	}
/*
create:	dynamic	(path: string, attr: fileAttributes) * file =
	{
	d:		diskDirectory;
	fp:		* file;
	err:		int;

	err = findDirectoryEntry(&d, path, D_CREATE);
	if	(err){
		CurProc->error = err;
		return 0;
		}
	fp = newFile(&d, D_CREATE);
	fp = fp attach(AR_WRITE | AR_CONTROL);
	if	(fp == 0)
		return fp;
	fp->attributes = attr;
	fp->ftime = newFileTime();
	fp->flags |= F_CHANGED;
	return fp;
	}

makeDirectory:	dynamic	(filename: string) int =
	{
	d:		diskDirectory;
	fd:		int;
	fp:		* DOSfile;
	ch:		* channel;
	parTime:	int;
	err:		int;
	newTime:	int;

		// File had better not exist 

	err = findDirectoryEntry(&d, filename, D_LOOKUP);
	if	(err == 0)
		return ERREXIST;

	err = findDirectoryEntry(&d, filename, D_CREATE);
	if	(err)
		return err;
	newTime = newFileTime();
	if	(cluster == 0)
		parTime = newTime;
	else	{
		d2:	diskDirectory;

		d.disk getDirectoryEntry(&d2, cluster, 0);
		parTime = d2.ftime;
		}
	fp = newFile(&d, D_CREATE);
	if	(fp == 0)
		return ERRMFILE;
	ch = fp open(CH_WRITE);
	if	(ch == 0){			// Big trouble, no room for
						// the channel to make the
						// directory complete
		d.filename[0] = FILE_DEL_CHAR;
		writeDirectoryEntry(&d);
		fp close();
		return ERRNOMEMORY;
		}
	BasicDirEvent take(0);			// Non-interruptable protection
						// of BasicDirs
	ch seek(SECTOR_SIZE * 
			ref dosVolume(residesOn)->sectorsPerCluster - 1, 0);
	ch write(&BasicDirs[0].size, 1);		// write a zero
	BasicDirs[0].cluster = fp->sCluster;
	BasicDirs[0].ftime = newTime;
	BasicDirs[1].ftime = parTime;
	BasicDirs[1].cluster = cluster;
	ch seek(0, 0);
	ch write(&BasicDirs, sizeof BasicDirs);
	BasicDirEvent give();			// BasicDirs is available now
	fp->ftime = newTime;
	ch close();				// Writes the directory 
						// Entry and FAT
	err = findDirectoryEntry(&d, filename, D_LOOKUP);
	if	(err)
		return err;
	d.attribute = DA_DIR;
	d.size = 0;
	writeDirectoryEntry(&d);
	return SUCCESS;
	}

removeDirectory:	dynamic	(path: string) int =
	{
	err:		int;
	d:		diskDirectory;
	d2:		diskDirectory;
	i:		int;

	err = findDirectoryEntry(&d, path, D_LOOKUP);
	if	(err)
		return err;
	if	(d.attribute & DA_READONLY)
		return ERRPERMISSION;
	if	(d.attribute & DA_DIR == 0)
		return ERRPERMISSION;

	for	(i = 0; ; i++){
		err = d.disk getDirectoryEntry(&d2, d.cluster, i);
		if	(err)
			break;

			// Ignore deleted entries

		if	(d2.filename[0] == FILE_DEL_CHAR)
			continue;

			// Null byte entries signal end of directory

		if	(d2.filename[0] == 0)
			break;

			// If any entries are not . or .. abort

		if	(d2.filename[0] != '.')
			return ERRPERMISSION;

		if	(d2.filename[1] != ' ' &&
			 d2.filename[1] != '.')
			return ERRPERMISSION;
		}
	ref dosVolume(residesOn) removeChain(d.cluster);
	ref dosVolume(residesOn) syncFAT();
	d.filename[0] = FILE_DEL_CHAR;
	writeDirectoryEntry(&d);
	return SUCCESS;
	}

delete:	dynamic	(path: string) errorCode =
	{
	d:	diskDirectory;
	i:	int;

	i = findDirectoryEntry(&d, path, D_DELETE);
	if	(i == SUCCESS)
		d.disk syncFAT();
	return i;
	}

deleteGroup:	dynamic	(path: string) errorCode =
	{
	d:	diskDirectory;
	i:	int;

	i = findDirectoryEntry(&d, path, D_DGROUP);
	if	(i > 0){
		d.disk syncFAT();
		return SUCCESS;
		}
	else if	(i)
		return i;
	else
		return ERRNOFILE;
	}
 */
move:	gate	(fname1: [:] char, dr2x: ref far directory, 
						fname2: [:] char) int =
	{
	d:		ref alysFile;
	d2:		ref alysFile;
	dr2:		ref alysDictionary;

	dr2 = locateObject(dr2x);

		// Make sure the target name doesn't already exist

	d = dr2 findDirectoryEntry(fname2);
	if	(d)
		return ERREXIST;
	d = findDirectoryEntry(fname1);
	if	(d == 0)
		return ERRNOFILE;
		
		// We are doing a simple rename of a file within the
		// same directory.

	if	(dr2 == self){
		free(d->name);
		d->name = new [|fname2] char;
		d->name [:]= fname2;
		}
	else
		return ERRPERMISSION;
	return SUCCESS;
	}

getAbsolutePath:	gate	(fname: [:] char) [] char =
	{
	buf:		[ALYS_NAME_LENGTH + 1] char;

	if	(|fname > ALYS_NAME_LENGTH)
		reject(ERRINVALIDDATA);
	replyPartial("/", 1);
	if	(stringCompare(fname, "."))
		return fname;
	}

findDirectoryEntry:	dynamic	(n: [:] char) ref alysFile =
	{
	af:	* alysFile;

	for	(af = first; af; af = af->next){
//		kprintf("Looking at %s\n", af->name);
		if	(stringIcompare(af->name, n) == 0){
			af dup();
			return af;
			}
		}
	return 0;
	}

addReference:	gate	() =
	{
	}

getDriveInfo:	gate	() drive_t =
	{
	return [ 0 ];
	}

scanDirectory:	gate	() ref far directoryScanner =
	{
	a:	ref alysScanner;
	af:	ref far directoryScanner;

	a = new alysScanner[ self ];
	af = ref far directoryScanner(jobPublishKernel(dot.name, a, AR_ANY));
	if	(af == 0)
		free(a);
	return af;
	}

close:	gate	() boolean =
	{
//	kprintf("Rejecting close of /\n");
	return FALSE;
	}

delete:	gate	() boolean =
	{
//	kprintf("Rejecting delete of /\n");
	return FALSE;
	}

	};

alysScanner:	type	inherit	directoryScanner {
	here:	ref alysFile;

	public:

constructor:	(d: ref alysDictionary) =
	{
	here = d->first;
	}

next:	gate	() fileDescriptor_t =
	{
	fd:	fileDescriptor_t;

	if	(here){
		i:	int;
		d:	ref alysFile;

		d = here;
		here = d->next;
		fd.info.attributes = d->attributes;
		fd.info.ftime = d->ftime;
		fd.info.user = d->user;
		fd.info.group = d->group;
		fd.info.id = int(&d);
		fd.info.size = d->size;
		i = |d->name;
		if	(i > sizeof fd.name)
			i = sizeof fd.name;
		memSet(fd.name, 0, sizeof fd.name);
		fd.name [:]= d->name[:i];
		fd.nlen = i;
		}
	else
		memSet(&fd, 0, sizeof fd);
	return fd;
	}

	};

alysFile:	type	inherit file {
	public:

	next:		ref alysFile;
	prev:		ref alysFile;
	name:		[:] char;

getDirectory:	dynamic	() ref far directory =
	{
	return 0;
	}

	};

alysVolume:	type	inherit	alysFile {
	public:

	vol:		* volume;
	vdir:		ref far directory;

constructor:	(nm: [:] char, v: * volume, vd: ref far directory) =
	{
	name = nm;
	attributes = FA_DIR|FA_READ;
	size = 0;
	ftime = 0;
	useCount = 1;
	user = 0;
	group = 0;
	flags = 0;
	vol = v;
	vdir = vd;
	next = 0;
	prev = 0;
	}

getDirectory:	dynamic	() ref far directory =
	{
	return vdir;
	}

	};

alysDir:	type	inherit	alysFile {
	public:

	vdir:		ref alysDictionary;

constructor:	(nm: [:] char, vd: ref alysDictionary) =
	{
	name = nm;
	attributes = FA_DIR|FA_READ;
	size = 0;
	ftime = 0;
	useCount = 1;
	user = 0;
	group = 0;
	flags = 0;
	vdir = vd;
	next = 0;
	prev = 0;
	}

getDirectory:	dynamic	() ref far directory =
	{
	return vdir->id;
	}

	};

alysDirChannel:	public	type	inherit	directoryChannel {
	public:
	owner:		ref alysDictionary;
	filePos:	* alysFile;

constructor:	(dp: ref alysDictionary) =
	{
	super constructor(0);
	owner = dp;
	filePos = owner->first;
	}

dispose:	dynamic	() =
	{
	free(self);
	}

	};

alysDevice:	type	inherit	alysFile {
	public:

	thisFile:	* file;

constructor:	(nm: [:] char, f: * file, attr: fAttributes_t) =
	{
	name = nm;
	attributes = attr;
	thisFile = f;
	size = 0;
	ftime = 0;
	useCount = 1;
	user = 0;
	group = 0;
	flags = 0;
	}

open:	dynamic	(acc: accessRights_t) ref far channel =
	{
	return thisFile open(acc);
	}

	};
/*
alysNetNode:	type	inherit alysFile {
	netNode:	* nodeDescriptor;
	nodeId:		objectId;

	public:

constructor:	(nm: string, nn: * nodeDescriptor, ni: int) =
	{
	nodeId = ni;
	name = nm;
	attributes = FA_DIR|FA_READ|FA_NETNODE;
	size = 0;
	ftime = 0;
	useCount = 1;
	user = 0;
	group = 0;
	flags = 0;
	netNode = nn;
	}

getDirectory:	dynamic	() * directory =
	{
	d:	* remoteDirectory;

	if	(MyNetNodeId == 0){
		CurProc->error = ERRNETDOWN;
		return 0;
		}
	if	(netNode->state == ND_UNKNOWN){
		err:	int;


		err = probeNode(nodeId);
		if	(err < 0){
			CurProc->error = err;
			return 0;
			}
		}
	if	(netNode->state != ND_UP){
		CurProc->error = ERRNODEDOWN;
		return 0;
		}
	d = new remoteDirectory[ netNode, netNode->namer ];
	return d;
	}

	};

 */