/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	alys;
include	filesys;
include	dos_vol;
include	object;
include	disk;
include	kprintf;
include	error;

diskioOps:	type	char = {
	READ_OP,
	RLOCAL_OP,
	WRITE_OP,
	FILL_OP
	};
/*
//FileTrap:	trap;

FILE_DEL_CHAR:	public	const	byte = 0xE5;

dirAttributes:	public	type	byte = {
	DA_READONLY	= 0x01,
	DA_HIDDEN	= 0x02,
	DA_SYSTEM	= 0x04,
	DA_VLABEL	= 0x08,
	DA_DIR		= 0x10,
	DA_ARCHIVE	= 0x20,
	};

diskDirectory:	public	type	packed	{
	public:
	filename:	[8] byte;
	extension:	[3] byte;
	attribute:	dirAttributes;
 			[10] char;
	ftime:		ftime_t;
	cluster:	unsigned[16];
	size:		unsignedLong;
	};

incoreDirectory:	public	type {
	public:
	dd:		diskDirectory;
	sector:		unsigned;
	offset:		unsigned[16];
	disk:		* dosVolume_t;
	};
 */
DOSfile:	public	type	inherit	file {
	public:

	prev:		* DOSfile;
	next:		* DOSfile;
	disk:		* dosVolume_t;
	sCluster:	unsigned[16];
	DOSattrib:	dirAttributes;
	dirSector:	unsigned;
	dirOffset:	byte;

constructor:	(dp: * incoreDirectory) =
	{
	i:	fAttributes_t;

	i = (int(dp->dd.attribute) & 
			(DA_HIDDEN|DA_SYSTEM|DA_VLABEL|DA_DIR|DA_ARCHIVE))
				<< 11;
	i |= 	FA_READ|FA_CONTROL|FA_EXEC|FA_SEEKOK;
	if	(dp->dd.attribute & (DA_READONLY|DA_DIR) == 0)
		i |= FA_WRITE;
	user = 0;
	group = 0;
	DOSattrib = dp->dd.attribute;
	attributes = i;
	sCluster = dp->dd.cluster;
	size = dp->dd.size;
	ftime = dp->dd.ftime;
	useCount = 1;
	dirSector = dp->sector;
	dirOffset = dp->offset >> 5;
	disk = dp->disk;
	disk loadFAT();
	flags = 0;
	next = disk->files;
	prev = 0;
	if	(disk->files)
		disk->files->prev = self;
	disk->files = self;
	}

open:	dynamic	(access: accessRights_t) ref far channel = 
	{
	dc:	ref DOSfileChannel;
	x:	ref far channel;

	dc = new DOSfileChannel[ self ];
	return ref far channel(jobPublishKernel("file channel", dc, access));
	}

dispose:	dynamic	() =
	{
	sync();
	if	(prev)
		prev->next = next;
	else
		disk->files = next;
	if	(next)
		next->prev = prev;
	free(self);
	}

sync:	dynamic	() =
	{
	dp:	* diskDirectory;
	buf:	pointer;

		// Update any pending directory entry on a write

	if	(flags & F_CHANGED){
		sect:	int;
		off:	int;

		disk syncFAT();
		if	(dirSector){
			dp = disk->drive readSector(dirSector);
			buf = dp;
			dp += dirOffset;
			dp->ftime = ftime;
			dp->size = size;
			dp->cluster = sCluster;
			disk->drive writeSector(buf);
			}
		flags &= ~F_CHANGED;
		}
	}

truncate:	(newLength: long) =
	{
	if	(newLength < size){
		disk truncateChain(sCluster, newLength);
		size = newLength;
		ftime = newFileTime();
		flags |= F_CHANGED;
		if	(size == 0)
			sCluster = 0;
		}
	}

	};

DOSDirfile:	public	type	inherit	DOSfile {

constructor:	(dp: * incoreDirectory) =
	{
	super constructor(dp);
	size = disk chainLength(sCluster);
	}

	};

DOSrootfile:	public	type	inherit	DOSfile {

constructor:	(dp: * incoreDirectory) =
	{
	super constructor(dp);
	size = disk->rootDirSize * SECTOR_SIZE;
	}

	};
/*
DOSfileObject:	kernelObjectDescriptor = [ 8, &DOSfileFuncs ];
DOSfileFuncs:	[8] functionDescriptor = [ 
	[ 0, &closeSend,	0,	0,		0, AR_ALL ],
	[ 1, &disposeSend,	0,	0,		0, AR_ALL ],
	[ 0x100, &readSend,	4,	&readReply,	-1, AR_READ ],
	[ 0x101, &writeSend,	-1,	0,		4, AR_WRITE ],
	[ 0x102, &seekSend,	8,	0,		4, AR_READ|AR_WRITE ],
	[ 0x103, &setAgeSend,	4,	0,		4, AR_WRITE ],
	[ 0x105, &getClassSend,	0,	0,		4, AR_READ|AR_WRITE ],
	[ 0x200, &nextSend,	0,	&nextReply,	-1, AR_DIREC ],
	];

nextSend:	(pointer, * kernelMessage, pointer, int) int =
	{
	return sizeof file_t + 13;
	}

nextReply:	(o: pointer, * kernelMessage, buf: pointer, len: int) int =
	{
	c:	* DOSfileChannel;

	c = o;
	return c next(buf, len);
	}

readSend:	(o: pointer, * kernelMessage, buf: pointer, int) int =
	{
	c:	* DOSfileChannel;
	req:	int;

	c = o;
	req = * ref int(buf);
	if	(c->filePosition >= c->owner->size)
		return 0;
	if	(req > c->owner->size - c->filePosition)
		return c->owner->size - c->filePosition;
	else
		return req;
	}
 */
DOSfileChannel:	public	type	inherit	directoryChannel {
	public:
	owner:		* DOSfile;
	posCluster:	cluster_t;
	posLsect:	unsigned[16];	// logical sector within cluster

constructor:	(dp: * DOSfile) =
	{
	super constructor(0);
	owner = dp;
	posCluster = dp->sCluster;
	posLsect = 0;
	}

/*
dispose:	dynamic	() =
	{
	owner sync();
	free(self);
	}
 */
close:	gate	() boolean =
	{
//	kprintf("close %d\n", objectId);
	owner sync();
	return TRUE;
	}

delete:	gate	() boolean =
	{
//	kprintf("delete %d\n", objectId);
	owner sync();
	owner close();
	owner = 0;
	return TRUE;
	}

setAge:	gate	(ftime: time_t) int =
	{
	owner->ftime = ftime;
	return SUCCESS;
	}

write:	gate	(buf: [:] byte) int =
	{
	rem:		long;
	i:		int;
	endPosition:	long;
	len:		unsigned;

	len = |buf;
	if	(owner->attributes & FA_DIR)
		return ERRINTERNAL;
	if	(len == 0){
		owner truncate(filePosition);
		if	(filePosition == 0){
			posCluster = 0;
			posLsect = 0;
			}
		return 0;
		}
	endPosition = filePosition + len;
	if	(endPosition > owner->size){
		i = owner->disk extendChain(owner->sCluster, endPosition);
		if	(i == 0)
			return ERRDISKFULL;
		owner->sCluster = i;
		if	(owner->size == 0){
			posCluster = owner->sCluster;
			posLsect = filePosition / SECTOR_SIZE;
			}
		if	(filePosition > owner->size){
			i:	int;

			i = filePosition - owner->size;
			filePosition = owner->size;
			posLsect = filePosition / SECTOR_SIZE;
			diskio(FILL_OP, owner->disk, 0, i);
			}
		owner->size = endPosition;
		}
	diskio(WRITE_OP, owner->disk, buf, len);
	owner->ftime = newFileTime();
	owner->flags |= F_CHANGED;
	return len;
	}

getClass:		gate	() channelClass_t =
	{
	return CC_FILE;
	}

/*
next:	gate	() [] byte =
	{
	if	(owner->attributes & FA_DIR == 0)
		reject();
	if	(filePosition & (sizeof diskDirectory - 1))
		reject();

	d:	diskDirectory;

	i:	int;
	f:	file_t;
	name:	[13] char;

	for	(;;){
		rem:		long;

		if	(filePosition >= owner->size)
			return "";
		rem = owner->size - filePosition;
		if	(rem < sizeof d)
			reject();
		diskio(RLOCAL_OP, owner->disk, &d, sizeof d);
		if	(d.filename[0] == 0)
			return "";
		if	(d.filename[0] != FILE_DEL_CHAR)
			break;
		}
	f.attributes = (int(d.attribute) & 
			(DA_HIDDEN|DA_SYSTEM|DA_VLABEL|DA_DIR|DA_ARCHIVE))
				<< 11;
	f.attributes |= FA_READ|FA_CONTROL|FA_EXEC|FA_SEEKOK;
	if	(d.attribute & (DA_READONLY|DA_DIR) == 0)
		f.attributes |= FA_WRITE;
	f.ftime = d.ftime;
	f.user = 0;
	f.group = 0;
	f.id = d.cluster;
	f.size = d.size;
	replyPartial(&f, sizeof f);
	i = fillInName(&d, name, sizeof name);
	replyPartial(name, i);
	}
 */
read:	gate	() [] byte =
	{
	rem:		long;
	len:		unsigned;

	if	(filePosition < owner->size){
		rem = owner->size - filePosition;
		len = MessageHeader->expected;
		if	(rem < len)
			len = rem;
		diskio(READ_OP, owner->disk, 0, len);
		}
	}

seek:	gate	(offset: long, whence: seek_t) long =
	{
	switch	(whence){
	case	SEEK_ABS:
		filePosition = offset;
		break;

	case	SEEK_CUR:
		if	(offset == 0)
			return filePosition;
		filePosition += offset;
		break;

	case	SEEK_END:
		filePosition = owner->size + offset;
		break;

	default:
		return ERRINVALIDFUNC;
		}
	posCluster = owner->sCluster;
	posLsect = filePosition / SECTOR_SIZE;
	return filePosition;
	}

	private:

diskio:	(op: diskioOps, disk: * dosVolume_t, bufx: pointer, len: unsigned) =
	{
	buf:		ref byte;
	lsect:		unsigned;
	blkoff:		unsigned;
	rem:		unsigned;
	blkamt:		unsigned;
	psect:		unsigned;
	ibuf:		* char;
	isect:		unsigned;
	icluster:	unsigned;
	xlen:		unsigned;

	buf = bufx;
	xlen = len;
	blkoff = filePosition & 0x1ff;
	while	(len){
		psect = disk mapCluster(&posLsect, &posCluster);
		if	(psect <= disk->firstDataSector){
			kprintf("diskio involved sector %d - sCluster %d filePosition = %d\n",
					psect, owner->sCluster, filePosition);
			break;
			}
		rem = SECTOR_SIZE - blkoff;
		if	(len >= rem){
			blkamt = rem;
			posLsect++;
			}
		else
			blkamt = len;
		if	(op == READ_OP ||
			 blkamt != SECTOR_SIZE){
			ibuf = disk->drive readSector(psect);
			if	(op == READ_OP){
				replyPartial(ibuf + blkoff, blkamt);
				disk->drive releaseSector(ibuf);
				}
			else if	(op == RLOCAL_OP){
				memCopy(buf, ibuf + blkoff, blkamt);
				disk->drive releaseSector(ibuf);
				}
			else if	(op == FILL_OP){
				memSet(ibuf + blkoff, 0, blkamt);
				disk->drive writeSector(ibuf);
				}
			else	{
				memCopy(ibuf + blkoff, buf, blkamt);
				disk->drive writeSector(ibuf);
				}
			}
		else	{
			i:		int;
			nsect:		unsigned;

			i = 1;

				// While we have enough room to get another
				// full sector, look for one to read

			while	(blkamt + SECTOR_SIZE <= len){
				nsect = disk mapCluster(&posLsect, &posCluster);
				if	(nsect != psect + i)
					break;
				blkamt += SECTOR_SIZE;
				i++;
				posLsect++;
				}
			if	(op == FILL_OP)
				disk->drive fill(psect, i);
			else if	(op == RLOCAL_OP)
				disk->drive read(psect, buf, i);
			else
				disk->drive write(psect, buf, i);
			}
		blkoff = 0;
		len -= blkamt;
		buf += blkamt;
		}
	filePosition += xlen;
	}

	};
/*
newFileTime:	public	() long =
	{
	dx:	unsigned;
	tx:	unsigned;

	dx = (Today.year - 1980) << 9 + int(Today.month) << 5 + Today.day;
	tx = int(Now.hour) << 11 + int(Now.minutes) << 5 + Now.seconds >> 1;
	return(long(dx) << 16 + tx);
	}

dirOps:	public	type	char = {
	D_LOOKUP,
	D_DELETE,
	D_DGROUP,			// delete a group of files
//	D_RENAME,
	D_CREATE,
	D_FDIREC,
	};

writeDirectoryEntry:	public	(dp: * incoreDirectory) =
	{
	buf:	* char;
	dp2:	* diskDirectory;

	buf = dp->disk->drive findSector(dp->sector, TRUE);
	dp2 = ref diskDirectory(buf + dp->offset);
	*dp2 = dp->dd;
	dp->disk->drive writeSector(buf);
	}
 */
fillInName:	(dp: * diskDirectory, cp: * char, len: int) int =
	{
	i:	int;
	actual:	int;

	for	(i = 0; i < 8; i++, cp++, len--){
		if	(dp->filename[i] == ' ')
			break;
		if	(len <= 1)
			return ERRNOMEMORY;
		*cp = tolower(dp->filename[i]);
		}
	if	(dp->extension[0] == ' '){
		*cp = 0;
		return i;
		}
	if	(len <= 1)
		return ERRNOMEMORY;
	*cp = '.';
	cp++;
	len--;
	actual = i + 1;
	for	(i = 0; i < 3; i++, cp++, len--){
		if	(dp->extension[i] == ' ')
			break;
		if	(len <= 1)
			return ERRNOMEMORY;
		*cp = tolower(dp->extension[i]);
		}
	*cp = 0;
	return actual + i;
	}
