/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	vmemory;
include	hardware;
include	pc_hdw;
/*
	Each process in the 80386 needs two descriptor table slots to 
	describe the process.  ALYS uses two adjacent slots in the GDT for
	each process.  P_TSS_BASE defines the first GDT slot used.  The
	process index is used to identify which slot pair is being used for
	that process.  ALYS will not switch to GDT entries that do not have
	a live process entry, so obsolete entries can hang around.  A user
	process that tries to muck with any GDT entries will trap no matter
	whether the entry is current or not.  Of course, kernel mode drivers
	could cause havoc with some injudicious poking about in the GDT.

	In the GDT the LDT entry is the first entry in the slot pair for
	a process.  The TR entry comes second.
 */
P_TSS_BASE:		const int = 10;		// starting point of process
						// GDT entries
TSS_SIZE:	public	const int = offsetof task_t.fpu;

hardwarePswitch:	public	(pindex: int, task: ref task_t) =
	{
	switchVector:	[2] int;
	IDT:	static	descriptorReg;

	PageDir[0] = task->pageTable0;
	IDT.base = task->idt;
	IDT.limit = 8 * 256;
	_emit(0x0f, 0x01, 0x1D, &IDT);		// LIDT &IDT
	switchVector[1] = (pindex * 2) << 3 + _GDT_TSS_BASE;
	_EBX = unsigned(&switchVector[0]);
	_emit(jmp_bx_);
	}

descriptorReg:	type	packed	{
	public:

	limit:	unsigned[16];
	base:	long;
	};


jmp_bx_:	const	unsigned[16]	= 0x2BFF;

loadTSS:	public	(pindex: int, tss: ref task_t, 
			 ldtLoc: ref localContext_t, 
			 kstack: pointer, cs: int, ds: int, ss: int, 
			eip: int, esp: int, dsegLength: paddr_t) =
	{
	gdtSelector:	int;

	gdtSelector = _GDT_TSS_BASE + pindex * 16;
	tss->ldt = gdtSelector + 8;
	setMapping(0, 0, tss->ldt, LDT_DESC, unsigned(ldtLoc), 
						sizeof localContext_t);
	setMapping(0, 0, gdtSelector, AVAIL_TSS, unsigned(tss), TSS_SIZE);
	tss->idt = addressableToMapped(&_IDT_);
	tss->esp0 = unsigned(kstack);
	tss->ss0 = _SS;
	tss->cs = cs;
	tss->ds = ds;
	tss->es = ds;
	tss->fs = ds;
	tss->gs = ds;
	tss->ss = ss;
	tss->eip = eip;
	tss->esp = esp;
	tss->esi = dsegLength;
	tss->eflags = DEFAULT_FLAGS;
	tss->cr3 = PageDirectory;
	}

loadProc0Hardware:	public	(tss: * task_t) =
	{
	setMapping(0, 0, _GDT_TSS_BASE, AVAIL_TSS, unsigned(tss), TSS_SIZE);
	tss->ldt = 0;
	tss->idt = addressableToMapped(&_IDT_);
	tss->cr3 = PageDirectory;
	_AX = 0;
	_emit(0x66, 0x0F, 0x00, 0xD0);		// LLDT AX
	_AX = _GDT_TSS_BASE;
	_emit(0x66, 0x0F, 0x00, 0xD8);		// LTR AX
	}

hardwarePushCall:	public	(f: pointer, tss: ref task_t) =
	{
	x:	ref pointer;

	x = ref pointer(tss->esp);
	x--;
	tss->esp = unsigned(x);
	*x = f;
	}
