/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	vmemory, hardware;
/*
	Through a trick of the linker, this routine really is the real
	starting point of the kernel.  __startup__ never gets called at all.
 */
__realStartup:	public	() int =
	{
	_AX = _GDT_KERNEL_DATA;
	_SS = _AX;
	_DS = _AX;
	_ES = _AX;
	_emit(0x16);		// Push SS
	_emit(0x0f, 0xa1);	// Pop FS
	_emit(0x16);		// Push SS
	_emit(0x0f, 0xa9);	// Pop GS

	ip:	* _entryVector;

	_brklvl = _heapbase_;

	base.size = 0;
	base.next = &base;
	allocp = &base;

	for	(ip = _entry_; ip < ref _entryVector(_cleanup_); ip++){
		_activeCleanup_ = ip->exit;
		ip->func();
		}
	}
/*
------------------------------------------------------------------------------
		Critical region stuff
 */
_lock_enter:	public	(latch: ref _latchValues_t) =
	{
	*ref unsignedShort(latch) = _FLAGS;
	_emit(disableI);
	}

_lock_leave:	public	(latch: ref _latchValues_t) =
	{
	_FLAGS = *latch;
	}

disableI:		const	byte = 0xFA;
/*
------------------------------------------------------------------------------
 */
base:		header;
allocp:		* header;

header:	type	{
	public:

	size:	size_t;			/* Size of this free block */
	next:	* header;		/* Pointer to next header */

nextHeader:	() * header =
	{
	return ref header(long(self) + size);
	}

	};

_alloc:	public	(size: size_t) pointer =
	{
	p:	* header;
	q:	* header;
	cp:	* char;
	n:	threadLock;
	origSize:	size_t;

	origSize = size;
	size = (size + sizeof unsigned + sizeof header - 1) &
				~(sizeof header - 1);
	n lock();
	q = allocp;
	for	(p = q->next; ; q = p, p = p->next){
		if	(p->size >= size){
			if	(p->size <= size + sizeof header)
				q->next = p->next;
			else	{
				p->size -= size;
				p = p nextHeader();
				p->size = size;
				}
			allocp = q;
			n unlock();
			memSet(&p->next, 0, origSize);
			return &p->next;
			}
		if	(p == allocp)
			break;
		}
	p = _brklvl;
	cp = ref byte(p) + size;
	if	(!P_grow(cp)){
		n unlock();
		MemTrap raise(H_NOMEMORY, size);
		}
	_brklvl = cp;
	p->size = size;
	n unlock();
	memSet(&p->next, 0, origSize);
	return &p->next;
	}

_free:	public	(block: pointer) =
	{
	p:	* header;
	q:	* header;
	n:	threadLock;

	p = ref header(long(block) - sizeof size_t);
	n lock();
	for	(q = &base; p >= q->next; q = q->next)
		if	(q >= q->next)
			break;

	if	(p nextHeader() == q->next){
		p->size += q->next->size;
		p->next = q->next->next;
		}
	else
		p->next = q->next;
	if	(q nextHeader() == p){
		q->size += p->size;
		q->next = p->next;
		p = q;
		}
	else
		q->next = p;

		/* If the block just freed is at the top of memory,
			use growDS to free it up.
		 */

	if	(p nextHeader() == _brklvl){

			/* Find the new end of list */

		for	(q = p; q->next != p; q = q->next)
			;
		q->next = p->next;
		P_grow(p);
		_brklvl = p;
		}
	allocp = q;
	n unlock();
	}

_freeListSize:	public	() size_t =
	{
	j:	int;
	p:	* header;

	j = 0;
	for	(p = base.next; p != &base; p = p->next){
		j += p->size;
		}
	return j;
	}

/*
------------------------------------------------------------------------------
		Kernel message interface

	These functions perform the primitive message calls.  In order to
	have access to the necessary information, this code uses a kludgy
	set of function pointers (in order to avoid circular entry function
	problems).
 */
_receive:	public	(hdr: ref messageHeader) int = 
	{
	return P_receive(hdr);
	}

_reject:	public	(seq: _sequence_t, code: int) = 
	{
	P_reject(seq, code);
	}

_readText:	public	(seq: _sequence_t, offs: unsigned, buf: pointer, len: int) int = 
	{
	return P_readText(seq, offs, buf, len);
	}

_reply:		public	(seq: _sequence_t, buf: pointer, len:int) = 
	{
	P_reply(seq, buf, len);
	}

_replyPartial:	public	(seq: _sequence_t, buf: pointer, len: int) = 
	{
	P_replyPartial(seq, buf, len);
	}

_alarm:	public	(i: time_t) =
	{
	P_alarm(i);
	}

_discardText:	public	(seq: _sequence_t) =
	{
	P_discardText(seq);
	}
/*
_setSignalThreshold:	public	(thresh: signal_t) signal_t =
	{
	return P_setSignalThreshold(thresh);
	}
 */
_publish:	public	(nm: [:] char, o: ref external, jr: accessRights_t,
			 ur: accessRights_t, gr: accessRights_t,
			 wr: accessRights_t) ref far external =
	{
	return P_publish(nm, o, jr, ur, gr, wr);
	}

P_receive:	public	ref (ref messageHeader) int;
P_reject:	public	ref (_sequence_t, int);
P_readText:	public	ref (_sequence_t, unsigned, pointer, int) int;
P_reply:	public	ref (_sequence_t, pointer, int);
P_replyPartial:	public	ref (_sequence_t, pointer, int);
P_alarm:	public	ref (time_t);
P_discardText:	public	ref (_sequence_t);
//P_setSignalThreshold:	public	ref (signal_t) signal_t;
P_publish:	public	ref ([:] char, ref external, accessRights_t, accessRights_t,
				accessRights_t, 
				accessRights_t) ref far external;
P_grow:		public	ref (pointer) boolean;
