/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	filesys;

color_t:	public	type	byte;

colorChar:	public	type	{ public:
	character:		char;
	color:			color_t;
	};

point:	public	type	{
	public:
	x:	signed[16];
	y:	signed[16];
	};

BLACK:	public	const color_t = 0;
BLUE:	public	const color_t = 1;
GREEN:	public	const color_t = 2;
CYAN:	public	const color_t = 3;
RED:	public	const color_t = 4;
PURPLE:	public	const color_t = 5;
YELLOW:	public	const color_t = 6;
WHITE:	public	const color_t = 7;
HIGH:	public	const color_t = 8;

COLOR:	public	(foreground: color_t, background: color_t) color_t =
	{
	return background << 4 + foreground;
	}

foreground:	public	(color: color_t) color_t =
	{
	return color & 0xf;
	}

background:	public	(color: color_t) color_t =
	{
	return (color >> 4) & 0xf;
	}

console:	public	type	inherit	external	{
	public:

mode:	gate	(m: consoleMode_t) =
	{
	}

newWindow:	gate	(title: [:] char, sz: point) ref far textWindow =
	{
	reject(ERRINVALIDFUNC);
	}

screenWindow:	gate	() ref far textWindow =
	{
	reject(ERRINVALIDFUNC);
	}

describe:	gate	() console_t =
	{
	}

getWindowInfo:	gate	(idx: int) window_t =
	{
	reject(ERRINVALIDFUNC);
	}

beep:	gate	() =
	{
	reject(ERRINVALIDFUNC);
	}

setRepeatRate:	gate	(delay: int, repeat: int) =
	{
	reject(ERRINVALIDFUNC);
	}

postEvent:	dynamic	(e: event_t) =
	{
	}

clearEvents:	dynamic	() =
	{
	}

generateBreak:	dynamic	() =
	{
	}

	};

consoleChannel:	public	type	inherit	channel	{
	public:

getClass:	gate	() int =
	{
	return CC_CONSOLE;
	}

appearsOn:	gate	() ref far console =
	{
	}

	};

console_t:	public	type	packed	{
	public:

	windowCount:	unsigned[16];
	mode:		consoleMode_t;
	size:		point;

	};

consoleMode_t:	public	type	byte;

window_t:	public	type	packed	{
	public:

	corner:		point;
	size:		point;
	color:		color_t;
	zoomState:	windowZoom_t;
	flags:		windowFlags_t;
	title:		[80] char;
	};

windowFlags_t:	public	type	char = {
	W_OS =		0x02,
	W_POPUP =	0x04,
	W_OPEN =	0x08,
	};

textWindow:	public	type	inherit	external	{
	public:

read:	gate	(p: point) [] colorChar =
	{
	reject(ERRINVALIDFUNC);
	}

write:	gate	(p: point, buf: [:] colorChar) =
	{
	reject(ERRINVALIDFUNC);
	}

writeChar:	gate	(p: point, buf: [:] char) =
	{
	reject(ERRINVALIDFUNC);
	}

zoom:	gate	(corner: point, zoomState: windowZoom_t) =
	{
	reject(ERRINVALIDFUNC);
	}

clear:	gate	() =
	{
	reject(ERRINVALIDFUNC);
	}

textCursor:	gate	(p: point) =
	{
	reject(ERRINVALIDFUNC);
	}

mouseCursor:	gate	(p: point) =
	{
	reject(ERRINVALIDFUNC);
	}

setColor:	gate	(c: color_t) =
	{
	reject(ERRINVALIDFUNC);
	}

putc:	gate	(p: point, c: char) =
	{
	reject(ERRINVALIDFUNC);
	}

verticalScroll:	gate	(ul: point, sz: point, amount: int) =
	{
	reject(ERRINVALIDFUNC);
	}

horizontalScroll:	gate	(ul: point, sz: point, amount: int) =
	{
	reject(ERRINVALIDFUNC);
	}

showCursor:	gate	() =
	{
	reject(ERRINVALIDFUNC);
	}

putcc:		gate	(p: point, c: char, co: color_t) =
	{
	reject(ERRINVALIDFUNC);
	}

hideCursor:	gate	() =
	{
	reject(ERRINVALIDFUNC);
	}

toTop:	gate	() =
	{
	reject(ERRINVALIDFUNC);
	}

toBottom:	gate	() =
	{
	reject(ERRINVALIDFUNC);
	}

beep:	gate	() =
	{
	reject(ERRINVALIDFUNC);
	}

getEvent:	gate	() event_t =
	{
	reject(ERRINVALIDFUNC);
	}

testEvent:	gate	() event_t =
	{
	reject(ERRINVALIDFUNC);
	}

getKey:		gate	() keystroke =
	{
	reject(ERRINVALIDFUNC);
	}

getRawKey:	gate	() keystroke =
	{
	reject(ERRINVALIDFUNC);
	}

testKey:	gate	() keystroke =
	{
	reject(ERRINVALIDFUNC);
	}

	};

windowZoom_t:	public	type	byte = {
	WZ_FULL_SCREEN,
	WZ_NORMAL,
	WZ_MINIMIZED,
	WZ_HIDDEN
	};

event_t:	public	type	{ public:
	class:		eClass_t;
	info:		unsigned[16];		// class dependent info
	location:	point;
	};

eClass_t:	public	type	byte = {
	E_CHARACTER,			// a character keystroke
	E_BUTTON,			// a special keystroke
	E_MOUSE,			// a mouse event
	};
/*
	This is the ALYS console standard keyboard key values.  This is part
	of the ALYS model, but there are some serious questions concering the
	relationship between a keystroke and the target character set, such 
	as ASCII or Unicode.
 */
keystroke:	public	type	unsigned[16] = {
	CTRL_AT,			/* ^@	nul character */
	CTRL_A,		CTRL_B,		CTRL_C,		CTRL_D,
	CTRL_E,		CTRL_F,		CTRL_G,		CTRL_H,
	CTRL_I,		CTRL_J,		CTRL_K,		CTRL_L,
	CTRL_M,		CTRL_N,		CTRL_O,		CTRL_P,
	CTRL_Q,		CTRL_R,		CTRL_S,		CTRL_T,
	CTRL_U,		CTRL_V,		CTRL_W,		CTRL_X,
	CTRL_Y,		CTRL_Z,

	ESC,

//	BS = CTRL_H,	TAB = CTRL_I,	LF = CTRL_J,	FF = CTRL_L,
//	CR = CTRL_M,

	START_KEY = CTRL_Q,
	STOP_KEY = CTRL_S,

	F1 = 256,	F2,		F3,		F4,
	F5,		F6,		F7,		F8,
	F9,		F10,		F11,		F12,

	SHFT_F1,	SHFT_F2,	SHFT_F3,	SHFT_F4,
	SHFT_F5,	SHFT_F6,	SHFT_F7,	SHFT_F8,
	SHFT_F9,	SHFT_F10,	SHFT_F11,	SHFT_F12,

	CTRL_F1,	CTRL_F2,	CTRL_F3,	CTRL_F4,
	CTRL_F5,	CTRL_F6,	CTRL_F7,	CTRL_F8,
	CTRL_F9,	CTRL_F10,	CTRL_F11,	CTRL_F12,

	ALT_F1,		ALT_F2,		ALT_F3,		ALT_F4,
	ALT_F5,		ALT_F6,		ALT_F7,		ALT_F8,
	ALT_F9,		ALT_F10,	ALT_F11,	ALT_F12,

	HOME,		END,		PGUP,		PGDN,
	CENTER,

	UP_ARW,		DOWN_ARW,	LEFT_ARW,	RIGHT_ARW,

	INS,
	DEL,

	GREY_BS,	GREY_TAB,	GREY_PLUS,	GREY_DASH,
	GREY_STAR,

	NUM_0,		NUM_1,		NUM_2,		NUM_3,
	NUM_4,		NUM_5,		NUM_6,		NUM_7,
	NUM_8,		NUM_9,

	NUM_DOT,

	GREY_CR,
	GREY_ESC,

	BACK_TAB,

	CTRL_HOME,	CTRL_END,	CTRL_PGUP,	CTRL_PGDN,
	CTRL_CENTER,

	CTRL_UP,	CTRL_DOWN,	CTRL_LEFT,	CTRL_RIGHT,

	ALT_DASH,	ALT_EQ,		CTRL_BREAK,	CTRL_PRTSC,
	PRTSC,		SYSREQ,

	ALT_0 = SYSREQ + 2,
			ALT_1,		ALT_2,		ALT_3,
	ALT_4,		ALT_5,		ALT_6,		ALT_7,
	ALT_8,		ALT_9,

	CTRL_CR,

	ALT_A,		ALT_B,		ALT_C,		ALT_D,
	ALT_E,		ALT_F,		ALT_G,		ALT_H,
	ALT_I,		ALT_J,		ALT_K,		ALT_L,
	ALT_M,		ALT_N,		ALT_O,		ALT_P,
	ALT_Q,		ALT_R,		ALT_S,		ALT_T,
	ALT_U,		ALT_V,		ALT_W,		ALT_X,
	ALT_Y,		ALT_Z,

	KEYCOUNT,
	};
