/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	string;
//include	kprintf;
include	alys;
include	error;
include	filesys;

Environment:	public	ref far environment = ref far environment(ENV_SLOT);

environment:	public	type	inherit	external {
	list:	* envEntry;

	public:

constructor:	(oldList: * envEntry) =
	{
	last:	* envEntry;
	ee:	* envEntry;
	cp:	ref char;

	last = 0;
	while	(oldList){
		ee = alloc(sizeof envEntry + |oldList->name + 
						|oldList->value);
		cp = ref char(ee + 1);
		ee->name = cp[:|oldList->name];
		ee->name [:]= oldList->name;
		cp += |ee->name;
		ee->value = cp[:|oldList->value];
		ee->value [:]= oldList->value;
		ee->next = 0;
		if	(last)
			last->next = ee;
		else
			list = ee;
		last = ee;
		oldList = oldList->next;
		}
	}

dispose:	() =
	{
	ee:	* envEntry;

	while	(list){
		ee = list->next;
		free(list);
		list = ee;
		}
	free(self);
	}

get:	gate	(name: [:] char) [] char =
	{
	ee:	* envEntry;

	for	(ee = list; ee; ee = ee->next)
		if	(stringIcompare(ee->name, name) == 0)
			return ee->value;
	reject(ERRINVALIDFUNC);
	}
/*
	Get by index has to return the full name and value pair.
 */
getByIndex:	gate	(index: int) [] char =
	{
	ee:	* envEntry;

	for	(ee = list; ee; ee = ee->next, index--){
		if	(index <= 1){
			replyPartial(ee->name, |ee->name);
			replyPartial(" = ", 3);
			return ee->value;
			}
		}
	reject(ERRINVALIDFUNC);
	}
/*
	This function defines a new name/value pair.  Names are case
	insensitive, but values are not touched.
 */
define:	gate	(name: [:] char, value: [:] char) int =
	{
	ee:	* envEntry;
	last:	* envEntry;
	cp:	ref char;

//	printf("name %P value %P\n", name, value);
	for	(last = 0, ee = list; ee; last = ee, ee = ee->next){
		if	(stringIcompare(ee->name, name) == 0){
			if	(last)
				last->next = ee->next;
			else
				list = ee->next;
			free(ee);
			break;
			}
		}
	ee = alloc(sizeof envEntry + |name + |value);
//	printf("ee = %p last = %p\n", ee, last);
	if	(last){
		ee->next = last->next;
		last->next = ee;
		}
	else	{
		ee->next = list;
		list = ee;
		}
	cp = ref char(ee + 1);
//	printf("cp = %p\n", cp);
	ee->name = cp[:|name];
	ee->value = (cp + |name)[:|value];
//	printf("ee->name = %P ee->value = %P\n", ee->name, ee->value);
	ee->name [:]= name;
	ee->value [:]= value;
	return SUCCESS;
	}

undefine:	gate	(name: [:] char) int =
	{
	ee:	* envEntry;
	last:	* envEntry;

	for	(last = 0, ee = list; ee; last = ee, ee = ee->next){
		if	(stringIcompare(ee->name, name) == 0){
			if	(last)
				last->next = ee->next;
			else
				list = ee->next;
			free(ee);
			return SUCCESS;
			}
		}
	return ERRNOTFOUND;
	}

fork:	gate	() ref far environment =
	{
	e:	* environment;
	i:	int;
	rf:	ref far external;

	e = new environment[ list ];
	rf = e jobPublish("environment");	
	if	(int(rf) < 0){
		e dispose();
		reject(ERRINVALIDFUNC);
		}
	makeLocal(e->objectId, Environment);
	return Environment;
	}

copy:	gate	() ref far external =
	{
	e:	* environment;
	i:	int;
	rf:	ref far external;

	e = new environment[ list ];
	rf = e jobPublish("environment");	
	if	(int(rf) < 0){
		e dispose();
		reject(ERRINVALIDFUNC);
		}
	return rf;
	}

probe:	gate	(name: [:] char) size_t =
	{
	ee:	* envEntry;

	for	(ee = list; ee; ee = ee->next)
		if	(stringIcompare(ee->name, name) == 0)
			return |ee->value;
	reject(ERRINVALIDFUNC);
	}

	};

envEntry:	type	{
	public:

	next:		* envEntry;
	name:		[:] char;
	value:		[:] char;
	};
