/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
MAX_FLT_CHARS:	const	int = 40;   /* maximum floating digits supported */

stringConverter:	public	type	{
	visible:

	success:	boolean;
	buffer:		[:] char;

	public:

constructor:	(buf: [:] char) =
	{
	buffer = buf;
	success = FALSE;
	}

decodeSigned:	(v: long) [:] char =
	{
	if	(||buffer == 0){
		success = FALSE;
		return buffer;
		}
	if	(v < 0){
		buffer[0] = '-';
		v = -v;
		|buffer = 1;
		}
	else
		|buffer = 0;
	success = TRUE;
	utoa(v);
	return buffer;
	}

decodeUnsigned:	(v: unsignedLong) [:] char =
	{
	if	(||buffer == 0){
		success = FALSE;
		return buffer;
		}
	|buffer = 0;
	success = TRUE;
	utoa(v);
	return buffer;
	}

decodeFloat:	(x: extended, format: char, precision: int,
					alternate: boolean) [:] char =
	{
	buf:		[MAX_FLT_CHARS + 4] char;
	sign:		int;
	point:		boolean;
	digitCount:	int;
	exp:		int;

	sign = ref unsignedShort(&x)[4] >> 15;
	|buffer = 0;
	if	(sign)
		deposit('-');
	ref unsignedShort(&x)[4] &= 0x7FFF;
	if	(precision > MAX_FLT_CHARS)
		precision = MAX_FLT_CHARS;
	if	(format == 'f')
		digitCount = -precision;
	else
		digitCount = precision + 1;
	success = TRUE;
	switch	(fpclassify(x)){
	case	FP_NAN:		return stringAppend(buffer, "NaN");
	case	FP_INFINITE:	return stringAppend(buffer, "INF");
		}
	exp = convertToDigitString(x, digitCount, buf);
	cp:	ref char;

	cp = buf;
//	printf("exp = %d num = %s\n", exp, buf);
	if	((format == 'f' &&
		  exp <= MAX_FLT_CHARS) ||
		 (tolower(format) == 'g' &&
		  exp >= -4 && exp < precision)){
		point = FALSE;
		if	(exp <= 0){
			deposit('0');
			deposit('.');
			point = TRUE;
			}
		while	(exp < 0){
			deposit('0');
			exp++;
			}
		while	(*cp){
			deposit(*cp);
			exp--;
			if	(exp == 0){
				deposit('.');
				point = TRUE;
				}
			cp++;
			}
		while	(exp > 0){
			deposit('0');
			exp--;
			if	(exp == 0){
				deposit('.');
				point = TRUE;
				break;
				}
			}
		if	(tolower(format) == 'g'){
			buffer = trimZeroes(buffer);
			alternate = FALSE;
			}
		if	(point && !alternate)
			buffer = trimDecimalPoint(buffer);
		return buffer;
		}
	else	{
		if	(*cp == 0){
			deposit('0');
			deposit('.');
			}
		else	{
			deposit(*cp++);
			deposit('.');
			if	(*cp){
				do
					deposit(*cp++);
					while	(*cp);
				}
			}
		if	(tolower(format) == 'g'){
			buffer = trimZeroes(buffer);
			buffer = trimDecimalPoint(buffer);
			}
		else if	(!alternate)
			buffer = trimDecimalPoint(buffer);
		if	(isupper(format))
			deposit('E');
		else
			deposit('e');
		exp--;
		if	(exp < 0){
			deposit('-');
			exp = -exp;
			}
		else
			deposit('+');
		if	(exp >= 1000)
			deposit('0' + exp / 1000);
		i:	int;

		if	(exp >= 100){
			i = exp % 1000;
			deposit('0' + i / 100);
			}
		i = exp % 100;
		deposit('0' + i / 10);
		deposit('0' + exp % 10);
		}
	return buffer;
	}

encodeSigned:	(s: [:] char) long =
	{
	buffer = stringTrim(s);
	if	(|buffer && buffer[0] == '-'){
		buffer = buffer[1:];
		return -atou();
		}
	else
		return atou();
	}

encodeUnsigned:	(s: [:] char) unsignedLong =
	{
	buffer = stringTrim(s);
	return atou();
	}

encodeFloat:	(s: [:] char) extended =
	{
	buffer = stringTrim(s);
	return atof();
	}

	private:

deposit:	(c: char) =
	{
	if	(|buffer < ||buffer){
		buffer[|buffer] = c;
		(|buffer)++;
		}
	else
		success = FALSE;
	}

utoa:	(v: unsignedLong) =
	{
		// Recursively build up the string

	if	(v >= 10)
		utoa(v / 10);
	if	(|buffer < ||buffer){
		buffer[|buffer] = '0' + v % 10;
		++|buffer;
		}
	else
		success = FALSE;
	}

atou:	() unsignedLong =
	{
	i:	unsignedLong;
	j:	int;

	i = 0;
	for	(j = 0; j < |buffer; j++){
		if	(!isdigit(buffer[j])){
			success = FALSE;
			return 0;
			}
		i = i * 10 + buffer[j] - '0';
		}
	return i;
	}
/*
	Convert a string to a float.  The string must be formatted according
	to the following syntax:

        float ::=	  realnum [ exponent ]

        realnum ::=	  digits 
			| digits '.' [ digits ]
			| '.' digits

        exponent ::=	  'e' [ sign ] digits
 			| 'E' [ sign ] digits

	digits ::=	  digit
			| digits digit

	digit ::=	  '0' | '1' | '2' | '3' | '4' 
			| '5' | '6' | '7' | '8' | '9'

	sign ::=	  '+'
			| '-'

	The format of the string is checked, and if there is a format error,
	the function returns NaN and sets success to FALSE.

	If the number is too large or too tiny then the result is infinity 
	or zero, and success is set to FALSE.
 
METHOD
------

	The conversion is performed in three phases:

	- The realnum part is scanned, the digits are converted to a
	  64 unsigned integer (with 18 decimal digits accuracy).  The
	  position of the decimal point is remembered.

	- Any exponent is parsed.  The resulting exponent adjusts decimal
	  position from phase 1.

	- The integer is converted to floating point and the exponent is
	  factored in using the following computation:

		result = integer * 10 ^ exponent

The following diagram may be helpful with undestanding the relations
between the variables:

   000012345789012345.098765432109876E+99
      |---decimals-->|
      |--------------.----digits---->|   not counting the '.'
 
	Decimals are counted negative if the '.' is left of the first digit.
	Digits are positive unless no non-zero digit is ever seen.
 */
atof:	() extended =
	{
	exponent, decimals, digits:		int;
	expNegative, pointSeen:			boolean;
	actual:					int;
	c:					char;
	pow, result:				extended;
	fraction:				[2] unsigned;
	i:					int;

	pointSeen = FALSE;
	decimals = 0;
	digits = 0;

	fraction[0] = 0;
	fraction[1] = 0;
	for	(i = 0; i < |buffer; i++){
		c = buffer[i];
		if	(c == '.'){
			if	(pointSeen){
				success = FALSE;
				return NaN;
				}
			pointSeen = TRUE;
			decimals = digits;
			continue;
			}
		if	(!isdigit(c))
			break;
		c -= '0';
		if	(digits == 0){
			if	(c == 0)
				decimals--;
			else	{
				fraction[0] = c;
				actual = digits = 1;
				}
			}
		else	{
			digits++;
			if	(digits > 9){
				if	(fraction[1] >= 0xCCC0000)
					continue;
				fraction[1] *= 10;
				_EAX = fraction[0];
				_EDX = 10;
				_emit(0xf7, 0xe2);	// mul eax,edx
				fraction[0] = _EAX;
				fraction[1] += _EDX;
				fraction[0] += c;
				if	(_FLAGS & 1)
					fraction[1]++;
				}
			else
				fraction[0] = fraction[0] * 10 + c;
			actual = digits;
			}
		}

		// If there are no non-zero digits, the answer must be zero
		// and we don't care what the exponent is.

	if	(digits == 0)
		return 0.0;
	if	(!pointSeen)
		decimals = digits;

	exponent = 0;
	expNegative = FALSE;
	if	(i < |buffer &&
		 tolower(c) == 'e'){
		c = buffer[++i];
		if	(i >= |buffer){
			success = FALSE;
			return NaN;
			}
		if	(c == '-'){
			expNegative = TRUE;
			i++;
			}
		else if	(c == '+')
			i++;
		if	(i >= |buffer){
			success = FALSE;
			return NaN;
			}
		for	(; i < |buffer; i++){
			c = buffer[i];
			if	(!isdigit(c))
				break;
			c -= '0';
			exponent = exponent * 10 + c;

				// large exponents become infinity

			if	(exponent > 9999)
				exponent = 9999;
			}
		if	(expNegative)
			exponent = -exponent;
		}

	x:	int;

	x = decimals + exponent;

		// Check for overflow and underflow

	if	(x >= 308)
		return Infinity;
	if	(x <= -306)
		return 0.0;

	exponent += decimals - actual;

	result = fromUnsigned64(fraction);
	if	(exponent){
		pow = pow10(abs(exponent));
		if	(exponent < 0)
			result /= pow;
		else
			result *= pow;
 		}
	return result;
	}

	};

pow10:	public	(p: unsigned) extended =
	{
	x:	extended;

	if	(p == 0)
		return 1.0;

	if	(p > 511)
		return Infinity;

	x = smallPowers[p & 0x7];

	if	(p < 8)
		return x;

	if	(p & 0x008)
		x *= e8;

	if	(p & 0x010)
		x *= e16;

	if	(p & 0x020)
		x *= e32;

	if	(p & 0x040)
		x *= e64;

	if	(p & 0x080)
		x *= e128;

	if	(p & 0x100)
		x *= e256;
	return x;
	}

smallPowers:	const   [8] long =
		[ 1, 10, 100, 1000, 10000, 100000, 1000000, 10000000 ];

e8:		const	extended = 0x0.BEBC2000p27L;
e16:		const   extended = 0x0.8E1BC9BF04p54L;
e32:		const   extended = 0x0.9DC5ADA82B70B59Ep107L;
e64:		const   extended = 0x0.C2781F49FFCFA6D5p213L;
e128:		const   extended = 0x0.93BA47C980E98CDFp426L;
e256:		const   extended = 0x0.AA7EEBFB9DF9DE8Cp851L;

EXTEND_EXP_BIAS:	const	int = 0x3fff;
DOUBLE_EXP_BIAS:	const	int = 0x3ff;
FLOAT_EXP_BIAS:		const	int = 0x3f;
INFINITE_EXP:		const	int = 0x7fff;

/*
	This function converts a 64-bit unsigned integer, represented as
	an array of two 32-bit integers, to an extendedReal value.
*/
fromUnsigned64:	(src: [2] unsigned[32]) extended =
	{
	x, a, b:	int;
	u:		union	{ public:
				x:	extended;
				y:	packed { public:
					frac:	[2] unsigned;
					exp:	unsigned[16];
					};
				};

	a = src[0];
	b = src[1];
	x = 64;
	if	(b == 0){
		if	(a == 0)
			return 0.0;
		b = a;
		a = 0;
		x = 32;
		}
	while	(b >= 0){		// normalize b, 
		b <<= 1;
		if	(a < 0)
			b++;
		a <<= 1;
		x--;
		}
	u.y.exp = x + EXTEND_EXP_BIAS - 1;
	u.y.frac[0] = a;
	u.y.frac[1] = b;
	return u.x;
	}

stringIcompare:	public	(s1: [:] char, s2: [:] char) int =
	{
	i, j, len:	int;

	len = |s1;
	if	(len > |s2)
		len = |s2;
	for	(i = 0; i < len; i++){
		j = tolower(s1[i]) - tolower(s2[i]);
		if	(j)
			return j;
		}
	if	(len < |s1)
		return 1;
	else if	(len < |s2)
		return -1;
	else
		return 0;
	}

stringCompare:	public	(s1: [:] char, s2: [:] char) int =
	{
	i, j, len:	int;

	len = |s1;
	if	(len > |s2)
		len = |s2;
	for	(i = 0; i < len; i++){
		j = s1[i] - s2[i];
		if	(j)
			return j;
		}
	if	(len < |s1)
		return 1;
	else if	(len < |s2)
		return -1;
	else
		return 0;
	}

stringLength:	public	(cp: ref char) size_t =
	{
	xp:	ref char;

	xp = memScan(cp, 0, 0x7fffffff);
	return (xp - cp) - 1;
	}

stringSubstring:	public	(s: [:] char, pat: [:] char) int =
	{
	i:	int;
	base:	int;

	if	(|pat == 0)
		return 0;
	base = 0;
	for	(;;){
		i = stringScan(s, pat[0]);
		if	(i < 0)
			return i;
		if	(|s - i >= |pat &&
			 memCompare(s + i, pat, |pat) == 0)
			return base + i;
		base += i + 1;
		s = s[i + 1:];
		}
	}

stringScan:	public	(s: [:] char, c: char) int =
	{
	xp:	ref char;

	xp = memScan(s, c, |s);
	if	(_FLAGS & 0x40)
		return (xp - s) - 1;
	else
		return -1;
	}

stringReverseScan:	public	(s: [:] char, c: char) int =
	{

		// If we have a non-empty string, scan it

	if	(|s){
		_EDI = int(&s[|s - 1]);
		_ECX = |s;
		_AL = c;	
		_emit(0xfd, 0xf2, 0xae, 0xfc);	//	std; repnz; scasb; cld	
		if	(_FLAGS & 0x40)
			return (ref char(_EDI) - s) + 1;
		}
	return -1;
	}

stringAppend:	public	(dest: [:] char, src: [:] char) [:] char =
	{
	xp:	[:] char;

	xp = dest[|dest:];
	xp [:]= src;
	|dest += |src;
	return dest;
	}

stringTrim:	public	(s: [:] char) [:] char =
	{
	slen:	int;
	i:	int;

	slen = |s;
	for	(i = 0; i < slen; i++)
		if	(!isspace(s[i]))
			break;
	for	(; i < slen; slen--)
		if	(!isspace(s[slen - 1]))
			break;
	return s[i:slen];
	}
/*
	This function converts a positive floating point value to a digit
	string.
 */
convertToDigitString:	(x: extended, precision: int, buf: ref char) int =
	{
	expo:			short;
	frac:			[10] byte;	/* tenbyte BCD integer */
	y:			extended;
	c:			char;
	exp:			int;
	scaleFactor:		int;
	actualDigits:		int;
	destP, cp, endP:	ref char;
	b:			byte;
	roundup:		byte;

	endP = buf;
	switch	(fpclassify(x)){
	case	FP_ZERO:
		exp = 1;
		break;

	default:
/*
		Do a fast estimate of the base 10 exponent:

		- Multiply the base 2 exponent (unbiased) by log10 of 2.
		- The multiplication actually computes that value times 0x10000.
 */
		u:	unsigned;
		u = (ref short(&x)[4] - 0x3FFF) * 0x4D10;
		exp = signed(u) >> 16;
//		printf("u = %x exp = %x\n", u, exp);
/*
			Now adjust for the magnitude of the fractional part.
 */
		u &= 0xFFFF;
		u += byte(ref byte(&x)[7] << 1) * 0x4D;
		exp += u >> 16;
		if	(u & 0xFFFF)
			exp++;
		if	(precision <= 0){
			scaleFactor = exp - precision;
			if	(scaleFactor < 0){
				exp = 1;
				break;
				}
			}
		else
			scaleFactor = precision;
		if	(scaleFactor > 18)
			scaleFactor = 18;
		actualDigits = scaleFactor;
		scaleFactor -= exp;
		if	(scaleFactor){
			if	(scaleFactor < 0)
				y = x / pow10(-scaleFactor);
			else
				y = x * pow10(scaleFactor);
			}
		else
			y = x;
		if	(pow10(actualDigits) !> y){
			exp++;
			actualDigits++;
			if	(actualDigits > 18 || 
				 precision > 0){
				y /= 10.0;
				actualDigits--;
				}
			}
		else if	(pow10(actualDigits - 1) !<= y){
			exp--;
			actualDigits--;
			if	(precision > 0){
				y *= 10.0;
				actualDigits++;
				}
			}
		y = roundInt(y);
		_cvtBCD(y, frac);
//		i:	int;
//		printf("act = %d scal = %d exp = %d y = %x %x : %x\n",
//			actualDigits, scaleFactor, exp, y);
//		printf("frace = ");
//		for	(i = 0; i < sizeof frac; i++)
//			printf("%02x ", frac[i]);
//		printf("\n");
		endP = buf + actualDigits;
		*endP = 0;
		destP = endP - 1;
		cp = frac;
		roundup = 0;
		if	(actualDigits == 0)
			roundup = *cp ^ 1;	/* round up if the byte is 1 */
		else	{
			do	{
				b = *cp++;
				*destP = (b & 0xf) + '0';
				destP--;
				roundup |= b & 0xf;
				actualDigits--;
				if	(actualDigits == 0)
					break;
				b >>= 4;
				*destP = (b & 0xf) + '0';
				destP--;
				roundup |= b & 0xf;
				actualDigits--;
				}	while	(actualDigits);
			}
		if	(roundup & 0xf == 0){	// any non-zero digits?
			destP[1] = '1';
			exp++;
//			*endP = '0';
//			endP++;
//			*endP = 0;
			}
		}
	if	(precision < 0)
		precision = exp - precision;	
	if	(precision > MAX_FLT_CHARS)
		precision = MAX_FLT_CHARS;
	precision -= (endP - buf);
	if	(precision > 0){
		memSet(endP, '0', precision);
		endP += precision;
		}
	*endP = 0;
        return exp;
	}

trimDecimalPoint:	(s: [:] char) [:] char =
	{
	if	(|s){
		if	(s[|s - 1] == '.')
			(|s)--;
		}
	return s;
	}

trimZeroes:	(s: [:] char) [:] char =
	{
	while	(|s){
		if	(s[|s - 1] != '0')
			return s;
		(|s)--;
		}
	return s;
	}
