/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	file, alys, runfile, filesys;

include	target;
include	symtab;
include	value;
include	ptree;
include	errmsg;

BUF_SIZE:	const	int = 4096;	// size of exe file copy buffer

CODE_BASE:	const	addr_t = 0x1000;
DATA_BASE:	const	addr_t = 0x1000;

LinkVersion:	public	int = ALYS1;

ALYS1:	public	const int = 1;
ALYS2:	public	const int = 2;

symbolList:	public	type	{
	public:

	next:		* symbolList;
	sym:		ref symbol_s;
	refCount:	int;
	};

/*
	These are special symbols defined in the machine unit that are
	filled in with addresses automatically, without having to go
	through normal channels.

	0 = The entry function table
	1 = The cleanup function table
	2 = The end of the cleanup function table
	3 = The base of the heap
	4 = The GDT (ALYS only)
	5 = The IDT (ALYS only)
 */
MagicValues:	[6] ref value;

RunFile:	public	{
	public:

	codeSize:		addr_t;
	dataSize:		addr_t;
	initSize:		addr_t;
	entries:		* symbolList;
	lastEntry:		* symbolList;
	cleanups:		* symbolList;
	lastCleanup:		* symbolList;
	entryCount:		int;
	cleanupCount:		int;
	header:			runHeader;
	dataBlock:		ref byte;
	codeBlock:		ref byte;

link:	() =
	{
	i:		int;
	vp:		ref value;
	f:		* fixup;
	u:		ref unit_s;
	sym:		ref symbol_s;
	sl:		* symbolList;
	startupValue:	ref value;
	lit:		* literalValue;
	cleanupBase:	int;

	header.cs = 0x7;
	header.ds = 0xf;
	header.ss = 0xf;
	codeSize = 0;
	dataSize = 0;
	initSize = 0;
	entries = 0;
	lastEntry = 0;
	entryCount = 0;
	cleanups = 0;
	lastCleanup = 0;
	cleanupCount = 0;
	memSet(&MagicValues, 0, sizeof MagicValues);
	for	(u = Project.units; u; u = u->next)
		u->built = FALSE;
	logUnit(Project.projectUnit);
	startupValue = 0;
	dataSize = 0;
	buildValueVector();

		// Decide what to link in.  First, identify the entry
		// and cleanup functions.  Then, iteratively include
		// values referred to by already included units

	for	(i = 0; i < ValueIndex; i++){
		vp = ValueVector[i];
/*
		printf("%5d: %x", i, vp);
		if	(vp->owner)
			printf(" %S", vp->owner objectName());
		printf("\n");
 */
		if	(Project.smartLink){
			vp->linked = FALSE;
			vp->used = FALSE;
			}
		else	{
			vp->linked = TRUE;
			vp->used = TRUE;
			}
		if	(vp->owner == 0)
			continue;
		if	(vp->owner->qualifier & (DQ_ENTRY|DQ_CLEANUP))
			vp->used = TRUE;
		}

		// Also mark __startup__ as linked.

	if	(Project.startupSymbol)
		Project.startupSymbol->currentValue->used = TRUE;

	changed:	boolean;

	do	{
		changed = FALSE;
		for	(i = 0; i < ValueIndex; i++){
			vp = ValueVector[i];

			if	(!vp->used ||
				 vp->linked)
				continue;

			vp markReferencedValues();

			changed = TRUE;
			vp->linked = TRUE;
			}
		}
		while	(changed);

	dataSize = CODE_BASE;
	for	(i = 0; i < ValueIndex; i++){
		vp = ValueVector[i];

			// Locate the functions

		if	(vp->linked &&
			 vp->isCode)
			assignLocation(vp);
		}
	codeSize = dataSize;
	if	(Project.startupSymbol)
		header.ip = Project.startupSymbol->currentValue->address;

		// Record the entry and cleanup table addresses

	vp = MagicValues[0];
	if	(vp == 0)
		fatal(ErrInternal, "Missing entry function table");

		// Note that we have to pretend that the magic values are
		// not initialized because we want them to use our hand-
		// crafted initialization logic (if any), not anything the
		// link routines might want to do.

	vp->address = DATA_BASE;
	vp->vSize = entryCount * 8;

	vp = MagicValues[1];
	if	(vp == 0)
		fatal(ErrInternal, "Missing cleanup function table");
	vp->address = DATA_BASE + entryCount * 8;
	vp->vSize = cleanupCount * 4;
	cleanupBase = vp->address;

	vp = MagicValues[2];
	if	(vp == 0)
		fatal(ErrInternal, "Missing cleanup function table ender");
	vp->address = DATA_BASE + entryCount * 8 + cleanupCount * 4;
	vp->vSize = 0;
	dataSize = vp->address;
	for	(i = 0; i < ValueIndex; i++){
		vp = ValueVector[i];
		if	(!vp->linked)
			continue;
		for	(f = vp->fixups; f; f = f->next)
			f assignLiteralLocation();
		}
	for	(i = 0; i < ValueIndex; i++){
		vp = ValueVector[i];
		if	(!vp->linked)
			continue;

				// Locate the initialized data

		if	(!vp->isCode &&
			 vp->data)
			assignLocation(vp);
		}
	initSize = dataSize;
	for	(i = 0; i < ValueIndex; i++){
		vp = ValueVector[i];
		if	(!vp->linked)
			continue;

				// Locate the BSS

		if	(!vp->isCode &&
			 vp->data == 0)
			assignLocation(vp);
		}

		// Allocate the stack

	dataSize += 3;
	dataSize &= ~3;		// Align the stack
	dataSize += Project.stackSize;
	header.sp = dataSize;

	vp = MagicValues[5];
	if	(vp &&
		 vp->linked){			// IDT goes here
		vp->address = dataSize;
		dataSize += vp->vSize;
		}
	vp = MagicValues[4];
	if	(vp &&
		 vp->linked){			// GDT goes here
		vp->address = dataSize;
		dataSize += vp->vSize;
		}

	vp = MagicValues[3];
	if	(vp == 0)
		fatal(ErrInternal, "Missing heap base");
	vp->address = dataSize;
	vp->vSize = 1;

		// Pad out the code segment

	codeBlock = alloc(codeSize);
	memSet(codeBlock, 0, codeSize);

		// Pad out the data segment

	dataBlock = alloc(initSize);
	memSet(dataBlock, 0, initSize);

	dataSize++;			// PLEX assumes the heap has one byte
					// to start with

		// Write the entry function table

	evect:	ref packed { public:
		addr:		unsigned[32];
		cleanVal:	unsigned[32];
		};

	evect = pointer(dataBlock + DATA_BASE);
	for	(sl = entries; sl; sl = sl->next, evect++){
		vp = sl->sym->currentValue;
		evect->addr = vp->address;
		evect->cleanVal = cleanupBase + sl->refCount * 4;
		}

		// Write the cleanup function table

	cvect:	ref unsigned[32];

	cvect = pointer(evect);
	for	(sl = cleanups; sl; sl = sl->next, cvect++){
		vp = sl->sym->currentValue;
		*cvect = vp->address;
		}

		// Link everything in sight

	for	(u = Project.units; u; u = u->next){
		u->codeSize = 0;
		u->dataSize = 0;
		u->bssSize = 0;
		}
	u = Project.units;
	for	(i = 0; i < ValueIndex; i++){
		vp = ValueVector[i];
		while	(u->next && u->next->index == i)
			u = u->next;
		if	(!vp->linked)
			continue;
		for	(f = vp->fixups; f; f = f->next)
			u->dataSize += f linkLiteral();
		}
	u = Project.units;
	for	(i = 0; i < ValueIndex; i++){
		vp = ValueVector[i];
		while	(u->next && u->next->index == i)
			u = u->next;
		if	(!vp->linked)
			continue;
//		TargetData.currentUnit = u;
		if	(vp->data){
			buf:	ref byte;

			vp link();
			if	(vp->isCode){
				buf = codeBlock;
				if	(u)
					u->codeSize += vp->vSize;
				}
			else	{
				buf = dataBlock;
				if	(u)
					u->dataSize += vp->vSize;
				}
			memCopy(buf + vp->address, vp->data, vp->dataSize);
			}
		else if	(u)
			u->bssSize += vp->vSize;
		}
	}

write:	() =
	{
	exeFile:	stream;
	rh:		runHeader;
	rem:		int;
	j:		int;
	i:		int;

//	printf("link write(), creating %S\n", Project.runFile);
	if	(exeFile create(Project.runFile, FA_READ|FA_WRITE|FA_EXEC))
		fatal(ErrCreate, Project.runFile);
//	printf("created file fd = %x\n", exeFile getChannel());
	memSet(&rh, 0, sizeof rh);
	rh.magic = RUN_MAGIC;
	rh.cs = header.cs;
	rh.ds = header.ds;
	rh.ss = header.ss;
	rh.ip = header.ip;
	rh.sp = header.sp;
	rh.descriptors = sizeof rh;
	rh.image = sizeof rh;
	rh.codeLen = codeSize;
	rh.dataTotalLen = dataSize;
	rh.dataInitLen = initSize;
	rh.fixups = sizeof rh + rh.codeLen + rh.dataInitLen;
	rh.version = RUN_VERSION_2;
	rh.codeOffset = CODE_BASE;
	rh.dataOffset = DATA_BASE;
	rh.fixups = sizeof rh + rh.codeLen + rh.dataInitLen -
				(CODE_BASE + DATA_BASE);
	rh.gates = rh.fixups;
	rh.externGates = rh.fixups;
	rh.debugInfo = rh.fixups;
	if	(Project.threadValue)
		rh.threadLoc = Project.threadValue->address;
	exeFile write(ref byte(&rh)[:sizeof rh]);
//	exeFile write(codeBlock[CODE_BASE:codeSize]);
//	exeFile write(dataBlock[DATA_BASE:initSize]);
	exeFile write((codeBlock + CODE_BASE)[:codeSize - CODE_BASE]);
	exeFile write((dataBlock + DATA_BASE)[:initSize - DATA_BASE]);
	exeFile close();
	}

writeDriver:	() =
	{
	exeFile:	stream;
	rh:		runHeader;
	rem:		int;
	j:		int;
	i:		int;
	vp:		ref value;
	sl:		* symbolList;

	if	(exeFile create(Project.lodFile, 0))
		fatal(ErrCreate, Project.lodFile);
	memSet(&rh, 0, sizeof rh);
	rh.magic = LOD_MAGIC;
	rh.version = LOD_VERSION;
	rh.cs = header.cs;
	rh.ds = header.ds;
	rh.ss = header.ss;
	rh.ip = header.ip;
	rh.sp = header.sp;
	rh.descriptors = sizeof rh;
	rh.image = sizeof rh;
	rh.codeLen = codeSize;
	rh.dataTotalLen = dataSize;
	rh.dataInitLen = initSize;
	rh.fixups = sizeof rh + rh.codeLen + rh.dataInitLen;
	rh.gates = rh.fixups;
	rh.externGates = rh.fixups;
	rh.debugInfo = rh.fixups;
	exeFile write(ref byte(&rh)[:sizeof rh]);
	exeFile write(codeBlock[:codeSize]);
	exeFile write(dataBlock[:initSize]);
	buildValueVector();
	startLoadFixups();
	x:	long;

	x = 0x40000000;
	for	(sl = entries; sl; sl = sl->next, x += 8)
		generateLoadFixup(x, exeFile);
	for	(i = 0; i < ValueIndex; i++){
		vp = ValueVector[i];
		if	(!vp->linked)
			continue;
		vp writeLoadFixups(exeFile);
		}
	flushLoadFixups(exeFile);
	finishLoadFixups();
	exeFile close();
	}

assignLiteralLocation:	(lit: ref literalValue) =
	{
	i:	addr_t;

	i = lit->length;
	lit->address = dataSize;
	dataSize += i;
	}
/*
	This just writes the literal to the RUN file as a single blob.
	Note that since the data segment is zeroed, we don't need to
	write the null terminator
 */
linkLiteral:	(ll: ref literalValue) =
	{
	memCopy(dataBlock + ll->address, &ll->value, ll->length);
	}

	private:

logUnit:	(u: ref unit_s) =
	{
	ux:		ref include_s;
	sym:		ref symbol_s;
	vCount:		int;

	if	(u->built)
		return;
	u->built = TRUE;
	for	(ux = u->includes; ux; ux = ux->next)
		logUnit(ux->unit);
	for	(sym = u->symbols; sym; sym = sym->next){
		if	(sym->qualifier & DQ_ENTRY)
			logEntry(sym);
		else if	(sym->qualifier & DQ_CLEANUP)
			logCleanup(sym);
		else if	(sym->storageClass == SC_INTRINSIC &&
			 sym->dtype->topType != T_FUNC)
			logMagic(sym);
		}
	}

logMagic:	(sym: ref symbol_s) =
	{
	if	(sym->initBase > 5)
		fatal(ErrInternal, "Magic data value too high");
	MagicValues[sym->initBase] = sym->currentValue;
	}

logEntry:	(sym: ref symbol_s) =
	{
	sl:	* symbolList;

	sl = Heap alloc(sizeof symbolList);
	sl->sym = sym;
	sl->refCount = cleanupCount;
	sl->next = 0;
	if	(lastEntry)
		lastEntry->next = sl;
	else
		entries = sl;
	lastEntry = sl;
	entryCount++;
	}

logCleanup:	(sym: ref symbol_s) =
	{
	sl:	* symbolList;

	sl = Heap alloc(sizeof symbolList);
	sl->sym = sym;
	sl->next = 0;
	if	(lastCleanup)
		lastCleanup->next = sl;
	else
		cleanups = sl;
	lastCleanup = sl;
	cleanupCount++;
	}

assignLocation:	(vp: ref value) =
	{
	i:	addr_t;

		// Skip over magic symbols

	if	(vp->owner &&
		 vp->owner->storageClass == SC_INTRINSIC)
		return;
	i = dataSize;
	i += vp->align - 1;
	i &= ~(addr_t(vp->align) - 1);
	vp->address = i;
	dataSize = i + vp->vSize;
	}

	};
