/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	string;
include	file, filesys;

include	symtab;
include	value;
include	ptree;
include	errmsg;
include	heapsort;
include	target;
include	link;

Mapfile:	stream;

writeMap:	public	(file: [:] char) =
	{
	if	(file == 0)
		return;
//	postMessage([ file ]);
	if	(Mapfile create(file, FA_READ|FA_WRITE))
		fatal(ErrCreate, file);
//	Mapfile setBuffering(4096);
	sizeMap();
	entryMap();
	cleanupMap();
	valueMap();
	prtpubs();
	Mapfile close();
	}

sizeMap:	() =
	{
	u:	ref unit_s;
	cs:	unsigned;
	ds:	unsigned;
	bs:	unsigned;

	cs = 0;
	ds = 0;
	bs = 0;
	Mapfile printf("Sources\n\n");
	for	(u = Project.units; u; u = u->next){
		Mapfile printf("%-8S   %S\n", 
				u->name spelling(), u fileName());
		}
	Mapfile printf("\nSizes		Code		 Data		  BSS\n\n");
	for	(u = Project.units; u; u = u->next){
		Mapfile printf("%-8S   %8x(%4dK)  %8x(%4dK)  %8x(%4dK)\n", 
				u->name spelling(), 
					u->codeSize, (u->codeSize + 512) >> 10,
					u->dataSize, (u->dataSize + 512) >> 10,
					u->bssSize, (u->bssSize + 512) >> 10);
		cs += u->codeSize;
		ds += u->dataSize;
		bs += u->bssSize;
		}
	Mapfile printf("\nTotal      %8x(%4dK)  %8x(%4dK)  %8x(%4dK)\n", 
					cs, (cs + 512) >> 10,
					ds, (ds + 512) >> 10,
					bs, (bs + 512) >> 10);
	}

entryMap:	() =
	{
	i:	int;
	u:	ref unit_s;
	s:	ref symbolList;

	Mapfile printf("\nEntry Table\n\n");
	for	(i = 0, s = RunFile.entries; i < RunFile.entryCount; 
							i++, s = s->next){
		u = s->sym->enclosing getUnit();
		displaySymbol(i + 1, u, s->sym->currentValue);
		}
	}

cleanupMap:	() =
	{
	i:	int;
	u:	ref unit_s;
	s:	ref symbolList;

	Mapfile printf("\nCleanup Table\n\n");
	for	(i = 0, s = RunFile.cleanups; i < RunFile.cleanupCount; 
							i++, s = s->next){
		u = s->sym->enclosing getUnit();
		displaySymbol(i + 1, u, s->sym->currentValue);
		}
	}
/*
	Note that the following function dumps values in address order.

	Symbols beginning with double-underbar are omitted.  These are
	implementation internal symbols.
 */
valueMap:	() =
	{
	u:	ref unit_s;
	i:	int;
	v:	ref value;
	cp:	* char;

	buildValueVector();
	Mapfile printf("\nCode\n\n");
	u = Project.units;
	for	(i = 0; i < ValueIndex; i++){
		v = ValueVector[i];
		while	(u->next && u->next->index == i)
			u = u->next;
		if	(!v->isCode)
			continue;
		displaySymbol(i + 1, u, v);
		}
	Mapfile printf("\nData\n\n");
	u = Project.units;
	for	(i = 0; i < ValueIndex; i++){
//		printf("ValueVector = %p i = %d\n", ValueVector, i);
		v = ValueVector[i];
		while	(u->next && u->next->index == i)
			u = u->next;
		if	(v->isCode ||
			 v->data == 0)
			continue;
		displaySymbol(i + 1, u, v);
		}
	u = Project.units;
	for	(i = 0; i < ValueIndex; i++){
		v = ValueVector[i];
		while	(u->next && u->next->index == i)
			u = u->next;
		if	(v->isCode ||
			 v->data)
			continue;
		displaySymbol(i + 1, u, v);
		}
	}

displaySymbol:	(i: int, u: ref unit_s, v: ref value) =
	{
	cp:		[:] char;
	hasData:	char;

	if	(!v->linked)
		return;
	if	(v->owner){
		if	(v->owner->visibility == V_PRIVATE &&
			 !u isSourceUnit())
			return;
		cp = v->owner->name spelling();
		if	(cp[0] == '_' && cp[1] == '_' &&
			 !u isSourceUnit())
			return;
		cp = v->owner objectName();
		}
	else
		return;
	if	(!v->isCode &&
		 v->data)
		hasData = '+';
	else
		hasData = ' ';
	Mapfile printf("%4d: %08x%c%S\n", i, v->address, hasData, cp);
	}

prtpubs:	() =
	{
	v:		ref symbol_s;
	off:		unsigned;
	seg:		unsigned;
	symlist:	ref pointer;

	symlist = makeSymList();
	if	(symlist == 0){
		Mapfile printf("No memory for symbols\n");
		return;
		}
	heapsort(symlist, ref (pointer, pointer) int(&nameless));
	Mapfile printf("\n\n  Address         Publics by Name\n\n");
	dumplist(symlist);
	free(symlist);
	}

makeSymList:	() ref pointer =
	{
	s:	* symbol_s;
	u:	* unit_s;
	count:	int;
	ss:	ref pointer;
	ssp:	ref pointer;

	count = 1;
	for	(u = Project.units; u; u = u->next)
		for	(s = u->symbols; s; s = s->next){
			if	(s->name == 0)
				continue;
			if	(s->storageClass != SC_STATIC)
				continue;
			if	(s->currentValue == 0)
				continue;
			if	(!s->currentValue->linked)
				continue;
			count++;
			}
	ss = alloc(count * sizeof pointer);
	if	(ss == 0)
		return 0;
	ssp = ss;
	for	(u = Project.units; u; u = u->next)
		for	(s = u->symbols; s; s = s->next){
			if	(s->name == 0)
				continue;
			if	(s->storageClass != SC_STATIC)
				continue;
			if	(s->currentValue == 0)
				continue;
			if	(!s->currentValue->linked)
				continue;
			*ssp = s;
			ssp++;
			}
	*ssp = 0;
	return ss;
	}

dumplist:	(symlist: ref pointer) =
	{
	v:	* symbol_s;
	off:	addr_t;
	seg:	unsigned;
	u:	ref unit_s;

	for	(; *symlist; symlist++){
		v = *symlist;
		u = v->enclosing getUnit();
		if	(v->visibility == V_PRIVATE &&
			 u && !u isSourceUnit())
			continue;
		if	(v->dtype getType()->topType == T_FUNC)
			seg = 'C';
		else
			seg = 'D';
		Mapfile printf(" %c:%08x   ", seg, v->currentValue->address);
		Mapfile printf("%S", v->name spelling());
		if	(u)
			Mapfile printf(" (%S)", u->name spelling());
		Mapfile printf("\n");
		}
	}

nameless:	(v1: * symbol_s, v2: * symbol_s) int =
	{
	return stringIcompare(v1->name spelling(), v2->name spelling());
	}
