/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	filesys;
include	file;
include	error;
include	errmsg;
include	target;

lineNum:	public	type	int;

EOF_MARK:	public	const	char = 0;
BUF_SEEK_END:	public	const	int = 0x7FFFFFFF;

textRange:	public	type	{
	public:

	start:		fileOffset;
	end:		fileOffset;
	};

NO_RANGE:	public	textRange = [ 0, 0 ];

sourceBuffer:	public	type	{

	pos:			fileOffset;
	endPos:			fileOffset;
	textLength:		fileOffset;
	text:			* char;

	public:

create:	factory	(fname: [:] char) ref sourceBuffer =
	{
	self = alloc(sizeof sourceBuffer);
	self = [ fname ];
	if	(isNew()){
		free(self);
		return 0;
		}
	return self;
	}

constructor:	(fname: [:] char) =
	{
	fd:	stream;
	i:	int;
	cp:	* char;
	len:	int;
	s:	[:] char;

	pos = 0;
	endPos = 0;
	textLength = 0;
	text = 0;
	len = 0;
	i = fd open(fname, AR_READ);
	if	(i != SUCCESS)
		return;
	len = fd seek(0, SEEK_END);
	fd seek(0, 0);
	text = alloc(len + 1);
	cp = text;
	s = cp[:len];
	fd read(s);
	fd close();
	if	(|s != len){
		free(text);
		text = 0;
		return;
		}
	cp[len] = 0;
	for	(i = 0; i < len; i++){
		if	(cp[i] == 26 ||
			 cp[i] == 0){
			cp[i] = 0;
			len = i;
			break;
			}
		}
	textLength = len;
	}

isNew:	() boolean =
	{
	return text == 0;
	}

save:	(filename: [:] char, age: long) int =
	{
	fd:	stream;
	i:	int;

	i = fd create(filename, FA_READ|FA_WRITE);
	if	(i)
		return i;
	i = fd write(text[:textLength]);
	fd setAge(age);
	fd close();
	if	(i != textLength)
		return i;
	else
		return SUCCESS;
	}

tell:	() fileOffset =
	{
	return pos;
	}

tellLine:	(p: fileOffset) lineNum =
	{
	i:	fileOffset;
	cp:	ref char;
	line:	lineNum;

	line = 1;
	for	(i = 0, cp = text; i < p; i++, cp++){
		if	(*cp == '\n')
			line++;
		else if	(*cp == 0)
			break;
		}
	return line;
	}

seek:	(newPos: fileOffset, whence: int) fileOffset =
	{
	switch	(whence){
	case	0:
		pos = newPos;
		break;

	case	1:
		pos += newPos;
		break;

	case	2:
		pos = textLength + newPos;
		break;

	case	3:		// go to line number
		cp:	ref char;

		cp = text;
		while	(newPos){
			for	(;;){
				if	(*cp == 0){
					pos = textLength;
					return pos;
					}
				if	(*cp++ == '\n')
					break;
				}
			newPos--;
			}
		pos = cp - text;
		break;
		}
	return pos;
	}

sameText:	(oldSrc: textRange, newBuf: ref sourceBuffer, 
					newSrc: textRange) boolean =
	{
	len1:		fileOffset;
	len2:		fileOffset;
	ocp:		ref char;
	ncp:		ref char;
	thisCompare:	int;

	len1 = newSrc.end - newSrc.start;
	len2 = oldSrc.end - oldSrc.start;
	if	(len1 != len2)
		return FALSE;

		// make sure the text ranges are well formed

	if	(oldSrc.end > textLength)
		return FALSE;
	if	(oldSrc.start > textLength)
		return FALSE;
	if	(newSrc.end > newBuf->textLength)
		return FALSE;
	if	(newSrc.start > newBuf->textLength)
		return FALSE;
	if	(newSrc.start > newSrc.end)
		return FALSE;
	if	(oldSrc.start > oldSrc.end)
		return FALSE;

	ocp = text + oldSrc.start;
	ncp = newBuf->text + newSrc.start;

		// we know that the strings have equal length

	if	(memCompare(ocp, ncp, len1))
		return FALSE;
	else
		return TRUE;
	}

openRange:	(tr: textRange) =
	{
	if	(tr.end == BUF_SEEK_END)
		endPos = textLength;
	else
		endPos = tr.end;
	pos = tr.start;
	}

getc:	() char =
	{
	if	(pos < endPos)
		return text[pos++];
	else
		return EOF_MARK;
	}

ungetc:	() =
	{
	pos--;
	}

mapc:	(delim: char) int =
	{
	c:		int;

	for	(;;){
		CurrentContext.offset = pos;
		c = getc();
		if	(c == EOF_MARK ||
			 c == '\n'){
			ust();
			return -1;
			}
		if	(c == delim)
			return -1;
		else if	(c != '\\')
			return c;
		c = getc();
		switch	(c){
		case	EOF_MARK:
		case	'\n':
			ust();
			return -1;

		default:
			error(ErrBadEscape, c, c);
			return c;

		case	'a':	return('\a');
		case	't':	return('\t');
		case	'n':	return('\n');
		case	'b':	return('\b');
		case	'r':	return('\r');
		case	'f':	return('\f');
		case	'v':	return('\v');
		case	'\'':	return('\'');
		case	'"':	return('"');
		case	'\\':	return('\\');
		case	'0':	return('\0');
		case	'x':
			overflow:	boolean = FALSE;
			i:		int;
			digs:		int;

			c = getc();
			if	(!isxdigit(c)){
				ungetc();
				error(ErrBadEscape, 'x', 'x');
				return 'x';
				}
			for	(i = 0, digs = 1;; digs++){
				i <<= 4;
				if	(isdigit(c))
					i += c - '0';
				else
					i += tolower(c) - 'a' + 10;
				if	(!integerFits(i, CHARBITS))
					overflow = TRUE;
				c = getc();
				if	(!isxdigit(c)){
					ungetc();
					if	(overflow)
						error(ErrNumLarge);
					else if	(digs > MAXHDIGS)
						warn(WarnHexTooBig);
					return i;
					}
				}
			}
		}
	}

skipToEol:	() =
	{
	c:	int;

	do
		c = getc();
		while	(c != EOF_MARK &&
			 c != '\n');
	if	(c == '\n')
		ungetc();
	}

skipComment:	public	() =
	{
	c:			int;
	commentNestingLevel:	int;
	m:			messageContext;

	m = CurrentContext;
	m.offset = tell();
	commentNestingLevel = 0;
	for	(;;){
		switch	(c = getc()){
		case	EOF_MARK:
			errorAt(&m, ErrEofInComment);
			return;

		case	'/':
			c = getc();
			if	(c == '*')
				commentNestingLevel++;
			else if	(c == '/')
				skipToEol();
			break;

		case	'*':
			c = getc();
			if	(c == '/'){
				commentNestingLevel--;
				if	(commentNestingLevel < 0)
					return;
				}
			else if	(c != EOF_MARK)
				ungetc();
			}
		}
	}

	};

MAXHDIGS:	const int = ((CHARBITS + 3) / 4);

ust:	() = 
	{
	error(ErrStringNoTerm);
	}

