/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	string;
include	backend, xtree, xcall;
include	target;
include	hash;
include	sbuffer;
include	image;
include	file;
include	ptree;
include	symtab;
include	errmsg;
include	value;
/*
	topType:

		T_NAME		type name
		T_FUNC		function
		T_ARRAY		fixed array
		T_STRUCT	structure
		T_VARRAY	variable array
		T_REF		pointer
		T_SIGNED	signed integer
		T_UNSIGNED	unsigned integer
		T_FLOAT		floating
		T_VOID		void
		T_ERROR		error
		T_TYPE		type-type
 */
type_s:	public	type	inherit	scope_s	{
	public:
	topType:	topTypes;

constructor:	(t: topTypes) =
	{
	super constructor(0, 0);
	topType = t;
	}

save:	dynamic	(ref imageFile) =
	{
	}

display:	dynamic	(boolean) =
	{
	}
/*
	This function is called to construct the interface details for a
	type.  The second boolean parameter is TRUE if variable length types
	are allowed, FALSE otherwise.
 */
constructInterface:	dynamic	(ref scope_s, boolean) =
	{
	}

reconnectInterface:	dynamic	(ref scope_s) =
	{
	}

constructValue:	dynamic	(ref scope_s) =
	{
	}

needsDynamicVectors:	dynamic	() boolean =
	{
	return FALSE;
	}

hasConstructor:	dynamic	() boolean =
	{
	return FALSE;
	}

getType:	dynamic	() ref type_s =
	{
	return self;
	}

setTypeName:	dynamic	(ref identifier) =
	{
	}

emitNeededTypedefs:	dynamic	(ref stream) =
	{
	}

outputHeaderPrefix:	dynamic	(ref stream) =
	{
	}

outputHeaderSuffix:	dynamic	(ref stream) =
	{
	}

lookupMember:	dynamic	(ref identifier, ref scope_s) ref symbol_s =
	{
	return 0;
	}

returnTypeOf:	dynamic	() ref type_s =
	{
	return 0;
	}

targetOf:	dynamic	() ref type_s =
	{
	return 0;
	}

elementOf:	dynamic	() ref type_s =
	{
	return 0;
	}

isGateFunction:	dynamic	() boolean =
	{
	return FALSE;
	}

isFarPointer:	dynamic	() boolean =
	{
	return FALSE;
	}

inherits:	dynamic	(ref type_s) boolean =
	{
	return FALSE;
	}

commonBaseType:	dynamic	(t: ref type_s) ref type_s =
	{
	if	(inherits(t))
		return t;
	else
		return 0;
	}

hasDynamicVector:	dynamic	() boolean =
	{
	return FALSE;
	}
/*
	This function returns the offset, in bytes, of the dynamic vector
	offset within the object.
 */
dynamicOffset:	dynamic	() addr_t =
	{
	return 0;
	}

compare:	dynamic	(ref type_s) boolean =
	{
	return FALSE;
	}

sizeOf:	dynamic	() addr_t =
	{
	return 0;
	}

exprSizeOf:	dynamic	() ref tree_p =
	{
	return Func icon(sizeOf(), INTBITS);
	}

exprDimension:	dynamic	() ref tree_p =
	{
	return ErrorTree;
	}

bitSizeOf:	dynamic	() addr_t =
	{
	return 0;
	}
/*
	This must return the type's preferred alignment in bits.
 */
alignmentOf:	dynamic	() addr_t =
	{
	return BYTEBITS;
	}

dynamicVectorName:	dynamic	(targ: ref value) [:] char =
	{
	return "";
	}

	};

typeMatch:	public	(d1: ref type_s, d2: ref type_s) boolean =
	{
	if	(d1 == 0 ||
		 d2 == 0)
		return FALSE;
	d1 = d1 getType();
	d2 = d2 getType();
	if	(d1 == d2)
		return TRUE;
	if	(d1->topType != d2->topType)
		return FALSE;
	return d1 compare(d2);
	}

error_z:	public	type	inherit type_s	{
	public:

create:	factory	() ref error_z =
	{
	self = alloc(sizeof error_z);
	self = [ T_ERROR ];
	return self;
	}

display:	dynamic	(boolean) =
	{
	printf(" error-type");
	}

save:	dynamic	(ifile: ref imageFile) =
	{
	ifile beginRecord(U_ERROR_TYPE, self, sizeof *self);
	}

	};

type_z:	public	type	inherit type_s	{
	public:

create:	factory	() ref type_z =
	{
	self = alloc(sizeof type_z);
	self = [ T_TYPE ];
	return self;
	}

display:	dynamic	(boolean) =
	{
	printf(" type-type");
	}

compare:	dynamic	(ref type_s) boolean =
	{
	return TRUE;
	}

save:	dynamic	(ifile: ref imageFile) =
	{
	ifile beginRecord(U_TYPE_TYPE, self, sizeof *self);
	}

	};

ErrorType:	public	ref error_z;
IntType:	public	ref number_z;
TypeType:	public	ref type_z;

setup:	entry	() =
	{
	ErrorType = error_z create();
	IntType = number_z create(T_SIGNED, NO_RANGE, INTBITS);
	TypeType = type_z create();
	}

number_z:	public	type	inherit	type_s	{
	public:

	source:		textRange;
	width:		int;
	size:		byte;
	align:		byte;

create:	factory	(t: topTypes, sourc: textRange, w: int) ref number_z =
	{
	self = alloc(sizeof number_z);
	self = [ t ];
	source = sourc;
	width = w;
	size = 0;
	align = BYTEBITS;
	if	(source.start == 0)
		constructInterface(0, FALSE);
	return self;
	}

load:	factory	(n: pointer, image: ref loader) =
	{
	self = n;
	self = [ image integer() ];
	source.start = image uinteger();
	source.end = image uinteger();
	width = image uinteger();
	size = image uinteger();
	align = image uinteger();
	}

save:	dynamic	(ifile: ref imageFile) =
	{
	if	(ifile beginRecord(U_NUMBER_TYPE, self, sizeof *self)){
		ifile integer(topType);
		ifile uinteger(source.start);
		ifile uinteger(source.end);
		ifile uinteger(width);
		ifile uinteger(size);
		ifile uinteger(align);
		}
	}

display:	dynamic	(boolean) =
	{
	if	(topType == T_SIGNED)
		printf(" signed");
	else if	(topType == T_UNSIGNED)
		printf(" unsigned");
	else
		printf(" float");
	if	(source.start)
		printf("[%d,%d]", source.start, source.end);
	else
		printf("[%d]", width);
	}

constructInterface:	dynamic	(s: ref scope_s, boolean) =
	{
	if	(source.start)
		width = constantExpression(source, s);

	ntd:	ref numberTypeDescriptor;

	align = BYTEBITS;	// in case of error
	switch	(topType){
	case	T_FLOAT:
		for	(ntd = FloatingTypes; ntd < 
					&FloatingTypes[|FloatingTypes]; ntd++){
			if	(ntd->bitSize >= width){
				size = ntd->bitSize / BYTEBITS;
				align = ntd->bitAlignment;
				return;
				}
			}
		error(ErrFloatWide);
		break;

	case	T_SIGNED:
		for	(ntd = SignedTypes; ntd < 
					&SignedTypes[|SignedTypes]; ntd++){
			if	(ntd->bitSize >= width){
				size = ntd->bitSize / BYTEBITS;
				align = ntd->bitAlignment;
				return;
				}
			}
		error(ErrIntWide);
		break;

	case	T_UNSIGNED:
		for	(ntd = UnsignedTypes; ntd < 
					&UnsignedTypes[|UnsignedTypes]; ntd++){
			if	(ntd->bitSize >= width){
				size = ntd->bitSize / BYTEBITS;
				align = ntd->bitAlignment;
				return;
				}
			}
		error(ErrIntWide);
		break;
		}
	}

outputHeaderPrefix:	dynamic	(fd: ref stream) =
	{
	if	(topType == T_SIGNED){
		if	(width <= BYTEBITS)
			fd printf("signed char ");
		else if	(width <= INTBITS)
			fd printf("int ");
		else if	(width <= LONGBITS)
			fd printf("long ");
		}
	else if	(topType == T_UNSIGNED){
		if	(width <= BYTEBITS)
			fd printf("unsigned char ");
		else if	(width <= INTBITS)
			fd printf("unsigned ");
		else if	(width <= LONGBITS)
			fd printf("unsigned long ");
		}
	else if	(topType == T_FLOAT){
		if	(width <= FLOATBITS)
			fd printf("float ");
		else if	(width <= DOUBLEBITS)
			fd printf("double ");
		else if	(width <= EXTENDBITS)
			fd printf("long double ");
		}
	}

compare:	dynamic	(t: ref type_s) boolean =
	{
	nt:	ref number_z;

	nt = ref number_z(t);
	return width == nt->width;
	}

sizeOf:	dynamic	() addr_t =
	{
	return size;
	}

bitSizeOf:	dynamic	() addr_t =
	{
	if	(width < 0)
		return -width;
	else
		return width;
	}

alignmentOf:	dynamic	() addr_t =
	{
	return align;
	}

	};

numberTypeDescriptor:	public	type	{
	public:

	bitSize:		unsigned[16];
	bitAlignment:		unsigned[16];
	};

named_z:	public	type	inherit	type_s	{
	public:

	name:		ref identifier;
	offset:		fileOffset;

		// Constructed information

	actualType:	ref type_s;
	actualSymbol:	ref symbol_s;

create:	factory	(id: ref identifier, off: fileOffset) ref named_z =
	{
	self = alloc(sizeof named_z);
	self = [ T_NAME, id, off ];
	actualType = 0;
	actualSymbol = 0;
	return self;
	}

load:	factory	(n: pointer, image: ref loader) =
	{
	self = n;
	self = [ T_NAME ];
	name = identifier create(image string(), 0);
	offset = image uinteger();
	actualType = image address();
	actualSymbol = image address();
	}

save:	dynamic	(ifile: ref imageFile) =
	{
	if	(ifile beginRecord(U_NAMED_TYPE, self, sizeof *self)){
		ifile putstring(name spelling());
		ifile uinteger(offset);
		ifile address(actualType);
		ifile address(actualSymbol);
		}
	}

display:	dynamic	(boolean) =
	{
	printf(" %S", name spelling());
	}

emitNeededTypedefs:	dynamic	(fd: ref stream) =
	{
	if	(actualSymbol)
		actualSymbol emitNeededDeclaration(fd);
	}

constructInterface:	dynamic	(s: ref scope_s, boolean) =
	{
	sym:	ref symbol_s;
	u:	ref unit_s;

	sym = s lookup(name, s);
	CurrentContext.offset = offset;
	if	(sym == 0){
		error(ErrUndefSym, name spelling());
		actualType = ErrorType;
		return;
		}
	if	(sym->storageClass != SC_TYPE){
		error(ErrNotType, name spelling());
		actualType = ErrorType;
		return;
		}
	if	(sym->working){
		error(ErrCircular, name spelling());
		actualType = ErrorType;
		return;
		}
//	addInterfaceDependency(sym);
	sym constructInterface();
	actualSymbol = sym;
	actualType = sym->dtype;
	}

reconnectInterface:	dynamic	(s: ref scope_s) =
	{
	sym:	ref symbol_s;
	u:	ref unit_s;

	if	(actualType)
		return;
	sym = s lookup(name, s);
	CurrentContext.offset = offset;
	if	(sym == 0){
		error(ErrUndefSym, name spelling());
		actualType = ErrorType;
		return;
		}
	if	(sym->storageClass != SC_TYPE){
		error(ErrNotType, name spelling());
		actualType = ErrorType;
		return;
		}
	if	(sym->working)
		return;
	actualSymbol = sym;
	actualType = sym->dtype;
	sym reconnectInterface();
	}

getType:	dynamic	() ref type_s =
	{
	if	(actualType)
		return actualType getType();
	else
		return 0;
	}

outputHeaderPrefix:	dynamic	(fd: ref stream) =
	{
	t:	ref type_s;

	t = getType();
	if	(t == 0){
		fd printf("$%S$_ ", name spelling());
		return;
		}
	
	if	(t->topType == T_SIGNED ||
		 t->topType == T_UNSIGNED ||
		 t->topType == T_FLOAT)
		t outputHeaderPrefix(fd);
	else if	(t->topType == T_STRUCT){
		fd printf("struct ");
		actualSymbol outputHeaderName(fd);
		fd printf(" ");
		}
	else	{
		actualSymbol outputHeaderName(fd);
		fd printf(" ");
		}
	}

	};

refTo:	public	(t: ref type_s) ref ptr_z =
	{
	return ptr_z create(FALSE, t, 0);
	}

ptr_z:	public	type	inherit	type_s	{
	public:

	referTo:	* type_s;
	qualifier:	dQualifiers;
	owns:		boolean;

create:	factory	(p: boolean, r: ref type_s, q: dQualifiers) ref ptr_z =
	{
	self = alloc(sizeof ptr_z);
	self = [ T_REF, r, q, p ];
	return self;
	}

load:	factory	(p: pointer, image: ref loader) =
	{
	self = p;
	self = [ T_REF ];
	referTo = image address();
	qualifier = image integer();
	owns = image integer();
	}

save:	dynamic	(ifile: ref imageFile) =
	{
	if	(ifile beginRecord(U_PTR_TYPE, self, sizeof *self)){
		ifile address(referTo);
		ifile integer(qualifier);
		ifile integer(owns);
		if	(referTo)
			referTo save(ifile);
		}
	}

commonPointerType:	dynamic	(t: ref type_s) ref type_s =
	{
	if	(t->topType != T_REF)
		return 0;
	p:	ref ptr_z = ref ptr_z(t);

	if	(qualifier != p->qualifier)
		return 0;
	r1:	ref type_s;
	r2:	ref type_s;

	r1 = targetOf();
	r2 = p targetOf();
	if	(r1 == 0)
		return 0;
	if	(r2 == 0)
		return 0;
	if	(r1->topType == T_VOID)
		return p;
	if	(r2->topType == T_VOID)
		return self;
	if	(typeMatch(r1, r2))
		return self;
	else
		return 0;
	}

isFarPointer:	dynamic	() boolean =
	{
	if	(qualifier & DQ_FAR)
		return TRUE;
	else
		return FALSE;
	}

constructInterface:	dynamic	(s: ref scope_s, boolean) =
	{
	if	(referTo)
		s deferInterface(referTo, FALSE);
	}

reconnectInterface:	dynamic	(s: ref scope_s) =
	{
	if	(referTo)
		referTo reconnectInterface(s);
	}

constructValue:	dynamic	(s: ref scope_s) =
	{
	if	(referTo)
		referTo constructValue(s);
	}

display:	dynamic	(m: boolean) =
	{
	printf(" ref");
	if	(owns)
		printf(" owns");
	if	(qualifier)
		printf(" q %x", qualifier);
	if	(referTo)
		referTo display(m);
	}

outputHeaderPrefix:	dynamic	(fd: ref stream) =
	{
	fd printf("void *");
	}
/*
emitNeededTypedefs:	dynamic	(fd: ref stream) =
	{
	if	(referTo)
		referTo emitNeededTypedefs(fd);
	}
 */
targetOf:	dynamic	() ref type_s =
	{
	if	(referTo)
		return referTo getType();
	else
		return 0;
	}

compare:	dynamic	(t: ref type_s) boolean =
	{
	pt:	ref ptr_z;

	pt = ref ptr_z(t);
	if	(qualifier != pt->qualifier)
		return FALSE;
	return typeMatch(referTo, pt->referTo);
	}

sizeOf:	dynamic	() addr_t =
	{
	return PTRBITS / BYTEBITS;
	}

bitSizeOf:	dynamic	() addr_t =
	{
	return PTRBITS;
	}

alignmentOf:	dynamic	() addr_t =
	{
	return PTRALIGN;
	}

	};

array_z:	public	type	inherit	type_s	{
	public:

	element:	* type_s;
	source:		textRange;
	dimension:	int;
	xDimension:	ref tree_p;

create:	factory	(sourc: textRange, dim: int, 
				elementType: ref type_s) ref array_z =
	{
	return new array_z[ T_ARRAY, elementType, sourc, dim ];
	}

load:	factory	(a: pointer, image: ref loader) =
	{
	self = a;
	self = [ image integer() ];
	element = image address();
	source.start = image uinteger();
	source.end = image uinteger();
	dimension = image uinteger();
	}

save:	dynamic	(ifile: ref imageFile) =
	{
	if	(ifile beginRecord(U_ARRAY_TYPE, self, sizeof *self)){
		ifile integer(topType);
		ifile address(element);
		ifile uinteger(source.start);
		ifile uinteger(source.end);
		ifile uinteger(dimension);
		if	(element)
			element save(ifile);
		}
	}

display:	dynamic	(m: boolean) =
	{
	if	(topType == T_ARRAY)
		printf(" array");
	else
		printf(" var array");
	if	(source.start)
		printf(" bounds [ %d, %d ]", source.start, source.end);
	else if	(dimension)
		printf("[%d]", dimension);
	if	(element)
		element display(m);
	}

constructInterface:	dynamic	(s: ref scope_s, b: boolean) =
	{
	if	(element)
		element constructInterface(s, b);
	if	(b){
		if	(source.start)
			xDimension = extractExpression(source, s);
		}
	else if	(source.start)
		dimension = constantExpression(source, s);
	}

reconnectInterface:	dynamic	(s: ref scope_s) =
	{
	if	(element)
		element reconnectInterface(s);
	}

constructValue:	dynamic	(s: ref scope_s) =
	{
	if	(element)
		element constructValue(s);
	}

outputHeaderPrefix:	dynamic	(fd: ref stream) =
	{
	if	(element)
		element outputHeaderPrefix(fd);
	}

outputHeaderSuffix:	dynamic	(fd: ref stream) =
	{
	fd printf("[%d]", dimension);
	}

emitNeededTypedefs:	dynamic	(fd: ref stream) =
	{
	if	(element)
		element emitNeededTypedefs(fd);
	}

compare:	dynamic	(t: ref type_s) boolean =
	{
	at:	ref array_z;

	at = ref array_z(t);
	if	(dimension &&
		 at->dimension &&
		 dimension != at->dimension)
		return FALSE;
	return typeMatch(element, at->element);
	}

elementOf:	dynamic	() ref type_s =
	{
	if	(element)
		return element getType();
	else
		return 0;
	}

exprSizeOf:	dynamic	() ref tree_p =
	{
	e:	ref tree_p;

	e = element getType() exprSizeOf();
	return Func binary(O_MUL, xDimension dup(0), e, 0);
	}

exprDimension:	dynamic	() ref tree_p =
	{
	return xDimension dup(0);
	}

sizeOf:	dynamic	() addr_t =
	{
	if	(element){
		j:	addr_t;

		j = element getType() sizeOf();
		return dimension * j;
		}
	else
		return 0;
	}

bitSizeOf:	dynamic	() addr_t =
	{
	if	(element){
		j:	addr_t;

		j = element getType() bitSizeOf();
		return dimension * j;
		}
	else
		return 0;
	}

alignmentOf:	dynamic	() addr_t =
	{
	if	(element)
		return element getType() alignmentOf();
	else
		return BYTEBITS;
	}

needsDynamicVectors:	dynamic	() boolean =
	{
	if	(element)
		return element getType() needsDynamicVectors();
	else
		return FALSE;
	}

	};

descriptor_z:	public	type	inherit	type_s	{
	public:

	element:	* type_s;
	source:		textRange;
	dimension:	int;
	rank:		int;

create:	factory	(sourc: textRange, dim: int, 
				elementType: ref type_s) ref descriptor_z =
	{
	self = alloc(sizeof descriptor_z);
	self = [ T_DESCRIPTOR, elementType ];
	source = sourc;
	dimension = dim;
	rank = 1;			// default to rank 1
	return self;
	}

load:	factory	(a: pointer, image: ref loader) =
	{
	self = a;
	self = [ image integer() ];
	element = image address();
	source.start = image uinteger();
	source.end = image uinteger();
	dimension = image uinteger();
	rank = image uinteger();
	}

save:	dynamic	(ifile: ref imageFile) =
	{
	if	(ifile beginRecord(U_DESCRIPTOR_TYPE, self, sizeof *self)){
		ifile integer(topType);
		ifile address(element);
		ifile uinteger(source.start);
		ifile uinteger(source.end);
		ifile uinteger(dimension);
		ifile uinteger(rank);
		if	(element)
			element save(ifile);
		}
	}

display:	dynamic	(m: boolean) =
	{
	printf(" descriptor");
	if	(source.start)
		printf(" bounds [ %d, %d ]", source.start, source.end);
	else if	(dimension)
		printf("[%d]", dimension);
	printf(" rank %d", rank);
	if	(element)
		element display(m);
	}

constructInterface:	dynamic	(s: ref scope_s, boolean) =
	{
	if	(element){
		element constructInterface(s, FALSE);
		if	(element->topType == T_DESCRIPTOR)
			rank = ref descriptor_z(element)->rank + 1;
		else
			rank = 1;
		}
	if	(source.start)
		dimension = constantExpression(source, s);
	}

reconnectInterface:	dynamic	(s: ref scope_s) =
	{
	if	(element)
		element reconnectInterface(s);
	}

constructValue:	dynamic	(s: ref scope_s) =
	{
	if	(element)
		element constructValue(s);
	}

outputHeaderPrefix:	dynamic	(fd: ref stream) =
	{
	fd printf("p_descriptor ");
	}

outputHeaderSuffix:	dynamic	(fd: ref stream) =
	{
	}

compare:	dynamic	(t: ref type_s) boolean =
	{
	if	(ref descriptor_z(t)->rank != rank)
		return FALSE;
	return typeMatch(element, ref descriptor_z(t)->element);
	}

elementOf:	dynamic	() ref type_s =
	{
	if	(element)
		return element getType();
	else
		return 0;
	}

sizeOf:	dynamic	() addr_t =
	{
	return DESCRIPTOR_BASE + rank * DESCRIPTOR_RANK_SIZE;
	}

bitSizeOf:	dynamic	() addr_t =
	{
	return (DESCRIPTOR_BASE + rank * DESCRIPTOR_RANK_SIZE) * BYTEBITS;
	}

alignmentOf:	dynamic	() addr_t =
	{
	return PTRBITS;
	}

	};

void_z:	public	type	inherit	type_s	{
	public:

create:	factory	() ref void_z =
	{
	self = alloc(sizeof void_z);
	self = [ T_VOID ];
	return self;
	}

load:	factory	(v: pointer, ref loader) =
	{
	self = v;
	self = [ T_VOID ];
	}

save:	dynamic	(ifile: ref imageFile) =
	{
	ifile beginRecord(U_VOID_TYPE, self, sizeof *self);
	}

outputHeaderPrefix:	dynamic	(fd: ref stream) =
	{
	fd printf("void ");
	}

compare:	dynamic	(ref type_s) boolean =
	{
	return TRUE;
	}

	};

struct_z:	public	type	inherit	type_s	{
	public:

	base:		* type_s;
	packing:	packingMethods;

		// Constructed information

	name:		ref identifier;
	bitSize:	addr_t;
	align:		addr_t;
	vectorOffset:	addr_t;
	vectorSize:	addr_t;
	dynamicVector:	* value;
	gateVector:	* value;
	gateCount:	int;

create:	factory	(e: ref scope_s, parent: ref type_s, 
				p: packingMethods) ref struct_z =
	{
	self = alloc(sizeof struct_z);
	self = [ T_STRUCT, parent, p, 0, FALSE, 0 ];
	enclosing = e;
	vectorOffset = 0;
	vectorSize = 0;
	dynamicVector = 0;
	gateVector = 0;
	gateCount = 0;
	return self;
	}

load:	factory	(st: pointer, image: ref loader) =
	{
	self = st;
	self = [ T_STRUCT ];
	enclosing = image address();
	base = image address();
	symbols = image address();
	packing = image integer();
	bitSize = image uinteger();
	align = image integer();
	vectorOffset = image uinteger();
	vectorSize = image uinteger();
	dynamicVector = image address();
	gateVector = image address();
	gateCount = image integer();
	}

save:	dynamic	(ifile: ref imageFile) =
	{
	if	(ifile beginRecord(U_STRUCT_TYPE, self, sizeof *self)){
		ifile address(enclosing);
		ifile address(base);
		ifile address(symbols);
		ifile integer(packing);
		ifile uinteger(bitSize);
		ifile integer(align);
		ifile uinteger(vectorOffset);
		ifile uinteger(vectorSize);
		ifile address(dynamicVector);
		ifile address(gateVector);
		ifile integer(gateCount);
		if	(base)
			base save(ifile);
		if	(symbols)
			symbols save(ifile);
		if	(dynamicVector)
			dynamicVector save(ifile);
		if	(gateVector)
			gateVector save(ifile);
		}
	}

commonBaseType:	dynamic	(t: ref type_s) ref type_s =
	{
	for	(;;){
		if	(t inherits(self))
			return self;
		if	(base){
			b:	ref type_s;

			b = base getType();
			if	(b->topType != T_STRUCT){
				if	(t inherits(b))
					return b;
				else
					return 0;
				}
			self = ref struct_z(b);
			}
		else
			return 0;
		}
	}

inherits:	dynamic	(t: ref type_s) boolean =
	{
	if	(self == t)
		return TRUE;
	if	(base){
		t2:	ref type_s;

		t2 = base getType();
		if	(typeMatch(t2, t))
			return TRUE;
		return t2 inherits(t);
		}
	else
		return FALSE;
	}

lookupMember:	dynamic	(n: ref identifier, 
					context: ref scope_s) ref symbol_s =
	{
	sym:	ref symbol_s;

	sym = lookupLocal(n, self);
	if	(sym == 0){
		if	(base){
			sym = base getType() lookupMember(n, context);
			if	(sym == 0)
				return sym;
			}
		else
			return sym;
		}
	if	(sym->visibility != V_PRIVATE)
		return sym;
	if	(encloses(context))
		return sym;
	else
		return 0;
	}

lookup:	dynamic	(n: ref identifier, context: ref scope_s) ref symbol_s =
	{
	s:	ref symbol_s;

	s = lookupMember(n, context);
	if	(s)
		return s;
	if	(enclosing)
		return enclosing lookup(n, context);
	else
		return 0;
	}

objectName:	dynamic	() [:] char =
	{
	NameEmitter = [ Name ];
	if	(enclosing)
		enclosing scopeName();
	if	(name)
		NameEmitter printf(name spelling());
	else
		NameEmitter printf("<no name>");
	return NameEmitter result();
	}

dynamicVectorName:	dynamic	(target: ref value) [:] char =
	{
	NameEmitter = [ Name ];
	scopeName();
	if	(target == gateVector)
		NameEmitter printf("gate");
	return NameEmitter result();
	}

lineno:	dynamic	(o: fileOffset) int =
	{
	if	(enclosing)
		return enclosing getUnit() lineno(o);
	else
		return 0;
	}

scopeName:	dynamic	() =
	{
	if	(enclosing)
		enclosing scopeName();
	if	(name)
		NameEmitter printf("%S.", name spelling());
	}

csourceName:	dynamic	() =
	{
	if	(enclosing)
		enclosing csourceName();
	if	(name)
		Project.outputFd printf("%S_", name spelling());
	else
		Project.outputFd printf("_");
	}

setTypeName:	dynamic	(n: ref identifier) =
	{
	name = n;
	}

getEnclosingType:	dynamic	() ref type_s =
	{
	return self;
	}

addDeclaration:	(n: ref identifier, off: fileOffset,
				hasError: boolean, d: ref declaration_p) =
	{
	sym:	ref symbol_s;
	last:	ref symbol_s;


	sym = symbol_s create(self, n, off, hasError, d);
	if	(symbols){
		for	(last = symbols; last->next; last = last->next)
			;
		last->next = sym;
		}
	else
		symbols = sym;
	}

constructInterface:	dynamic	(s: ref scope_s, boolean) =
	{
	sym:		ref symbol_s;
	baseDyn:	boolean;
	selfDyn:	boolean;
	t:		ref type_s;
	bitOff:		addr_t;

	selfDyn = FALSE;
	baseDyn = FALSE;
	align = BYTEBITS;
	bitOff = 0;
	gateCount = 0;
	if	(base){
		base constructInterface(s, FALSE);
		t = base getType();
		if	(t->topType != T_STRUCT)
			error(ErrBadBaseType);
		gateCount = ref struct_z(t)->gateCount;
		baseDyn = t hasDynamicVector();
		align = t alignmentOf();
		bitOff = t sizeOf() * BYTEBITS;
		}
	for	(sym = symbols; sym; sym = sym->next){
		sym constructInterface();
		if	(sym->qualifier & DQ_DYNAMIC)
			selfDyn = TRUE;
		if	(sym->dtype isGateFunction())
			makeGateEntry(sym);
		else
			checkNonGateEntry(sym);
		}
	if	(baseDyn){
		selfDyn = FALSE;
		vectorOffset = ref struct_z(t)->vectorOffset;
		vectorSize = ref struct_z(t)->vectorSize;
		}

	j:	unsigned;

	switch	(packing){
	case	PM_PACKED:
		if	(selfDyn){
			vectorOffset = bitOff;
			bitOff += PTRBITS;
			}
		for	(sym = symbols; sym; sym = sym->next){
			if	(sym->storageClass != SC_MEMBER)
				continue;
			if	(sym->dtype == 0)
				continue;
			t = sym->dtype getType();
			bitOff = packedAdjustment(bitOff, t);
			sym->bitOffset = bitOff;
			bitOff += t bitSizeOf();
			}
		break;

	case	PM_STRUCT:
		i:	int;

		for	(i = 0; i < |StructLayout; i++){
			if	(StructLayout[i] == -1){
				if	(selfDyn){
					vectorOffset = bitOff;
					bitOff += PTRBITS;
					}
				continue;
				}
			for	(sym = symbols; sym; sym = sym->next){
				if	(sym->storageClass != SC_MEMBER)
					continue;
				if	(sym->dtype == 0)
					continue;
				t = sym->dtype getType();
				j = t alignmentOf();
				if	(j != StructLayout[i])
					continue;
				if	(j > align)
					align = j;

					// Do any needed alignment -
					// probably not necessary

				j = bitOff % j;
				if	(j)
					bitOff += StructLayout[i] - j;
				sym->bitOffset = bitOff;
				bitOff += t sizeOf() * BYTEBITS;
				}
			}
		break;

		// Unions are already set, all symbols have bitOffset of zero

	case	PM_UNION:
		if	(selfDyn)
			error(ErrNoDynamics);
		for	(sym = symbols; sym; sym = sym->next){
			if	(sym->storageClass != SC_MEMBER)
				continue;
			if	(sym->dtype == 0)
				continue;
			t = sym->dtype getType();
			j = t alignmentOf();
			if	(j > align)
				align = j;

				// Note that the loop computes size in bytes

			j = t sizeOf();
			if	(j > bitOff)
				bitOff = j;
			}

			// The size must now be converted to bits

		bitOff *= BYTEBITS;
		break;
		}

		// Round the structure size up to an even alignment factor

	j = align;			// an odd code gen bug happens
					// if the divide is by align
					// directly.
	j = bitOff % j;
	if	(j)
		bitOff += align - j;
	bitSize = bitOff;
	if	(gateCount)
		gateVector = value createVector();
	if	(selfDyn || baseDyn){
		dynamicVector = value createVector();

			// Assign dynamic vector addresses to dynamic
			// member functions

		for	(sym = symbols; sym; sym = sym->next){
			if	(sym->dtype->topType != T_FUNC)
				continue;
			if	(sym->qualifier & DQ_DYNAMIC)
				makeDynamicEntry(sym);
			else
				checkNondynamicEntry(sym);
			}
		}
	}

findVectorEntry:	(offset: unsigned) ref value =
	{
	m:	ref symbol_s;
	d:	ref type_s;

	for	(;;){
		for	(m = symbols; m; m = m->next){
			if	((m->qualifier & DQ_DYNAMIC) &&
				 m->bitOffset == offset)
				return m->currentValue;
			}
		if	(base == 0)
			return 0;
		d = base getType();
		if	(d->topType != T_STRUCT)
			return 0;
		self = ref struct_z(d);
		}
	}

findGateEntry:	(offset: unsigned) ref value =
	{
	m:	ref symbol_s;
	d:	ref type_s;

	for	(;;){
		for	(m = symbols; m; m = m->next){
			if	(m->dtype isGateFunction() &&
				 m->bitOffset == offset)
				return m->currentValue;
			}
		if	(base == 0)
			return 0;
		d = base getType();
		if	(d->topType != T_STRUCT)
			return 0;
		self = ref struct_z(d);
		}
	}

makeDynamicEntry:	(m: ref symbol_s) =
	{
	oldm:	ref symbol_s;
	x:	ref type_s;

	if	(base){
		x = base getType();
		oldm = x lookupMember(m->name, x);
		if	(oldm && oldm->qualifier & DQ_DYNAMIC){
			m->bitOffset = oldm->bitOffset;
			return;
			}
		}
	m->bitOffset = vectorSize;
	vectorSize += DYNFUNC_SIZE;
	}

checkNondynamicEntry:	(m: ref symbol_s) =
	{
	oldm:	ref symbol_s;
	x:	ref type_s;

	if	(base == 0)
		return;
	x = base getType();
	oldm = x lookupMember(m->name, x);
	if	(oldm &&
		 oldm->qualifier & DQ_DYNAMIC)
		error(ErrFuncNotDynamic, m->name spelling());
	}

makeGateEntry:	(m: ref symbol_s) =
	{
	oldm:	ref symbol_s;
	x:	ref type_s;

	if	(base){
		x = base getType();
		oldm = x lookupMember(m->name, x);
		if	(oldm &&
			 oldm->dtype isGateFunction()){
			m->bitOffset = oldm->bitOffset;
			return;
			}
		}
	m->bitOffset = MESSAGE_FUNCTION_BASE + gateCount;
	gateCount++;
	}

checkNonGateEntry:	(m: ref symbol_s) =
	{
	oldm:	ref symbol_s;
	x:	ref type_s;

	if	(base == 0)
		return;
	x = base getType();
	oldm = x lookupMember(m->name, x);
	if	(oldm &&
		 oldm->dtype isGateFunction())
		error(ErrFuncNotGate, m->name spelling());
	}

reconnectInterface:	dynamic	(s: ref scope_s) =
	{
	sym:	ref symbol_s;

	if	(base)
		base reconnectInterface(s);
	for	(sym = symbols; sym; sym = sym->next)
		sym reconnectInterface();
	}

display:	dynamic	(m: boolean) =
	{
	if	(base){
		printf(" inherit ");
		base display(m);
		}
	switch	(packing){
	case	PM_PACKED:	printf(" packed");	break;
	case	PM_UNION:	printf(" union");	break;
		}
	printf(" {");
	if	(m){
		printf("\n");
		sym:	ref symbol_s;

		for	(sym = symbols; sym; sym = sym->next){
			sym display();
			printf("\n");
			}
		}
	printf("}");
	}

constructValue:	dynamic	(s: ref scope_s) =
	{
	sym:	ref symbol_s;

	if	(base)
		base constructValue(s);
	for	(sym = symbols; sym; sym = sym->next){
		sym constructValue(FALSE);
		if	(sym->qualifier & DQ_DYNAMIC)
			checkDynamicEntry(sym);
		}
	if	(dynamicVector)
		dynamicVector constructVector(self);
	if	(gateVector)
		constructGateVector();
	}

constructGateVector:	() =
	{
	sz:	addr_t;

	sz = gateCount * GATE_DESCR_SIZE + TYPE_DESCR_BASE_SIZE;
	gateVector sizeValue(sz, FALSE);
	gateVector depositInteger(64, 0, 4);
	gateVector depositInteger(MESSAGE_FUNCTION_BASE, 4, 4);
	gateVector depositInteger(gateCount, 10, 2);
	i:	int;
	offs:	addr_t;

	offs = TYPE_DESCR_BASE_SIZE;
	for	(i = 0; i < gateCount; i++, offs += GATE_DESCR_SIZE){
		v:	ref value;

		v = findGateEntry(i + MESSAGE_FUNCTION_BASE);
		gateVector valueFixup(offs, v, 0);
		gateVector depositInteger(~0, offs + 4, 4);
		}
	gateVector->dtype = self;
	}

checkDynamicEntry:	(m: ref symbol_s) =
	{
	oldm:	ref symbol_s;
	x:	ref type_s;

	if	(base == 0)
		return;
	x = base getType();
	oldm = x lookupMember(m->name, x);
	if	(oldm == 0 ||
		 oldm->qualifier & DQ_DYNAMIC == 0)
		return;
	if	(!typeMatch(oldm->dtype, m->dtype)){
/*
		printf("oldm: ");
		oldm->dtype display(TRUE);
		printf("\n");
		printf("   m: ");
		m->dtype display(TRUE);
		printf("\n");
 */
		CurrentContext.offset = m->offset;
		CurrentContext.obj = m->enclosing;
		error(ErrRedecl, m->name spelling());
		}
	}

hasDynamicVector:	dynamic	() boolean =
	{
	if	(dynamicVector)
		return TRUE;
	else
		return FALSE;
	}

needsDynamicVectors:	dynamic	() boolean =
	{
	if	(dynamicVector ||
		 gateVector)
		return TRUE;

	sym:	ref symbol_s;

	if	(base &&
		 base needsDynamicVectors())
		return TRUE;
	for	(sym = symbols; sym; sym = sym->next)
		if	(sym->storageClass == SC_MEMBER &&
			 sym->dtype &&
			 sym->dtype needsDynamicVectors())
			return TRUE;
	return FALSE;
	}

hasConstructor:	dynamic	() boolean =
	{
	sym:		ref symbol_s;

	for	(sym = symbols; sym; sym = sym->next){
		if	(sym->name &&
			 sym->name isSpelled("constructor")){
			if	(sym->dtype->topType == T_FUNC)
				return TRUE;
			break;
			}
		}
	if	(base &&
		 base hasConstructor())
		return TRUE;
	for	(sym = symbols; sym; sym = sym->next)
		if	(sym->storageClass == SC_MEMBER &&
			 sym->dtype &&
			 sym->dtype hasConstructor())
			return TRUE;
	return FALSE;
	}

dynamicOffset:	dynamic	() addr_t =
	{
	return vectorOffset / BYTEBITS;
	}

sizeOf:	dynamic	() addr_t =
	{
	return (bitSize + BYTEBITS - 1) / BYTEBITS;
	}

bitSizeOf:	dynamic	() addr_t =
	{
	return bitSize;
	}

alignmentOf:	dynamic	() addr_t =
	{
	return align;
	}

outputHeaderPrefix:	dynamic	(fd: ref stream) =
	{
	sym:	ref symbol_s;

	fd printf("struct ");
	if	(name &&
		 enclosing){
		u:	ref unit_s;

		u = enclosing getUnit();
		fd printf("%S_%S_ ", u->name spelling(), name spelling());
		}
	fd printf("{\n");
	for	(sym = symbols; sym; sym = sym->next){
		if	(sym->storageClass != SC_MEMBER)
			continue;
		sym outputHeader(FALSE, fd);
		}
	fd printf("} ");
	}

emitNeededTypedefs:	dynamic	(fd: ref stream) =
	{
	sym:	ref symbol_s;

	for	(sym = symbols; sym; sym = sym->next){
		if	(sym->storageClass == SC_MEMBER)
			sym->dtype emitNeededTypedefs(fd);
		}
	}

countValues:	dynamic	() int =
	{
	vCount:		int;

	vCount = super countValues();
	if	(dynamicVector)
		vCount += dynamicVector countRelated();
	if	(gateVector)
		vCount += gateVector countRelated();
	return vCount;
	}

enumerateValues:	dynamic	() =
	{
	super enumerateValues();
	if	(dynamicVector)
		dynamicVector enumerateValues();
	if	(gateVector)
		gateVector enumerateValues();
	}

	};

function_z:	public	type	inherit	type_s	{
	public:

	returnType:		* type_s;
	fixedCalls:		boolean;
	callingConvention:	fConventions;
	parameters:		* parameter_s;

create:	factory	(rt: ref type_s, fc: boolean, 
		cc: fConventions, p: ref parameter_s) ref function_z =
	{
	self = alloc(sizeof function_z);
	self = [ T_FUNC, rt, fc, cc, p ];
	return self;
	}

load:	factory	(f: pointer, image: ref loader) =
	{
	self = f;
	self = [ T_FUNC ];
	returnType = image address();
	fixedCalls = image integer();
	callingConvention = image integer();
	parameters = image address();
	}

save:	dynamic	(ifile: ref imageFile) =
	{
	if	(ifile beginRecord(U_FUNCTION_TYPE, self, sizeof *self)){
		ifile address(returnType);
		ifile integer(fixedCalls);
		ifile integer(callingConvention);
		ifile address(parameters);
		if	(returnType)
			returnType save(ifile);
		if	(parameters)
			parameters save(ifile);
		}
	}

constructInterface:	dynamic	(s: ref scope_s, boolean) =
	{
	p:	ref parameter_s;

	if	(returnType)
		s deferInterface(returnType, FALSE);
	for	(p = parameters; p; p = p->next)
		p constructInterface(s);
	}

reconnectInterface:	dynamic	(s: ref scope_s) =
	{
	p:	ref parameter_s;

	if	(returnType)
		returnType reconnectInterface(s);
	for	(p = parameters; p; p = p->next)
		p reconnectInterface(s);
	}

isGateFunction:	dynamic	() boolean =
	{
	return (callingConvention == FC_GATE);
	}

constructValue:	dynamic	(s: ref scope_s) =
	{
	p:	ref parameter_s;

	if	(returnType)
		returnType constructValue(s);
	for	(p = parameters; p; p = p->next)
		p constructValue(s);
	}

display:	dynamic	(m: boolean) =
	{
	printf(" func");
	if	(!fixedCalls)
		printf(" var");
	if	(callingConvention != FC_NORMAL)
		printf(" calls %d", callingConvention);
	printf(" (");
	p:	ref parameter_s;
	for	(p = parameters; p; p = p->next){
		p display(m);
		if	(p->next)
			printf(", ");
		}
	printf(")");
	if	(returnType)
		returnType display(m);
	}

outputHeaderPrefix:	dynamic	(fd: ref stream) =
	{
	if	(returnType)
		returnType outputHeaderPrefix(fd);
	else
		fd printf("void ");
	}

outputHeaderSuffix:	dynamic	(fd: ref stream) =
	{
	fd printf("(");
	if	(parameters == 0){
		if	(fixedCalls)
			fd printf("void");
		}
	else	{
		parameters outputHeader(fd, TRUE);
		if	(!fixedCalls)
			fd printf(", ...");
		}
	fd printf(")");
	if	(returnType)
		returnType outputHeaderSuffix(fd);
	}

emitNeededTypedefs:	dynamic	(fd: ref stream) =
	{
	if	(parameters)
		parameters emitNeededTypedefs(fd);
	if	(returnType)
		returnType emitNeededTypedefs(fd);
	}

returnTypeOf:	dynamic	() ref type_s =
	{
	if	(returnType)
		return returnType getType();
	else
		return 0;
	}

checkArguments:	(s: ref scope_s, args: ref tree_p, 
					id: ref identifier) ref tree_p =
	{
	i:		int;

	i = checkArgCount(args);
	if	(i > 0){			// Too many arguments
		if	(id)
			error(ErrExtraParmsI, id spelling());
		else
			error(ErrExtraParms);
		return ErrorTree;
		}
	else if	(i < 0){			// Too few arguments
		if	(id)
			error(ErrFewParmsI, id spelling());
		else
			error(ErrFewParms);
		return ErrorTree;
		}
	if	(args == 0)
		return args;
	return args checkArgument(s, parameters, 1, id);
	}

checkArgCount:	(args: ref tree_p) int =
	{
	parm:	ref parameter_s;

	for	(parm = parameters; args;){
		if	(parm == 0){
			if	(!fixedCalls)
				return 0;	// More args are ok
			else
				return 1;	// Too many args
			}
		parm = parm->next;
		if	(args->operator == O_ERROR)
			return 0;		// don't report anything
		if	(args->operator != O_ARG)
			break;
		else
			args = ref argument_x(args)->right;
		}
	if	(parm)
		return -1;			// Too few arguments
	else
		return 0;			// Exact match
	}

fixedArgsOf:	() int =
	{
	parm:	ref parameter_s;
	i:	int;

	for	(i = 0, parm = parameters; parm; i++, parm = parm->next)
		;
	return i;
	}

compare:	dynamic	(t: ref type_s) boolean =
	{
	ft:	ref function_z;

	ft = ref function_z(t);
	if	(returnType ||
		 ft->returnType){
		if	(!typeMatch(returnType, ft->returnType))
			return FALSE;
		}
	if	(fixedCalls != ft->fixedCalls)
		return FALSE;
	if	(callingConvention != ft->callingConvention)
		return FALSE;
	if	(callingConvention == FC_INTERRUPT ||
		 callingConvention == FC_INTERRUPT2)
		return TRUE;
	return parameters compare(ft->parameters);
	}

	};

parameter_s:	public	type	{
	public:

	next:		* parameter_s;
	name:		ref identifier;
	offset:		fileOffset;
	pType:		* type_s;

create:	factory	(plist: ref parameter_s, n: ref identifier, i: fileOffset, 
				d: ref type_s) ref parameter_s =
	{
	self = alloc(sizeof parameter_s);
	self = [ plist, n, i, d ];
	return self;
	}

load:	factory	(pa: pointer, image: ref loader) =
	{
	self = pa;
	next = image address();
	name = identifier create(image string(), 0);
	offset = image uinteger();
	pType = image address();
	}

save:	(ifile: ref imageFile) =
	{
	if	(ifile beginRecord(U_PARAMETER, self, sizeof *self)){
		ifile address(next);
		if	(name)
			ifile putstring(name spelling());
		else
			ifile putc(0);
		ifile uinteger(offset);
		ifile address(pType);
		if	(next)
			next save(ifile);
		if	(pType)
			pType save(ifile);
		}
	}

outputHeader:	(fd: ref stream, firstParameter: boolean) =
	{
	if	(!firstParameter)
		fd putc(',');
	if	(pType == 0)
		fd printf("int");
	else	{
		pType outputHeaderPrefix(fd);
		if	(name)
			fd printf(" %S", name spelling());
		pType outputHeaderSuffix(fd);
		}
	if	(next)
		next outputHeader(fd, FALSE);
	}

emitNeededTypedefs:	(fd: ref stream) =
	{
	if	(pType)
		pType emitNeededTypedefs(fd);
	if	(next)
		next emitNeededTypedefs(fd);
	}

constructInterface:	(s: ref scope_s) =
	{
	if	(pType)
		s deferInterface(pType, FALSE);
	}

reconnectInterface:	(s: ref scope_s) =
	{
	if	(pType)
		pType reconnectInterface(s);
	}

constructValue:	(s: ref scope_s) =
	{
	if	(pType)
		pType constructValue(s);
	}

display:	(m: boolean) =
	{
	if	(name)
		printf("%S(%d):", name spelling(), offset);
	if	(pType)
		pType display(m);
	}

compare:	(p: ref parameter_s) boolean =
	{
	while	(p && self){
		if	(!typeMatch(pType, p->pType))
			return FALSE;
		self = next;
		p = p->next;
		}
	if	(p || self)
		return FALSE;
	else
		return TRUE;
	}

	};

