/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	file;
include	filesys;
include	error;
/*
		Deletes files.
 */

usage:	() =
	{
	printf( "Use is: del file(s)\n");
	exit(1);
	}

main:	entry	() =
	{
	src:		[:] char;
	j:		int;
	i:		int;
	ff:		finder;
	deleted:	boolean;
	dir:		[:] char;
	pattern:	[:] char;

	if	(ArgumentCount == 0)
		usage();

	while	(ArgumentCount){
		src = getNextArgument();
		dir = getDirectory(src);
		pattern = stripDirectory(src);
		if	(ff open(dir, pattern, 0) != SUCCESS){
			printf("Could not delete %s\n", src);
			continue;
			}
		deleted = FALSE;
		while	(ff next() == SUCCESS){
			i = FileSystem unlink(ff.pathname);
			deleted = TRUE;
			if	(i)
				printf("Could not delete %s\n", &ff.pathname);
			}
		if	(!deleted)
			printf("Could not delete %s\n", src);
		}
	}
