;---------------------------------------------------------------    
;intinit - main module for Int Monitor                         |
;--------------------------------------------------------------|
;Copyright 1991, 1993 ASMicro Co.                              |
;--------------------------------------------------------------|
; 09/25/93                      Rick Knoblaugh                 |
;--------------------------------------------------------------|
;include files                                                 |
;---------------------------------------------------------------    
.386P
                include intequ.inc
                include intstruc.inc
                include intmac.inc
                include intdat.inc

;--------------------------------------------------------------
;EXTERNALS                                                    |
;--------------------------------------------------------------
isrcode         segment para public 'icode16' use16
                extrn   int_0:far
                extrn   int_1:far
                extrn   int_2:far
                extrn   int_3:far
                extrn   int_4:far
                extrn   int_5:far
                extrn   int_6:far
                extrn   int_7:far
                extrn   except_8:far
                extrn   except_9:far
                extrn   except_0ah:far
                extrn   except_0bh:far
                extrn   except_0ch:far
                extrn   except_0dh:far
                extrn   except_0eh:far
                extrn   except_0fh:far
                extrn   int_20h:far
                extrn   int_21h:far
                extrn   int_22h:far
                extrn   int_23h:far
                extrn   int_24h:far
                extrn   int_25h:far
                extrn   int_26h:far
                extrn   int_27h:far
                extrn   int_70h:far
                extrn   int_71h:far
                extrn   int_72h:far
                extrn   int_73h:far
                extrn   int_74h:far
                extrn   int_75h:far
                extrn   int_76h:far
                extrn   int_77h:far
                extrn   user_int_isr:far 
isrcode         ends                               

                assume cs:code, ds:nothing, es:nothing


code            segment para public 'code16' use16
                assume cs:code, ds:data, es:data   
                .8086
start           proc    far 
                push    ds              ;save psp seg
                mov     ax, data
                mov     ds, ax
                mov     es, ax
                call    verify_cpu
                jnc     start_200       ;continue if 386/486 in real mode


start_050:                    
                mov     ah, DOS_PRT_STRING
                int     21h
                mov     ax, 4c01h
                int     21h
.386P
start_200:
                call    setup_ints      ;take over user int

                call    init_gdt
                call    init_tss

                mov     ax, data   
                mov     ds, ax
                assume  ds:data   


                cli                     ;no ints until protected mode

                mov     ax, gdt_seg
                movzx   eax, ax
                shl     eax,  4
                mov     gdtadrs, eax

                mov     ax, idt_seg
                movzx   eax, ax
                shl     eax,  4
                mov     idtadrs, eax


                call    reprogram_pic


                lgdt    gdtl
                lidt    idtl

                mov     dx, iostack3    ;get stack segment
                mov     bx, sp          ;and pointer
                mov     eax, cr0
                or      eax, 1          ;turn on protected mode bit
                mov     cr0, eax        ;go into protected mode

;
;jump to clear prefetch queue
;
                db      0eah            ;far jump
                dw      offset code:start_400
                dw      gdt_seg:sel_code
start_400:
                mov     ax, offset gdt_seg:sel_tss
                ltr     ax
                xor     ax, ax
                lldt    ax              ;null ldt
                mov     ax, seg data
                movzx   eax, ax
                push    eax             ;gs
                push    eax             ;fs
                push    eax             ;ds
                push    eax             ;es
                xor     ax, ax

                push    ax
                push    dx              ;stack segment
                push    ax
                push    bx              ;stack pointer

                push    2               ;VM bit set in upper eflags
                push    3000h           ;NT=0, IOPL=3, CLI in lower eflags
                push    ax
                push    seg code        ;cs of where to return
                push    ax
                push    offset code:start_500  ;ip of where to return
;
;Must ensure that Nested Task bit is not set in eflags.  If it were,
;processor would attempt to switch to a task via the selector in
;the TSS backlink field.  Since that field is now zero, an invalid TSS
;fault would occur.
;
                pushf
                pop     ax
                and     ax, NOT NT_FLAG
                push    ax
                popf
                iretd

start_500:                              ;begin vm86 task here
                pop     bx              ;get saved psp seg
                sti                     ;interrupts ok now
                mov     dx, code + 1    ;init code we are dropping        
                sub     dx, bx
                mov     ax, (DOS_TSR_FUNC shl 8)
                int     21h

start           endp        



reprogram_pic   proc    near
                in      al, 21h
                mov     ah, al
                mov     al, 11h         ;init
                out     20h, al
                mov     al, 20h         ;irq0 to int 20h
                out     21h, al
                jmp     short $ + 2
                jmp     short $ + 2
                mov     al, 4
                out     21h, al
                jmp     short $ + 2
                jmp     short $ + 2
                mov     al, 1
                out     21h, al
                jmp     short $ + 2
                jmp     short $ + 2
                mov     al, ah
                out     21h, al
                ret
reprogram_pic   endp

.8086

verify_cpu      proc    near
                xor     ax, ax
                push    ax
                popf
                pushf
                pop     ax
                and     ax, 0f000h
                cmp     ax, 0f000h
                jz      verify_c800     ;not 386
                mov     ax, 0f000h
                push    ax
                popf
                pushf
                pop     ax
                and     ax, 0f000h
                jz      verify_c800     ;not 386        
                mov     dx, offset noprot_msg
.386P
                smsw    ax              ;get pm flag into carry 
                rcr     ax, 1
                jmp     short verify_c999
verify_c800:
                mov     dx, offset not386_msg
                stc
verify_c999:
                ret
verify_cpu      endp




setup_ints      proc    near
                mov     bx, USER_INT
                mov     di, offset old_user_int
                mov     cx, isrcode
                mov     dx, offset isrcode:user_int_isr
                call    get_int
                ret
setup_ints      endp        

;--------------------------------------------------------------
;get_int - For a given interrupt vector, store contents and   |
;          load with new isr address.                         |
;                                                             |
;          bx = int number                                    |
;          es:di = location to store contents                 |
;          dx = offset new isr                                |
;          cx = cs of new isr
;--------------------------------------------------------------
get_int         proc    near
                cld
                push    ds
                xor     ax, ax
                mov     ds, ax
                shl     bx, 2
                mov     ax, [bx]
                stosw                
                mov     ax, [bx].d_segment
                stosw          
                cli
                mov     [bx].d_offset, dx
                mov     [bx].d_segment, cx
                sti
                pop     ds
                ret
get_int         endp        



init_gdt        proc    near
                mov     ax, gdt_seg
                mov     ds, ax
                assume  ds:gdt_seg

                mov     dx, tss_seg
                movzx   edx, dx                 ;base data segment
                mov     ecx, (TSS_END - TSS_BEG  ) - 1  ;limit
                mov     ah, TSS_DESC
                mov     si, offset sel_tss   
                call    make_entry

                mov     dx, tss_seg
                movzx   edx, dx                 ;base data segment
                mov     ecx, (TSS_END - TSS_BEG  ) - 1  ;limit
                mov     ah, RW_DATA             ;alias as r/w for editing
                mov     si, offset sel_tss_alias
                call    make_entry

                mov     dx, gdt_seg
                movzx   edx, dx                 ;base data segment
                mov     ecx, (GDT_END - GDT_BEG  ) - 1  ;limit
                mov     ah, RW_DATA             ;alias as r/w for editing
                mov     si, offset sel_gdt_alias
                call    make_entry

                mov     dx, isrcode
                movzx   edx, dx                 ;base of isr code segment
                mov     ecx, 0ffffh             ;max segment size
                mov     ah, ER_CODE
                mov     si, offset sel_isrcode 
                call    make_entry

                mov     dx, code
                movzx   edx, dx                 ;base code segment
                mov     ecx, 0ffffh             ;max segment size
                mov     ah, ER_CODE
                mov     si, offset sel_code 
                call    make_entry

                xor     edx, edx                ;zero base
                mov     ecx, 8fffffh            ;page granularity and 4 gig limit
                mov     ah, RW_DATA
                mov     si, offset sel_databs    
                call    make_entry

                mov     dx, iostack
                movzx   edx, dx                 ;base stack segment
                mov     ecx, (STACK_END - STACK_BEG  ) - 1  ;limit
                mov     ah, RW_DATA
                mov     si, offset sel_stack 
                call    make_entry

                mov     dx, data
                movzx   edx, dx                 ;base data segment
                mov     ecx, (DATA_END - DATA_BEG  ) - 1  ;limit
                mov     ah, RW_DATA
                mov     si, offset sel_data  
                call    make_entry

                int     11h                     ;equipment check
                mov     edx, 0b800h             ;color segment
                and     al, 30h                 ;monitor bits
                cmp     al, 30h                 ;30h=monochrome
                jne     init_gdt500
                mov     edx, 0b000h             ;monochrome segment

init_gdt500:
                mov     ecx, VID_PAGE_SIZE - 1  ;page size - 1  
                mov     ah, RW_DATA             
                mov     si, offset sel_video     
                call    make_entry

                ret
init_gdt        endp

;--------------------------------------------------------------
;make_entry - Load a GDT entry from information passed as     |
;             follows:                                        |
;                                                             |
;             ds=gdt segent                                   |
;             si=offset of gdt entry to load                  |
;             ah=type | dpl                                   |
;            ecx=limit (also, bits 23:20 are g, b, 0, and avl)|
;            edx=base segment (convert it to linear)          |
;--------------------------------------------------------------
make_entry      proc    near
                shl     edx, 4                  ;convert seg to linear
                mov     [si].seg_limit_low, cx 
                mov     [si].seg_base_low, dx  
                shr     edx, 16
                mov     [si].seg_base_mid, dl   
                mov     [si].seg_type_dpl, ah  
                shr     ecx, 16                 
                mov     [si].seg_limit_gran, cl 
                mov     [si].seg_base_top, dh  

                ret
make_entry      endp

;--------------------------------------------------------------
;init_tss - Initilize TSS with PL0 stack and io bit map base. |
;--------------------------------------------------------------
init_tss        proc    near
                mov     ax, tss_seg
                mov     ds, ax
                assume  ds:tss_seg
                xor     si, si

                mov     ax, offset gdt_seg:sel_stack
                mov     [si].t_ess0, ax
                mov     ax, offset iostack:io_sp 
                movzx   eax, ax
                mov     [si].t_esp0, eax

                lea     bx, [si].t_iomap 
                mov     [si].t_iobase, bx
                ret
init_tss        endp      

  
code            ends
                end  start
