/*****************************************************************
RV   FMTSTR.C --- printf-like formatting of string.
	    Based on code posted by Mike Geary to Compuserve in 1986.

REVISIONS:
  16 Aug 88  RV     fixed bug in VMS version of numberAsString()
  21 Nov 91  RV     changed #include , removed #ifdef ANSI_C,
		  added #ifdef WM_CREATE for windows.h
		  changed strlen --> lstrlen
   5 May 93 RV    made char * to be LPSTR
*****************************************************************/

#include "config.h"

/*#include <ctype.h>*/

#ifdef WIN32
#define FAR /*NOTHING*/
#else
#define FAR far
typedef short WORD;
typedef long LONG;
typedef short HANDLE;
#endif

/****************************************************************/
#include "std_defs.h"
/****************************************************************/

typedef int   FAR * LPINT;
typedef long  FAR * LPLONG;
typedef char  FAR * LPSTR;
typedef LPSTR FAR * LPLPSTR;

typedef int BOOL;

#define TRUE		1
#define FALSE		0
#define ASCII_NUL	('\0')
#define mIsDigit(c)	((c)>='0' && (c)<='9')

#define lstrlen stringLength

/****************************************************************/

	 /*  modifiable constants  */
#define  SIZEOF_BUFFER  256   /*  output buffer length   */

		      /*  radices */
#define  SDEC  (-10)  /*  signed decimal      */
#define  UDEC  ( 10)  /*  unsigned decimal    */
#define  OCT   (  8)  /*  octal         */
#define  HEX   ( 16)  /*  hexadecimal         */

#define mIsSignedRadix(r)   ((r) < 0)    /*signed radices are negative*/

typedef union
{
	 LPINT     pi;
	 LPLONG    pl;
	 LPLPSTR   ps;
} GENERICPTR;

typedef GENERICPTR FAR * LPGPTR;

/************** PRIVATE FUNCTIONS **********************************/

PRIVATE LPSTR	numberAsString (long , int , LPSTR );
PRIVATE LPSTR	convertObject  (LPSTR ,LPSTR ,LPGPTR,LPINT);
PRIVATE BOOL	stringContains (LPSTR ,char );
PRIVATE int	stringLength   (LPSTR );

/*****************************************************************/
PRIVATE int stringLength(LPSTR p)
{
    int i;
    for (i=0; *p; i++,p++)
	;
    return i;
}

/*****************************************************************/
PRIVATE BOOL     stringContains (LPSTR str,char c)
{
    while(*str)
    {
	if(*str==c) return TRUE;
	str++;
    }
    return FALSE;
}


/****************************************************************/
PRIVATE char      toUpper(char c)  /*NOT a macro. See below:"BUG"*/
{
    if(c>='a' && c<='z') return (char)(c-'a'+'A');
    return c;
}


/*****************************************************************
 * numberAsString()
 *  converts fromt integer/unsigned/long/unsigned_long
 *                    to ASCII (octal/decimal/hexadecimal formats)
 *****************************************************************/

PRIVATE LPSTR numberAsString(
	 long	val,  		/*  value to convert (was: unsigned long)   */
	 int    radix,   /*  output radix, negative for signed  */
	 LPSTR  outCh)   /*  -> output buffer       */
{
	 long t;          /*  local temp  (was: unsigned long)        */

	 if( mIsSignedRadix(radix) )
	 {
		if (val < 0)
		{
		 *outCh++ = '-';
		 val = -val;
		}
		t = (long)val / -radix;
		if (t)	 outCh = numberAsString(t, radix, outCh);
	 }
	 else    /* unsigned radix */
	 {
	        t = val / radix;
		if (t)	outCh = numberAsString(t, radix, outCh);
	 }

	 if (radix == HEX)   /*  need letters ??  */
	 {
		t = val % radix;
		*outCh++ = (char)(t + ((t > 9) ? ('A' - 10) : '0'));
	 }
	 else if (radix < 0)
		*outCh++ = (char)(((long)val % -radix) + '0');
	 else
		*outCh++ = (char)((val % radix) + '0');

	 *outCh = ASCII_NUL;

	 return outCh;
}


/****************************************************************/
PRIVATE LPSTR convertObject(
	 LPSTR     cs,		/*  control string      */
	 LPSTR     ds,		/*  destination string  */
	 LPGPTR    pp,		/*  -> -> data       	*/
	 LPINT     flen)	/*  -> returned length  */
/****************************************************************/
{
	 char buf[16],	/*  local buffer     */
	     fill_ch;	/*  fill character      */
	 BOOL hexcase;	/*  case on hex chars      */
	 char	plus,   /*  leading plus sign character */
		sharp;  /*  special formatting flag   */
	 LPSTR  p;    	/*  work buffer ptr     */

	 int	i,    /*  destination string index  */
		n,    /*  unpadded field width   */
		field_width,
		precision;
	 BOOL	is_long, 
		do_left_justify;

	 is_long = FALSE;
	 do_left_justify = FALSE;
	 hexcase = FALSE;
	 plus = sharp = 0;   /*  defaults  */
	 field_width = 0;
	 precision = -1;
	 fill_ch = ' ';

	 p = buf;   /*  init  */

	 /*while (strchr("-+ #", *cs) != NULL_PTR)*/
	 while (stringContains("-+ #", *cs))
	 {
		switch (*cs++)
		{
		 case '-' : do_left_justify = TRUE;    break;

		 case '+' : /*  leading + or -  */
				plus = '+';             break;

		 case ' ' : /*  leading blank or -  */
				if (!plus) { plus = ' '; } break;

		 case '#' : /*  special formatting  */
				++sharp;             break;
		}
	 }

	 if ( mIsDigit(*cs) || *cs == '*')   /*  field width given ??  */
	 {
		if (*cs == '0')      /*  fill with zeroes ??  */
			fill_ch = *cs++;

		if (*cs == '*')      /*  from arg ??  */
		{
			++cs;
			field_width = *pp->pi++;
		}
		else
			while (mIsDigit(*cs))
			  field_width = (10 * field_width) + (*cs++ & 0x0F);
	 }

	 if (*cs == '.')     /*  precision given ??  */
	 {
		if (mIsDigit(*++cs))
		{
			precision = 0;
			while (mIsDigit(*cs))
				precision = (10 * precision) + (*cs++ & 0x0F);
		}
		else if (*cs == '*')    /*  from arg ??  */
		{
			++cs;
			precision = *pp->pi++;
		}
	 }

	 if (*cs == 'l')     /*  long item ??  */
	 {
		is_long = TRUE;
		++cs;
	 }

	 switch (*cs++)
	 {
		case 'd' :  /*  decimal  */

			n = (int)((is_long
			? numberAsString(        *pp->pl++, SDEC, buf)
			: numberAsString( (long) *pp->pi++, SDEC, buf))
			 - (LPSTR)buf);

			break;

		case 'u' :  /*  unsigned  */
			n = (int)((is_long
		 ? numberAsString(                *pp->pl++, UDEC, buf)
		 : numberAsString((long)(unsigned)*pp->pi++, UDEC, buf))
			  - (LPSTR)buf);
			break;

		case 'X' : hexcase = TRUE; /*fall through */

		case 'x' :
			if (sharp && (is_long ? *pp->pl : *pp->pi))
			{
				*p++ = '0';
				*p-- = 'x'; /*  hexcase will fix  */
				n = (int)((is_long
		 ? numberAsString(       *pp->pl++, HEX, buf + 2)
		 : numberAsString((long)(unsigned)*pp->pi++,HEX,buf+2))
				- (LPSTR) buf);
				}
			else
				n = (int)((is_long
		 ? numberAsString(      *pp->pl++, HEX, buf)
		 : numberAsString((long)(unsigned)*pp->pi++,HEX,buf))
						- (LPSTR) buf);
			break;

		case 'o' :  /*  octal  */
			if (sharp && (is_long ? *pp->pl : *pp->pi))
			{
				*p = '0';
				n = (int)((is_long
		 ? numberAsString(*pp->pl++, OCT, buf + 1)
		 : numberAsString((long)(unsigned)*pp->pi++,OCT,buf+1)) 
					 - (LPSTR) buf);
			}
			else
		{
				n = (int)((is_long
		 ? numberAsString(*pp->pl++, OCT, buf)
		 : numberAsString((long)(unsigned)*pp->pi++, OCT, buf)) 
			     - (LPSTR) buf);
		}
			break;

		case 's' :  /*  string  */
			p = *pp->ps++;
			if (!p)	p = (LPSTR) "(null)";  
			n = lstrlen(p);
			if (precision > 0)
				n = ((n > precision) ? precision : n);
			break;

		case 'c' :  /*  single character  */
			n = 1;
			buf[0] = (char)(*pp->pi++);
			break;

		default :   /*  oops  */
			return 0;
	 }

	 if (field_width < n)
		field_width = n;

	 field_width -= n;   /*  field_width == number of pad chars  */
	 i = 0;
	 if (do_left_justify)
	 {
		while (--n >= 0)  /*  chars  */
			ds[i++] = hexcase ? toUpper(*p++) : *p++;
			    /* BUG? if toUpper were macro,then sideeffects!*/
		while (--field_width >= 0) /*  then filler  */
			ds[i++] = fill_ch;
	 }
	 else
	 {
		while (--field_width >= 0) /*  filler  */
			ds[i++] = fill_ch;
		while (--n >= 0)  /*  then chars  */
			ds[i++] = hexcase ? toUpper(*p++) : *p++;
			    /* BUG? if toUpper were macro,then sideeffects!*/
	 }

	 *flen = i;
	 return cs;
}

/*****************************************************************
 * fmtStr()    return formatted string
 *****************************************************************/

PUBLIC LPSTR  fmtStr(
	 LPSTR   inpCh,     /*  control string      */
	 long    args)      /*  arg place marker    (was LPSTR*) */
{
	 PRIVATE char myBuf[SIZEOF_BUFFER];/*  buffer to return */
	 char	work[SIZEOF_BUFFER]; /*  working buffer   */
	 LPSTR	outCh;         /*  current ptr (into myBuf[])   */
	 LPSTR  p;	      /*  work ptr         */

	 LPLPSTR  next_arg;		/*  -> next arg         */
	 int      myBufLen;		/*  work buffer length     */

	 next_arg =  (LPLPSTR) &args;	/*  point to first arg  */
	 outCh =  myBuf;  		/*  init current ptr  */

	 while (*inpCh)
	 {
		if (*inpCh == '%')
		{
			if (* ++inpCh == '%')
			{
				*outCh++ = *inpCh++;
			}
			else
			{	p = convertObject(
						 inpCh,
						 work,
						 (LPGPTR) &next_arg,
						 (LPINT)  &myBufLen);
				if(p)	     
				{	inpCh = p;
					for (p = work; myBufLen--;)
						*outCh++ = *p++;
				}
			 }
		}
		else
		{
			*outCh++ = *inpCh++;
		}
	}
	*outCh = ASCII_NUL;

	return ((LPSTR ) myBuf);
}


