///////////////////////////////////////////////////////////
//                                                       //
// MsgDisp - Message Text Display                        //
// Copyright (c) Ivan Gerencir, Aug 1993                 //
// Language: Borland C++ 3.1 & Application Frameworks    //
// OS: Windows 3.1                                       //
//                                                       //
///////////////////////////////////////////////////////////

// File mainwin.h; Listing 6

#ifndef _MAINWIN_H_
#define _MAINWIN_H_

#include <windows.h>
#include <dialog.h>
#include <listbox.h>

#include "menu.h"

/////////////////////////////////////////////////////////////////////
///////////////////// TMainWindow class definition //////////////////

_CLASSDEF(TMainWindow)
class TMainWindow : public TDialog {
private:
    PTListBox TextControl;  // ListBox pointer
    HMENU Menu;             // Menu Handle
    UINT MsgDispMessage;    // Message for communicating with MsgDisp
    BOOL PopUp;             // Should we popup after receiving message

public:
    TMainWindow(void);
    ~TMainWindow(void);
    virtual void SetupWindow();
    virtual void DefWndProc(RTMessage);
    virtual void CMExitApp(RTMessage)
    = [CM_FIRST + MENU_EXITAPP];
    virtual void CMOptionsPopUp(RTMessage)
    = [CM_FIRST + MENU_POPUP];
    virtual void CMInsertBreak(RTMessage)
    = [CM_FIRST + MENU_INSERTBREAK];
    virtual void CMClear(RTMessage)
    = [CM_FIRST + MENU_CLEAR];
    virtual void CMRepaint(RTMessage)
    = [CM_FIRST + MENU_REPAINT];
    virtual void CMSave(RTMessage)
    = [CM_FIRST + MENU_SAVE];
    virtual void CMPrint(RTMessage)
    = [CM_FIRST + MENU_PRINT];
    virtual void RecvString(RTMessage);
    virtual void WMSize(RTMessage)
    = [WM_FIRST + WM_SIZE];
};

#endif

// End of File
