///////////////////////////////////////////////////////////
//                                                       //
// MsgDisp - Message Text Display                        //
// Copyright (c) Ivan Gerencir, Aug 1993                 //
// Language: Borland C++ 3.1 & Application Frameworks    //
// OS: Windows 3.1                                       //
//                                                       //
///////////////////////////////////////////////////////////

// File: msgdisp.cpp; Listing 1

#include <owl.h>

#include "msgdisp.h"
#include "mainwin.h"

/////////////////////////////////////////////////////////////////////
/////////////////////// TMsgDisp class definition ///////////////////

_CLASSDEF(TMsgDisp)
class TMsgDisp : public TApplication {
public:
    TMsgDisp(LPSTR AName, HINSTANCE AnInstance,
            HINSTANCE APrevInstance, LPSTR ACmdLine,
            int ACmdShow);
    ~TMsgDisp();
    virtual void InitMainWindow();
};

/////////////////////////////////////////////////////////////////////
///////////////////////// TMsgDisp members //////////////////////////
//-------------------------------------------------------------------
// Constructor

TMsgDisp::TMsgDisp(LPSTR AName, HINSTANCE AnInstance,
            HINSTANCE APrevInstance, LPSTR ACmdLine,
            int ACmdShow)
: TApplication(AName, AnInstance, APrevInstance, ACmdLine, ACmdShow)
{
}

//-------------------------------------------------------------------
// Destructor

TMsgDisp::~TMsgDisp()
{
    TApplication::~TApplication();
}

//-------------------------------------------------------------------

void TMsgDisp::InitMainWindow()
{
    MainWindow = new TMainWindow();
}

/////////////////////////////////////////////////////////////////////
///////////////////////////// WinMain ///////////////////////////////

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
            LPSTR lpCmdLine, int nCmdShow)
{
    TMsgDisp MsgDisp(APPNAME, hInstance,
                    hPrevInstance, lpCmdLine, nCmdShow);

    // If another instance is already running, bring it
    // to the foreground end terminate
    if(hPrevInstance) {
        HWND PrevAppHandle = FindWindow(NULL, APPNAME);
        PrevAppHandle = GetLastActivePopup(PrevAppHandle);
        BringWindowToTop(PrevAppHandle);
        ShowWindow(PrevAppHandle, SW_RESTORE);
        return(0);
    }

    MsgDisp.Run();
    return(MsgDisp.Status);
}

// End of File
