///////////////////////////////////////////////////////////
//                                                       //
// MsgDispI - Message Text Display Interface             //
// Copyright (c) Ivan Gerencir, Aug 1993                 //
// Language: Borland C++ 3.1 & Application Frameworks    //
// OS: Windows 3.1                                       //
//                                                       //
///////////////////////////////////////////////////////////

// File: msgdispi.cpp; Listing 3

#include <windows.h>
#include <string.h>

#include "msgdisp.h"
#include "msgdispi.h"

UINT MsgDispMessage = 0;

#define FAIL 0
#define SUCCESS 1

int CALLBACK LibMain(HINSTANCE, WORD, WORD, LPSTR)
{
    if(MsgDispMessage == 0) {
        // Initialize DLL by registering message for communicating
        // with MsgDisp
        if((MsgDispMessage = RegisterWindowMessage(APPNAME)) == 0) {
            MessageBox(GetActiveWindow(),
                    "Unable to register Windows Message",
                    "Error in " APPNAME " DLL initialization",
                    MB_OK);
            return(FAIL);
        }
    }
    return(SUCCESS);
}

#undef FAIL
#undef SUCCESS

//------------------------------------------------------------------
// MsgDisp

#define STREND '\0'

void _export FAR MsgDisp(char FAR *Text)
{
    // Check received string length to maximum allowed
    if(strlen(Text) >= MAXMSGSTRLEN) {
        MessageBox(GetActiveWindow(),
                Text,
                "Error in " APPNAME " interface - string too long",
                MB_OK);
	Text[MAXMSGSTRLEN - 1] = STREND;
    }
    
    // Add string to global atom table
    ATOM Atom = GlobalAddAtom(Text);
    if(Atom == 0) {
        MessageBox(GetActiveWindow(),
                "Error in GlobalAddAtom",
                APPNAME " DLL MsgDisp",
                MB_OK);
        return;
    }

    // Send message containing handle of atom.
    // SendMessage does not return until the message is processed
    SendMessage(HWND_BROADCAST, MsgDispMessage, MAGIC_ID, Atom);

    // Now we must delete atom after we are done with it
    GlobalDeleteAtom(Atom);
}

// End of File
