/********************************************************
 * Heap -- heap debugger				*
 *							*
 * Link this with it's associated routines to trap all	*
 * calls to the following routines:			*
 *							*
 *   	malloc						*
 *	farmalloc					*
 *	free						*
 *	farfree						*
 *							*
 * Each time one of these routines is called, we'll	*
 * write an entry to "MEM.LOG"				*
 *							*
 * Note: Only works in the large model.			*
 ********************************************************/
#include <stdio.h>
#include <mem.h>
#include <alloc.h>
#include <dos.h> 
#include <string.h>

/********************************************************
 * Declarations for the "real" versions of the		*
 *	heap routines.  These are the standard routines	*
 *	that have been renamed.				*
 ********************************************************/
void        _Cdecl r_free(void _FAR *__block);
void  _FAR *_Cdecl r_malloc(size_t __size);

void        _Cdecl r_farfree(void far *__block);
void far  * _Cdecl r_farmalloc(unsigned long __nbytes);

FILE *heap_log_file = NULL;	/* File to write the data to */
#define LOG_FILE_NAME "MEM.LOG"	/* Name of the log file */
/********************************************************
 * log -- send a message to the log file		*
 *							*
 * Parameters						*
 *	what -- what we are doing			*
 *	where -- address of the thing calling us	*
 *	ptr -- the pointer that we're doing it to	*
 ********************************************************/
static void log(char *what, char **where, void *ptr)
{
    unsigned int ret_seg;	/* Segment of the return address */

    if (heap_log_file == NULL)
        heap_log_file = fopen(LOG_FILE_NAME, "w");

    if (heap_log_file == NULL)
        return;

    ret_seg = FP_SEG(*where);
    fprintf(heap_log_file, "%s %04X:%04X %p (%d,%d)\n", what, 
    	ret_seg - _psp - 0x10, FP_OFF(*where),
	ptr, heapcheck(), heapchecknode(ptr));
    fflush(heap_log_file);
}

/********************************************************
 * malloc -- log and malloc				*
 ********************************************************/
void *malloc(unsigned int size)
{
    /*
     * This little bit of magic gets us a pointer to the return
     * address.
     */
    char **ret_ptr = MK_FP(_SS, _BP+2);
    void *ptr;	/* Pointer to the returned data */
    /* Sentry to prevent recursion */
    static int in_malloc = 0;

    /*
     * This little hack tasks care of the malloc in the fopen 
     * -- the fopen which we call in this routine
     */
    if (in_malloc)
        return (r_malloc(size));

    /*
     * The startup code does a malloc.  This code
     * opens the log file at startup and doesn't
     * log it (we want to log OUR code)
     */
    if (heap_log_file == NULL) {
        in_malloc++;
	ptr = r_malloc(size);
	heap_log_file = fopen(LOG_FILE_NAME, "w");
	in_malloc--;
	return (ptr);
    } 
    ptr = r_malloc(size);
    log("malloc   ", ret_ptr, ptr);
    return (ptr);
}

/********************************************************/
void far *farmalloc(unsigned long size)
{
    /* Pointer to our return address */
    char **ret_ptr = MK_FP(_SS, _BP+2);
    /* Get the pointer */
    void *ptr = r_farmalloc(size);

    log("malloc   ", ret_ptr, ptr);
    return (ptr);
}

/********************************************************/
void free(void *ptr)
{
    char **ret_ptr = MK_FP(_SS, _BP+2);

    log("free     ", ret_ptr, ptr);
    r_free(ptr);
}

/********************************************************/
void farfree(void *ptr)
{
    char **ret_ptr = MK_FP(_SS, _BP+2);

    log("free     ", ret_ptr, ptr);
    r_farfree(ptr);
}
