/***********************************************************
|* 'ipxint.h'
|*
|* DOS IPX interface.
|*
|* -93     PS    Created
|*
***********************************************************/


/*********************** Constants ***********************/

/* IPX error codes */
#define IPX_OK               (0)
#define IPX_NOT_INSTALLED (0xF0)

/* IPX commands */
#define IPXCMD_OPEN_SOCKET          (0x0000)
#define IPXCMD_CLOSE_SOCKET         (0x0001)
#define IPXCMD_GET_LOCAL_TARGET     (0x0002)
#define IPXCMD_SEND_PACKET          (0x0003)
#define IPXCMD_LISTEN_FOR_PACKET    (0x0004)
#define IPXCMD_RELINQUISH_CONTROL   (0x000A)

/* IPX interrupt vector # */
#define IPXINT         (0x7A)

/* IPX socket types */
#define IPXSOCK_SHORT  (0x00)

/* Get address offset */
#define FP_OFFSET(fp)  ((unsigned int)(unsigned long)(fp))


/*********************** Data types ***********************/
typedef int            bool;

/* Fixed sizes */
typedef unsigned char  u8;
typedef unsigned int   u16;
typedef unsigned long  u32;

/* CPU registers */
typedef union  REGS   CREGS;
typedef struct SREGS  CSEGS;

/* Full IPX address */
typedef struct IPXADDRESS_record
{
  u8      network[4];
  u8      node[6];
  u16     socket;
} IPXADDRESS;

/* IPX header */
typedef struct IPXHEADER_record
{
  u16         checkSum;
  u16         length;
  u8          transportControl;
  u8          packetType;
  IPXADDRESS  destination;
  IPXADDRESS  source;
} IPXHEADER;

/* IPX event control block */
typedef struct ECB_record
{
  void        *linkAddress;
  struct ECB_record *ESRAddress;
  u8          inUse;
  u8          completionCode;
  u16         socketNumber;
  u32         reserved1;
  u32         reserved2[3];
  u8          routerAddress[6];
  u16         buffers;
  void        *header;
  u16         headerLength;
  void        *data;
  u16         dataLength;
} ECB;


/******************* Prototypes ***************************/
int   IPXInitialize(void);
int   IPXOpenSocket(u16  *socket,u8 socketType);
int   IPXGetLocalTarget(IPXADDRESS *IPXAddress,u8 *routerNode,
                        u16 *ticks);
void  IPXCloseSocket(u16 socket);
void  IPXSendPacket(const ECB *eventControlBlock);
void  IPXListenForPacket(const ECB *eventControlBlock);
void  IPXRelinquishControl(void);
void  IPXTerminate(void);
u16   Swap16(u16);
u32   Swap32(u32);

