/***********************************************************
|* 'ncptest.h'
|*
|* DOS NCP interface.
|*
|* -93     PS    Created
|*
***********************************************************/


/*********************** Constants ***********************/

#define FALSE (0)
#define TRUE  (~FALSE)

/* Max. # of NCP connections supported. */
#define MAX_NCP_CONNECTIONS (3)  /* Or whatever */

/* Value limits */
#define LIMIT_OBJNAME       (47)  /* NetWare object name */

/* NCP command status */
#define NCP_OK     (0)    /* Command completed w/o error */
#define NCP_BUSY  (-1)    /* Command in progress */
#define NCP_ERROR (-2)

/* Object types */
#define OTYPE_FSERVER (0x0004)
#define OTYPE_USER    (0x0001)

/* Text strings */
#define TXT_LOGOUT    "LOGOUT"

/* For 'variable' size struct members */
#define               VARSIZE

/*********************** Data types ***********************/

/* Test connection states */
typedef enum _TESTSTATE
{
  TS_INIT=0,                  /* Must be '0' */
  TS_GET_NEAREST_SERVER,
  TS_ATTACH,
  TS_NEGOTIATE_BUFFER_SIZE,
  TS_ENABLEMSG,
  TS_LOGIN,
  TS_OBJECTID,
  TS_GETKEY,
  TS_LOGOUT,
  TS_CLOSE,
  TS_WAIT,
  TS_IDLE,
  TS_MESSAGE,
  TS_DONE,
  TS_DEAD
} TESTSTATE;

/* Reply handling routine */
typedef void  NCPReplyHandler(unsigned int conn, void *reply,
                              unsigned int replySize);

/* Test connection info */
typedef struct NCPINFO_record
{
  TESTSTATE prevState;       /* Previous state */
  TESTSTATE state;           /* Current state */
  TESTSTATE nextState;       /* State to go to if current command
                                executes OK */
  int       commandStatus;   /* Latest command status */
  bool      attached;        /* TRUE if connection attached to a server */
  bool      messagePresent;  /* TRUE if a message is pending */
  bool      connectionDown;  /* TRUE if connection went down */
  u32       objectID;        /* User's object ID */
  u8        encKey[8];       /* Encryption key */
  NCPReplyHandler *replyHandler; /* Pointer to a routine that will handle
                                    the reply. */

} NCPINFO;


/* Used by Login, GetBroadcastMessage and others */
typedef struct NCP_STRING
{
  u8   length;
  char string[VARSIZE];
} NCP_STRING;


/* Get bindery object ID request */
typedef struct OBJECTID_REQ_record
{
  u16  objectType;
  u8   objectNameLength;
  char objectName[VARSIZE];
} OBJECTID_REQ;

/* Get bindery object ID reply */
typedef struct OBJECTID_REP_record
{
  u32  objectID;
  u16  objectType;
  char objectName[LIMIT_OBJNAME+1];
} OBJECTID_REP;


/* Message callback routine */
typedef void  NCPHaveMessage(unsigned int conn,int msgType);


/******************* Prototypes ***************************/
int  NCPInitialize(NCPHaveMessage *messageCallback);
void NCPTerminate(void);
void NCPAttachToFileServerWithAddress(int *commandStatus,unsigned int conn,
                                      IPXADDRESS *serverAddress);
void NCPNegotiateBufferSize(int *commandStatus,unsigned int conn);
void NCPLoginObjectEncrypted(int *commandStatus,unsigned int conn,
                             const char *userName,u16 objectType,
                             u8 *key);
void NCPLoginObject(int *commandStatus,unsigned int conn,
                    u16 objectType,const char *userName,
                    const char *userPassword);
void NCPLogoutFromFileServer(int *commandStatus,unsigned int conn);
void NCPDetachFromFileServer(int *commandStatus,unsigned int conn);
void NCPGetBroadcastMessage(int *commandStatus,unsigned int conn);
void NCPGetBinderyObjectID(int *commandStatus,unsigned int conn,
                           const char *objectName,u16 objectType);
void NCPGetEncryptionKey(int *commandStatus,unsigned int conn);
void NCPEnableUserMessages(int *commandStatus,unsigned int conn);
void NCPPoll(unsigned int conn);
void *NCPGetReplyBuffer(unsigned int conn,unsigned int *replyLength);
u16  NCPGetServerConnection(unsigned int conn);
char *NCPGetServerName(unsigned int conn);
int  SAPGetNearestServer(IPXADDRESS *nearestServer);

