#include <stdio.h>
#include <stdlib.h>
#ifdef __GNUC__
#  include <libbcc.h>
#  include <pc.h>
#  define getch() getkey()
#else
#  include <graphics.h>
#  include <conio.h>
#endif

void play_font(char *name, char *file, int *x, int *y)
{
  int font;

  if (*file != '\0')
    font = installuserfont(file);
  else {
    font = DEFAULT_FONT;
    file = "DEFAULT_FONT";
  }
  if (font >= 0) {
    settextstyle(font, HORIZ_DIR, 1);
    outtextxy( *x, *y, file);
    outtextxy( *x+textwidth(file), *y, ": ");
    outtextxy( *x+textwidth(file)+textwidth(": "), *y, name);
  } else {
    settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
    outtextxy( *x, *y, "Couldn't install ");
    outtextxy( *x+textwidth("Couldn't install "), *y, file);
  }
  *y += textheight( "M");
}

void main(void)
{
  int gd, gm, x, y;
  int err;
  char ch[2];

  gd = DETECT;
  initgraph(&gd,&gm,"c:\\bc\\bgi");
  err = graphresult();
  if (err != grOk) {
    fprintf(stderr, "Couldn't initialize graphics\n");
    exit(1);
  }
  setviewport( 50, 100, 150, 200, 1);
  rectangle( 0, 0, 100, 100);
  outtextxy( -20, 20, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
  outtextxy( -15, 40, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
  outtextxy( -10, 60, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
  outtextxy( -05, 80, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
  setviewport( getmaxx()-150, 100, getmaxx()-50, 200, 1);
  settextstyle(DEFAULT_FONT, VERT_DIR, 1);
  rectangle( 0, 0, 100, 100);
  outtextxy(  5, -5, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
  outtextxy( 15,  5, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
  outtextxy( 95, -5, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
  outtextxy(105,  5, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
  x = 50; y = 105;
  ch[0] = 'A'; ch[1] = '\0';
  while (y > 0) {
    outtextxy(x,y,ch);
    y -= textwidth(ch);
    ++ch[0];
  }
  settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
  setviewport( 0, 0, getmaxx(), getmaxy(), 1);
#ifdef __TURBOC__
  outtextxy( 10, 10, "Turbo-C cuts text");
#else
  outtextxy( 10, 10, "BCC2GRX clips text");
#endif
#ifdef __GNUC__
  setviewport( 100, 250, getmaxx()-100, getmaxy(), 1);
  rectangle( 0, 0, getmaxx()-200, getmaxy()-250);
  x = 5; y = 5;
  play_font( "8x8 bit mapped characters",       "",             &x, &y);
  play_font( "8x14 bit mapped characters",      "@:pc8x14.fnt", &x, &y);
  play_font( "8x14 bit mapped characters thin", "pc8x14t.fnt",  &x, &y);
  play_font( "8x16 bit mapped characters",      "@:pc8x16.fnt", &x, &y);
  play_font( "courier 16 pixel high",           "cour16.fnt",   &x, &y);
  play_font( "helvetica 17 pixel high italic",  "helv17i.fnt",  &x, &y);
  play_font( "helvetica 29 pixel bold italic",  "helv29bi.fnt", &x, &y);
#endif
  getch();
  closegraph();
}
