/* This is file FSEEK.C */
/* This file may have been modified by DJ Delorie (Jan 1991).  If so,
** these modifications are Coyright (C) 1993 DJ Delorie, 24 Kirsten Ave,
** Rochester NH, 03867-2954, USA.
*/

/* This file was modified 1991-10-20 by R. Davidson in order to correct
** for ascii text files.
*/

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)fseek.c	5.3 (Berkeley) 3/9/86";
#endif LIBC_SCCS and not lint

/*
 * Seek for standard library.  Coordinates with buffering.
 */

#include	<stdio.h>

long lseek();

int
fseek(iop, offset, ptrname)
     register FILE *iop;
     long offset;
     int ptrname;
{
	register long c;
	long p = -1;			/* can't happen? */
	long adjust = 0;
	char *q, *qq;

	iop->_flag &= ~_IOEOF;
	if (iop->_flag&_IOREAD) {
		if (ptrname!=SEEK_END && iop->_base &&
			!(iop->_flag&_IONBF)) {
			c = iop->_cnt;
			p = offset;
			if (ptrname==SEEK_SET) {
				long curpos = lseek(fileno(iop), 0L, 1);
				if (curpos == -1)
					return (-1);
				p += c - curpos;
			} else
				offset -= c;
			if(!(iop->_flag&_IORW) && c>0 && p<=c
			    && p>=iop->_base-iop->_ptr){
				if (iop->_flag&_IOTEXT){
				  q = &iop->_ptr[iop->_cnt];
				  qq = iop->_ptr + (int)p;
				  while (--q >= qq)
				    if (*q == '\n'){
				      adjust++; qq++;
				    }
				  p += adjust;
				}
				iop->_ptr += (int)p;
				iop->_cnt -= (int)p;
				return(0);
			}
		}
		if (iop->_flag & _IORW) {
			iop->_ptr = iop->_base;
			iop->_flag &= ~_IOREAD;
		}
		p = lseek(fileno(iop), offset, ptrname);
		iop->_cnt = 0;
	}
	else if (iop->_flag & (_IOWRT|_IORW)) {
		p = fflush(iop);
		if (iop->_flag & _IORW) {
			iop->_cnt = 0;
			iop->_flag &= ~_IOWRT;
			iop->_ptr = iop->_base;
		}
		return(lseek(fileno(iop), offset, ptrname) == -1 || p == EOF ?
		    -1 : 0);
	}
	return(p==-1?-1:0);
}
