/* This is file GETFTIME.C */
/*
** Copyright (C) 1993 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <dos.h>
#include <errno.h>

int getftime(int handle, struct ftime *ft)
{
  union REGS r;
  r.h.ah = 0x57;
  r.h.al = 0;
  r.x.bx = handle;
  int86(0x21, &r, &r);
  if (r.x.cflag)
  {
    errno = r.x.ax;
    return -1;
  }
  ((short *)ft)[0] = r.x.cx;
  ((short *)ft)[1] = r.x.dx;
  return 0;
}

int setftime(int handle, struct ftime *ft)
{
  union REGS r;
  r.h.ah = 0x57;
  r.h.al = 1;
  r.x.bx = handle;
  r.x.cx = ((short *)ft)[0];
  r.x.dx = ((short *)ft)[1];
  int86(0x21, &r, &r);
  if (r.x.cflag)
  {
    errno = r.x.ax;
    return -1;
  }
  return 0;
}
