/* This is file SOUND.C */
/*
** Copyright (C) 1993 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "pc.h"

void sound(int freq)
{
  int scale;
  if (freq == 0)
  {
    outportb(0x61, inportb(0x61) & ~3);
    return;
  }
  scale = 1193046 / freq;
  outportb(0x43, 0xb6);
  outportb(0x42, scale & 0xff);
  outportb(0x42, scale >> 8);
  outportb(0x61, inportb(0x61) | 3);
}
