                           THE - The Hessling Editor
     
     OVERVIEW
     ========
     
     THE is a text editor that uses both command line commands and key bindings
     to operate. It is intended to be similar to the VM/CMS System Product 
     Editor, XEDIT and to Mansfield Software's, KEDIT.
     
     The screen display consists of several windows:
        - a main body window which displays the contents of the file being
          editted,
        - a command line from which commands may be issued,
        - an optional prefix window which shows line numbers and from
          which prefix commands can be issued
        - an id window which displays the file name, row/col etc. for the
          current file and
        - a status line which indicates global status info like number of files
          being editted, time etc.
     
     An important distinction must be made between what is called the current
     line and the focus line. The focus line is that line in the main body in
     which the cursor is displayed. All commands bound to function keys use the
     focus line as the initial line from which to begin executing the command.
     Commands issued from the command line use the current line as the starting
     line for execution of commands. The current line is the line in the main
     body that is highlighted; by default line 7.
     
     To move between the command line and the main body the 'cursor home' 
     command is used. By default it is bound to the Home key (on PCs), the 
     Do key (on vt220s) and Home (on xterms). 
     
     To determine what keys are bound to what commands, type 'show' followed 
     by Return on the command line, then follow the directions displayed.
     Key bindings may be changed for the current session by using the 'define'
     command.
     
     It is possible to make THE look and behave like either XEDIT or KEDIT.
     See the [SET] COMPAT command for further information.
     
     PROFILE FILE
     ============
     
     Various session defaults may be changed on startup for an individual by
     using a profile file. This file contains various commands that set the
     current environment, including key bindings. This profile file can also be
     used to process commands in batch mode. For example, to change all
     occurrences of 'alligator' to 'crocodile' in the file file.ext in batch
     mode, a profile file (prf.prf) with the following commands would be used:
     
          'c/alligator/crocodile/ * *'
          'file'
     
     and the command
     
          the -p prf.prf file.ext
     
     would be issued.
     
     This changes the first string enclosed in delimiters (either /,\ or @) to
     the second string for every line (*) starting at the current line
     (0 initially) changing each occurrence on a line (*).
     Maybe you only want to change a string after the first line that contains
     the string 'donkey', but only change the second occurrence of that string.
     The profile commands would then be:
     
          '/donkey/'
          'c/alligator/crocodile/ * 1 2'
          'file'
     
     The change command uses a 'target' specification as its first parameter
     after the string details. A target can be a number of lines, an absolute
     line number, BLANK, ALL or a string.
     Number of line targets consist of either a positive integer, for
     referencing lines toward the end of the file, negative for referencing
     toward the start of the file or '*', which is all the remaining lines in
     the file or '-*' which is all lines toward the start of the file.
     An absolute line number in the form of ':n' is the line number in a file,
     starting with line number 1.
     A target is any string within the allowable target delimiters.
     
     For more information on default key bindings see the *.hlp files. Detailed
     documentation of each command is present in each of the comm*.c files.
     
     --------------------------------------------------------------------------
     
     
     ========================================================================
     COMMAND REFERENCE
     ========================================================================



     --------------------------------------------------------------------------
     COMMAND
          add - add blank line
     
     SYNTAX
          Add [n]
     
     DESCRIPTION
          The ADD command inserts the specified number of blank lines after
          the current_line (if issued from the command line) or after the
          focus_line (if issued from the FILEAREA or PREFIX areas).
          If SET NEWLINE is set to ALIGNED, the cursor is positioned in
          the column corresponding to the first column not containing a 
          space in the line above.
          If SET NEWLINE is set to LEFT, the cursor is positioned in the
          first column.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          1
     
     SEE ALSO
          SOS ADDLINE
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          all - select and display restricted set of lines
     
     SYNTAX
          ALL [rtarget]
     
     DESCRIPTION
          The ALL command allows for the selective display, and editting
          (subject to SET SCOPE) of lines that match the specified target.
          This target consists of any number of individual targets
          seperated by '&' (logical and) or '|' (logical or). 
          For example, to display all lines in a file that contain the 
          strings 'ball' and 'cat' on the same line or the named lines 
          .fred or .bill, use the following command:
     
          ALL /ball/ & /cat/ | .fred | .bill
     
          Logical operators act left to right, with no precedence for &.
     
          ALL without any arguments, displays all lines in the file.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          SET SCOPE, SET DISPLAY, SET SELECT
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          backward - scroll backwards [n] screens
     
     SYNTAX
          BAckward [n|*]
     
     DESCRIPTION
          The BACKWARD command scrolls the file contents backwards through
          the file [n|*] screens.
     
          If 0 is specified as the number of screens to scroll, the last
          line of the file becomes the current line. 
          If the BACKWARD command is issued while the current line is
          the "Top of File" line, the last line of the file becomes the 
          current line.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Does not support HALF or Lines options.
     
     DEFAULT
          1
     
     SEE ALSO
          FORWARD, TOP
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          bottom - move to the bottom of the file
     
     SYNTAX
          Bottom
     
     DESCRIPTION
          The BOTTOM command moves to the very end of the current file.
          The last line of the file is set to the current line.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          FORWARD, TOP
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          cancel - quit from all unaltered files in the ring
     
     SYNTAX
          CANcel
     
     DESCRIPTION
          The CANCEL command exits from THE quickly by executing a QQUIT
          command for every file in the ring that does not have any 
          outstanding alterations.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          CCANCEL
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          cappend - append text after column pointer
     
     SYNTAX
          CAppend [text]
     
     DESCRIPTION
          The CAPPEND command moves the column pointer to the end of the
          focus line and appends the specified text.
          If no text is specified, the column pointer moves to the first
          trailing space.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          CLAST
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          ccancel - qquit from all files in the ring
     
     SYNTAX
          CCancel
     
     DESCRIPTION
          The CCANCEL command exits from THE quickly by executing the QQUIT
          command for every file in the ring. Any changes made to any of 
          the files will be lost.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          CANCEL
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          cdelete - delete text starting at column pointer
     
     SYNTAX
          CDelete [column_target]
     
     DESCRIPTION
          The CDELETE command deletes characters starting from the current
          column pointer for the specified column_target.
          If no column_target is specified, the character at the column
          pointer is deleted.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Incomplete. No string targets.



     --------------------------------------------------------------------------
     COMMAND
          cfirst - move column pointer to beginning of zone
     
     SYNTAX
          CFirst
     
     DESCRIPTION
          The CFIRST command moves the column pointer to the beginning of
          the zone.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          SET ZONE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          change - change one string to another
     
     SYNTAX
          Change /string1/string2/ [target] [n] [m]
     
     DESCRIPTION
          The CHANGE command changes one string of text to another.
     
          The first parameter to the change command is the old and new
          string values, seperated by delimiters.
          The allowable delimiters are '/' '\' and '@'.
     
          The second parameter is the target; how many lines are to be
          searched for occurrences of the first string to be changed.
     
          The third parameter determines how many occurrences of 'string1'
          are to be changed on each line.
     
          The fourth parameter determines at which occurrences of 'string1'
          on the line are changes to commence.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          1 1 1
     
     SEE ALSO
          SCHANGE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          cinsert - insert text starting at the column pointer
     
     SYNTAX
          CInsert text
     
     DESCRIPTION
          The CINSERT command inserts text starting at the column position.
     
          It is possible to insert blanks with the CINSERT command.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          clast - move the column pointer to end of zone
     
     SYNTAX
          CLAst
     
     DESCRIPTION
          The CLAST command moves the column pointer to the end of the
          zone.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          SET ZONE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          clocate - move the column pointer
     
     SYNTAX
          CLocate column_target
     
     DESCRIPTION
          The CLOCATE command scans the file for the specified column_target
          beginning with the column following (or preceding) the column
          pointer.
     
          Column targets can be specified as absolute targets, relative
          targets or string targets.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Incomplete. No string targets.



     --------------------------------------------------------------------------
     COMMAND
          cmatch - find matching bracket character
     
     SYNTAX
          cmatch 
     
     DESCRIPTION
          The CMATCH command searches for the matching bracket character to
          the character under the cursor.
     
          It handles nested sets of matching pairs.
          The matching character pairs are '[]{}<>()'.
     
          This command can only be used by assigning it to a function key
          with the DEFINE command.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          cmsg - display text on command line
     
     SYNTAX
          CMSG [text]
     
     DESCRIPTION
          The CMSG command, primarily used in macros, displays text on the
          command line.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          EMSG, MSG
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          command - execute a command without translation
     
     SYNTAX
          COMMAND command [options]
     
     DESCRIPTION
          The COMMAND command executes the specified command without
          synonym or macro translation. THE does not attempt to execute 
          the command as a macro even if IMPMACRO is ON. The command will 
          be passed to the operating system if IMPOS is ON.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          control_char - allow control characters to be entered
     
     SYNTAX
          control_char
     
     DESCRIPTION
          The CONTROL_CHAR command prompts the user to enter a control 
          character.
     
          This command can only be used by assigning it to a function key
          with the DEFINE command.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          copy - copies text from one position to another
     
     SYNTAX
          COPY target1 target2
          COPY BLOCK [RESET]
     
     DESCRIPTION
          With the first form of the COPY command, text is copied from the
          first target area to the line specified by target2. Text can
          only be copied within the same view of the file.
     
          The second form of the COPY command copies text within the
          currently marked block to the current cursor position.
          The text can be in the same file or a different file.
     
     COMPATIBILITY
          XEDIT: COPY BLOCK not available.
          KEDIT: Adds extra functionality with [RESET] option.
                 With the cursor in the marked block this command in KEDIT
                 acts like DUPLICATE BLOCK.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          coverlay - overlay text starting at the column pointer
     
     SYNTAX
          COverlay text
     
     DESCRIPTION
          The COVERLAY command overlays the supplied text onto the
          characters following the column position.
     
          Spaces in the text do not destroy the existing characters.
     
          An underscore character "_" in the text places a space in the
          corresponding character position. Therefore you cannot use the
          COVERLAY command to place underscores in a line.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          creplace - replace text starting at the column pointer
     
     SYNTAX
          CReplace text
     
     DESCRIPTION
          The CREPLACE command replaces the current characters after the
          column pointer with the supplied text.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          cursor - move cursor to specified position
     
     SYNTAX
          CURsor Column
          CURsor Screen UP|DOWN|LEFT|RIGHT
          CURsor Screen row [col]
          CURsor [Escreen] UP|DOWN
          CURsor [Escreen|Kedit] LEFT|RIGHT
          CURsor [Escreen] row [col]
          CURsor CMdline [n]
          CURsor HOME [SAVE]
          CURsor File line [col]
     
     DESCRIPTION
          The CURSOR command allows the user to specify where the cursor
          is to be positioned.
     
          CURSOR COLUMN moves the cursor to the current column of the
          focus line. 
     
          CURSOR SCREEN UP|DOWN|LEFT|RIGHT moves the cursor in the
          indicated direction one line or column. If the cursor is
          positioned on the first or last line of the screen, the cursor
          wraps to the first or last enterable lines. If the cursor is
          positioned on the left or right edges of the screen, the cursor
          moves to the left or right edge of the screen on the same line.
     
          CURSOR SCREEN row [col] moves the cursor to the specified
          row/col position within the file area. The top left corner of
          the file area is 1,1.
          row and col may be specified as '=', which will default to the
          current row and/or column position.
          If row or col are greater than the maximum number of rows or
          columns in the file area, the cursor will move to the last 
          row/column available.
          If the specified row is a reserved line, scale line or tab line
          an error will be displayed.
          If the row specified is above "Top of File" or below
          "Bottom of File" the cursor will be placed on the appropriate
          line.
     
          CURSOR [ESCREEN] UP|DOWN|LEFT|RIGHT is similar to CURSOR SCREEN
          UP|DOWN|LEFT|RIGHT, except that where scrolling of the window is
          possible, then scrolling will take place.
     
          CURSOR [ESCREEN] row [col] is similar to CURSOR SCREEN row [col],
          but all coordinates are relative the the top left corner of the
          logical window, not the top left corner of the file area. Hence,
          1,1 would be an invalid cursor position because it would result
          in the cursor being moved to the id line.
          Specification of row and/or column outside the boundaries of the
          logical window is regarded as an error.
     
          CURSOR KEDIT LEFT|RIGHT mimics the default behaviour of CURL and
          CURR in KEDIT.
     
          CURSOR CMDMLINE moves the cursor to the indicated column of the
          command line.
     
          CURsor HOME moves the cursor to the first column of the command
          line (if not on the command line), or to the last row/column of
          the file area if on the command line. With the [SAVE] option,
          the cursor will move to the last row/column of the file area or
          prefix area (which ever was the last position) if on the
          command line.
     
          CURSOR FILE moves the cursor to the line and column of the file.
          If the line and/or column are not currently displayed, an error
          message is displayed.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          define - assign one or many commands to a key
     
     SYNTAX
          DEFine key-name [command [args] [[#command [args]...]]]
     
     DESCRIPTION
          The DEFINE command allows the user to assign one or many 
          commands and optional parameter(s) to a key. 
     
          Commands may be abbreviated.
     
          If multiple commands are assigned, then the LINEND setting
          must be ON and the LINEND character must match the character
          that delimits the commands at the time that the DEFINE command
          is executed. LINEND can be OFF at the time the key is pressed.
     
          With no arguments, any existing definition for that key is
          removed and the key reverts back to its default assignation (if
          it had any).
     
          key-names correspond to the key name shown with the SHOW command.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Minimal. No support for in-memory macro commands.
                 KEDIT does not allow multiple commands except as KEXX
                 macros.
     
     SEE ALSO
          SHOW
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          delete - delete lines from a file
     
     SYNTAX
          DELete [target]
     
     DESCRIPTION
          The DELETE command removes lines from the current file.
          The number of lines removed depends on the target specified.
          Lines are removed starting with the focus line.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          1
     
     SEE ALSO
          SOS DELLINE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          directory - list the specified directory as an editable file
     
     SYNTAX
          DIRectory [filespec]
     
     DESCRIPTION
          The DIRECTORY command displays all files matching the specified 
          file specification.
          When no parameter is supplied, all files in the current directory 
          are displayed subject to any SET DIRINCLUDE restrictions.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          LS, SET DIRINCLUDE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          dos - execute an operating system command
     
     SYNTAX
          DOS [command]
     
     DESCRIPTION
          The DOS command executes the supplied operating system command 
          or runs an interactive shell if no command is supplied.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          OS, !
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          dosnowait - execute an operating system command - no prompt
     
     SYNTAX
          DOSNowait command
     
     DESCRIPTION
          The DOSNOWAIT command executes the supplied operating system 
          command not waiting for the user to be prompted once the
          command has completed.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          OSNOWAIT
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          dosquiet - execute an operating system command quietly
     
     SYNTAX
          DOSQuiet command
     
     DESCRIPTION
          The OSQUIET command executes the supplied operating system command 
          as quietly as possible.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          OSQUIET
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          down - move forward in the file a number of lines
     
     SYNTAX
          Down [relative_target]
     
     DESCRIPTION
          The DOWN command moves the current line forwards the number of
          lines specified by the relative_target. This relative_target can 
          only be a positive integer or the character "*". 
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          1
     
     SEE ALSO
          NEXT, UP
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          duplicate - duplicate lines
     
     SYNTAX
          DUPlicate [n [target|BLOCK]]
     
     DESCRIPTION
          The DUPLICATE command copies the number of lines extrapolated from
          target, n times.
     
     COMPATIBILITY
          XEDIT: Equivalent of DUPLICAT command.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          edit - edit another file or switch to next file
     
     SYNTAX
          Edit [filename]
     
     DESCRIPTION
          The EDIT command allows the user to edit another file. The new file
          is placed in the file ring. The previous file being edited remains
          in memory and can be returned to by issuing an EDIT command without
          any parameters. Several files can be edited at once, and all files
          are arranged in a ring, with subsequent EDIT commands moving through
          the ring, one file at a time.
     
     COMPATIBILITY
          XEDIT: Does not provide options switches.
          KEDIT: Does not provide options switches.
     
     SEE ALSO
          THE, XEDIT
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          emsg - display message
     
     SYNTAX
          EMSG [message]
     
     DESCRIPTION
          The EMSG command displays an error message on the error line.
          This command is usually issued from a macro file.
     
     COMPATIBILITY
          XEDIT: Does not support [mmmnnns text] option
          KEDIT: Compatible
     
     SEE ALSO
          CMSG, MSG
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          enter - execute a command
     
     SYNTAX
          enter
     
     DESCRIPTION
          The ENTER command executes the command currently displayed on the
          command line, if the cursor is currently displayed there.
          If the key associated with ENTER is pressed while in the FILEAREA,
          then the cursor will move to the first column of the
          next line. If the cursor is in the PREFIX area, any pending 
          prefix commands will be executed. If the mode is currently in 
          'insert', then a new line is added and the cursor placed on the
          next line depending on the value of SET NEWLINE.
     
          This command can only be used by assigning it to a function key
          with the DEFINE command.
     
          This command will be removed in a future version.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          SOS EXECUTE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          expand - expand tab characters to spaces
     
     SYNTAX
          EXPand [target]
     
     DESCRIPTION
          The EXPAND command converts all tab characters to spaces depending
          on the size of a tab determined by the SET TABS command.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          SET TABS
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          extract - obtain various internal information about THE
     
     SYNTAX
          EXTract /item/[...]
     
     DESCRIPTION
          The EXTRACT command is used to relay information about settings
          within THE from within a REXX macro. EXTRACT is only valid within
          a REXX macro.
     
     COMPATIBILITY
          XEDIT: Only allows '/' as delimiter.
          KEDIT: Only allows '/' as delimiter.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          ffile - force a FILE of the current file to disk
     
     SYNTAX
          FFile  [filename]
     
     DESCRIPTION
          The FFILE command writes the current file to disk to the current
          file name or to the supplied filename.
          Unlike the FILE command, if the optional filename exists, this
          command will overwrite the file.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          With no parameters, the current file is written.
     
     SEE ALSO
          FILE, SAVE, SSAVE
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          file - write the current file to disk and remove from ring
     
     SYNTAX
          FILE  [filename]
     
     DESCRIPTION
          The FILE command writes the current file to disk to the current
          file name or to the supplied filename.
          Unlike the FFILE command, if the optional filename exists, this
          command will not overwrite the file.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          With no parameters, the current file is written.
     
     SEE ALSO
          FFILE, SAVE, SSAVE
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          fillbox - fill the marked box block with a character
     
     SYNTAX
          FILLbox [c]
     
     DESCRIPTION
          The FILLBOX command fills the marked block with the specified
          character. If no parameters are supplied and the command is run
          from the command line, then the box will be filled with spaces.
          If the command is not run from the command line, the user is
          prompted for a character to fill the box.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          forward - scroll forwards [n] screens
     
     SYNTAX
          FOrward [n]
     
     DESCRIPTION
          The FORWARD command scrolls the file contents forwards the number
          of screens specified.
     
          If 0 is specified as the number of screens to scroll, the "Top
          of File" line becomes the current line. 
          If the FORWARD command is issued while the current line is the 
          "Bottom of File" line, the "Top of File" line becomes the 
          current line.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Does not support HALF or Lines options.
     
     DEFAULT
          1
     
     SEE ALSO
          BACKWARD, TOP
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          get - insert into file the contents of specified file
     
     SYNTAX
          GET [fileid] [fromline] [numlines]
     
     DESCRIPTION
          The GET command reads a file into the current file, inserting
          lines after the current line.
          When no fileid is supplied the temporary file generated by the
          PUT command is used.
     
          When fromline is specified, reading of the file begins at the
          line number specified.
          If fromline is not specifed, reading begins at line 1.
     
          When numlines is specified, reading of the file ends when the
          specified number of lines has been read.
          If numlines is not specified, or numlines is specified as '*',
          all files from the fromline to the end of file are read.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          PUT, PUTD
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          help - edit help file for THE
     
     SYNTAX
          HELP
     
     DESCRIPTION
          The HELP command displays help for the editor.
          Uses THE_HELP_FILE environment variable to point to the help file.
     
     COMPATIBILITY
          XEDIT: Similar in concept.
          KEDIT: Similar in concept.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          hit - simulate hitting of the named key
     
     SYNTAX
          HIT key
     
     DESCRIPTION
          The HIT command enables the simulation of hitting the named key.
          This is most useful from within a macro.
     
          Be very careful when using the HIT command with the DEFINE command.
          If you assign the HIT command to a key, DO NOT use the same key
          name. eg. DEFINE F1 HIT F1
          This will result in an infinite processing loop.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Similar, but more like the MACRO command.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          input - insert the command line contents into the file
     
     SYNTAX
          Input [line contents]
     
     DESCRIPTION
          The INPUT command inserts the remainder of the command line into the
          file after the current line.
     
     COMPATIBILITY
          XEDIT: Does not provide full input mode option.
          KEDIT: Does not provide full input mode option.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          join - join a line with the line following
     
     SYNTAX
          Join [ALigned]
     
     DESCRIPTION
          The JOIN command makes one line out of the focus line and the
          line following.
          If ALIGNED is specified, any leading spaces in the following line
          are ignored. If ALIGNED is not specified, all characters, including
          spaces are added.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          SPLIT, SPLTJOIN
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          left - scroll the screen to the left
     
     SYNTAX
          LEft [n|HALF]
     
     DESCRIPTION
          The LEFT command scrolls the screen n columns to the left.
          If no parameter is supplied, the screen is scrolled by one
          column. If HALF is specified the screen is scrolled by half 
          the number of columns in the FILEAREA.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          RIGHT, RGTLEFT
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          locate - search for a target
     
     SYNTAX
          [Locate] target [command]
     
     DESCRIPTION
          The LOCATE command searches for the next or previous occurrence 
          of the specified target.  If no parameter is supplied, LOCATE
          uses the the last target specified. If no prior target has been
          specified, an error message is displayed. With an optional operand, 
          it executes the command after finding the target.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          lowercase - change uppercase characters to lowercase
     
     SYNTAX
          LOWercase [target]
     
     DESCRIPTION
          The LOWERCASE command changes all uppercase characters in all 
          lines up to the target line to lowercase. All other characters 
          remain untouched.
     
     COMPATIBILITY
          XEDIT: Equivalent of LOWERCAS command.
          KEDIT: Compatible.
     
     SEE ALSO
          UPPERCASE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          ls - list the specified directory as an editable file
     
     SYNTAX
          LS [filespec]
     
     DESCRIPTION
          The LS command displays all files matching the specified
          file specification.
          When no parameter is supplied, all files in the current directory 
          are displayed subject to any SET DIRINCLUDE restrictions.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          DIRECTORY, SET DIRINCLUDE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          macro - execute a macro command file
     
     SYNTAX
          MACRO filename [arguments]
     
     DESCRIPTION
          The MACRO command executes the contents of the specified file
          as command line commands.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
          Only REXX macros accept the passing of arguments to the macro file.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          mark - mark a portion of text
     
     SYNTAX
          MARK Line|Box|Stream|Word|Column
     
     DESCRIPTION
          The MARK command marks a portion of text for later processing
          by a COPY, MOVE or DELETE command.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Does not implement Stream.
                 Adds WORD option and COLUMN options.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          modify - display current SET command for alteration
     
     SYNTAX
          MODify set-command
     
     DESCRIPTION
          The MODIFY command displays the current setting of a set command
          on the command line enabling the user to change that setting.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          SET, QUERY
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          move - move a portion of text
     
     SYNTAX
          MOVE BLOCK [RESET]
     
     DESCRIPTION
          The MOVE command copies the contents of the marked block to the
          current cursor position and deletes the characters/lines from the
          original position of the marked block.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Adds extra functionality with [RESET] option.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          msg - display message on error line
     
     SYNTAX
          MSG [message]
     
     DESCRIPTION
          The MSG command displays an error message on the error line.
          This command is usually issued from a macro file.
          This is similar to EMSG, but MSG does not sound the bell if SET
          BELL is on.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          CMSG, EMSG
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          next - move forward in the file a number of lines
     
     SYNTAX
          Next [relative_target]
     
     DESCRIPTION
          The NEXT command moves the current line forwards the number of
          lines specified by the relative_target. This relative_target can 
          only be a positive integer or the character "*". 
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          1
     
     SEE ALSO
          DOWN, UP
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          nextwindow - switch focus of editing session to other window
     
     SYNTAX
          NEXTWindow
     
     DESCRIPTION
          The NEXTWINDOW command moves the focus of the editing session to
          the other window (if more than one window is currently displayed)
          or to the next file in the ring.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          EDIT, SCREEN
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          nomsg - execute a command suppressing any messages 
     
     SYNTAX
          NOMSG command [parameters]
     
     DESCRIPTION
          The NOMSG command executes the supplied command but suppresses
          messages that would normally be displayed as a result of the 
          command.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          nop - no operation command
     
     SYNTAX
          NOP
     
     DESCRIPTION
          The NOP command doesn't do anything. It is used as a means of
          setting a key to do nothing.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          DEFINE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          os - execute an operating system command
     
     SYNTAX
          OS [command]
     
     DESCRIPTION
          The OS command executes the supplied operating system command 
          or runs an interactive shell if no command is supplied.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Equivalent to DOS command.
     
     SEE ALSO
          DOS, !
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          osnowait - execute an operating system command - no prompt
     
     SYNTAX
          OSNowait command
     
     DESCRIPTION
          The OSNOWAIT command executes the supplied operating system 
          command not waiting for the user to be prompted once the
          command has completed.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Equivalent of DOSNOWAIT command.
     
     SEE ALSO
          DOSNOWAIT
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          osquiet - execute an operating system command quietly
     
     SYNTAX
          OSQuiet command
     
     DESCRIPTION
          The OSQUIET command executes the supplied os command as quietly
          as possible.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Equivalent of DOSQUIET command.
     
     SEE ALSO
          DOSQUIET
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          osredir - execute an operating system command and capture output
     
     SYNTAX
          OSRedir filename command
     
     DESCRIPTION
          The OSREDIR command executes the supplied os command and redirects
          output destined for STDOUT and STDERR to the specified file.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          OS, OSQUIET, OSNOWAIT
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          overlaybox - overlay marked box block on current cursor position
     
     SYNTAX
          OVERLAYBox
     
     DESCRIPTION
          The OVERLAYBOX copies the contents of the marked box block over the
          characters at the current cursor position or to column 1 of the
          current line if issued from the command line.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          MOVE, COPY
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          print - send text to default printer or print spooler
     
     SYNTAX
          PRint [target] [n]
          PRint LINE [text]
          PRint STRING [text]
          PRint FORMfeed
          PRint CLOSE
     
     DESCRIPTION
          The PRINT command writes a portion of the current file to the default
          printer or print spooler, or text entered on the command line.
       
          PRINT [target] [n]
             Sends text from the file contents up to the target to the printer
             followed by a CR/LF (DOS) or LF(UNIX) after each line.
             When [n] is specified, this sends a formfeed after [n] successive
             lines of text.
          PRINT LINE [text]
             Sends the remainder of the text on the command line to the printer
             followed by a CR/LF (DOS) or LF(UNIX).
          PRINT STRING [text]
             Sends the remainder of the text on the command line to the printer
             without any trailing line terminator.
          PRINT FORMFEED
              Sends a formfeed (^L) character to the printer.
          PRINT CLOSE
              Closes the printer spooler.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          PRINTER
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          put - write part of a file to another
     
     SYNTAX
          PUT [target] [fileid]
     
     DESCRIPTION
          The PUT command writes a portion of the current file to another
          file, either explicit or temporary.
          When no fileid is supplied the temporary file is overwritten.
          When a fileid is supplied the portion of the file written out
          is appended to the specified file.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          PUTD, GET
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          putd - write part of a file to another and delete
     
     SYNTAX
          PUTD [target] [fileid]
     
     DESCRIPTION
          The PUTD command writes a portion of the current file to another
          file, either explicit or temporary and deletes those lines written.
          When no fileid is supplied the temporary file is overwritten.
          When a fileid is supplied the portion of the file written out
          is appended to the specified file.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          PUT, GET
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          qquit - exit from the current file without saving changes
     
     SYNTAX
          QQuit
     
     DESCRIPTION
          The QQUIT command exits the user from the current file, whether
          changes have been made to the file or not.
          The previous file in the ring then becomes the current file.
          If the current file is the only file in the ring, the user is
          returned to the Operating System.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          QUIT
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          query - display various option settings
     
     SYNTAX
          Query item
     
     DESCRIPTION
          The QUERY command displays the various settings for options set
          by THE.
     
     COMPATIBILITY
          XEDIT: Compatible functionality, but not all options.
          KEDIT: Compatible functionality, but not all options.
     
     SEE ALSO
          STATUS, MODIFY
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          quit - exit from the current file if no changes made
     
     SYNTAX
          QUIT
     
     DESCRIPTION
          The QUIT command exits the user from the current file, provided
          no changes have been made to the file. An error message will be
          displayed if changes have been made.
          The previous file in the ring then becomes the current file.
          If the current file is the only file in the ring, the user is
          returned to the Operating System.
     
     COMPATIBILITY
          XEDIT: Does not support return code option.
          KEDIT: Compatible.
     
     SEE ALSO
          QQUIT
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          readv - read keystrokes and pass to macro
     
     SYNTAX
          READV Cmdline|KEY
     
     DESCRIPTION
          The READV command allows a REXX macro to interact with the user 
          by accepting keystrokes.
     
          The macro obtains the entered information by setting REXX
          variables. These are set as follows:
     
          For READV KEY
     
              readv.0 = 3
              readv.1 = name of key (empty if unknown)
              readv.2 = ASCII value of key (null if not an ASCII code)
              readv.3 = curses key value (or ASCII code if an ASCII code)
     
          For READV CMDLINE
     
              readv.0 = 1
              readv.1 = contents of command line
     
     COMPATIBILITY
          XEDIT: Similar to READ CMDLINE option.
          KEDIT: Compatible.
     
     STATUS
          Incomplete. CMDLINE option not implemented.



     --------------------------------------------------------------------------
     COMMAND
          recover - recover changed or deleted lines
     
     SYNTAX
          RECover [n|*]
     
     DESCRIPTION
          The RECOVER command restores the last n changed or deleted lines
          back into the body of the file.
     
     COMPATIBILITY
          XEDIT: Also recovers changes to lines, not just lines deleted.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          redraw - redraw the current screen
     
     SYNTAX
          REDRAW
     
     DESCRIPTION
          The REDRAW command redraws the current contents of the screen.
          This is usually used when some outside influence has affected 
          the display.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          REFRESH
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          refresh - refresh the contents of the current screen
     
     SYNTAX
          REFRESH
     
     DESCRIPTION
          The REFRESH command refreshes what is being displayed on the screen.
          This is usually used from within a macro to indicate the progress
          of the macro.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          REDRAW
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          repeat - repeat the last command
     
     SYNTAX
          REPEat [target]
     
     DESCRIPTION
          The REPEAT command advances the current line and executes the
          last command. It is equivalent to NEXT 1 (or UP 1) and = for
          the specified number of times.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Incomplete



     --------------------------------------------------------------------------
     COMMAND
          replace - replace the current line with supplied text
     
     SYNTAX
          Replace [text]
     
     DESCRIPTION
          The REPLACE command replaces the current line with the supplied
          text.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          reset - cancel the marked block or prefix commands or both
     
     SYNTAX
          RESet ALL|Block|Prefix
     
     DESCRIPTION
          The RESET command unmarks any marked block or outstanding prefix
          commands or both.
     
     COMPATIBILITY
          XEDIT: Adds Block and All options.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          rgtleft - scroll the screen to the left or right
     
     SYNTAX
          RGTLEFT [n]
     
     DESCRIPTION
          The RGTLEFT command scrolls the screen n columns to the right
          if the value of VERSHIFT is less than or equal to 0, or if
          the value of VERSHIFT is greater than 0, the screen is
          scrolled n columns to the left.
          If n is not specified, the screen scrolls by three quarters the
          number of columns displayed.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          LEFT, RIGHT
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          right - scroll the screen to the right
     
     SYNTAX
          RIght [n|HALF]
     
     DESCRIPTION
          The RIGHT command scrolls the screen n columns to the right.
          If no parameter is supplied, the screen is scrolled by 1
          column. If HALF is specified the screen is scrolled by half 
          the number of columns in the FILEAREA.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          LEFT, RGTLEFT
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          save - save changes to current file
     
     SYNTAX
          SAVE [fileid]
     
     DESCRIPTION
          The SAVE command writes the current file to disk. If a fileid is
          supplied, the current file is saved in that file, unless the file
          already exists which will result in an error message being
          displayed. The 'Alterations' counter on the heading line is 
          reset to zero.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          SSAVE, FILE, FFILE
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          schange - selectively change strings
     
     SYNTAX
          SCHange /string1/string2/ [target] [n] [m]
     
     DESCRIPTION
          The SCHANGE command changes one string of text to another.
     
          The first parameter to the change command is the old and new
          string values, seperated by delimiters.
          The allowable delimiters are '/' '\' and '@'.
     
          The second parameter is the target; how many lines are to be
          searched for occurrences of the first string to be changed.
     
          The third parameter determines how many occurrences of 'string1'
          are to be changed on each line.
     
          The fourth parameter determines at which occurrences of 'string1'
          on the line are changes to commence.
     
     COMPATIBILITY
          XEDIT: Functionally compatible, but syntax different.
          KEDIT: Compatible.
     
     DEFAULT
          1 1 1
     
     SEE ALSO
          CHANGE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          set - execute various set commands
     
     SYNTAX
          SET set_command [set_command parameter(s) ...]
     
     DESCRIPTION
          The SET command is a front end to existing 'set' commands. It treats
          the first parameter it receives as a command and executes it.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          shift - move text left or right
     
     SYNTAX
          SHift Left|Right [n] [target]
     
     DESCRIPTION
          The SHIFT command moves text in the direction specified the number
          of columns [n] for the specified target lines.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          showkey - display current key value and command assignation
     
     SYNTAX
          SHOWkey
     
     DESCRIPTION
          The SHOWKEY command prompts the user to enter a key and responds
          with the key name and associated command (if applicable).
          To exit from SHOWKEY, press the space bar.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sort - sort selected lines in a file
     
     SYNTAX
          SORT target [[[Ascending|Descending] left_col right_col] [...]]
     
     DESCRIPTION
          The SORT command sort a portion of a file based on the sort field
          specifications.
          target can be any valid target including ALL, *, -*, and BLOCK.
          Each sort field specification consists of an optional ordering
          flag and a left and right column.
     
          Only 10 sort fields are allowed.
     
     COMPATIBILITY
          XEDIT: XEDIT only allows ordering flag for all fields
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos - execute various sos commands
     
     SYNTAX
          SOS sos_command [sos_command ...]
     
     DESCRIPTION
          The SOS command is a front end to existing 'sos' commands. It treats
          each parameter it receives as a command and executes it.
     
     COMPATIBILITY
          XEDIT: XEDIT only permits 1 command
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          split - split a line into two lines
     
     SYNTAX
          SPlit [ALigned]
     
     DESCRIPTION
          The SPLIT command splits the focus line into two lines.
          If ALIGNED is specified, the first non-blank character of the new
          line is positioned under the first non-blank character of the
          focus line. If ALIGNED is not specified, the text of the new line
          starts in column 1.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          JOIN, SPLTJOIN
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          spltjoin - split/join two lines
     
     SYNTAX
          spltjoin
     
     DESCRIPTION
          The SPLTJOIN command splits the focus line into two or joins the
          focus line with the next line depending on the position of the
          cursor. If the cursor is after the last column of a line, the JOIN
          command is executed, otherwise the SPLIT command is executed.
          The text in the new line is aligned with the text in the focus line.
     
          This command can only be used by assigning it to a function key.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          JOIN, SPLIT
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          ssave - force SAVE to specified file
     
     SYNTAX
          SSave [fileid]
     
     DESCRIPTION
          The SSAVE command writes the current file to disk. If a fileid is
          supplied, the current file is saved in that file, otherwise the
          current name of the file is used.
          If a fileid is supplied and that fileid already exists, the previous
          contents of that fileid will be replaced with the current file.
          The 'Alterations' counter on the heading line is reset to zero.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          SAVE, FILE, FFILE
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          status - display current settings of various variables
     
     SYNTAX
          STATus [filename]
     
     DESCRIPTION
          The STATUS command, without the optional filename, displays a full
          screen of current settings for various variables. With the filename,
          the STATUS command creates a file containing a series of SET commands
          with the current values of these settings.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible. KEDIT does not support [filename] option.
     
     SEE ALSO
          QUERY, EXTRACT, MODIFY
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          suspend - suspend THE and return to operating system
     
     SYNTAX
          SUSPend
     
     DESCRIPTION
          The SUSPEND command suspends the current editing session and 
          returns control to the operating system. Under DOS and OS/2 this
          is the equivalent of OSNowait. Under UNIX, the process gets placed
          in the background until it is brought to the foreground.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          OSNOWAIT
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          tabpre - switch between FILEAREA and PREFIX area
     
     SYNTAX
          tabpre
     
     DESCRIPTION
          The TABPRE command switches the focus of the editor from the
          FILEAREA to the PREFIX area and vice versa, depending
          on which window is currently active.
     
          This command can only be used by assigning it to a function key.
     
          This command will be removed in a future version.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Equivalent of SOS LEFTEDGE and SOS PREFIX
     
     SEE ALSO
          SOS LEFTEDGE, SOS PREFIX
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          text - simulate keyboard entry of characters
     
     SYNTAX
          TEXT text
     
     DESCRIPTION
          The TEXT command simulates the entry of characters from the
          keyboard. This command is actually called when you enter text
          from the keyboard.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
                 Does not allow trailing spaces in text.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          the - edit another file or switch to next file
     
     SYNTAX
          THE [filename]
     
     DESCRIPTION
          The THE command allows the user to edit another file. The new file
          is placed in the file ring. The previous file being edited remains
          in memory and can be returned to by issuing a THE command without
          any parameters. Several files can be edited at once, and all files
          are arranged in a ring, with subsequent THE commands moving through
          the ring, one file at a time.
     
     COMPATIBILITY
          XEDIT: Does not provide options switches.
          KEDIT: Does not provide options switches.
     
     SEE ALSO
          XEDIT, EDIT
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          top - move to the top of the file
     
     SYNTAX
          TOP
     
     DESCRIPTION
          The TOP command moves to the very start of the current file.
          The "Top-of-file" line is set to the current_line.
     
          "TOP" is equivalent to "BACKWARD *".
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          BACKWARD, BOTTOM
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          up - move backward in the file a number of lines
     
     SYNTAX
          Up [relative_target]
     
     DESCRIPTION
          The UP command moves the current line backwards the number of
          lines specified by the relative_target. This relative_target can 
          only be a positive integer or the character "*". 
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          1
     
     SEE ALSO
          NEXT, DOWN
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          uppercase - change lowercase characters to uppercase
     
     SYNTAX
          UPPercase [target]
     
     DESCRIPTION
          The UPPERCASE command changes all lowercase characters in all
          lines up to the target line to uppercase. All other characters 
          remain untouched.
     
     COMPATIBILITY
          XEDIT: Equivalent of UPPERCAS
          KEDIT: Compatible.
     
     SEE ALSO
          LOWERCASE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          xedit - edit another file or switch to next file
     
     SYNTAX
          Xedit [filename]
     
     DESCRIPTION
          The XEDIT command allows the user to edit another file. The new file
          is placed in the file ring. The previous file being edited remains
          in memory and can be returned to by issuing an XEDIT command without
          any parameters. Several files can be edited at once, and all files
          are arranged in a ring, with subsequent XEDIT commands moving through
          the ring, one file at a time.
     
     COMPATIBILITY
          XEDIT: Does not provide options switches.
          KEDIT: Does not provide options switches.
     
     SEE ALSO
          EDIT, THE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          retrieve - return the next/prior command on the command line
     
     SYNTAX
          ?[+]
     
     DESCRIPTION
          The ? command returns the next or prior command from the command
          line stack and displays it on the command line.
          With no parameters, the most recent command entered on the command
          line is retrieved.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: See below..
          Does not support multiple '?' as in ??? to retrieve the third last
          command.
          This command is bound to the up and down arrows when on the
          command line depending on the setting of CMDARROWS.
     
     SEE ALSO
          SET CMDARROWS
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          = - re-execute the last command issued on the command line
     
     SYNTAX
          =
     
     DESCRIPTION
          The = command retrieves the most recently issued command from
          the command line and re-executes it.
     
     COMPATIBILITY
          XEDIT: Does not support optional [subcommand] option.
          KEDIT: Does not support optional [command] option.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          ! - execute an operating system command
     
     SYNTAX
          ! [command]
     
     DESCRIPTION
          The OS command executes the supplied operating system command 
          or runs an interactive shell if no command is supplied.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Equivalent to DOS command.
     
     SEE ALSO
          DOS, OS
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     
     
     
     ========================================================================
     SOS COMMAND REFERENCE
     ========================================================================



     --------------------------------------------------------------------------
     COMMAND
          sos addline - add blank line after focus line
     
     SYNTAX
          SOS ADDline
     
     DESCRIPTION
          The SOS ADDLINE command inserts a blank line in the file following
          the focus line. The cursor is placed in the column under the first
          non-blank in the focus line.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          SOS LINEADD, SOS DELLINE
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos bottomedge - move cursor to bottom edge of FILEAREA
     
     SYNTAX
          SOS BOTTOMEdge
     
     DESCRIPTION
          The SOS BOTTOMEDGE command moves the cursor to the last 
          enterable line in the FILEAREA or PREFIX area. If the cursor
          is on the command line, the cursor moves to the first 
          enterable line of the FILEAREA.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Comaptible.
     
     SEE ALSO
          SOS TOPEDGE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos current - move cursor to current line
     
     SYNTAX
          SOS CURRent
     
     DESCRIPTION
          The SOS CURRENT command moves the cursor to the current column
          of the cursor line from any window.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos cursoradj - move first non-blank character to cursor
     
     SYNTAX
          SOS CURSORAdj
     
     DESCRIPTION
          The SOS CURSORADJ command moves text in the focus line so that
          the first non-blank character appears under the cursor position.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos delback - delete the character to the left of the cursor
     
     SYNTAX
          SOS DELBAck
     
     DESCRIPTION
          The SOS DELBACK command moves the cursor one character to the left
          and deletes the character now under the cursor.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          SOS DELCHAR
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos delchar - delete character under cursor
     
     SYNTAX
          SOS DELChar
     
     DESCRIPTION
          The SOS DELCHAR command deletes the character under the cursor.
          Text to the right is shifted to the left.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          SOS DELBACK
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos delend - delete to end of line
     
     SYNTAX
          SOS DELEnd
     
     DESCRIPTION
          The SOS DELEND command deletes all characters from the current
          column to the end of line.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos delline - delete focus line
     
     SYNTAX
          SOS DELLine
     
     DESCRIPTION
          The SOS DELLINE command deletes the focus line.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          SOS LINEDEL, SOS ADDLINE
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos delword - delete word at or right of cursor
     
     SYNTAX
          SOS DELWord
     
     DESCRIPTION
          The SOS DELWORD command deletes the word at or to the right
          of the current cursor position and any spaces following the 
          word.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos doprefix - execute any pending prefix commands
     
     SYNTAX
          SOS DOPREfix
     
     DESCRIPTION
          The SOS DOPREFIX command executes any pending prefix commands.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos edit - edit a file from directory list
     
     SYNTAX
          SOS EDIT
     
     DESCRIPTION
          The SOS EDIT command allows the user to edit a file, chosen from
          a directory list.(the file DIR.DIR).
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible with default definition for Alt-X key.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos endchar - move cursor to end of focus line
     
     SYNTAX
          SOS ENDChar
     
     DESCRIPTION
          The SOS ENDCHAR command moves the cursor to the position after
          the last character displayed in the current window.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          SOS STARTENDCHAR
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos execute - move cursor to command line and execute command
     
     SYNTAX
          SOS EXecute
     
     DESCRIPTION
          The SOS EXECUTE command moves the cursor to the command line
          and executes any command that is on the command line.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible
     
     STATUS
          Complete. 



     --------------------------------------------------------------------------
     COMMAND
          sos firstchar - move cursor to first non-blank of field
     
     SYNTAX
          SOS FIRSTCHar
     
     DESCRIPTION
          The SOS FIRSTCHAR command moves the cursor to the first
          non-blank character of the cursor field
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible
     
     SEE ALSO
          SOS FIRSTCOL
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos firstcol - move cursor to first column of field
     
     SYNTAX
          SOS FIRSTCOl
     
     DESCRIPTION
          The SOS FIRSTCOL command moves the cursor to the first
          column of the cursor field
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible
     
     SEE ALSO
          SOS FIRSTCHAR, SOS LASTCOL
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos lastcol - move cursor to last column of field
     
     SYNTAX
          SOS LASTCOl
     
     DESCRIPTION
          The SOS LASTCOL command moves the cursor to the last column
          of the cursor field.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          SOS FIRSTCOL
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos leftedge - move cursor to left edge of window
     
     SYNTAX
          SOS LEFTEdge
     
     DESCRIPTION
          The SOS LEFTEDGE command moves the cursor to the leftmost edge
          of the filearea if not on the command line or to the leftmost
          edge of the command line if on the command line.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible
     
     SEE ALSO
          SOS RIGHTEDGE, SOS PREFIX
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos lineadd - add blank line after focus line
     
     SYNTAX
          SOS LINEAdd
     
     DESCRIPTION
          The SOS LINEADD command inserts a blank line in the file following
          the focus line. The cursor is placed in the column under the first
          non-blank in the focus line.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          SOS ADDLINE, SOS LINEDEL
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos linedel - delete focus line
     
     SYNTAX
          SOS LINEDel
     
     DESCRIPTION
          The SOS LINEDEL command deletes the focus line.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          SOS DELLINE, SOS LINEADD
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos makecurr - make focus line the current line
     
     SYNTAX
          SOS MAKECURR
     
     DESCRIPTION
          The SOS MAKECURR command set the current line to the current focus
          line.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos marginl - move cursor to the left margin column
     
     SYNTAX
          SOS MARGINL
     
     DESCRIPTION
          The SOS MARGINL command moves the cursor to the left margin
          column.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
                 Although, when issued from the command line, nothing
                 happens.
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos marginr - move cursor to the right margin column
     
     SYNTAX
          SOS MARGINR
     
     DESCRIPTION
          The SOS MARGINR command moves the cursor to the right margin
          column.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
                 Although, when issued from the command line, nothing
                 happens.
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos parindent - move cursor to the paragraph indent column
     
     SYNTAX
          SOS PARINDent
     
     DESCRIPTION
          The SOS PARINDENT command moves the cursor to the paragraph
          indent column.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
                 Although, when issued from the command line, nothing
                 happens.
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos prefix - move cursor to leftmost edge of prefix area
     
     SYNTAX
          SOS PREfix
     
     DESCRIPTION
          The SOS PREFIX command moves the cursor to the rightmost edge
          of the prefix area.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible
     
     SEE ALSO
          SOS LEFTEDGE, SOS RIGHTEDGE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos qcmnd - move cursor to command line and clear
     
     SYNTAX
          SOS QCmnd
     
     DESCRIPTION
          The SOS QCMND command moves the cursor to the first column of
          the command line and clears the command line.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible
     
     SEE ALSO
          SOS EXECUTE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos rightedge - move cursor to right edge of window
     
     SYNTAX
          SOS RIGHTEdge
     
     DESCRIPTION
          The SOS RIGHTEDGE command moves the cursor to the rightmost edge
          of the filearea if not on the command line or to the rightmost
          edge of the command line if on the command line.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible
     
     SEE ALSO
          SOS LEFTEDGE, SOS PREFIX
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos startendchar - move cursor to end/start of focus line
     
     SYNTAX
          SOS STARTENDChar
     
     DESCRIPTION
          The SOS STARTENDCHAR command moves the cursor to the first character
          displayed in the current window, if the cursor is after the last
          character displayed in the current window, or to the position after
          the last character displayed in the current window, if the cursor is
          anywhere else.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     SEE ALSO
          SOS ENDCHAR
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos tabb - move cursor to previous tab stop
     
     SYNTAX
          SOS TABB
     
     DESCRIPTION
          The SOS TABB command causes the cursor to move to the previous tab
          column as set by the SET TABS command.
          If the resulting column is beyond the left hand edge of the main
          window, the window will scroll half a window.
     
     COMPATIBILITY
          XEDIT: Does not allow arguments.
          KEDIT: Compatible. See below.
          Does not line tab to next line if before the left hand tab column.
     
     SEE ALSO
          SET TABS, SOS TABF
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos tabf - move cursor to next tab stop
     
     SYNTAX
          SOS TABf
     
     DESCRIPTION
          The SOS TABF command causes the cursor to move to the next tab column
          as set by the SET TABS command.
          If the resulting column is beyond the right hand edge of the main
          window, the window will scroll half a window.
     
     COMPATIBILITY
          XEDIT: Does not allow arguments.
          KEDIT: Compatible. See below.
          Does not line tab to next line if after the right hand tab column.
     
     SEE ALSO
          SET TABS, SOS TABB
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos tabfieldb - move cursor to previous enterable field
     
     SYNTAX
          SOS TABFIELDB
     
     DESCRIPTION
          The SOS TABFIELDB command causes the cursor to move to the first
          column of the current enterable field. If the cursor is already
          in the first column of the current field the cursor moves to the
          first column of the previous enterable field on the screen. 
          This command is intended to mimic the behavior of the SHIFT-TAB 
          key on a 3270 terminal.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          SOS TABFIELDF
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos tabfieldf - move cursor to next enterable field
     
     SYNTAX
          SOS TABFIELDf
     
     DESCRIPTION
          The SOS TABFIELDF command causes the cursor to move to the next 
          enterable field on the screen. This command is intended to
          mimic the behavior of the TAB key on a 3270 terminal.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          SOS TABFIELDB
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos tabwordb - move cursor to beginning of previous word
     
     SYNTAX
          SOS TABWORDB
     
     DESCRIPTION
          The SOS TABWORDB command causes the cursor to move to the first character
          of the word to the left or to the start of the line if no more
          words precede.
          If the resulting column is beyond the left hand edge of the 
          FILEAREA, the window will scroll half a window.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          SOS TABWORDF
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos tabwordf - move cursor to start of next word
     
     SYNTAX
          SOS TABWORDf
     
     DESCRIPTION
          The SOS TABWORDF command causes the cursor to move to the first character
          of the next word to the right or to the end of the line if no more
          words follow.
          If the resulting column is beyond the right hand edge of the
          FILEAREA, the window will scroll half a window.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     SEE ALSO
          SOS TABWORDB
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos topedge - move cursor to top edge of filearea
     
     SYNTAX
          SOS TOPEdge
     
     DESCRIPTION
          The SOS TOPEDGE command moves the cursor to the first
          enterable line in the FILEAREA or PREFIX area. If the cursor
          is on the command line, the cursor moves to the first 
          enterable line of the FILEAREA.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Comaptible.
     
     SEE ALSO
          SOS BOTTOMEDGE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos undo - undo changes to the current line
     
     SYNTAX
          SOS UNDO
     
     DESCRIPTION
          The SOS UNDO command causes the contents of the focus line (or the
          command line) to be reset to the contents before the cursor was
          positioned there.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible. 
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     
     
     
     ========================================================================
     SET COMMAND REFERENCE
     ========================================================================



     --------------------------------------------------------------------------
     COMMAND
          arbchar - set arbitrary character(s) for targets
     
     SYNTAX
          [SET] ARBchar ON|OFF [char1] [char2]
     
     DESCRIPTION
          Set the character to use as an 'arbitrary character' in string
          targets. The first arbitrary character matches a group of zero
          or more characters, the second will match exactly one character.
     
     COMPATIBILITY
          XEDIT: Compatible.
                 Single arbitrary character not supported.
          KEDIT: Compatible.
     
     DEFAULT
          OFF $ ?
     
     STATUS
          Multiple arbitrary character matching is not implemented.



     --------------------------------------------------------------------------
     COMMAND
          autosave - set autosave period
     
     SYNTAX
          [SET] AUtosave n|OFF
     
     DESCRIPTION
          The AUTOSAVE command sets the interval between automatic saves
          of the file, or turns it off altogether.
     
     COMPATIBILITY
          XEDIT: Does not support [mode] option.
          KEDIT: Compatible.
     
     DEFAULT
          OFF
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          backup - indicate if a backup copy of the file is to be kept
     
     SYNTAX
          [SET] BACKup OFF|TEMP|KEEP|ON
     
     DESCRIPTION
          The BACKUP command allows the user to determine if a backup copy
          of the original file is to be kept when the file being edited is
          saved or filed.
     
          BACKUP KEEP and BACKUP ON are the same. BACKUP ON is kept for
          compatability with previous versions of THE.
     
          With BACKUP OFF, the file being written to disk will replace an
          existing file. There is a chance that you will end up with neither
          the old version of the file or the new one if problems occur
          while the file is being written.
     
          With BACKUP TEMP or KEEP, the file being written is first renamed
          to the filename with a .bak extension. The file in memory is 
          then written to disk. If BACKUP TEMP is in effect, the backup
          file is then deleted.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          KEEP
     
     SEE ALSO
          FILE, FFILE, SAVE, SSAVE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          beep - turn on or off the audible alarm when displaying errors
     
     SYNTAX
          [SET] BEEP ON|OFF
     
     DESCRIPTION
          The BEEP command allows the user to determine if an audible alarm
          is sounded when an error is displayed.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          OFF
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          case - set case sensitivity parameters
     
     SYNTAX
          [SET] CASE Mixed|Lower|Upper [Respect|Ignore] [Respect|Ignore] 
                     [Respect|Ignore]
     
     DESCRIPTION
          The CASE command sets the editor's handling of the case of text.
     
          The first option (which is mandatory) controls how text is entered
          by the user. When LOWER or UPPER are in effect, the shift or caps
          lock keys have no effect on the text being entered. When MIXED is
          in effect, text is entered in the case set by the use of the shift
          and caps lock keys.
     
          The second option determines how the editor determines if a string
          target matches text in the file when the target is used in a LOCATE
          command.  With IGNORE in effect, a match is
          found irrespective of the case of the target or the found text.
          The following strings are treated as equivalent: the THE The ThE...
          With RESPECT in effect, the target and text must be the same case.
          Therefore a target of 'The' only matches text containing 'The', not
          'THE' or 'ThE' etc.
     
          The third option determines how the editor determines if a string
          target matches text in the file when the target is used in a CHANGE
          command.  With IGNORE in effect, a match is
          found irrespective of the case of the target or the found text.
          The following strings are treated as equivalent: the THE The ThE...
          With RESPECT in effect, the target and text must be the same case.
          Therefore a target of 'The' only matches text containing 'The', not
          'THE' or 'ThE' etc.
     
          The fourth option determines how the editor determines the sort 
          order of upper and lower case with the SORT command.
          With IGNORE in effect, upper and lower case letters are treated as
          equivalent.
          With RESPECT in effect, upper and lower case letters are treated as
          different values and uppercase characters will sort before lowercase
          characters.
     
     COMPATIBILITY
          XEDIT: Adds support for case significance in CHANGE commands.
          KEDIT: Adds support for LOWER option.
          Both:  Adds support for case significance in SORT command.
     
     DEFAULT
          MIXED IGNORE RESPECT RESPECT
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          clearscreen - indicate if the screen is to be cleared on exit
     
     SYNTAX
          [SET] CLEARScreen ON|OFF
     
     DESCRIPTION
          The CLEARSCREEN command allows the user to request that the 
          screen be cleared on exit from THE.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          OFF
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          clock - turn on or off display of time on status line
     
     SYNTAX
          [SET] CLOCK ON|OFF
     
     DESCRIPTION
          The CLOCK command turns on or off the display of the time on the
          status line.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          ON
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          cmdarrows - sets the behaviour of the up and down arrow keys
     
     SYNTAX
          [SET] CMDArrows Retrieve|Tab 
     
     DESCRIPTION
          The CMDARROWS command determines the action that occurs when the
          up and down arrows keys are hit while on the command line.
     
          CMDARROWS RETRIEVE (the default) will set the up and down arrows 
          to retrieve the last or next command entered on the command 
          line.
     
          CMDARROWS TAB will set the up and down arrows to move to the last 
          or first line respectively of the main window.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          RETRIEVE
     
     SEE ALSO
          CURSOR
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          cmdline - sets the position of the command line.
     
     SYNTAX
          [SET] CMDline ON|OFF|Top|Bottom
     
     DESCRIPTION
          The CMDLINE command sets the position of the command line, either
          at the top of the screen, the bottom of the screen or off.
     
     COMPATIBILITY
          XEDIT: Compatible.
                 CMDLINE ON is equivalent to CMDLINE BOTTOM
          KEDIT: Compatible. 
     
     DEFAULT
          BOTTOM
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          colour - set colours for display
     
     SYNTAX
          [SET] COLOUR area [modifier[...]] [foreground background]
          [SET] COLOR  area [modifier[...]] [foreground background]
     
     DESCRIPTION
          The COLOUR command changes the colours or display attributes of
          various display areas in THE.
     
          Valid values for 'area':
            Arrow    - command line prompt
            Block    - marked block
            CBlock   - current line if in marked block
            Cmdline  - command line
            CTofeof  - as above if the same as current line
            CUrline  - the current line
            Divider  - dividing line between vertical split screens
            Filearea - area containing file lines
            Idline   - line containing file specific info
            Msgline  - error messages
            Pending  - pending commands in prefix
            PRefix   - prefix area
            Reserved - any reserved lines
            Scale    - line showing scale line
            SHadow   - hidden line marker lines
            STatarea - line showing status of editing session
            Tabline  - line showing tab positions
            TOfeof   - *** Top of File *** and *** Bottom of File *** lines
     
          Valid values for 'foreground' and 'background':
            black,blue,green,cyan,red,magenta,yellow,white
     
          Valid values for 'modifier':
            normal,blink,bold,bright,high,reverse,underline
     
          It is an error to attempt to set a colour on a mono display.
     
     COMPATIBILITY
          XEDIT: Functionally compatible. See below.
          KEDIT: Functionally compatible. See below.
          Does not implement all modifiers.
     
     DEFAULT
          Depends on compatibility mode setting.
     
     SEE ALSO
          SET COMPAT
     
     STATUS  
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          compat - set compatibility mode
     
     SYNTAX
          [SET] COMPat The|Xedit|Kedit
     
     DESCRIPTION
          The COMPAT command changes some settings of THE to make it 
          more compatible with the behaviour of XEDIT and KEDIT.
     
          This command is most useful as the first [SET] command in a
          profile file. It will change the default settings of THE to
          initially look like the chosen editor. You can then make any
          additional changes in THE by issuing other [SET] commands.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          THE
     
     STATUS  
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          curline - set position of current line on screen
     
     SYNTAX
          [SET] CURLine M[+n|-n] | [+|-]n
     
     DESCRIPTION
          The CURLINE command sets the position of the current line to
          the physical screen line specified by supplied arguments.
     
          The two forms of parameters are:
          M[+n|-n] - this sets the current line to be relative to the
                     middle of the screen. A positvie value adds to the
                     middle line number, a negative subtracts from it.
                     eg. M+3 on a 24 line screen will be line 15
                         M-5 on a 24 line screen will be line 7
     
          [+|-]n   - this sets the current line to be relative to the
                     top of the screen (if positive or no sign) or
                     relative to the bottom of the screen if negative.
                     eg. +3 or 3 will set current line to line 3
                         -3 on a 24 line screen will be line 21
     
          If the resulting line is outside the bounds of the screen
          the position of the current line will become the middle line
          on the screen.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          +6
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          dirinclude - set the file mask for directory command
     
     SYNTAX
          [SET] DIRInclude * 
          [SET] DIRInclude [Normal] [Readonly] [System] [Hidden] [Directory]
     
     DESCRIPTION
          The DIRINCLUDE command sets the file mask for files that will be
          displayed on subsequent DIRECTORY commands. The operand "*" will
          set the mask to all files, the other options will set the
          mask to include those options specified together with "normal"
          files eg.
     
           DIRINCLUDE R S
     
          will display readonly and system files together with "normal" files
          the next time the DIRECTORY command is issued.
     
          The effects of DIRINCLUDE are ignored in the Unix version.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          *
     
     SEE ALSO
          DIRECTORY, LS
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          display - specify which level of lines to display
     
     SYNTAX
          [SET] DISPlay n [m|*]
     
     DESCRIPTION
          The DISPLAY command sets the selection level for lines to be
          displayed on the screen.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          0 0
     
     SEE ALSO
          SET SCOPE, SET SELECT, ALL
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          eolout - set end of line terminating character(s)
     
     SYNTAX
          [SET] EOLout CRLF|LF|CR
     
     DESCRIPTION
          The EOLOUT command allows the user to specify the combination of
          characters that terminate a line. Lines of text in Unix files are
          usually terminated with a LF, DOS file usually end with a CR and 
          LF combination. Files on the Apple Macintosh are usually terminated
          with a CR.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          LF - Unix, CRLF - DOS/OS2
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          etmode - indicate if extended display mode is possible
     
     SYNTAX
          [SET] ETMODE ON|OFF
     
     DESCRIPTION
          The ETMODE command allows the user to specify if extended ASCII
          codes ( > 127) are to be displayed or should be displayed as
          the NONDISP character.
     
     COMPATIBILITY
          XEDIT: Similar function but deals with Double-Byte characters
          KEDIT: N/A
     
     DEFAULT
          ON - DOS/OS2, OFF - Unix
     
     SEE ALSO
          SET NONDISP
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          hex - set how hexidecimal strings are treated in string operands
     
     SYNTAX
          [SET] HEX ON|OFF
     
     DESCRIPTION
          The HEX set command determines whether hexidecimal strings are
          treated as such in string operands.
          With HEX ON, any string operand of the form
             /x'31 32 33'/ or
             /d'49 50 51'/
          will be converted to /123/ before the command is executed.
          With HEX OFF, no conversion is done.
     
          This conversion should work wherever a string operand is used
          in any command.
     
     COMPATIBILITY
          XEDIT: Adds support for decimal representation. See below.
          KEDIT: Compatible. See below.
          Spaces must seperate each character representation.
     
     DEFAULT
          OFF
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          hexdisplay - turn on or off display of character under cursor
     
     SYNTAX
          [SET] HEXDISPlay ON|OFF
     
     DESCRIPTION
          The HEXDISPLAY command turns on or off the display of the character under
          the cursor on the status line.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          ON
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          hexshow - turn on or off hex display of current line
     
     SYNTAX
          [SET] HEXShow ON|OFF [M[+n|-n]|[+|-]n]
     
     DESCRIPTION
          The HEXShow command indicates if and where a hexidecimal
          representation of the current line will be displayed.
     
          The two forms of the position parameters are:
          M[+n|-n] - this sets the hexshow line to be relative to the
                     middle of the screen. A positive value adds to the
                     middle line number, a negative subtracts from it.
                     eg. M+3 on a 24 line screen will be line 15
                         M-5 on a 24 line screen will be line 7
     
          [+|-]n   - this sets the hexshow line to be relative to the
                     top of the screen (if positive or no sign) or
                     relative to the bottom of the screen if negative.
                     eg. +3 or 3 will set scale line to line 3
                         -3 on a 24 line screen will be line 21
     
          If the resulting line is outside the bounds of the screen
          the position of the hexshow line will become the middle line
          on the screen.
     
          The position argument specifies the position of the first line
          of the hexidecimal display.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          OFF 7
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          idline - specify if IDLINE is displayed
     
     SYNTAX
          [SET] IDline ON|OFF
     
     DESCRIPTION
          The IDLINE set command determines if the IDLINE for a file is
          displayed or not.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          ON
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          impcmscp - set implied operating system command processing
     
     SYNTAX
          [SET] IMPcmscp ON|OFF
     
     DESCRIPTION
          The IMPCMSCP command is used to toggle implied operating system
          command processing from the command line. By turning this feature 
          on you can then issue an operating system command without the need 
          to prefix the operating system command with the OS command.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: N/A
     
     DEFAULT
          ON
     
     SEE ALSO
          SET IMPOS
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          impmacro - set implied macro command processing
     
     SYNTAX
          [SET] IMPMACro ON|OFF
     
     DESCRIPTION
          The IMPMACRO command is used to toggle implied macro processing
          from the command line. By turning this feature on you can then
          issue a macro command without the need to prefix the macro name
          with the MACRO command.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          ON
     
     SEE ALSO
          MACRO, SET MACROPATH
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          impos - set implied operating system command processing
     
     SYNTAX
          [SET] IMPOS ON|OFF
     
     DESCRIPTION
          The IMPOS command is used to toggle implied operating system
          command processing from the command line. By turning this feature 
          on you can then issue an operating system command without the need 
          to prefix the operating system command with the OS command.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: N/A
     
     DEFAULT
          ON
     
     SEE ALSO
          SET IMPCMSCP
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          insertmode - put editor into or out of insert mode
     
     SYNTAX
          [SET] INSERTMode ON|OFF|TOGGLE
     
     DESCRIPTION
          The INSERTMODE command toggles the insert mode within THE.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          OFF
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          linend - allow/disallow multiple commands on command line
     
     SYNTAX
          [SET] LINENd ON|OFF [char]
     
     DESCRIPTION
          The LINEND command allows or disallows the execution of multiple
          commands on the command line. When setting LINEND ON, a character
          is specified as the LINEND character which delimits each command.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          OFF #
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          macroext - set default macro extension value
     
     SYNTAX
          [SET] MACROExt [ext]
     
     DESCRIPTION
          The MACROEXT command sets the value of the file extension to be
          used for macro files. When a macro file name is specified on the
          command line, a fullstop '.' then this value will be appended.
          If no value is specified for ext, then THE assumes that the
          supplied macro file name is the fully specified name for a macro.
     
          The length of ext must be 10 characters or less.
     
          The macro extension is only appended to a file if that file does
          not include any path specifiers.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          the
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          macropath - set default path for macro commands
     
     SYNTAX
          [SET] MACROPath path[s]
     
     DESCRIPTION
          The MACROPATH command sets up the search path from which macro
          command files are executed. Each directory is seperated by a
          colon (Unix) or semi-colon (DOS & OS/2).
          No check is done at this stage to validate the supplied path.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Incompatible.
     
     DEFAULT
          Path specified by env variable THE_MACRO_PATH
     
     SEE ALSO
          MACRO, SET IMPMACRO
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          margins - set left and right margins for wordwrap
     
     SYNTAX
          [SET] MARgins left right [[+|-]indent]
     
     DESCRIPTION
          The MARGINS command sets the left and right margins and the
          number of columns to indent a paragraph.
          These values are used with the WORDWRAP option.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          1 72 +0
     
     SEE ALSO
          SET WORDWRAP
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          msgline - set position and size of message line
     
     SYNTAX
          [SET] MSGLine ON [M[+n|-n]|[+|-]n] [lines]
     
     DESCRIPTION
          The MSGLINE set command specifies the position of the message line
          and the size of the message line window.
     
          The two forms of the position parameters are:
          M[+n|-n] - this sets the first line to be relative to the
                     middle of the screen. A positive value adds to the
                     middle line number, a negative subtracts from it.
                     eg. M+3 on a 24 line screen will be line 15
                         M-5 on a 24 line screen will be line 7
     
          [+|-]n   - this sets the first line to be relative to the
                     top of the screen (if positive or no sign) or
                     relative to the bottom of the screen if negative.
                     eg. +3 or 3 will set tab line to line 3
                         -3 on a 24 line screen will be line 21
     
          If the resulting line is outside the bounds of the screen
          the position of the message line will become the middle line
          on the screen.
     
     COMPATIBILITY
          XEDIT: Compatible.
                 Does not support OVERLAY option.
          KEDIT: Compatible
                 Does not support OVERLAY option.
     
     DEFAULT
          ON 2 1
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          msgmode - set display of messages on or off
     
     SYNTAX
          [SET] MSGMode ON|OFF
     
     DESCRIPTION
          The MSGMODE set command determines whether error messages will be 
          displayed or suppressed.
     
     COMPATIBILITY
          XEDIT: Does not support [Short|Long] options.
          KEDIT: Compatible
     
     DEFAULT
          ON
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          newlines - set position of cursor after adding blank line
     
     SYNTAX
          [SET] NEWLines Aligned|Left
     
     DESCRIPTION
          The NEWLINES set command determines where the cursor displays after
          a new line is added to the file.
          With ALIGNED, the cursor will display in the column of the new line
          immediately underneath the first non-blank character in the line
          above.
          With LEFT, the cursor will display in the first column of the new line.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Same command, different functionality.
     
     DEFAULT
          ALIGNED
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          nondisp - specify character to display for non-displaying characters
     
     SYNTAX
          [SET] NONDisp char
     
     DESCRIPTION
          The NONDISP command allows the user to change the character that 
          is displayed for non-displaying commands when [SET] ETMODE is OFF.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: N/A
     
     DEFAULT
          #
     
     SEE ALSO
          SET ETMODE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          number - turn prefix numbers on or off
     
     SYNTAX
          [SET] NUMber ON|OFF
     
     DESCRIPTION
          The NUMBER command allows the user to toggle the display of numbers
          in the prefix area.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          ON
     
     SEE ALSO
          SET PREFIX
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          pending - set status of pending prefix commands
     
     SYNTAX
          [SET] PENDing ON string
          [SET] PENDing OFF
          [SET] PENDing BLOCK string
     
     DESCRIPTION
          The PENDING command allows the user to insert or remove commands
          from the pending prefix list.
     
          ON string, simulates the user typing 'string' in the PREFIX area
          of the focus line.
     
          OFF, removes any pending prefix command from the focus line.
     
          BLOCK string, simulates the user typing 'string' in the PREFIX
          area of the focus line and identifies the prefix command to be 
          a BLOCK command.
     
     COMPATIBILITY
          XEDIT: Does not support ERROR option.
          KEDIT: N/A
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          point - assign a name to the current line
     
     SYNTAX
          [SET] Point .name [OFF]
     
     DESCRIPTION
          The POINT command assignes the specified name to the current
          line, or removes the name from the line with the specified name.
          A valid line name must start with a '.' followed by an alphabetic
          character. eg. .a .fred and .GG are valid names; fred and .3 are
          invalid line names.
     
          When a line is moved within the same file, its line name stays
          with the line.
     
     COMPATIBILITY
          XEDIT: Compatible. See below.
          KEDIT: Compatible. See below.
          Does not allow for multiple names for the same line.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          position - determine if LINE/COL is displayed on IDLINE
     
     SYNTAX
          [SET] POSition ON|OFF
     
     DESCRIPTION
          The POSITION command allows the user to turn on or off the
          display of LINE/COL on the IDLINE.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          ON
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          prefix - set prefix area attributes
     
     SYNTAX
          [SET] PREfix ON [Left|Right]
          [SET] PREfix Nulls [Left|Right]
          [SET] PREfix OFF
          [SET] PREfix Synonym newname oldname
     
     DESCRIPTION
          The first form of the PREFIX command allows the user to display
          the prefix area and optionally to select the position the prefix
          should be displayed at.
     
          The second form of the PREFIX command is functionally the same
          as the first form. The difference is that when the prefix area
          is displayed with NUMBER ON, numbers are displyed with leading
          spaces rather than zeros; with NUMBER OFF, blanks are displayed
          instead of equal signs.
     
          The third form, turns the display of the prefix area off.
          Executed from within the profile, the only effect is that the
          defaults for all files is changed.
          Executed from the command line, the PREFIX command changes the
          current window displays to reflect the required options.
     
          The fourth form of the PREFIX command allows the users to specify
          a synonym for a prefix command or REXX prefix macro. The 'newname'
          is the command entered in the prefix area and 'oldname' corresponds
          to an existing prefix command or a REXX macro file in the MACROPATH
          ending in .the or whatever the value of MACROEXT is at the time the
          prefix command is executed. The 'oldname' can also be the fully
          qualified filename of a REXX macro.
     
     COMPATIBILITY
          XEDIT: Compatible. See below.
          KEDIT: Compatible. See below.
     
     DEFAULT
          ON LEFT
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          printer - define printer spooler name
     
     SYNTAX
          [SET] PRINTER spooler
     
     DESCRIPTION
          The PRINTER command sets up the print spooler name to determine
          where output from the PRINT command goes.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          LPT1 - DOS/OS2, lpr - Unix
     
     SEE ALSO
          PRINT
     
     STATUS
          Complete. 



     --------------------------------------------------------------------------
     COMMAND
          reprofile - indicate if profile file to be executed for all files
     
     SYNTAX
          [SET] REPROFile ON|OFF
     
     DESCRIPTION
          The REPROFILE command allows the user to determine if the profile
          file is to reexecuted for files subsequenlty edited.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          OFF
     
     SEE ALSO
          XEDIT
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          reserved - display a reserved line
     
     SYNTAX
          [SET] RESERved +|-n [colour] [text|OFF]
     
     DESCRIPTION
          The RESERVED command reseves a line for the display of arbitrary
          text by the user. The position is determined by +|-n.
          This number, if positive, specifies the line relative from the
          top of the display. A negative number is relative from the
          bottom of the display.
     
          By specifying a line, say +3, then THREE lines from the top will
          be reserved, with the supplied text being displayed in line 3.
     
          The idline of a file will always be displayed after any reserved
          lines.
     
          The statusline is not considered part of the displayable area,
          so any positioning specifications ignore that line.
     
          A reserved line can only be turned off by identifying it in the
          same way that it was defined.  If a reserved line was added with
          the position specification of -1, it cannot be turned off with
          a position specification of 23, even though both position 
          specifiers result in the same display line.
     
          The colour option specifies the colours to use to display the
          reserved line.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     SEE ALSO
          SET COLOUR
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          rexxoutput - indicate where REXX output is to go
     
     SYNTAX
          [SET] REXXOUTput File|Display n
     
     DESCRIPTION
          The REXXOUTPUT command indicates where output from the REXX
          interpreter is to go; either captured to a file in the ring
          or displayed in a scrolling fashion on the screen.
     
          Also specified is the maximum number of lines from the REXX
          interpreter that are to be displayed or captured. This is
          particularly useful when a REXX macro gets into an infinite
          loop.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          DISPLAY 1000
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          scale - set position and status of scale line on screen
     
     SYNTAX
          [SET] SCALe ON|OFF [M[+n|-n]|[+|-]n]
     
     DESCRIPTION
          The SCALE command sets the position and status of the scale line
          for the current view.
     
          The two forms of the position parameters are:
          M[+n|-n] - this sets the scale line to be relative to the
                     middle of the screen. A positive value adds to the
                     middle line number, a negative subtracts from it.
                     eg. M+3 on a 24 line screen will be line 15
                         M-5 on a 24 line screen will be line 7
     
          [+|-]n   - this sets the scale line to be relative to the
                     top of the screen (if positive or no sign) or
                     relative to the bottom of the screen if negative.
                     eg. +3 or 3 will set scale line to line 3
                         -3 on a 24 line screen will be line 21
     
          If the resulting line is outside the bounds of the screen
          the position of the current line will become the middle line
          on the screen.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          OFF M+1
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          scope - sets which lines are to be excluded from commands
     
     SYNTAX
          [SET] SCOPE All|Display
     
     DESCRIPTION
          The SCOPE command indicates whether lines not displayed as
          the result of a SET DISPLAY or ALL command are included in
          the scope of lines to be acted upon by other THE commands.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          DISPLAY
     
     SEE ALSO
          SET DISPLAY, SET SELECT, ALL
     
     STATUS
          Completed.



     --------------------------------------------------------------------------
     COMMAND
          screen - specifiy number of screens displayed
     
     SYNTAX
          [SET] SCReen n [Horizontal|Vertical]
     
     DESCRIPTION
          The SCREEN command specifies the number of views of file(s) to
          display on screen at once. If the number of views specified is 2
          and only one file is currently in the ring, two views of the
          same file are displayed.
     
     COMPATIBILITY
          XEDIT: Does not support Size,Width or Define options.
          KEDIT: Does not support Size option.
          Only 2 screens are supported.
     
     DEFAULT
          1
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          select - sets the selection level for the specified lines
     
     SYNTAX
          [SET] SELect [+|-]n [target]
     
     DESCRIPTION
          The SELECT command sets the selection level for the indicated
          lines equal to n (if no signs are specified) or adds or subtracts
          n from the selection level currently set for the lines in the
          target.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          0
     
     SEE ALSO
          SET SCOPE, SET DISPLAY, ALL
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          shadow - determines if shadow lines are displayed or not
     
     SYNTAX
          [SET] SHADOW ON|OFF
     
     DESCRIPTION
          The SHADOW command indicates whether shadow lines are to be
          displayed.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          ON
     
     SEE ALSO
          SET DISPLAY, SET SELECT, ALL
     
     STATUS
          Completed.



     --------------------------------------------------------------------------
     COMMAND
          statusline - set position of status line
     
     SYNTAX
          [SET] STATUSLine Top|Bottom|Off|GUI
     
     DESCRIPTION
     
          The STATUSLINE command determines the position of the status
          line for the editing session. TOP will place the status line on
          the first line of the screen; BOTTOM will place the status line
          on the last line of the screen; OFF turns off the display of
          the status line.
     
          The GUI option is only meaningful for those platforms that support
          a separate status line window. If specified for non-GUI ports, the
          GUI option is equivalent to OFF.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
                 Added GUI option.
     
     DEFAULT
          BOTTOM
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          stay - set condition of cursor position after CHANGE/LOCATE commands
     
     SYNTAX
          [SET] STAY ON|OFF
     
     DESCRIPTION
          The STAY set command determines what line is displayed as the current
          line after an unsuccessful LOCATE or successful CHANGE command.
          With STAY ON, the current line remains where it currently is. With
          STAY OFF, after an unsuccessful LOCATE, the current line is "Bottom
          of File". After a successful CHANGE, the current line is the last
          line affected by the CHANGE command.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          ON
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          synonym - define synonyms for commands
     
     SYNTAX
          [SET] SYNonym ON|OFF
          [SET] SYNonym [LINEND char] newname [n] oldname
     
     DESCRIPTION
          The SYNONYM command allows the user to define synonyms for commands
          or macros.
     
          The first format indicates if synonym processing is to be performed.
     
          The second format specifies the name to be associated with the
          following commands.
     
     COMPATIBILITY
          XEDIT: Does not support the formatting option.
          KEDIT: Compatible.
     
     DEFAULT
          ON
     
     STATUS
          Incomplete.



     --------------------------------------------------------------------------
     COMMAND
          tabkey - set characteristics of the SOS TABF command
     
     SYNTAX
          [SET] TABKey Tab|Character Tab|Character
     
     DESCRIPTION
          The TABKEY sets the action to be taken when the SOS TABF command
          is executed. Depending on the insert mode, the SOS TABF command
          will either display a raw tab character or will move to the next
          tab column.
          The first operand refers to the behaviour of the SOS TABF command
          when INSERTMODE is OFF; the second operand specifies the behaviour
          when the SOS TABF command is executed when INSERTMODE is ON.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          TAB CHARACTER
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          tabline - set position and status of tab line on screen
     
     SYNTAX
          [SET] TABLine ON|OFF [M[+n|-n]|[+|-]n]
     
     DESCRIPTION
          The TABLINE command sets the position and status of the tab line
          for the current view.
     
          The two forms of the position parameters are:
          M[+n|-n] - this sets the tab line to be relative to the
                     middle of the screen. A positive value adds to the
                     middle line number, a negative subtracts from it.
                     eg. M+3 on a 24 line screen will be line 15
                         M-5 on a 24 line screen will be line 7
     
          [+|-]n   - this sets the tab line to be relative to the
                     top of the screen (if positive or no sign) or
                     relative to the bottom of the screen if negative.
                     eg. +3 or 3 will set tab line to line 3
                         -3 on a 24 line screen will be line 21
     
          If the resulting line is outside the bounds of the screen
          the position of the current line will become the middle line
          on the screen.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          OFF -3
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          tabs - set tab length for TAB key
     
     SYNTAX
          [SET] TABS n1 n2[n3...n32]
          [SET] TABS INCR n
     
     DESCRIPTION
          The TABS command determines the position of tab columns when the
          SOS TABF or SOS TABB commands are executed.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          INCR 8
     
     SEE ALSO
          SOS TABF, SOS TABB
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          tabsin - set tab processing on file input
     
     SYNTAX
          [SET] TABSIn ON|OFF [n]
     
     DESCRIPTION
          The TABSIN command determines if tabs read from a file are to be
          expanded to spaces and if so how many spaces.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Does not support TABQUOTE option.
     
     DEFAULT
          OFF 8
     
     SEE ALSO
          SET TABSOUT
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          tabsout - set tab processing on file output
     
     SYNTAX
          [SET] TABSOut ON|OFF [n]
     
     DESCRIPTION
          The TABSOUT command determines if spaces written to a file are to be
          compressed to tabs and if so how many spaces.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          OFF 8
     
     SEE ALSO
          SET TABSIN
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          typeahead - set behavior of screen redraw
     
     SYNTAX
          [SET] TYPEAhead ON|OFF
     
     DESCRIPTION
          The TYPEAHEAD set command determines whether or not THE uses the
          curses screen display optimization techniques.
          With TYPEAHEAD ON, curses will abort screen display if a keystroke
          is pending.
          With TYPEAHEAD OFF, curses will not abort screen display if a
          keystroke is pending.
          For BSD based curses, this function has no effect.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: N/A
     
     DEFAULT
          ON
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          verify - set column display limits
     
     SYNTAX
          [SET] Verify first [last]
     
     DESCRIPTION
          The VERIFY command sets the column limits for the display of the
          current file. 'first' specifies the first column to be displayed
          and 'last' specifies the last column to be displayed.
     
          If no 'last' option is specified '*' is assumed.
     
     COMPATIBILITY
          XEDIT: Does not implement HEX display nor multiple column pairs.
          KEDIT: Does not implement HEX display nor multiple column pairs.
     
     DEFAULT
          1 *
     
     SEE ALSO
          SET ZONE
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          wordwrap - set wordwrap feature on or off
     
     SYNTAX
          [SET] WORDWrap ON|OFF
     
     DESCRIPTION
          The WORDWRAP set command determines whether wordwrap occurs when
          the cursor moves past the right margin (as set my [SET] MARGINS
          command).
          With WORDWRAP ON, the line, from the beginning of the word that
          exceeds the right margin, is wrapped onto the next line. The cursor
          position stays in the same position relative to the current word.
          WIth WORDWRAP OFF, no word wrap occurs.
     
     COMPATIBILITY
          XEDIT: N/A
          KEDIT: Compatible.
     
     DEFAULT
          OFF
     
     SEE ALSO
          SET MARGINS
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          zone - set column limits for editing
     
     SYNTAX
          [SET] Zone first [last]
     
     DESCRIPTION
          The ZONE command sets the column limits for various other editor
          commands, such as 'locate' and 'change'. It effectively restricts
          to the specified columns those parts of the file which can be
          acted upon.
     
          If no 'last' option is specified '*' is assumed.
     
     COMPATIBILITY
          XEDIT: Compatible.
          KEDIT: Compatible.
     
     DEFAULT
          1 *
     
     SEE ALSO
          SET VERIFY
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     
     
     ========================================================================
     QUERY, EXTRACT and STATUS
     ========================================================================
     
          The following lists the valid variables that can be queried and
          also shows what values are returned. For both QUERY and STATUS,
          the values are concatenated together and displayed as a single
          line. For EXTRACT the REXX variables that are set are defined.
          The capitalised portion of the variable is the minimum abbreviation
          recognised.
          The bracketed text at the end of the description indicates from
          which commands a valid response will be supplied (Q-Query,E-Extract
          M-Modify and S-Status).
     
     ALT
          The number of alterations to the current file since the last SAVE
          or AUTOSAVE.
          (QES)
     
          alt.0           - 2
          alt.1           - Number of alterations since last SAVE or AUTOSAVE
          alt.2           - Number of alterations since last SAVE
     
     ARBchar
          The status of ARBCHAR and the ARBCHAR characters.
          (QEMS)
     
          arbchar.0       - 3
          arbchar.1       - ON|OFF
          arbchar.2       - multiple match character
          arbchar.3       - single match character
     
     AUtosave
          The status of AUTOSAVE and/or the frequency setting.
          (QEMS)
     
          autosave.0      - 1
          autosave.1      - OFF|n
     
     BACKup
          Indicates if a .bak file is kept after editing.
          (QEMS)
     
          backup.0        - 1
          backup.1        - ON|OFF|TEMP|KEEP
     
     BEEP
          Indicates if the bell is sounded on display of error messages.
          (QEMS)
     
          beep.0          - 1
          beep.1          - ON|OFF
     
     BLOCK
          Returns information about the marked block, if any.
          (E)
     
          block.0         - 6 if a marked block exists, or 1 for NONE
          block.1         - type of marked block (LINE|BOX|NONE|WORD|COLUMN)
          block.2         - line number of start of block
          block.3         - column number of start of block
          block.4         - line number of end of block
          block.5         - column number of end of block
          block.6         - file name containing marked block
     
     CASE
          The settings related to the CASE of characters entered, searched
          for, changed and sorted.
          (QEMS)
     
          case.0          - 4
          case.1          - MIXED|UPPER|LOWER
          case.2          - RESPECT|IGNORE
          case.3          - RESPECT|IGNORE
          case.4          - RESPECT|IGNORE
     
     CLEARScreen
          Indicates if the screen is cleared on exit from THE.
          (QEMS)
     
          clearscreen.0   - 1
          clearscreen.1   - ON|OFF
     
     CLOCK
          Indicates if the time is displayed on the status line.
          (QEMS)
     
          clock.0         - 1
          clock.1         - ON|OFF
     
     CMDArrows
          Returns the settings for arrow key behaviour.
          (QEMS)
     
          cmdarrows.0     - 1
          cmdarrows.1     - RETRIEVE|TAB
     
     CMDline
          The settings for the command line.
          (QEMS)
     
          If CMDLINE OFF
     
          cmdline.0       - 1
          cmdline.1       - OFF
     
          If CMDLINE ON, BOTTOM or TOP
     
          cmdline.0       - 3
          cmdline.1       - ON|TOP|BOTTOM
          cmdline.2 *     - line number within window of command line
          cmdline.3 *     - contents of command line
                    * these values are only returned with EXTRACT
     
     COMPAT
          The settings for the compatibility mode.
          (QEMS)
     
          compat.0        - 1
          compat.1        - THE|XEDIT|KEDIT
     
     CURline
          The value and position of the current line within the current file.
          (QEMS)
     
          With EXTract command:
     
          curline.0       - 3
          curline.1       - curline setting
          curline.2       - line number within window of current line
          curline.3       - contents of current line
     
          With Query,Modify and Status commands:
     
          curline.0       - 1
          curline.1       - curline setting
     
     CURSor
          The position of the cursor within the displayed screen and file
          at the time the EXTRACT /CURSOR/ is issued and the position of
          the cursor at the time the macro was issued.
          If the cursor is not in the file area, then line and column
          values will be set to -1.
          (QE)
     
          cursor.0        - 8
          cursor.1        - line number of cursor in screen (current)
          cursor.2        - column number of cursor in screen (current)
          cursor.3        - line number of cursor in file (current)
          cursor.4        - column number of cursor in file (current)
          cursor.5        - line number of cursor in screen (original)
          cursor.6        - column number of cursor in screen (original)
          cursor.7        - line number of cursor in file (original)
          cursor.8        - column number of cursor in file (original)
     
     DIRFILEID
          The value of the path and filename of the focus line in a DIR.DIR
          file.
          (E)
     
          dirfileid.0     - 2
          dirfileid.1     - full path of directory
          dirfileid.2     - file name at focus line
     
     DISPlay
          Indicates the range of selection levels current.
          (QEMS)
     
          display.0       - 2
          display.1       - display low value
          display.2       - display high value
     
     EOF
          Indicates if the current line is on the *** Bottom of file *** line.
          (QES)
     
          eof.0           - 1
          eof.1           - ON|OFF
     
     EOLout
          Returns the value of the end-of-line character(s).
          (QEMS)
     
          eolout.0        - 1
          eolout.1        - LF|CRLF|CR
     
     ETMODE
          Indicates if extended display mode is set.
          (QEMS)
     
          etmode.0        - 1
          etmode.1        - ON|OFF
     
     FNAME
          The file name of the current file.
          (E)
     
          fname.0         - 1
          fname.1         - File name.
     
     FPATH
          The path name of the current file. This includes a trailing
          directory separator.
          (E)
     
          fpath.0         - 1
          fpath.1         - File path.
     
     FTYPE
          The extension of the current file. The characters following
          the trailing '.' character.
          (E)
     
          ftype.0         - 1
          ftype.1         - File extension.
     
     GETENV variable
          The value of the supplied environment variable or ***invalid***
          if the variable does not exist.
          (E)
     
          getenv.0        - 1
          getenv.1        - value of variable
     
     HEX
          Indicates if HEX is on or off.
          (QEMS)
     
          hex.0           - 1
          hex.1           - ON|OFF
     
     HEXDISPlay
          Indicates if the current character is displayed on the status line.
          (QEMS)
     
          hexdisplay.0    - 1
          hexdisplay.1    - ON|OFF
     
     HEXShow
          Returns details of HEXSHOW placement.
          (QEMS)
     
          hexshow.0       - 2
          hexshow.1       - ON|OFF
          hexshow.2       - line displaying first hexshow line
     
     IDline
          Indicates if the id line is displayed for a file.
          (QEMS)
     
          idline.0        - 1
          idline.1        - ON|OFF
     
     IMPMACro
          Indicates if implied macro processing is on or off.
          (QEMS)
     
          impmacro.0      - 1
          impmacro.1      - ON|OFF
     
     IMPOS
          Indicates if implied operating system command processing is on 
          or off.
          (QEMS)
     
          impos.0         - 1
          impos.1         - ON|OFF
     
     INSERTmode
          Indicates if currently in insert mode or overstrike mode.
          (QEMS)
     
          insertmode.1    - 1
          insertmode.1    - ON|OFF
     
     LASTmsg
          Return the text of the last error message generated.
          (E)
     
          lastmsg.0       - 1
          lastmsg.1       - text of last message.
     
     LASTRC
          Return code from last command issued from command line.
          (QES)
     
          lastrc.0        - 1
          lastrc.1        - Last return code.
     
     LENgth
          Length of the current line.
          (QES)
     
          length.0        - 1
          length.1        - Length of current line.
     
     LIne
          Line number of current line in current file.
          (QES)
     
          line.0          - 1
          line.1          - Line number
     
     LINENd
          Indicates if multiple commands allowed on command line
          and the delimiter.
          (QEMS)
     
          linend.0        - 2
          linend.1        - ON|OFF
          linend.2        - delimiter
     
     LScreen
          Displays the size of the current screen and window. Also
          shows the upper left corner of the window.
          (QE)
     
          lscreen.0       - 6
          lscreen.1       - height of current window
          lscreen.2       - width of current window
          lscreen.3       - screen line of upper left corner of window
          lscreen.4       - screen column of upper left corner of window
          lscreen.5       - height of screen
          lscreen.6       - width of screen
     
     MACROExt
          The current setting for a macro's file extension.
          (QEMS)
     
          macroext.0      - 1
          macroext.1      - Default file extension
     
     MACROPath
          The path that THE looks for by default for macro files.
          (QEMS)
     
          macropath.0     - 1
          macropath.1     - Path for macro files.
     
     MARgins
          The settings for left and right margins and paragraph indent.
          (QEMS)
     
          margins.0       - 3
          margins.1       - left column
          margins.2       - right column
          margins.3       - indent value (column or offset from left margin)
     
     MONITOR
          Indicates if the combination of monitor and the curses package
          supports colour. If the curses package supports colour, then
          monitor.3 is set to COLOR and monitor.2 can be COLOR or MONO
          depending on whether the monitor supports colour. If monitor.3
          is MONO then monitor.2 will also be set to MONO.
          (QES)
     
          monitor.0       - 2
          monitor.1       - COLOR|MONO
          monitor.2       - COLOR|MONO
     
     MSGLine
          Returns details of where the message line is displayed.
          (QEMS)
     
          msgline.0       - 2
          msgline.1       - ON
          msgline.2       - line position of message line
          msgline.3       - number of message lines available
          msgline.4       - OVERLAY
     
     MSGMode
          Indicates if MSGMODE setting is on or off.
          (QEMS)
     
          msgmode.0       - 1
          msgmode.1       - ON|OFF
     
     NBFile
          Returns with the number of files currently in the ring.
          (QES)
     
          nbfile.0        - 1
          nbfile.1        - Number of files in ring
     
     NEWLines
          Indicates if NEWLINES variable is set to LEFT or ALIGNED.
          (QEMS)
     
          newlines.0      - 1
          newlines.1      - ALIGNED|LEFT
     
     NONDisp
          Returns the character that is displayed for extended characters
          that are not displayed.
          (QEMS)
     
          nondisp.0       - 1
          nondisp.1       - char
     
     NUMber
          Indicates if line numbers are displayed in the prefix area.
          (QEMS)
     
          number.0        - 1
          number.1        - ON|OFF
     
     PENDing [BLOCK] [OLDNAME] name|*
          Returns information about pending prefix commands.
          (E)
     
          pending.0       - 4
          pending.1       - line number in file
          pending.2       - newname - actual name entered in prefix area
          pending.3       - oldname - original name of macro after
                                      synonym resolution
          pending.4       - BLOCK or null
     
     Point [*]
          Returns the name and line number of the focus line, or names and
          line numbers of all lines in a file if '*' is specified.
          (QE)
     
          When 'EXTract /Point' is specified:
     
          point.0         - 0 or 1       (0 if focus line not named)
          point.1         - line number and name of line (if line is named)
     
          When 'EXTract /Point *' is specified:
          (E)
     
          point.0         - number of named lines in the file
          point.1         - line number and name for first named line
          point.n         - line number and name for nth named line
     
     POSition
          Indicates if LINE/COL is displayed on IDLINE
          (QEMS)
     
          position.0      - 3
          position.1      - ON|OFF
          position.2      - current or focus line
          position.3      - current or focus column
     
     PREfix [Synonym name|*]
          Indicates if prefix is displayed for the view and if displayed
          where is is displayed.
          (QEMS)
     
          prefix.0        - 1 or 2     (1 if prefix.1 is OFF, 2 otherwise)
          prefix.1        - ON|OFF|NULLS
          prefix.2        - LEFT|RIGHT        (if prefix.1 is ON or NULLS)
     
          With [Synonym name] option, the name of the macrofile (oldname) 
          is returned that is associated with the synonym, name. If name 
          is not a synonym then name is returned.
          (E)
     
          prefix.0        - 1
          prefix.1        - oldname
     
          With [Synonym *] option, all prefix synonyms are returned.
          (E)
     
          prefix.0        - number of prefix synonyms
          prefix.1        - newname oldname
          prefix.n        - newname oldname
     
     PRINTER
          Returns the value of the printer port or spooler.
          (QEMS)
     
          printer.0       - 1
          printer.1       - port or spooler name
     
     REPROFile
          Indicates if the profile file is to be re-executed for each
          subsequent file to be edited.
          (QEMS)
     
          reprofile.0     - 1
          reprofile.1     - ON|OFF
     
     RESERved
          Return with list of the screen rows that have been reserved.
          (QES)
     
          reserved.0      - 0 if no reserved lines; 1 otherwise
          reserved.1      - list of screen row numbers reserved
     
     REXXOUTput
          Indicates if REXX output is captured to a file or not and the
          line number limit of lines to be displayed.
          (QEMS)
     
          rexxoutput.0    - 2
          rexxoutput.1    - FILE|DISPLAY
          rexxoutput.2    - line number limit
     
     SCOPE
          Returns the status of [SET] SCOPE.
          (QEMS)
     
          scope.0         - 1
          scope.1         - ALL|DISPLAY
     
     SCALe
          Returns details of SCALE line.
          (QEMS)
     
          scale.0         - 2
          scale.1         - ON|OFF
          scale.2         - line displaying scale line
     
     SELect
          Returns the selection level of the focus line and the
          maximum selection level for the file.
          (QES)
     
          select.0        - 2
          select.1        - selection level of focus line
          select.2        - maximum selection level for file
     
     SHADow
          Returns the status of the display of shadow lines.
          (QEMS)
     
          shadow.0        - 1
          shadow.1        - ON|OFF
     
     SIze
          Returns the number of lines in the current file.
          (QES)
     
          size.0          - 1
          size.1          - Lines in current file.
     
     STATUSLine
          The settings for the status line.
          (QEMS)
     
          statusline.0    - 1
          statusline.1    - TOP|BOTTOM|OFF
     
     STAY
          Indicates if STAY is on or off.
          (QEMS)
     
          stay.0          - 1
          stay.1          - ON|OFF
     
     TABKey
          Returns settings about behaviour of TAB key.
          tabkey.1 is behaviour while not in insert mode
          tabkey.2 is behaviour while in insert mode
          (QEMS)
     
          tabkey.0        - 2
          tabkey.1        - TAB|CHARACTER
          tabkey.2        - TAB|CHARACTER
     
     TABLine
          Returns details of TABLine line.
          (QEMS)
     
          tabline.0       - 2
          tabline.1       - ON|OFF
          tabline.2       - line displaying tab line
     
     TABS
          Returns settings about tab columns.
          (QEMS)
     
          tabs.0          - 2
          tabs.1          - tab columns
     
     TABSIn
          Indicates if TABSIN processing is on or off and the size of the
          tabs setting.
          (QEMS)
     
          tabsin.0        - 2
          tabsin.1        - ON|OFF
          tabsin.2        - size of tabs
     
     TABSOut
          Indicates if TABSOUT processing is on or off and the size of the
          tabs setting.
          (QEMS)
     
          tabsout.0       - 2
          tabsout.1       - ON|OFF
          tabsout.2       - size of tabs
     
     TERMinal
          Identifies the terminal type currently being used.
          (QES)
     
          terminal.0      - 1
          terminal.1      - DOS|OS2|$TERM value under Unix
     
     TOF
          Indicates if the current line is on the *** Top of file *** line.
          (QES)
     
          tof.0           - 1
          tof.1           - ON|OFF
     
     Verify
          Returns verify column settings.
          (QEMS)
     
          verify.0        - 1
          verify.1        - Column pair of verify start and end columns.
     
     VERShift
          Returns vertical shift value.
          (QES)
     
          vershift.0      - 1
          vershift.1      - VERSHIFT value
     
     VERSION
          Returns information about name of application (THE) and version
          information.
          (QES)
     
          version.0       - 4
          version.1       - THE
          version.2       - version string eg. 1.5
          version.3       - platform version (DOS,OS2,UNIX)
          version.4       - version status information eg. beta
     
     Width
          Returns maximum line width setting.
          (QES)
     
          width.0         - 1
          width.1         - Maximum line width value.
     
     WORDWrap
          Indicates if WORDWARP is on or off.
          (QEMS)
     
          wordwrap.0      - 1
          wordwrap.1      - ON|OFF
     
     Zone
          Returns zone column settings.
          (QEMS)
     
          zone.0          - 2
          zone.1          - Zone start column
          zone.2          - Zone end column
     
     
     
     ========================================================================
     IMPLIED EXTRACT, BOOLEAN and OTHER FUNCTIONS
     ========================================================================
     
     IMPLIED EXTRACT
     
          The above REXX variables set above by the EXTRACT command may also
          be obtained by a REXX macro as an implied EXTRACT. Each variable
          above that may be set by an explicit EXTRACT command may also be
          used as an external function to REXX to obtain the same information.
          eg. The REXX commands:
     
              'EXTRACT /SIZE/CURLINE/'
              Say size.1 curline.1
     
          may be substituted with:
     
              Say size.1() curline.1()
     
     BOOLEAN FUNCTIONS
     
          THE also provides other information to the REXX interpreter via
          boolean functions. These functions return either '1' or '0'
          depending on the information queried.
     
       after()
          Returns '1' if the cursor is currently after the last non-blank
          character on the line, or if the line is blank.
     
       blank()
          Returns '1' if the line the cursor is on is completely blank.
     
       block()
          Returns '1' if the marked block is within the current view.
     
       before()
          Returns '1' if the cursor is currently before the first non-blank
          character on the line, or if the line is blank.
     
       bottomedge()
          Returns '1' if the cursor is on the bottom edge of the filearea
          or prefix area.
     
       command()
          Returns '1' if the command line is on. This is different to
          KEDIT's definition; "Returns '1' if the cursor is on the 
          command line." To get the equivalent KEDIT functionality
          use incommand();
     
       current()
          Returns '1' if the cursor is on the current line.
     
       dir()
          Returns '1' if the current file is the special DIR.DIR file.
     
       end()
          Returns '1' if the cursor is on the last non-blank character on
          the line.
     
       eof()
          Returns '1' if the cursor is on the '*** Bottom of file ***' line
          and the cursor is not on the command line.
     
       first()
          Returns '1' if the cursor is in column 1 of the current window.
     
       focuseof()
          Returns '1' if the focus line is the '*** Bottom of file ***' line
          whether the cursor is on it or not.
     
       focustof()
          Returns '1' if the focus line is the '*** Top of file ***' line
          whether the cursor is on it or not.
     
       inblock()
          Returns '1' if the cursor is in the marked block.
     
       incommand()
          Returns '1' if the cursor is on the command line.
     
       initial()
          Returns '1' if the function is called from the profile file.
     
       inprefix()
          Returns '1' if the cursor is located in the prefix area.
     
       leftedge()
          Returns '1' if the cursor is on the left edge of the file area.
     
       modifiable()
          Returns '1' if the cursor is located in an area that can be changed.
          ie. not on '*** Top of File ***' or '*** Bottom of File ***' lines.
     
       rightedge()
          Returns '1' if the cursor is on the right edge of the file area.
     
       spacechar()
          Returns '1' if the cursor is on a space character.
     
       tof()
          Returns '1' if the cursor is on the '*** Top of file ***' line
          and the cursor is not on the command line.
     
       topedge()
          Returns '1' if the cursor is on the top edge of the file area.
     
       verone()
          Returns '1' if the column 1 of the file is being displayed in
          column 1.
     
     OTHER FUNCTIONS
     
        The following functions provide features to simplify THE macros
        written in REXX.
     
       valid_target(target[,anything])
          Returns 'ERROR' if the supplied target is invalid.
          Returns 'NOTFOUND' if the supplied target is valid, but not found.
     
          The first argument is the target to be validated. If a second,
          optional argument is supplied, the target to be validated can
          consist of a target followed by any optional characters. This can
          be useful if the arguments to a macro consist of a target followed
          by another argument. If a valid target is supplied, the remainder
          of the string passed to valid_target() is returned following the
          first line affected and the number of lines to the target.
     
          If a valid target, returns the first line affected by the target
          followed by the number of lines to the target, and optionally the
          remainder of the argument.
          eg. if the focus line is 12 and valid_target() is called as
              result = valid_target(":7") , the return value is "12 -5"
              if the focus line is 12 and valid_target is called as
              result = valid_target(":7 /fred bloggs/",junk), the return
              value is "12 -5 /fred bloggs/"
     



     --------------------------------------------------------------------------
     
     
     ========================================================================
     APPENDIX 1 - ENVIRONMENT VARIABLES
     ========================================================================
     
     THE uses the following environment variables:
     
             THE_HOME_DIR     - the directory in which THE looks for its help
                                file(s) and macro(s);
             THE_HELP_FILE    - the fully qualified file name containing help
                                information.
             THE_PROFILE_FILE - the fully qualified file name for the default
                                profile file.
             THE_MACRO_PATH   - a list of all directories in which THE is to 
                                look for macro files.
     
     The following defines how these environment variables are used under UNIX.
     
     If no environment variable; THE_HOME_DIR, is set prior to starting THE,
     THE uses /usr/local/THE/ (or /opt/THE/ if SYSVR4 is defined when compiling)
     as the default value for ${THE_HOME_DIR}. 
     This can be changed in the.c if necessary.
     
     The default value of THE_HELP_FILE is ${THE_HOME_DIR}${TERM}.hlp
     eg. with no environment variables set and $TERM set to vt220, the help 
     file to be looked for will be /usr/local/THE/vt220.hlp (or 
     /opt/THE/vt220.hlp if SYSVR4 is defined when compiling).
     If THE_HOME_DIR environment variable was set to /usr/opt/etc or changed in
     the.c, the help file will be /usr/opt/etc/vt220.hlp. If no $TERM 
     environment variable is set, "default" is used.
     
     The name of the default profile file is $HOME/.therc.
     
     The default value of THE_MACRO_PATH is ${THE_HOME_DIR}:. THE will look for 
     a macro file first in ${THE_HOME_DIR} and then in the current directory. 
     So with no environment variables set, THE looks for macros in 
     $(THE_HOME_DIR} first and if no file exists in that directory, THE will 
     look in the current directory. If the file does not exist in either of 
     these places, an error message will be displayed.
     The format of THE_MACRO_PATH is dir1:dir2:dir3 Each directory is seperated 
     by colons. By default, up to 20 directories may be specified. This can be 
     changed in the.h.
     
     The following defines how these environment variables are used under DOS 
     and OS/2.
     
     By default THE_HOME_DIR is set to the directory from which THE was 
     invoked. Assuming THE.EXE resides in d:\tools, THE_HOME_DIR will equate 
     to d:\tools\.
     
     The default value of THE_HELP_FILE is ${THE_HOME_DIR}dos.hlp for DOS and
     ${THE_HOME_DIR}os2.hlp for OS/2.
     
     The name of the default profile file is ${THE_HOME_DIR}profile.the.
     
     The default value of THE_MACRO_PATH is ${THE_HOME_DIR};. THE will look for
     a macro file first in THE_HOME_DIR and then in the current directory. So 
     with no environment variables set, THE first looks for macros in the 
     directory from which THE was invoked and then in the current directory. 
     If the file does not exist in either directory, an error message is displayed.
     The format of THE_MACRO_PATH is dir1;dir2;dir3 Each directory is seperated 
     by semi-colons. By default up to 20 directories may be specified. This can 
     be changed in the.h.
     



     --------------------------------------------------------------------------
     
     
     ========================================================================
     GLOSSARY
     ========================================================================
     
          Bottom-of-File line
               A line marker, identifying the end of the file.
     
          command line
               The area of the display, usually identified by an arrow
               prompt, "====>", where THE commands are entered.
     
          current line
               The line in the filearea, normally highlighted, from which
               commands entered on the command line take effect.
     
          filearea
               That part of the screen display where the contents of the
               file being edited are displayed.
     
          focus line
               The line in the filearea which currently has the focus. If
               the cursor is in the filearea or prefix area, it is the line
               on which the cursor is displayed. If the cursor is on the
               command line, the focus line is the current line. All THE
               commands operate relative to the focus line.
     
          idline
               That part of the screen display which shows details about
               the file being edited.
     
          macro
               A file containing a sequence of THE commands. Macros can
               be written in REXX if a supported REXX interpreter is 
               available.
     
          prefix area
               That part of the screen display where prefix commands can
               be entered. It also displays the line number of each line
               in the file is SET NUMBER is ON.
     
          profile
               A macro file that is executed at the start of an editing
               session.
          REXX
               A powerful, easy-to-learn macro language available on most
               machines that THE uses as its macro language.
     
          ring
               The set of files currently being edited are arranged in a
               ring formation.
     
          scaleline
               A line in the filearea showing column positions.
     
          shadow line
               A line which signifies how many lines have been excluded
               from display. See SET SHADOW, SET SELECT.
     
          statusline
               That part of the screen display showing details about the
               entire THE session.
     
          tabline
               A line in the filearea which displays the currently set 
               TAB stops.
     
          target
               A method of referring to some part of the file being edited.
     
          Top-of-File line
               A line marker, identifying the beginning of the file.
     



     --------------------------------------------------------------------------





