/***********************************************************************/
/* DIRECTRY.C - Directory routines                                     */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1995 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                 Email:             M.Hessling@qut.edu.au
 * 36 David Road                 Phone:                    +617 3849 7731
 * Holland Park                  http://www.gu.edu.au/gwis/the/markh.html
 * Brisbane                      **** Maintainer PDCurses & REXX/SQL ****
 * QLD 4121                      ************* Author of THE ************
 * Australia                     ************* Member RexxLA ************
 */

/*
$Id: directry.c 2.1 1995/06/24 16:29:33 MH Rel MH $
*/
#if 0
#ifdef __EMX__
#  define __OS2__ 3
#endif
#endif

#ifdef __OS2__
#   define INCL_DOS
#endif
#include "the.h"
#include "directry.h"
#include "fnmatch.h"
#include "proto.h"

static ATTR_TYPE curr_dirtype = (F_DI | F_AR);
/*********************************************************************/
#ifdef PROTO
CHARTYPE *make_full(CHARTYPE *path, CHARTYPE *file)
#else
CHARTYPE *make_full(path, file)
CHARTYPE *path, *file;
#endif
/*********************************************************************/
{
 static CHARTYPE filebuf[BUFSIZ];
 short pathlen=strlen(path);

 if (pathlen+1+strlen(file)+1 > BUFSIZ)
    return(NULL);
 if (!strcmp(path, "") || !strcmp(path, "."))
   {
    (void) strcpy(filebuf, file);
    return(filebuf);
   }
 (void) strcpy(filebuf, path);
 if (*(path+(pathlen - 1)) != ISLASH && *file != ISLASH)
    (void) strcat(filebuf, ISTR_SLASH);
 (void) strcat(filebuf, file);
 return(filebuf);
}
/*********************************************************************/
#if defined(UNIX)
#ifdef PROTO
short getfiles(CHARTYPE *path,CHARTYPE *files,struct dirfile **dpfirst,
                                    struct dirfile **dplast)
#else
short getfiles(path,files,dpfirst,dplast)
CHARTYPE *path;
CHARTYPE *files;
struct dirfile **dpfirst;
struct dirfile **dplast;
#endif
/*********************************************************************/
{
 DIR *dirp=NULL;
 struct stat sp;
 struct dirent *direntp=NULL;
 struct dirfile *dp=NULL;
 CHARTYPE *full_name=NULL;
 short entries = 10;

 dirp = opendir(path);
 if (dirp == NULL)
    return(10);

 dp = *dpfirst = (struct dirfile *)(*the_calloc)(entries, sizeof(struct dirfile));
 if (dp == NULL)
    return(30);
 *dplast = *dpfirst + entries;

 for (direntp = readdir(dirp);direntp != NULL;direntp = readdir(dirp))
    {
     if (fnmatch(files,direntp->d_name,0) == 0)
       {
        if ((full_name = make_full(path,(CHARTYPE *)direntp->d_name)) == NULL)
           return(30);
        if (stat(full_name,&sp) != 0)
           continue;
        if ((dp->fname = (CHARTYPE *)(*the_calloc)(strlen(direntp->d_name)+1,sizeof(CHARTYPE))) == NULL)
           return(30);
        strcpy(dp->fname,direntp->d_name);
        dp->fattr = sp.st_mode;
#if defined(_HPUX_SOURCE)
        dp->facl  = sp.st_acl;
#else
        dp->facl  = 0;
#endif
        dp->ftime = sp.st_mtime;
        dp->fsize = sp.st_size;
	dp->fdate = 0;
        dp++;
        if (dp == *dplast)
          {
           *dpfirst = (struct dirfile *)(*the_realloc)((CHARTYPE *)*dpfirst,
                      2 * entries * sizeof (struct dirfile));
           if (*dpfirst == NULL)
              return(30);
           dp = *dpfirst + entries;
           *dplast = dp + entries;
           entries *= 2;
          }
       }
    }
 closedir(dirp);
 *dplast = dp;
 return(0);
}
#else
/*********************************************************************/
#ifdef PROTO
short getfiles(CHARTYPE *path,CHARTYPE *files,struct dirfile **dpfirst,
                                    struct dirfile **dplast)
#else
short getfiles(path,files,dpfirst,dplast)
CHARTYPE *path;
CHARTYPE *files;
struct dirfile **dpfirst;
struct dirfile **dplast;
#endif
/*********************************************************************/
{
 struct dirfile *dp=NULL;
#ifdef OS2
#  ifdef __32BIT__
 ULONG matches=1L;
 ULONG rsvrd=FIL_STANDARD;
 FILEFINDBUF3 ffblk;
#  else
 USHORT matches=1;
 ULONG rsvrd=0;
 FILEFINDBUF ffblk;
#  endif
 HDIR hdir=HDIR_SYSTEM;
#else
 FSTR_TYPE ffblk;
#endif
 ATTR_TYPE attrs=curr_dirtype;
 DONE_TYPE done=0;
 CHARTYPE *full_path=NULL;
 CHARTYPE str_attr[12];
 CHARTYPE str_date[10];
 CHARTYPE str_time[6];
 short entries = 10;

 if ((full_path = make_full(path,"*.*")) == NULL)
	   return(RC_FILE_NOT_FOUND);

#if defined(DOS) && defined(TC)
 done = findfirst(full_path,&ffblk,attrs);
#endif
#if defined (DOS) && defined(MSC)
 done = _dos_findfirst(full_path,attrs,&ffblk);
#endif
#if defined(DOS) && defined(GO32)
 done = findfirst(full_path,&ffblk,attrs);
#endif
#ifdef OS2
#  ifdef __32BIT__
 done = DosFindFirst((PSZ) full_path, (PHDIR)&hdir, (ULONG)attrs,
		     (PVOID)&ffblk, (ULONG)sizeof(ffblk), (PULONG)&matches,
		     (ULONG)rsvrd);
#  else
 done = DosFindFirst((PSZ) full_path, (PHDIR)&hdir, (USHORT)attrs,
		     (PFILEFINDBUF)&ffblk, (USHORT)sizeof(ffblk), (PUSHORT)&matches,
		     (ULONG)rsvrd);
#  endif
#endif
 if (done != 0)
    return(RC_FILE_NOT_FOUND);

 dp = *dpfirst = (struct dirfile *)(*the_calloc)(entries, sizeof (struct dirfile));
 *dplast = *dpfirst + entries;


 while(!done)
    {
     if (fnmatch(files,ffblk.NAME_NAME,FNM_IGNORECASE) == 0)
       {
	if ((dp->fname = (CHARTYPE *)(*the_calloc)(strlen(ffblk.NAME_NAME)+1,sizeof(CHARTYPE))) == NULL)
	   return(RC_OUT_OF_MEMORY);
	strcpy(dp->fname,ffblk.NAME_NAME);
	dp->fattr = ffblk.ATTR_NAME;
	dp->ftime = ffblk.TIME_NAME;
	dp->fsize = ffblk.SIZE_NAME;
	dp->fdate = ffblk.DATE_NAME;
	dp++;
	if (dp == *dplast)
	  {
           *dpfirst = (struct dirfile *)(*the_realloc)((CHARTYPE *)*dpfirst,
                      2 * entries * sizeof (struct dirfile));
           if (*dpfirst == NULL)
              return(RC_FILE_NOT_FOUND);
           dp = *dpfirst + entries;
           *dplast = dp + entries;
           entries *= 2;
          }
       }
#if defined(DOS) && defined(TC)
     done = findnext(&ffblk);
#endif
#if defined(DOS) && defined(MSC)
     done = _dos_findnext(&ffblk);
#endif
#if defined(DOS) && defined(GO32)
     done = findnext(&ffblk);
#endif
#ifdef OS2
#  ifdef __32BIT__
     done = DosFindNext((HDIR)hdir, (PVOID)&ffblk, (ULONG)sizeof(ffblk),
            (PULONG)&matches);
#  else
     done = DosFindNext((HDIR)hdir, (PFILEFINDBUF)&ffblk, (USHORT)sizeof(ffblk),
            (PUSHORT)&matches);
#  endif
#endif
    }
 *dplast = dp;
 return(RC_OK);
}
#endif
/*********************************************************************/
#ifdef PROTO
int fcomp(struct dirfile *first,struct dirfile* next)
#else
int fcomp(first,next)
struct dirfile *first;
struct dirfile* next;
#endif
/*********************************************************************/
{
#ifdef OS2
 return(stricmp(first->fname,next->fname));
#else
 return(strcmp(first->fname,next->fname));
#endif
}
/*********************************************************************/
#ifdef PROTO
CHARTYPE *file_date(D_TYPE date,CHARTYPE *str_date)
#else
CHARTYPE *file_date(date,str_date)
D_TYPE date;
CHARTYPE *str_date;
#endif
/*********************************************************************/
{
 static CHARTYPE mon[12][4] = {
 "Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
 sprintf(str_date,"%2d-%3.3s-%2.2d",DAYS_MASK,MONT_MASK,YEAR_MASK);
 return(str_date);
}
/*********************************************************************/
#ifdef PROTO
CHARTYPE *file_time(T_TYPE time,CHARTYPE *str_time)
#else
CHARTYPE *file_time(time,str_time)
T_TYPE time;
CHARTYPE *str_time;
#endif
/*********************************************************************/
{
 sprintf(str_time,"%2d:%2.2d",HOUR_MASK,MINU_MASK);
 return(str_time);
}
/*********************************************************************/
#ifdef PROTO
CHARTYPE *file_attrs(ATTR_TYPE attrs,CHARTYPE *str_attr,int facl)
#else
CHARTYPE *file_attrs(attrs,str_attr,facl)
ATTR_TYPE attrs;
CHARTYPE *str_attr;
int facl;
#endif
/*********************************************************************/
{
#ifdef UNIX
 ATTR_TYPE ftype=(attrs & S_IFMT);

 str_attr[11] = '\0';
 str_attr[10] = ' ';
#if defined(_HPUX_SOURCE)
 if (facl)
    str_attr[10] = '+';
#endif
 switch(ftype)
   {
    case S_IFDIR:  str_attr[0] = 'd'; break;
    case S_IFCHR:  str_attr[0] = 'c'; break;
    case S_IFIFO:  str_attr[0] = 'p'; break;
#if defined(S_IFSOCK)
    case S_IFSOCK: str_attr[0] = 's'; break;
#endif
#if defined(S_IFLNK)
    case S_IFLNK:  str_attr[0] = 'l'; break;
#endif
    default:       str_attr[0] = '-'; break;
   }
 str_attr[1] = (attrs & S_IRUSR) ? 'r' : '-';
 str_attr[2] = (attrs & S_IWUSR) ? 'w' : '-';
 str_attr[3] = (attrs & S_IXUSR) ? 'x' : '-';
 str_attr[3] = (attrs & S_ISUID) ? 's' : str_attr[3];
 str_attr[4] = (attrs & S_IRGRP) ? 'r' : '-';
 str_attr[5] = (attrs & S_IWGRP) ? 'w' : '-';
 str_attr[6] = (attrs & S_IXGRP) ? 'x' : '-';
 str_attr[6] = (attrs & S_ISGID) ? 's' : str_attr[6];
 str_attr[7] = (attrs & S_IROTH) ? 'r' : '-';
 str_attr[8] = (attrs & S_IWOTH) ? 'w' : '-';
 str_attr[9] = (attrs & S_IXOTH) ? 'x' : '-';
#else
 strcpy(str_attr,".... ");
 if ((attrs & F_RO) == F_RO)
   str_attr[0] = 'r';
 if ((attrs & F_AR) == F_AR)
   str_attr[1] = 'a';
 if ((attrs & F_SY) == F_SY)
   str_attr[2] = 's';
 if ((attrs & F_HI) == F_HI)
   str_attr[3] = 'h';
 str_attr[4] = '\0';
 if ((attrs & F_DI) == F_DI)
   strcat(str_attr,"(dir)  ");
 else
   strcat(str_attr,"       ");
#endif
 return(str_attr);
}
/*********************************************************************/
#ifdef PROTO
short set_dirtype(CHARTYPE *params)
#else
short set_dirtype(params)
CHARTYPE *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
#define NUM_DIRTYPE 5
 static CHARTYPE *dirtype[NUM_DIRTYPE] =
         {(CHARTYPE *)"normal",
          (CHARTYPE *)"readonly",
          (CHARTYPE *)"system",
          (CHARTYPE *)"hidden",
          (CHARTYPE *)"directory"};
 static ATTR_TYPE att[NUM_DIRTYPE] =
         {0,F_RO,F_SY,F_HI,F_DI};
 CHARTYPE *p=NULL;
 register short i=0;
 ATTR_TYPE attribs=0;
 bool found=FALSE;
/*--------------------------- processing ------------------------------*/
 if (strcmp(params,"") == 0)                 /* error if no paramaters */
   {
    display_error(3,(CHARTYPE *)"",FALSE);
    return(RC_INVALID_OPERAND);
   }
 if (strcmp(params,"*") == 0)                            /* set to ALL */
   {
    curr_dirtype = (F_RO | F_HI | F_SY | F_DI | F_AR);
    return(RC_OK);
   }
 p = (CHARTYPE *)strtok(params," ");
 while(p != NULL)
   {
    found = FALSE;
    for (i=0;i<NUM_DIRTYPE;i++)
       {
        if (equal(dirtype[i],p,1))
          {
           found = TRUE;
           attribs |= att[i];
          }
       }
    if (!found)
      {
       display_error(1,(CHARTYPE *)p,FALSE);
       return(RC_INVALID_OPERAND);
      }
    p = (CHARTYPE *)strtok(NULL," ");
   }
 curr_dirtype = attribs;
 return(RC_OK);
 }
