/***********************************************************************/
/* THE.C - The Hessling Editor                                         */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1995 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                 Email:             M.Hessling@qut.edu.au
 * 36 David Road                 Phone:                    +617 3849 7731
 * Holland Park                  http://www.gu.edu.au/gwis/the/markh.html
 * Brisbane                      **** Maintainer PDCurses & REXX/SQL ****
 * QLD 4121                      ************* Author of THE ************
 * Australia                     ************* Member RexxLA ************
 */

/*
$Id: the.c 2.1 1995/06/24 16:31:24 MH Rel MH $
*/

#include <stdio.h>

#define MAIN 1
#include "the.h"
#include "proto.h"
#include <signal.h>

#if defined(DOS) || defined(OS2)
#  if !defined(EMX) && !defined(GO32)
#    include <direct.h>
#  endif
#endif

/*--------------------------- global data -----------------------------*/
 WINDOW *foot=NULL,*error_window=NULL,*divider=NULL;
 VIEW_DETAILS *vd_current=(VIEW_DETAILS *)NULL;
 VIEW_DETAILS *vd_first=(VIEW_DETAILS *)NULL;
 VIEW_DETAILS *vd_mark=(VIEW_DETAILS *)NULL;
 CHARTYPE number_of_views = 0;                      /* number of views */
 CHARTYPE number_of_files = 0;                      /* number of files */
 CHARTYPE display_screens = 1;                    /* number of screens */
 CHARTYPE current_screen = 0;
 SCREEN_DETAILS screen[MAX_SCREENS];            /* 2 screen structures */
 bool rexx_support;                          /* initially REXX support */
 bool horizontal=TRUE;
 short save_coord_x[VIEW_WINDOWS];
 short save_coord_y[VIEW_WINDOWS];

 LINE *next_line=NULL,*curr_line=NULL;
 LINE *first_file_name=NULL,*current_file_name=NULL;
 bool error_on_screen=FALSE;
 bool colour_support=TRUE;         /* indicates if colour is supported */
 bool initial=TRUE;
 bool been_interactive=FALSE;
 CHARTYPE *rec=NULL;
 LENGTHTYPE rec_len = 0;                              /* length of rec */
 CHARTYPE *trec=NULL;
 LENGTHTYPE trec_len = 0;
 CHARTYPE *cmd_rec=NULL;
 unsigned short cmd_rec_len = 0;                  /* length of cmd_rec */
 CHARTYPE *pre_rec=NULL;
 unsigned short pre_rec_len = 0;                  /* length of cmd_rec */
 CHARTYPE *profile_command_line=NULL;
 bool focus_changed = FALSE;    /* indicates if focus line has changed */
 bool current_changed = FALSE;/* indicates if current line has changed */
 bool in_profile=FALSE;             /* indicates if processing profile */
 bool execute_profile=TRUE;/* indicates if we are to process a profile */
 bool in_macro=FALSE;            /* indicates if processing REXX macro */
 bool file_read=FALSE;           /* indicates if we have read the file */
 bool curses_started=FALSE;         /* indicates if curses has started */
 bool readonly=FALSE;     /* indicates if running THE in readonly mode */

 CHARTYPE *the_version = (CHARTYPE *)"2.1";
 CHARTYPE *the_release = (CHARTYPE *)"24-Jun-95";
 CHARTYPE *the_copyright = (CHARTYPE *)"Copyright 1991-1995 Mark Hessling";
 CHARTYPE term_name[20];  /* $TERM value */
#if defined(UNIX)
 CHARTYPE user_home_dir[MAX_FILE_NAME+1];
#   define THE_PROFILE_FILE ".therc"
#else
#   define THE_PROFILE_FILE "PROFILE.THE"
#endif
 CHARTYPE *tempfilename = (CHARTYPE *)"THE.$$$";
 CHARTYPE *rexxoutname = (CHARTYPE *)"REXX.$$$";
 CHARTYPE rexx_pathname[MAX_FILE_NAME+1];
 CHARTYPE rexx_filename[10];
#ifdef VMS
 CHARTYPE *dirfilename = (CHARTYPE *)"DIR.THE";
#else
 CHARTYPE *dirfilename = (CHARTYPE *)"DIR.DIR";
#endif
 CHARTYPE macro_suffix[12] = ".the";   /* default extension for macros */
 CHARTYPE dir_pathname[MAX_FILE_NAME+1];
 CHARTYPE dir_filename[10];
 CHARTYPE curr_path[MAX_FILE_NAME+1];
 CHARTYPE sp_path[MAX_FILE_NAME+1];
 CHARTYPE sp_fname[MAX_FILE_NAME+1];
 CHARTYPE dir_path[MAX_FILE_NAME+1];        /* for dir and ls commands */
 CHARTYPE dir_files[MAX_FILE_NAME+1];       /* for dir and ls commands */
 CHARTYPE rexx_macro_name[MAX_FILE_NAME+1]; /* current rexx macro name */

 CHARTYPE the_home_dir[MAX_FILE_NAME+1];
 CHARTYPE the_macro_path[MAX_FILE_NAME+1];        /* for macro command */
 CHARTYPE the_help_file[MAX_FILE_NAME+1];

 CHARTYPE *prf_arg=(CHARTYPE *)NULL;
 CHARTYPE *local_prf=(CHARTYPE *)NULL;
 CHARTYPE *specified_prf=(CHARTYPE *)NULL;

 CHARTYPE tabkey_insert='C';
 CHARTYPE tabkey_overwrite='T';
 unsigned short file_start = 36;
 CHARTYPE *last_target=NULL;

#if defined(UNIX) || defined(OS2)
 CHARTYPE *spooler_name=NULL;
#endif

 CHARTYPE file_disposition=0;

 struct stat stat_buf;

 short lastrc=0;
 short compatible=COMPAT_THE;
 short prefix_width=PREFIX_WIDTH;

#define DEFAULT_LINES 24
#define DEFAULT_COLS  80

 short terminal_lines=DEFAULT_LINES;
 short terminal_cols=DEFAULT_COLS;
/*---------------------------------------------------------------------*/
/* Following are for getopt function(s).                               */
/*---------------------------------------------------------------------*/
extern char *optarg;
extern int optind;
/*---------------------------------------------------------------------*/
/* Following are for original cursor position for EXTRACT /CURSOR/     */
/*---------------------------------------------------------------------*/
 LINETYPE original_screen_line = (-1L);
 LINETYPE original_screen_column = (-1L);
 LINETYPE original_file_line = (-1L);
 LINETYPE original_file_column = (-1L);

#ifdef XCURSES
 char *XCursesProgramName = "the";
#endif
/***********************************************************************/
#ifdef MSWIN
int Themain(argc,argv)
int argc;
char *argv[];
#else
#ifdef PROTO
int main(int argc, char *argv[])
#else
int main(argc,argv)
short argc;
char *argv[];
#endif
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern ROWTYPE STATUSLINEx;
 extern DEFINE *first_define;
 extern bool CLEARSCREENx;
 extern bool INSERTMODEx;
 extern LINE *first_prefix_synonym;

#ifdef MSWIN
 extern void efree();
 extern char far *emalloc(unsigned long);
 extern char far *erealloc(void far *,unsigned long);
 extern char far *ecalloc();
#endif
/*--------------------------- local data ------------------------------*/
 register short i=0;
 short c=0;
 bool trap_signals=TRUE;
 bool pause_for_errors=FALSE;
 short rc=RC_OK;
/*--------------------------- processing ------------------------------*/
#ifdef __EMX__
 _wildcard(&argc,&argv);
#endif

#ifdef TRACE
 trace_initialise();
 trace_function("the.c:     main");
#endif
/*---------------------------------------------------------------------*/
/* Ensure that CURRENT_VIEW is NULL before starting. This is to ensure */
/* that any errors generated before CURRENT_VIEW is assigned are       */
/* handled gracefully.                                                 */
/*---------------------------------------------------------------------*/
 CURRENT_VIEW = (VIEW_DETAILS *)NULL;
/*---------------------------------------------------------------------*/
/* Set up our memory management calls. This is where you can specify a */
/* debugging memory manager.                                           */
/*---------------------------------------------------------------------*/
#ifdef MSWIN
 the_malloc  = emalloc;
 the_calloc  = ecalloc;
 the_free    = efree;
 the_realloc = erealloc;
 Win31Startup();
#else
 the_malloc  = malloc;
 the_calloc  = calloc;
 the_free    = free;
 the_realloc = realloc;
#endif
/*---------------------------------------------------------------------*/
/* Set up flag to indicate that we are not interactive...yet.          */
/*---------------------------------------------------------------------*/
 in_profile = TRUE;
 execute_profile = TRUE;
 in_macro = FALSE;
/*---------------------------------------------------------------------*/
/* Initialise the printer spooler.                                     */
/*---------------------------------------------------------------------*/
#if defined(UNIX) || defined(OS2)
 if ((spooler_name = (CHARTYPE *)(*the_malloc)(4*sizeof(CHARTYPE))) == NULL)
   {
    display_error(30,(CHARTYPE *)"",FALSE);
    exit_clean(1);
   }
#  ifdef UNIX
 strcpy(spooler_name,(CHARTYPE *)"lpr");
#  else
 strcpy(spooler_name,(CHARTYPE *)"LPT1");
#  endif
#endif
/*---------------------------------------------------------------------*/
/* Get all environment variables here. Some may be overridden by       */
/* command-line switches. (future possibility)                         */
/*---------------------------------------------------------------------*/
#if defined(UNIX)
 if (getenv("HOME") != NULL)
    strcpy(user_home_dir,getenv("HOME"));
 else
    strcpy(user_home_dir,"./");
 if (*(user_home_dir+strlen(user_home_dir)-1) != ISLASH)
    strcat(user_home_dir,ISTR_SLASH);
 if (getenv("TERM") != NULL)
    strcpy(term_name,getenv("TERM"));
 else
    strcpy(term_name,"default");
#endif
#if defined(DOS)
 strcpy(term_name,"DOS");
#endif
#if defined(OS2)
 strcpy(term_name,"OS2");
#endif
/*---------------------------------------------------------------------*/
/* Get THE_HOME_DIR first (as all other paths rely on this value)      */
/*---------------------------------------------------------------------*/
 if (getenv("THE_HOME_DIR") != NULL)
   {
    strcpy(the_home_dir,getenv("THE_HOME_DIR"));
    (void *)strtrans(the_home_dir,OSLASH,ISLASH);
    if ((the_home_dir[strlen(the_home_dir)-1]) != ISLASH)
       strcat(the_home_dir,ISTR_SLASH);
   }
 else
   {
#if defined(UNIX)
    strcpy(the_home_dir,THE_HOME_DIRECTORY);
#else
    strcpy(the_home_dir,(CHARTYPE *)argv[0]);
    (void *)strtrans(the_home_dir,OSLASH,ISLASH);
    i = strzreveq(the_home_dir,ISLASH);
    if (i != (-1))
       the_home_dir[i+1] = '\0';
    else
       the_home_dir[0] = '\0';
#endif
   }
/*---------------------------------------------------------------------*/
/* Get THE_MACRO_PATH environment variable. If not set set up default  */
/* to be THE_HOME_DIR followed by the current directory.               */
/*---------------------------------------------------------------------*/
 if (getenv("THE_MACRO_PATH") != NULL)
    strcpy(the_macro_path,getenv("THE_MACRO_PATH"));
 else
   {
    strcpy(the_macro_path,the_home_dir);
#if defined(UNIX)
    strcat(the_macro_path,":.");
#else
    strcat(the_macro_path,";.");
#endif
   }
 (void *)strtrans(the_macro_path,OSLASH,ISLASH);
#ifdef VMS
 strcpy(the_macro_path,"");
#endif
/*---------------------------------------------------------------------*/
/* Set up help file name.                                              */
/*---------------------------------------------------------------------*/
 if (getenv("THE_HELP_FILE") != NULL)
    strcpy(the_help_file,getenv("THE_HELP_FILE"));
 else
   {
    strcpy(the_help_file,the_home_dir);
    strcat(the_help_file,term_name);
    strcat(the_help_file,".hlp");
   }
 (void *)strtrans(the_help_file,OSLASH,ISLASH);
/*---------------------------------------------------------------------*/
/* Process the command line arguments.                                 */
/*---------------------------------------------------------------------*/
 while ((c = getopt(argc,argv,"smnrp:w:a:h?")) != EOF)
   switch((char)c)
     {
      case 's':        /* don't trap signals */
               trap_signals = FALSE;
               break;
      case 'm':        /* force into MONO */
               colour_support = FALSE;
               break;
      case 'n':        /* do not execute any profile file */
               execute_profile = FALSE;
               break;
      case 'r':        /* run in readonly mode */
               readonly = TRUE;
               break;
      case 'p':        /* profile file name */
               if ((specified_prf = (CHARTYPE *)(*the_malloc)((strlen(optarg)+1)*sizeof(CHARTYPE))) == NULL)
                 {
                  display_error(30,(CHARTYPE *)"",FALSE);
                  exit_clean(1);
                 }
               strcpy(specified_prf,optarg);
               break;
      case 'a':        /* profile arguments */
               if ((prf_arg = (CHARTYPE *)(*the_malloc)((strlen(optarg)+1)*sizeof(CHARTYPE))) == NULL)
                 {
                  display_error(30,(CHARTYPE *)"",FALSE);
                  exit_clean(1);
                 }
               strcpy(prf_arg,optarg);
               break;
      case 'w':        /* width of line */
               max_line_length = (unsigned short)atoi(optarg);
               if (max_line_length < 10)
                 {
                  display_error(5,(CHARTYPE *)"width MUST be >= 10",FALSE);
                  exit_clean(1);
                 }
               break;
      case 'h':
      case '?':
               display_info((CHARTYPE *)argv[0]);
               exit_clean(0);
               break;
      default:
               break;
     }

 if (optind<argc)
   {
    while(optind<argc)
      {
       if ((current_file_name = add_line(first_file_name,
                                         current_file_name,
                                         strtrans((CHARTYPE *)argv[optind],OSLASH,ISLASH),
                                         strlen(argv[optind]),0)) == NULL)
           {
            display_error(30,(CHARTYPE *)"",FALSE);
            exit_clean(1);
           }
       if (first_file_name == NULL)
          first_file_name = current_file_name;
       optind++;
      }
   }
 else
   {
    if ((current_file_name = add_line(first_file_name,
                                      current_file_name,
                                      CURRENT_DIR,
                                      strlen(CURRENT_DIR),0)) == NULL)
        {
         display_error(30,(CHARTYPE *)"",FALSE);
         exit_clean(1);
        }
    if (first_file_name == NULL)
       first_file_name = current_file_name;
   }
/*---------------------------------------------------------------------*/
/* Override any default paths,filenames etc if supplied on command line*/
/*---------------------------------------------------------------------*/
 if (setup_profile_files(specified_prf) != RC_OK)
    exit_clean(1);
/*---------------------------------------------------------------------*/
/* Allocate some memory to last_target and set it to a blank value.    */
/*---------------------------------------------------------------------*/
 if ((last_target = (CHARTYPE *)(*the_malloc)(80*sizeof(CHARTYPE))) == NULL)
    exit_clean(1);
 strcpy(last_target,"");
/*---------------------------------------------------------------------*/
/* Allocate some memory to rec.                                        */
/*---------------------------------------------------------------------*/
 if ((rec = (CHARTYPE *)(*the_malloc)((max_line_length+5)*sizeof(CHARTYPE))) == NULL)
    exit_clean(1);
/*---------------------------------------------------------------------*/
/* Allocate some memory to trec; buffer for reading files.             */
/*---------------------------------------------------------------------*/
 trec_len = max(80,(max_line_length+2)*2);
 if ((trec = (CHARTYPE *)(*the_malloc)(trec_len*sizeof(CHARTYPE))) == NULL)
    exit_clean(1);
/*---------------------------------------------------------------------*/
/* Allocate memory to cmd_rec and set it to blanks.                    */
/*---------------------------------------------------------------------*/
 if ((cmd_rec = (CHARTYPE *)(*the_malloc)((max_line_length+2)*sizeof(CHARTYPE))) == NULL)
    exit_clean(1);
 memset(cmd_rec,' ',max_line_length);
 cmd_rec_len = 0;
/*---------------------------------------------------------------------*/
/* Allocate some memory for temporary space...                         */
/*---------------------------------------------------------------------*/
 if (allocate_temp_space(max_line_length,TEMP_PARAM) != RC_OK)
    exit_clean(1);
 if (allocate_temp_space(max_line_length,TEMP_TMP_CMD) != RC_OK)
    exit_clean(1);
 if (allocate_temp_space(max_line_length,TEMP_TEMP_CMD) != RC_OK)
    exit_clean(1);
/*---------------------------------------------------------------------*/
/* Allocate memory to pre_rec and set it to blanks.                    */
/*---------------------------------------------------------------------*/
 if ((pre_rec = (CHARTYPE *)(*the_malloc)((PREFIX_WIDTH+1)*sizeof(CHARTYPE))) == NULL)
    exit_clean(1);
 memset(pre_rec,' ',PREFIX_WIDTH+1);
 pre_rec_len = 0;
/*---------------------------------------------------------------------*/
/* Allocate some memory to profile_command_line. (only really need to  */
/* do this if NO REXX support).                                        */
/*---------------------------------------------------------------------*/
 if ((profile_command_line = (CHARTYPE *)(*the_malloc)((max_line_length+2)*sizeof(CHARTYPE))) == NULL)
    exit_clean(1);
/*---------------------------------------------------------------------*/
/* Determine the current working directory.                            */
/* Do this before any other file setting up so that we don't change the*/
/* current directory from the default.                                 */
/*---------------------------------------------------------------------*/
#if defined(EMX)
 _getcwd2(curr_path,MAX_FILE_NAME);
#else
 getcwd(curr_path,MAX_FILE_NAME);
#endif
/*---------------------------------------------------------------------*/
/* Set up filename for directory temporary file (DIR.DIR).             */
/* Set up filename for REXX capture file (REXX.$$$).                   */
/*---------------------------------------------------------------------*/
#ifdef UNIX
 strcpy(dir_pathname,user_home_dir);
#endif
#if defined(DOS) || defined(OS2)
 strcpy(dir_pathname,ISTR_SLASH);
#endif
#ifdef VMS
 strcpy(dir_pathname,"");
#endif

 strcpy(rexx_pathname,dir_pathname);
 strcat(dir_pathname,dirfilename);
 if (splitpath(dir_pathname) != RC_OK)
    exit_clean(1);
 strcpy(dir_pathname,sp_path);
 strcpy(dir_filename,sp_fname);

 strcat(rexx_pathname,rexxoutname);
 if (splitpath(rexx_pathname) != RC_OK)
    exit_clean(1);
 strcpy(rexx_pathname,sp_path);
 strcpy(rexx_filename,sp_fname);
/*---------------------------------------------------------------------*/
/* Trap signals to exit gracefully, unless user has specified they not */
/* be trapped.                                                         */
/*---------------------------------------------------------------------*/
 if (trap_signals)
    init_signals();
/*---------------------------------------------------------------------*/
/* Set SCREEN values up...                                             */
/*---------------------------------------------------------------------*/
 for (i=0;i<VIEW_WINDOWS;i++)
     CURRENT_SCREEN.win[i] = (WINDOW *)NULL;
/*---------------------------------------------------------------------*/
/* Set up global defaults.                                             */
/*---------------------------------------------------------------------*/
 set_global_defaults();
/*---------------------------------------------------------------------*/
/* Initialise command array to empty strings.                          */
/*---------------------------------------------------------------------*/
 init_command();
/*---------------------------------------------------------------------*/
/* Initialise rexx support. If no REXX available, set flag...          */
/*---------------------------------------------------------------------*/
#ifndef MSWIN
 rexx_support = TRUE;
 if (initialise_rexx() != RC_OK)
    rexx_support = FALSE;
#endif
/*---------------------------------------------------------------------*/
/* Set up default screens using the default values of terminal_lines   */
/* and terminal_cols. These will be altered after initscr().           */
/*---------------------------------------------------------------------*/
 screen[0].sl = screen[1].sl = NULL;
 set_screen_defaults();
/*---------------------------------------------------------------------*/
/* Read each file into memory and apply the profile file to each of the*/
/* files.                                                              */
/*---------------------------------------------------------------------*/
 current_file_name = first_file_name;
 while(current_file_name != NULL)
   {
   if ((rc = get_file((CHARTYPE *)current_file_name->line)) != RC_OK)
     {
      if (rc == RC_DISK_FULL)
         display_error(57,(CHARTYPE *)"...probably",FALSE);
      exit_clean(2);
     }
   pre_process_line(CURRENT_VIEW,0L);
   if (execute_profile)
     {
      if (local_prf != (CHARTYPE *)NULL)
         rc = get_profile(local_prf,prf_arg);
      if (error_on_screen)
        {
         pause_for_errors = TRUE;
         error_on_screen = FALSE;
        }
#ifdef MSWIN
      (void)get_user_profile();
      if (error_on_screen)
        {
         pause_for_errors = TRUE;
         error_on_screen = FALSE;
        }
#endif
     }
   current_file_name = current_file_name->next;
   }
/*---------------------------------------------------------------------*/
/* If THE has been used only in batch, exit here.                      */
/*---------------------------------------------------------------------*/
 if (number_of_files == 0)
    exit_clean(0);
 been_interactive = TRUE;
 lll_free(first_file_name);
 CURRENT_VIEW = CURRENT_SCREEN.screen_view = vd_first;
 pre_process_line(CURRENT_VIEW,CURRENT_VIEW->focus_line);
/*---------------------------------------------------------------------*/
/* If we have had an error in the profile file we need to pause so the */
/* user sees the messages. This pause should only occur if the number  */
/* of files > 0. ie the profile file does not contain a 'file' or 'quit*/
/* command.                                                            */
/*---------------------------------------------------------------------*/
#ifndef MSWIN
 if (pause_for_errors && number_of_files != 0)
   {
    fprintf(stderr,"\n%s","Hit RETURN to continue...");
    fflush(stderr);
    (void)getchar();
    error_on_screen = FALSE;
   }
#endif
/*---------------------------------------------------------------------*/
/* Start up curses. This allows profile commands to be processed before*/
/* curses starts.                                                      */
/*---------------------------------------------------------------------*/
 initscr();
 curses_started = TRUE;
/*---------------------------------------------------------------------*/
/* Save the value of LINES and COLS and use these for all screen       */
/* sizing calculations. This is because BSD scrolls if a character is  */
/* displayed in the bottom right corner of the screen :-(              */
/*---------------------------------------------------------------------*/
 terminal_lines=LINES;
 terminal_cols=COLS;
#if defined(BSDcurses)
 terminal_lines--;
#endif
/*---------------------------------------------------------------------*/
/* Determine if colour support available.                              */
/*---------------------------------------------------------------------*/
 if (colour_support) /* if default setting not overridden on command line */
   {
    colour_support = FALSE;
#ifdef A_COLOR
    if (has_colors())
      {
       start_color();
       colour_support = TRUE;
       init_colour_pairs();
      }
#endif
   }
/*---------------------------------------------------------------------*/
/* Set various terminal characteristics...                             */
/*---------------------------------------------------------------------*/
#if !defined(VMS)
 cbreak();
#endif
#if !defined(MINIX)
 raw();
#endif
#if defined(USE_EXTCURSES)
 extended(FALSE);
#endif
#if defined(DOS) || defined(OS2)
 raw_output(TRUE);
#endif
 nonl();
 noecho();
#if !defined(NO_KEYPAD)
 keypad(stdscr,TRUE);
#endif
#if defined(USE_NOTIMEOUT)
 notimeout(stdscr,TRUE);
#endif
/*---------------------------------------------------------------------*/
/* We are now finished with profile commands.                          */
/*---------------------------------------------------------------------*/
 in_profile = FALSE;
/*---------------------------------------------------------------------*/
/* Set up variables and values dependent on LINES and COLS now with    */
/* values set by initscr().                                            */
/*---------------------------------------------------------------------*/
 set_screen_defaults();
/*---------------------------------------------------------------------*/
/* Call insertmode command to set default mode to whatever the current */
/* setting is. If set in profile, could be anything.                   */
/* Run AFTER initscr() as it uses curs_set().                          */
/*---------------------------------------------------------------------*/
 Insertmode(INSERTMODEx ? "ON" : "OFF");
/*---------------------------------------------------------------------*/
/* For each file being edited, set up the curses windows for each of  */
/* them.                                                               */
/*---------------------------------------------------------------------*/
 CURRENT_VIEW = CURRENT_SCREEN.screen_view = vd_first;

 for (i=0;i<display_screens;i++)
    if (set_up_windows(i) != RC_OK)
       exit_clean(1);

 CURRENT_VIEW = CURRENT_SCREEN.screen_view = vd_first;
 pre_process_line(CURRENT_VIEW,CURRENT_VIEW->focus_line);
/*---------------------------------------------------------------------*/
/* Create the statusline window...                                     */
/*---------------------------------------------------------------------*/
 if (create_statusline_window() != RC_OK)
   {
    display_error(0,(CHARTYPE *)"creating status line window",FALSE);
    exit_clean(2);
   }
/*---------------------------------------------------------------------*/
/* This is where it all happens.                                       */
/*---------------------------------------------------------------------*/
 editor();
/*---------------------------------------------------------------------*/
/* Finalise rexx support...                                            */
/*---------------------------------------------------------------------*/
#ifndef MSWIN
 finalise_rexx();
#endif
/*---------------------------------------------------------------------*/
/* Free up the dynamically allocated memory.                           */
/*---------------------------------------------------------------------*/
 if (first_define != NULL)
    first_define = dll_free(first_define);
 if (first_prefix_synonym != NULL)
    first_prefix_synonym = lll_free(first_prefix_synonym);
 (*the_free)(last_target);
 (*the_free)(rec);
 (*the_free)(trec);
 (*the_free)(cmd_rec);
 if (profile_command_line != NULL)
    (*the_free)(profile_command_line);
 if (screen[0].sl != NULL)
    (*the_free)(screen[0].sl);
 if (screen[1].sl != NULL)
    (*the_free)(screen[1].sl);
/*---------------------------------------------------------------------*/
/* Free memory for temp_params and tmp_cmd                             */
/*---------------------------------------------------------------------*/
 free_temp_space(TEMP_PARAM);
 free_temp_space(TEMP_MACRO);
 free_temp_space(TEMP_TEMP_CMD);
 free_temp_space(TEMP_TMP_CMD);

 if (specified_prf != NULL)
    (*the_free)(specified_prf);
 if (local_prf != NULL)
    (*the_free)(local_prf);
 if (prf_arg != NULL)
    (*the_free)(prf_arg);
 free_recovery_list();

#if defined(UNIX) || defined(OS2)
 (*the_free)(spooler_name);
#endif

 if (divider != (WINDOW *)NULL)
   {
    delwin(divider);
    divider = (WINDOW *)NULL;
   }
 if (error_window != (WINDOW *)NULL)
   {
    delwin(error_window);
    error_window = (WINDOW *)NULL;
   }
/*---------------------------------------------------------------------*/
/* If the user wants a clearscreen done before exiting, do it...       */
/*---------------------------------------------------------------------*/
 if (CLEARSCREENx)
   {
    wclear(stdscr);
    move(0,0);
    attrset(A_NORMAL);
    refresh();
   }
 else
/*---------------------------------------------------------------------*/
/* ...otherwise, get the cursor to the bottom line.                    */
/*---------------------------------------------------------------------*/
   {
    if (foot != (WINDOW *)NULL)
      {
       wattrset(foot,A_NORMAL);
       mvwaddstr(foot,0,0,"THE - END");
       wrefresh(foot);
      }
   }
 if (foot != (WINDOW *)NULL)
   {
    delwin(foot);
    foot = (WINDOW *)NULL;
   }
#ifdef MSWIN
 Win31Cleanup();
 return(0);
#endif
 exit_clean(0);
}
/***********************************************************************/
#ifdef PROTO
void init_signals(void)
#else
void init_signals()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("the.c:     init_signals");
#endif
#ifdef UNIX
 signal(SIGQUIT,handle_signal);
 signal(SIGHUP,handle_signal);
 signal(SIGABRT,handle_signal);
 signal(SIGFPE,handle_signal);
 signal(SIGSEGV,handle_signal);
 signal(SIGINT,handle_signal);
 signal(SIGTERM,handle_signal);
#if defined(SIGBUS)
 signal(SIGBUS,handle_signal);
#endif
#endif
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void init_colour_pairs(void)
#else
void init_colour_pairs()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register int fg=0,bg=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("the.c:     init_colour_pairs");
#endif

#ifdef A_COLOR
 for (fg=0;fg<COLORS;fg++)
   {
    for (bg=0;bg<COLORS;bg++)
      {
       if (ATTR2PAIR(fg,bg) <= COLOR_PAIRS)
          init_pair(ATTR2PAIR(fg,bg),fg,bg);
      }
   }
#endif

#ifdef TRACE
 trace_return();
#endif
 return;
}
#ifdef UNIX
/***********************************************************************/
#ifdef PROTO
void handle_signal(int err)
#else
void handle_signal(err)
int err;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("the.c:     handle_signal");
#endif
 if (curses_started)
    endwin();
 fprintf(stderr,"\nTHE terminated with signal: %d\n\n",err);
 exit_clean(2);
}
#endif
/***********************************************************************/
#ifdef PROTO
int setup_profile_files(CHARTYPE *specified_prf)
#else
int setup_profile_files(specified_prf)
CHARTYPE *specified_prf;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 int rc=RC_OK;
/*--------------------------- processing ------------------------------*/
/*---------------------------------------------------------------------*/
/* If a profile specified on the command line, set it up as the local  */
/* profile. It MUST exist and be readable, otherwise an error.         */
/*---------------------------------------------------------------------*/
 if (specified_prf != (CHARTYPE *)NULL)
   {
    if ((local_prf = (CHARTYPE *)(*the_malloc)((MAX_FILE_NAME+1)*sizeof(CHARTYPE))) == NULL)
       return(RC_OUT_OF_MEMORY);
    strcpy(local_prf,specified_prf);
    (*the_free)(specified_prf);
    specified_prf = (CHARTYPE *)NULL;
    if (!file_exists(local_prf))
      {
       display_error(9,local_prf,FALSE);
       return(RC_FILE_NOT_FOUND);
      }
/*---------------------------------------------------------------------*/
/* If the file is not readable, error.                                 */
/*---------------------------------------------------------------------*/
    if (!file_readable(local_prf))
      {
       display_error(8,local_prf,FALSE);
       return(RC_ACCESS_DENIED);
      }
    return(rc);
   }
/*---------------------------------------------------------------------*/
/* If a profile specified with THE_PROFILE_FILE, set it up as the local*/
/* profile. It does not have to exist.                                 */
/*---------------------------------------------------------------------*/
 if (getenv("THE_PROFILE_FILE") != NULL)
   {
    if ((local_prf = (CHARTYPE *)(*the_malloc)((MAX_FILE_NAME+1)*sizeof(CHARTYPE))) == NULL)
       return(RC_OUT_OF_MEMORY);
    strcpy(local_prf,getenv("THE_PROFILE_FILE"));
    if (!file_readable(local_prf))
      {
       (*the_free)(local_prf);
       local_prf = (CHARTYPE *)NULL;
      }
    return(rc);
   }
/*---------------------------------------------------------------------*/
/* No specific profile, so check for default profiles.                 */
/*---------------------------------------------------------------------*/
 if ((local_prf = (CHARTYPE *)(*the_malloc)((MAX_FILE_NAME+1)*sizeof(CHARTYPE))) == NULL)
    return(RC_OUT_OF_MEMORY);
/*---------------------------------------------------------------------*/
/* For Unix, use a local profile first...                              */
/*---------------------------------------------------------------------*/
#if defined(UNIX)
 strcpy(local_prf,user_home_dir);
 strcat(local_prf,THE_PROFILE_FILE);
 (void *)strtrans(local_prf,OSLASH,ISLASH);
 if (file_readable(local_prf))
    return(rc);
#endif
/*---------------------------------------------------------------------*/
/* If no local profile, see if a global profile exists...              */
/*---------------------------------------------------------------------*/
 strcpy(local_prf,the_home_dir);
 strcat(local_prf,THE_PROFILE_FILE);
 (void *)strtrans(local_prf,OSLASH,ISLASH);
 if (file_readable(local_prf))
    return(rc);
/*---------------------------------------------------------------------*/
/* To get here, no profile files to be executed.                       */
/*---------------------------------------------------------------------*/
 (*the_free)(local_prf);
 local_prf = (CHARTYPE *)NULL;
 return(rc);
}
/***********************************************************************/
#ifdef PROTO
void display_info(CHARTYPE *argv0)
#else
void display_info(argv0)
CHARTYPE *argv0;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/

 fprintf(stderr,"\nTHE %s %2s %s. All rights reserved.\n",the_version,the_release,the_copyright);
 fprintf(stderr,"THE is distributed under the terms of the GNU General Public License \n");
 fprintf(stderr,"and comes with NO WARRANTY. See the file COPYING for details.\n");
 fprintf(stderr,"\nUsage:\n\n%s [-h?nms] [-p profile] [-a profile_arg] [-w width] [[dir] [file [...]]]\n",argv0);
 fprintf(stderr,"\nwhere:\n\n");
 fprintf(stderr,"-h,-?                  show this message\n");
 fprintf(stderr,"-n                     do not execute a profile file\n");
 fprintf(stderr,"-m                     force display into mono\n");
 fprintf(stderr,"-r                     run THE in read-only mode\n");
 fprintf(stderr,"-s                     turn off signal trapping (Unix only)\n");
 fprintf(stderr,"-p profile             filename of profile file\n");
 fprintf(stderr,"-a profile_arg         argument(s) to profile file (only with REXX)\n");
 fprintf(stderr,"-w width               maximum width of line (default 2048)\n");
 fprintf(stderr,"[dir [file [...]]]     file(s) and/or directory to be edited\n\n");
 fflush(stderr);
 return;
}
/***********************************************************************/
#ifdef PROTO
void exit_clean(short err_num)
#else
void exit_clean(err_num)
short err_num;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
extern bool CLEARSCREENx;
extern bool INSERTMODEx;
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("the.c:     exit_clean");
#endif

 if (curses_started)
   {
    INSERTMODEx=FALSE;
    draw_cursor(TRUE);
#ifdef BSD
    nl();
    echo();
#endif
    endwin();
   }
 if (!CLEARSCREENx
 && been_interactive)
    printf("\n");
 if (file_exists(tempfilename))
    remove_file(tempfilename);
#ifdef TRACE
 trace_return();
#endif
 exit(err_num);
}
