/* Switching text for SemWare's TSE editor V2.0. To make this SAL
   macro operational, invoke the main menu (F10), choose "Macro",
   choose "Compile" and press Enter at "Execute Macro".

....................................................................
Prof. Timo Salmi   Co-moderator of news:comp.archives.msdos.announce
Moderating at ftp:// & http://garbo.uwasa.fi archives  193.166.120.5
Department of Accounting and Business Finance  ; University of Vaasa
ts@uwasa.fi http://uwasa.fi/~ts BBS 961-3170972; FIN-65101,  Finland
*/

// The contents of a simple help, tied later to the CtrlAlt-H key
helpdef tHelpData                 // helpdef was Help in prelease
  title = "SWITCH.S HELP"         // The help's caption
  x = 10                          // Location
  y = 3
  "Timo's text-switch TSE commands "    // The actual help text
  ""
  " You can use <F11> to invoke the command "
  " menu after first exiting this help. "
  ""
  " Last updated Sun 26-March-1995 18:20:59 "
end  /* tHelpData */

// Reverse a person's name *********************************************
proc timoRevName()
  string s[80] = ''
  integer comma = 0
  //
  // Store original status
  PushPosition()
  PushBlock()
  //
  // Mark the first part of the name and store it
  BegWord()
  UnmarkBlock()
  MarkChar()
  EndWord()
  MarkChar()
  s = GetMarkedText()
  DelBlock()
  //
  // Check for comma
  if CurrChar() == Asc(",")
    comma = 1
  else
    comma = 0
  endif
  //
  // Delete intervening blanks etc
  UnmarkBlock()
  MarkChar()
  WordRight()
  MarkChar()
  DelBlock()
  //
  // Reverse
  if comma
    EndWord()
    InsertText (" " + s, _INSERT_)
  else
    EndWord()
    InsertText (", " + s, _INSERT_)
  endif
  //
  // Restore original status
  PopBlock()
  PopPosition()
end timoRevName

// Swich two characters ************************************************
proc timoSwitchChar()
  string s[1] = ''
  s = Chr(CurrChar())
  DelChar()
  Right()
  InsertText(s,_INSERT_)
  Left()
  Left()
end timoSwitchChar

// Switch two words ****************************************************
proc timoSwitchWord()
  string s[80] = ''
  //
  // Store original status
  PushPosition()
  PushBlock()
  //
  // Mark the first word and store it
  BegWord()
  UnmarkBlock()
  MarkChar()
  EndWord()
  MarkChar()
  s = GetMarkedText()
  DelBlock()
  //
  // Delete intervening blanks etc
  UnmarkBlock()
  MarkChar()
  WordRight()
  MarkChar()
  DelBlock()
  //
  // Reverse
  EndWord()
  InsertText (" " + s, _INSERT_)
  //
  // Restore original status
  PopBlock()
  PopPosition()
end timoSwitchWord

// New keys and menus **************************************************
forward Menu tSwitchMenu()
forward proc timoDisableNewKeys()

// Add new key definitions
keydef new_keys
  <CtrlAlt 4>           timoSwitchChar()
  <CtrlAlt 5>           timoSwitchWord()
  <CtrlAlt 6>           timoRevName()
  // QuickHelp was ShowHelp in prerelease
  <CtrlAlt H>           QuickHelp(tHelpData)
  <F11>                 tSwitchMenu()
end

// Disable the new extra keys ****************************************
proc timoDisableNewKeys()
  if YesNo("Disable the extra keys:") == 1
    Disable(new_keys)
  endif
end

Menu tSwitchMenu()
  Title = ""
  x = 31
  y = 2
  history
  "&Switch two characters   <CtrlAlt 4>"  , timoSwitchChar()
  "Switch two &words        <CtrlAlt 5>"  , timoSwitchChar()
  "&Reverse a person's name <CtrlAlt 6>"  , timoRevName()
  "Administer",,Divide
  "Disable new &keys        <CtrlAlt 0>" , timoDisableNewKeys()
  // QuickHelp was ShowHelp in prerelease
  "&Help                    <CtrlAlt H>" , QuickHelp(tHelpData)
  "This Menu               <F11>"
end  /* tSwitchMenu */

proc Main()
  Enable (new_keys)
  tSwitchMenu()
end
