/* Scandinavian conversions for SemWare's TSE editor V2.0. To make
   this SAL macro operational, invoke the main menu (F10), choose
   "Macro", choose "Compile" and press Enter at "Execute Macro".

....................................................................
Prof. Timo Salmi   Co-moderator of news:comp.archives.msdos.announce
Moderating at ftp:// & http://garbo.uwasa.fi archives  193.166.120.5
Department of Accounting and Business Finance  ; University of Vaasa
ts@uwasa.fi http://uwasa.fi/~ts BBS 961-3170972; FIN-65101,  Finland
*/

// The contents of a simple help, tied later to the CtrlAlt-H key
helpdef tHelpData
  title = "TOASC.S HELP"           // The help's caption
  x = 10                           // Location
  y = 3
  // The actual help text
  " Prof. Timo Salmi's Scandinavian conversions"
  ""
  " These procedures are for converting the Scandinavian "
  " characters between different conventions."
  ""
  " You can use <F11> to invoke the command menu after "
  " first exiting this help. "
  ""
  " Last updated Sat 6-May-1995 04:08:34 "
end  /* tHelpData */

// Convert 8-bit Scandinavian characters to their local 7-bit counterparts
proc timoIbmToAsc()
  lReplace("","}","gn")
  lReplace("","{","gn")
  lReplace("","|","gn")
  lReplace("","]","gn")
  lReplace("","[","gn")
  lReplace("","\","gn")
end

// Convert local 7-bit Scandinavian characters to their 8-bit IBM
// PC counterparts
proc timoAscToIbm()
  lReplace("}","","gn")
  lReplace("{","","gn")
  lReplace("|","","gn")
  lReplace("]","","gn")
  lReplace("[","","gn")
  lReplace("\","","gn")
end

// Convert 8-bit Latin1 Scandinavian characters to their 8-bit IBM
// PC counterparts
proc timoLat1ToIbm()
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","","gn")
end

// Convert 8-bit IBM PC Scandinavian characters to their 8-bit
// Latin1 counterparts
proc timoIbmToLat1()
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","","gn")
end

// Covert Mac Scandinavian characters to their 8-bit IBM PC equivalents
proc timoMac2Pc()
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","","gn")
  lReplace("","'","gn")
  lReplace("","'","gn")
end

// Convert 8-bit Scandinavian characters to their html codes
proc timoIbmToHtml()
  lReplace("","&aring;","gn")
  lReplace("","&auml;","gn")
  lReplace("","&ouml;","gn")
  lReplace("","&Aring;","gn")
  lReplace("","&Auml;","gn")
  lReplace("","&Ouml;","gn")
end

// Convert html codes to their 8-bit Scandinavian counterparts
proc timoHtmlToIbm()
  lReplace("&aring;","","gn")
  lReplace("&auml;" ,"","gn")
  lReplace("&ouml;" ,"","gn")
  lReplace("&Aring;","","gn")
  lReplace("&Auml;" ,"","gn")
  lReplace("&Ouml;" ,"","gn")
end

// New keys and menus **************************************************
forward Menu tIbmAscMenu()
forward proc tDisableNewKeys()

// Add the new key definitions
keydef new_keys
  <CtrlAlt 1>      timoIbmToAsc()
  <CtrlAlt 2>      timoAscToIbm()
  <CtrlAlt 3>      timoLat1ToIbm()
  <CtrlAlt 4>      timoIbmToLat1()
  <CtrlAlt 5>      timoMac2Pc()
  <CtrlAlt 6>      timoIbmToHtml()
  <CtrlAlt 7>      timoHtmlToIbm()
  <CtrlAlt 0>      tDisableNewKeys()
  <CtrlAlt H>      QuickHelp(tHelpData)
  <F11>            tIbmAscMenu()
end

// Disabling the new extra keys ***************************************
proc tDisableNewKeys()
  if YesNo("Disable the extra keys:") == 1 Disable(new_keys) endif
end

// The IbmAsc menu ****************************************************
Menu tIbmAscMenu()
  Title = "Timo's conversion menu"
  x = 40
  y = 3
  history
  "Ibm&Asc  (7-bit)    <CtrlAlt 1>"   , timoIbmToAsc()
  "Asc&Ibm  (8-bit)    <CtrlAlt 2>"   , timoAscToIbm()
  "&Lat1Ibm (8-bit)    <CtrlAlt 3>"   , timoLat1ToIbm()
  "IbmLat&1 (8-bit)    <CtrlAlt 4>"   , timoIbmToLat1()
  "Mac2P&C  (8-bit)    <CtrlAlt 5>"   , timoMac2Pc()
  "IbmH&tml (7-bit)    <CtrlAlt 6>"   , timoIbmToHtml()
  "Ht&mlIbm (8-bit)    <CtrlAlt 7>"   , timoHtmlToIbm()
  "",,Divide
  "Disable &new keys  <CtrlAlt 0>"   , tDisableNewKeys()
  "&Help              <CtrlAlt H>"   , QuickHelp(tHelpData)
  "This Menu         <F11>"
end tIbmAscMenu

proc Main()
  Enable (new_keys)
  tIbmAscMenu()
end
