/*****************************************************************
Module name: SetupInf.H
Programmer : Jeffrey M. Richter.
*****************************************************************/

// Defines used by the SETUP program.
#define MAXDISKDESC     50
#define MAXDIRDESC      30
#define MAXFILEDESC     50
#define MAXPMDESC       30
#define MAXAPPNAME      40


#define MAXDISKS      15
#define MAXDIRS       25
#define MAXFILES     250
#define MAXPMFILES    20

class DISKINFO;
class DIRINFO;
class FILEINFO;
class PMINFO;

class SETUPINFO {
   typedef enum {
      RS_UNDEFINED, RS_APPLICATION, RS_DISKS, RS_SRCDIRS,
      RS_DSTDIRS, RS_FILES, RS_PMINFO, RS_TERMINATE
   } READSTATE;
   READSTATE ReadState;

   char     szAppName[MAXAPPNAME];
   char     szDefaultDstDir[MAXDIR];
   UINT     uSpaceNeeded;
   char     szPMGrpFileName[MAXFILENAME];
   char     szPMGrpName[MAXPMDESC];
   BOOL     fShowSubDirCreateStats;
   UINT     uNumDisks, uNumSrcDirs, uNumDstDirs;
   UINT     uNumFiles, uNumPMFiles;
   DISKINFO *Disks[MAXDISKS];
   DIRINFO  *SrcDirs[MAXDIRS];
   DIRINFO  *DstDirs[MAXDIRS];
   FILEINFO *Files[MAXFILES];
   PMINFO   *PMFiles[MAXPMFILES];

   DISKINFO *FindDiskFromNum (UINT uNum) const;
   DIRINFO  *FindSrcDirFromNum (UINT uNum) const;
   DIRINFO  *FindDstDirFromNum (UINT uNum) const;
   BOOL ReadSetupInfo (char FAR *lpSetupInfo);

   public:
   SETUPINFO (void);

   ~SETUPINFO (void);

   typedef enum {
      ISI_NOERROR, ISI_NOMEM, ISI_FILENOTFOUND, ISI_CANTPARSE
   } ISIERROR;

   ISIERROR InitSetupInfo (LPSTR szSetupInfoPathName);

   void GetAppName (LPSTR szAppName) const
      { lstrcpy(szAppName, this->szAppName); }

   BOOL ShowSubDirCreateStats (void) const
      { return(fShowSubDirCreateStats); }

   void GetDefaultDstDir (LPSTR szDefaultDstDir) const
      { lstrcpy(szDefaultDstDir, this->szDefaultDstDir); }

   UINT GetDstDiskSpaceNeeded (void) const
      { return(uSpaceNeeded); }

   UINT GetNumDstDirs (void) const
      { return(uNumDstDirs); }

   void GetDstDir (UINT uDirNum, LPSTR szDstDir) const;

   void GetPMGroupInfo (LPSTR szGrpFileName, LPSTR szPMGrpName)
      const {
      lstrcpy(szGrpFileName, this->szPMGrpFileName);
      lstrcpy(szPMGrpName, this->szPMGrpName);
   }

   UINT GetPMItemNum (void) const
      { return(uNumPMFiles); }

   UINT GetPMItemInfo (UINT uPMItemNum, LPSTR szAppDesc,
      LPSTR szDstFileName) const;

   UINT GetNumFilestoInstall (void) const
      { return(uNumFiles); }

   void GetFileInstallInfo (UINT uFileNum,
      LPSTR szSrcDiskDesc, LPSTR szFileDesc,
      LPSTR szSrcFilePath, LPSTR szSrcFileName,
      LPSTR szDstFilePath, LPSTR szDstFileName,
      BOOL FAR *fSharable) const;

   void SetFileDstDir (UINT uFileNum, LPCSTR szDstDir);
};

extern SETUPINFO _SetupInfo;
