//-------------------------------------------------------------------//

//  Syntax:	input ( STRING )
//		input ( STRING , "s" )

//  Description:

//  The input function provides an easy method for users to get a
//  simple response from the keyboard. The STRING argument is printed
//  on the standard output (usually the screen), and the program waits
//  until input is entered. Input then returns the input, which can be
//  either a string, or a number. If you want to force the input to be
//  a string, then use the second, and optional argument, "s" to force
//  the return value to be a string.

//  If the user does not enter anything when prompted, then input
//  returns an empty matrix.

//-------------------------------------------------------------------//

input = function ( STRING, S )
{
  if (!exist (STRING)) { STRING = "input: "; }

  fprintf ("stdout", "%s", STRING);
  ans = getline ("stdin");

  if (length (ans) == 0)
  {
    return [];
  else
    if (exist (S))
    {
      if (class (ans.[1]) == "num")
      {
        return num2str (ans.[1])
      else
        return ans.[1];
      }
    else
      return ans.[1]
    }
  }
};
