//---------------------------------------------------------------------------
//  window.r

//  Syntax:	window ( N , wt )

//  Description:

//  Window generates a window function.
//
//  N = length of desired window
//  wt = window type desired
//       "rect" = rectangular      "tria" = triangular (Bartlett)
//       "hann" = Hanning          "hamm"  = Hamming
//       "blac" = Blackman

//  Window returns a row vector containing samples of the desired
//  window.
//---------------------------------------------------------------------------

window = function ( N, wt )
{
  local (m, nn, pn, w)
  global (pi)

  nn = N-1;
  pn = 2*pi*(0:nn)/nn;
  if (wt == "rect")
  {
    w = ones (1, N);
  else if (wt == "tria") {
    m = nn/2;
    w = (0:m)/m;
    w = [w, w[ceil(m):1:-1]];
  else if (wt == "hann") {
    w = 0.5*(1 - cos (pn));
  else if (wt == "hamm") {
    w = .54 - .46*cos (pn);
  else if (wt == "blac") {
    w = .42 -.5*cos (pn) + .08*cos (2*pn);
  else
    disp("Incorrect Window type requested");
  }}}}}

  return w';
};
