/*
 *  EMAILNLM.C
 *
 *  An example NLM for NetWare 3.11. This program maintains
 *  mail files on the server in a special subdirectory. For
 *  privacy, only this NLM has rights to that subdirectory.
 *
 *      1. Before loading this NLM, use SYSCON to establish
 *         user id "MAILBOX", password "EMAIL".  At a DOS
 *         prompt, use MKDIR to create a directory named
 *         "MAILBOX" on the SYS: volume.  Ensure the user
 *         "MAILBOX" has all rights to the directory.
 *
 *      2. On the workstation side, you need to create a
 *         program that communicates with this NLM through
 *         IPX, using the packet/message structures given
 *         below in this listing.
 *
 *
 *  Barry Nance
 *  released to the public domain
 *
*/

#include <nwtypes.h>
#include <nwbindry.h>
#include <nwipxspx.h>
#include <nwconn.h>
#include <nwdir.h>
#include <conio.h>
#include <process.h>
#include <string.h>
#include <fcntl.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

struct  MailHeaderType
        {
        char    From[50];
        char    To[50];
        char    Date[10];
        char    Time[10];
        char    Subject[50];
        char    Reserved[4];
        char    FileName[15];
        };

unsigned short Socket;
DIR     *MailDirPtr;
DIR     *DirEntryPtr;
FILE    *MailFile;
struct  MailHeaderType   MailHeader;
struct  MailHeaderType   MailTable[500];
int     MailSub;
int     MailCount;
IPX_ECB EventControlBlock;
IPX_HEADER IpxHeader;
struct  {
        char    ActionCode;
        short   MailID;
        short   Sequence;
        char    LastPacketFlag;
        short   Length;
        short   Reserved;
        char    Packet[500];
        } Message;

struct UserNameStruct User;

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

void    MailUnload(void)
        {
        Logout();
        IpxCloseSocket(Socket);
        }

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int     main(int argc, char *argv[])
        {
        /* login as user MAILBOX, password EMAIL */
        if (LoginToFileServer("mailbox", OT_USER, "EMAIL"))
            {
            printf("Could not login as MAILBOX.  Aborting.\n");
            return 1;
            }

        /* change to the SYS:\MAILBOX directory */
        if (chdir("SYS:\\MAILBOX"))
            {
            printf("Could not change to MAILBOX directory.  Aborting.\n");
            return 1;
            }

        /* open socket 0x4545 */
        Socket = 0x4545;
        IpxOpenSocket(&Socket);

        /* register an atexit() function to happen at unload time */
        atexit(MailUnload);

        printf("Mail Server is now active.\n");

        /* index any outstanding mail files */
        MailSub = 0;
        MailDirPtr = opendir("*.*");
        if (MailDirPtr != NULL)
            {
            DirEntryPtr = readdir(MailDirPtr);
            while (DirEntryPtr != NULL)
                {
                MailFile = fopen(DirEntryPtr->d_name, "rb");
                fread(&MailHeader, sizeof(MailHeader), 1, MailFile);
                fclose(MailFile);
                strcpy(MailHeader.FileName, DirEntryPtr->d_name);
                MailTable[MailSub] = MailHeader;
                MailSub++;
                DirEntryPtr = readdir(MailDirPtr);
                }
            closedir(MailDirPtr);
            }
        MailCount = MailSub;

        /* issue a Listen ECB */
IssueListen:
        memset(&EventControlBlock, 0, sizeof(EventControlBlock));
        memset(&IpxHeader, 0, sizeof(IpxHeader));
        memset(&Message, 0, sizeof(Message));
        EventControlBlock.fragCount = 2L;
        EventControlBlock.fragList[0].fragAddress = &IpxHeader;
        EventControlBlock.fragList[0].fragSize    = sizeof(IpxHeader);
        EventControlBlock.fragList[1].fragAddress = &Message;
        EventControlBlock.fragList[1].fragSize    = sizeof(Message);
        IpxReceive(Socket, &EventControlBlock);

        /* wait for a message */
        while (EventControlBlock.status)
            delay(100);

        GetUserNameFromNetAddress( (BYTE *) &IpxHeader.sourceNet, 
                                    0, &User);

        /* Action Code 1 is "Do I have any mail?" */
        if (Message.ActionCode == '1')
            {
            if (Message.Sequence == 1)
                MailSub = 0;
            while (strcmp(User.UserName, MailTable[MailSub].To) != 0
              && MailSub < 500)
                  MailSub++;
            if (MailSub == 500)
                {
                Message.LastPacketFlag = 'Y';
                Message.Length = 0;
                }
            else
                {
                Message.LastPacketFlag = 'N';
                memcpy(Message.Packet, &MailTable[MailSub], 
                        sizeof(MailHeader));
                Message.Length = sizeof(MailHeader);
                }
            Message.MailID = MailSub;
            Message.Sequence++;
            memcpy(&IpxHeader.destNet, &IpxHeader.sourceNet, 10);
            IpxHeader.destSocket = Socket;
            IpxHeader.packetType = 4;
            EventControlBlock.fragCount = 2L;
            EventControlBlock.fragList[0].fragAddress = &IpxHeader;
            EventControlBlock.fragList[0].fragSize    = sizeof(IpxHeader);
            EventControlBlock.fragList[1].fragAddress = &Message;
            EventControlBlock.fragList[1].fragSize    = Message.Length+10;
            IpxSend(Socket, &EventControlBlock);
            goto IssueListen;
            }

        /* Action Code 2 is "Give me that mail item" */
        if (Message.ActionCode == '2')
            {
            MailSub = Message.MailID;
            if (strcmp(User.UserName, MailTable[MailSub].To) != 0)
                goto IssueListen;
            if (Message.Sequence == 1)
                {
                MailFile = fopen(MailTable[Message.MailID].FileName, "rb");
                if (MailFile == NULL)
                    goto IssueListen;
                }
            if (fread(Message.Packet, 500, 1, MailFile) != 1)
                {
                Message.LastPacketFlag = 'Y';
                fclose(MailFile);
                }
            else
                {
                Message.LastPacketFlag = 'N';
                }
            Message.Sequence++;
            Message.Length = 500;
            memcpy(&IpxHeader.destNet, &IpxHeader.sourceNet, 10);
            IpxHeader.destSocket = Socket;
            IpxHeader.packetType = 4;
            EventControlBlock.fragCount = 2L;
            EventControlBlock.fragList[0].fragAddress = &IpxHeader;
            EventControlBlock.fragList[0].fragSize    = sizeof(IpxHeader);
            EventControlBlock.fragList[1].fragAddress = &Message;
            EventControlBlock.fragList[1].fragSize    = 510;
            IpxSend(Socket, &EventControlBlock);
            goto IssueListen;
            }

        /* Action Code 3 is "Delete mail item */
        if (Message.ActionCode == '3')
            {
            MailSub = Message.MailID;
            if (strcmp(User.UserName, MailTable[MailSub].To) != 0)
                goto IssueListen;
            unlink(MailTable[MailSub].FileName);
            strcpy(MailTable[MailSub].To, "");
            goto IssueListen;
            }

        /* Action Code 4 is "Send this mail item" */
        if (Message.ActionCode == '4')
            {
            if (Message.Sequence == 1)
                {
                MailSub = 0;
                while (strlen(MailTable[MailSub].To) > 0
                  && MailSub < 500)
                    MailSub++;
                if (MailSub == 500)
                    goto IssueListen;
                sprintf(MailTable[MailSub].FileName, "%5.5d", MailSub);
                MailFile = fopen(MailTable[MailSub].FileName, "wb");
                if (MailFile == NULL)
                    goto IssueListen;
                }
            fwrite(Message.Packet, Message.Length, 1, MailFile);
            if (Message.LastPacketFlag == 'Y')
                fclose(MailFile);
            Message.Sequence++;
            Message.Length = 0;
            memcpy(&IpxHeader.destNet, &IpxHeader.sourceNet, 10);
            IpxHeader.destSocket = Socket;
            IpxHeader.packetType = 4;
            EventControlBlock.fragCount = 2L;
            EventControlBlock.fragList[0].fragAddress = &IpxHeader;
            EventControlBlock.fragList[0].fragSize    = sizeof(IpxHeader);
            EventControlBlock.fragList[1].fragAddress = &Message;
            EventControlBlock.fragList[1].fragSize    = 10;
            IpxSend(Socket, &EventControlBlock);
            }

        goto IssueListen;
        }
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

