//  Cross-platform DLLs for Windows and Dos
//  Copyright (c) 1993 by Danny Thorpe
//
//  A 'computation engine' DLL for Windows or Dos
//  This DLL performs various arithmetic operations on
//  complex numbers.
//
//  To run this DLL in DOS protected mode, this must be built
//  with the FPINIT.ASM - modified BC++ 3.1 RTL.
//  Memory model should be large.

#include <windows.h>
#include <math.h>
#include <complex.h>

void FAR PASCAL _export Complex(complex& C, double real, double imag)
{
  C = complex(real, imag);
};

double FAR PASCAL _export Real(complex& C)
{
  return real(C);
};

double FAR PASCAL _export Imag(complex& C)
{
  return imag(C);
};

void FAR PASCAL _export AddFloat(complex& C, double R, double I)
{
  C += complex(R,I);
};

void FAR PASCAL _export Add(complex& A, complex& B)
{
  A += B;
};

void FAR PASCAL _export Multiply(complex& A, complex& B)
{
  A *= B;
};

double FAR PASCAL _export Normal(complex& C)
{
  return norm(C);
};


UINT calc_escape(complex& Point,
                 UINT LoopLimit,
                 BOOL ZeroStart)
{
  complex accum(0,0);
  if (!ZeroStart)
    accum = Point;
  for (UINT X = 0; (X < LoopLimit) && (norm(accum) < 4.0); X++)
  {
    accum += Point;
    accum *= accum;
  };
  return X;
};

// The Mandelbrot set is bounded by (-1.8,-1.8) to (1,-1.8), x = real, y = imag.
// For 16 color display, set the color of each point to:
//     PixelColor(x,y) = MandelbrotPoint((x,y), 256) div 16
// Higher looplimits yield finer detail near set boundary
UINT FAR PASCAL _export MandelbrotPoint(complex& Point, UINT LoopLimit)
{
  return calc_escape(Point,LoopLimit,TRUE);
};

// Mandelbrot set (M-set) is a dictionary of Julia sets.  Pick a point near the
// boundary of the M-set, feed it into Julia.  The resulting graph is unique to
// that M-point, but similar to Julia sets graphs of 'nearby' M-points.
// Notice that the only difference between calculating the M-set and the J-set
// is the starting value of the accumulator.
UINT FAR PASCAL _export JuliaPoint(complex& Point, UINT LoopLimit)
{
  return calc_escape(Point,LoopLimit,FALSE);
};


int FAR PASCAL LibMain(HINSTANCE,
                       WORD ,
                       WORD ,
                       LPSTR )
{
  return 1;
}
